/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import cf.gf;
import com.motivewave.common.h;
import com.motivewave.common.util.j;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.w;
import com.motivewave.platform.databean.ExitStrategy;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Ticker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.JSONObject;

public class ExitTrigger
implements j,
w {
    private List entryOrderIds;
    private ExitStrategy exitStrategy;
    private String copierLinkId = null;
    private String copierAccountId = null;
    private boolean activated = false;
    private boolean copierLead = false;
    private gf parent;
    private Ticker ticker;
    private String accountId;
    private String tradeId;
    private float quantity;
    private float position;
    private float avgPrice;
    private Enums$TIF tif;
    private int offset;

    public ExitTrigger(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public ExitTrigger(ExitStrategy exitStrategy, List list) {
        this.exitStrategy = exitStrategy.clone();
        this.entryOrderIds = h.a((Collection)list) ? Collections.emptyList() : new ArrayList(list);
    }

    @Override
    public void destroy() {
        this.clearPlaceholders();
    }

    private void clearPlaceholders() {
        for (MWOrder mWOrder : OrderDirectory.getAllOrders()) {
            ExitTrigger exitTrigger;
            if (!mWOrder.isExitStep() || (exitTrigger = OrderDirectory.getExitTrigger(mWOrder.getParentId())) != this) continue;
            OrderDirectory.removeOrder(mWOrder);
        }
    }

    public void updatePlaceholderOrders() {
        if (this.exitStrategy == null) {
            return;
        }
        this.clearPlaceholders();
        if (this.entryOrderIds.isEmpty() || this.entryOrderIds.size() > 1) {
            return;
        }
        MWOrder mWOrder = OrderDirectory.findOrder((String)this.entryOrderIds.get(0));
        if (mWOrder == null || !mWOrder.isActive()) {
            return;
        }
        List list = this.exitStrategy.createPlaceHolderOrders(mWOrder);
        for (MWOrder mWOrder2 : list) {
            OrderDirectory.createOrder(mWOrder2);
        }
    }

    public ExitStrategy getExitStrategy() {
        return this.exitStrategy;
    }

    public boolean isExitStrategy() {
        return this.exitStrategy != null;
    }

    public boolean isValid() {
        return this.exitStrategy != null;
    }

    public void setPosition(float f2) {
        this.position = f2;
    }

    public float getPosition() {
        return this.position;
    }

    public void setAvgPrice(float f2) {
        this.avgPrice = f2;
    }

    public float getAvgPrice() {
        return this.avgPrice;
    }

    public void setTif(Enums$TIF enums$TIF) {
        this.tif = enums$TIF;
    }

    public void setContainer(gf gf2) {
        this.parent = gf2;
    }

    public void setAccountID(String string) {
        this.accountId = string;
    }

    public String getAccountID() {
        return this.accountId;
    }

    public void setTradeId(String string) {
        this.tradeId = string;
    }

    public String getTradeId() {
        return this.tradeId;
    }

    public void setQuantity(float f2) {
        this.quantity = f2;
    }

    public void setOffset(int n2) {
        this.offset = n2;
    }

    public void setTicker(Ticker ticker) {
        this.ticker = ticker;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public boolean isCopierLead() {
        return this.copierLead;
    }

    public void setCopierLead(boolean bl2) {
        this.copierLead = bl2;
    }

    public String getCopierLinkId() {
        return this.copierLinkId;
    }

    public void setCopierLinkId(String string) {
        this.copierLinkId = string;
    }

    public String getCopierAccountId() {
        return this.copierAccountId;
    }

    public void setCopierAccountId(String string) {
        this.copierAccountId = string;
    }

    public List getEntryOrderIds() {
        return this.entryOrderIds;
    }

    public void activate() {
        if (this.activated) {
            return;
        }
        this.activated = true;
        this.clearPlaceholders();
        if (this.exitStrategy != null) {
            List list = this.exitStrategy.execute(this.parent, this.ticker, this.accountId, this.tradeId, this.position > 0.0f, this.avgPrice, this.quantity, this.tif);
            if (!h.g(this.copierLinkId)) {
                ArrayList arrayList = new ArrayList();
                for (List list2 : list) {
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    for (MWOrder mWOrder : list2) {
                        arrayList2.add(mWOrder.getOrderId());
                    }
                    arrayList.add(arrayList2);
                }
                if (!h.a(arrayList)) {
                    if (this.copierLead) {
                        OrderDirectory.registerLeads(arrayList, this);
                    } else {
                        OrderDirectory.registerFollowers(arrayList, this);
                    }
                }
            }
        }
        OrderDirectory.removeExitTrigger(this);
    }

    @Override
    public List getNVPs() {
        MWInstrument mWInstrument = null;
        if (this.ticker != null) {
            mWInstrument = this.ticker.getInstrument();
        }
        Object object = h.b(new String[]{this.b("acctId", this.accountId), this.b("tradeId", this.tradeId), this.a("instrKey", mWInstrument == null ? null : mWInstrument.getKey()), this.a("qty", this.quantity), this.a("offset", this.offset), this.a("avgPrice", this.avgPrice), this.a("position", this.position), this.a("exitStrategy", this.exitStrategy)});
        object.add(this.a("entryOrders", h.a((Collection)this.entryOrderIds, ",")));
        if (!h.g(this.copierLinkId)) {
            object.add(this.b("copierLinkId", this.copierLinkId));
            object.add(this.b("copierAccountId", this.copierAccountId));
            object.add(this.a("copierLead", this.copierLead));
        }
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        String string = jSONObject.str("exitId");
        if (!h.g(string)) {
            this.exitStrategy = ExitStrategy.getById(string);
        } else if (jSONObject.has("exitStrategy")) {
            this.exitStrategy = new ExitStrategy();
            this.exitStrategy.fromJSON(jSONObject.obj("exitStrategy"));
        }
        if (this.exitStrategy == null) {
            h.a.warning("ExitTrigger::fromJSON() exit strategy not found: " + string);
        }
        MWInstrument mWInstrument = null;
        if (jSONObject.has("instr")) {
            mWInstrument = this.a(jSONObject, "instr");
        } else if (jSONObject.has("instrKey")) {
            mWInstrument = MWInstrument.byKey(jSONObject.str("instrKey"));
        }
        if (mWInstrument == null && this.exitStrategy != null) {
            h.a.warning("ExitTrigger::fromJSON() instrument not found: " + String.valueOf(jSONObject));
        }
        if (mWInstrument != null) {
            this.ticker = LiveTicker.get(mWInstrument);
        }
        this.accountId = jSONObject.str("acctId");
        this.tradeId = jSONObject.str("tradeId");
        this.quantity = jSONObject.getFloat("qty");
        try {
            this.tif = Enums$TIF.valueOf(jSONObject.str("tif"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.offset = jSONObject.getInt("offset");
        this.position = jSONObject.getFloat("position");
        this.avgPrice = jSONObject.getFloat("avgPrice");
        this.entryOrderIds = new ArrayList();
        for (String string2 : jSONObject.getStringList("entryOrders")) {
            this.entryOrderIds.addAll(h.a(string2, ','));
        }
        if (jSONObject.has("copierLinkId")) {
            this.copierLinkId = jSONObject.str("copierLinkId");
            this.copierAccountId = jSONObject.str("copierAccountId");
            this.copierLead = jSONObject.is("copierLead");
        }
    }
}

