/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import cf.gf;
import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.g;
import com.motivewave.platform.common.Enums$ExitOffset;
import com.motivewave.platform.common.Enums$ExitStop;
import com.motivewave.platform.common.Enums$ExitTarget;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$OrderStatus;
import com.motivewave.platform.common.Enums$OrderType;
import com.motivewave.platform.common.Enums$RiskType;
import com.motivewave.platform.common.Enums$TIF;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.ag;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.ExitStep;
import com.motivewave.platform.databean.ExitTrigger;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderAction;
import com.motivewave.platform.databean.OrderAction$ActionType;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.Positions;
import com.motivewave.platform.databean.Settings;
import com.motivewave.platform.databean.Settings$Definition;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.UpdateListener;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.ah;
import com.motivewave.platform.databean.ai;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.ui.component.j;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class ExitStrategy
extends Settings {
    private static g all = new g();
    private static g listeners = new g();
    private static boolean showingWarning = false;
    private static Settings$Definition def = new ah();

    public ExitStrategy() {
        this.set("id", h.a());
    }

    private ExitStrategy(String string, String string2, List list) {
        this.set("id", string);
        this.set("name", string2);
        this.set("steps", list);
    }

    public String getId() {
        return (String)this.get("id");
    }

    public String getName() {
        return (String)this.get("name");
    }

    public Enums$ExitOffset getOffsetType() {
        return (Enums$ExitOffset)((Object)this.get("offsetType"));
    }

    public boolean isBeEnabled() {
        return this.is("beEnabled");
    }

    public double getBeTrigger() {
        return (Double)this.get("beTrigger");
    }

    public double getBeOffset() {
        return (Double)this.get("beOffset");
    }

    public List getSteps() {
        return (List)this.get("steps");
    }

    public double getRiskAmount() {
        return (Double)this.get("riskAmount");
    }

    public Enums$RiskType getRiskType() {
        return (Enums$RiskType)((Object)this.get("riskType"));
    }

    public boolean isRiskEnabled() {
        if (!this.is("riskEnabled")) {
            return false;
        }
        double d2 = 0.0;
        for (ExitStep exitStep : this.getSteps()) {
            d2 += exitStep.getQtyPer();
            if (exitStep.isStopEnabled()) continue;
            return false;
        }
        return Math.round(d2) == 100L;
    }

    public double getAvgStopOffset() {
        double d2 = 0.0;
        double d3 = 0.0;
        for (ExitStep exitStep : this.getSteps()) {
            if (!exitStep.isStopEnabled()) continue;
            d2 += exitStep.getQtyPer();
            d3 += exitStep.getStopOffset() * exitStep.getQtyPer();
        }
        return d3 / d2;
    }

    public ExitTrigger attach(gf gf2, Enums$TIF enums$TIF, MWOrder mWOrder) {
        List list = this.getSteps();
        if (h.a((Collection)list)) {
            return null;
        }
        if (list.size() == 1 && !mWOrder.isMarket()) {
            MWOrder mWOrder2;
            float f2;
            ExitStep exitStep = (ExitStep)this.getSteps().get(0);
            Ticker ticker = mWOrder.getTicker();
            Enums$OrderAction enums$OrderAction = mWOrder.isBuy() ? Enums$OrderAction.SELL : Enums$OrderAction.BUY;
            boolean bl2 = enums$OrderAction == Enums$OrderAction.BUY;
            float f3 = mWOrder.getTriggerPrice();
            float f4 = mWOrder.getQuantity();
            Account account = mWOrder.getAccount();
            String string = account.getAccountID();
            if (exitStep.isTargetEnabled()) {
                f2 = this.calcOffset(exitStep.getTargetOffset(), ticker, f3);
                mWOrder2 = new MWOrder(string, ticker, enums$OrderAction, exitStep.getTargetType() == Enums$ExitTarget.MIT ? Enums$OrderType.MIT : Enums$OrderType.LMT, f4, enums$TIF, ticker.round(bl2 ? f3 - f2 : f3 + f2), Enums$OrderStatus.NEW);
                mWOrder2.setOffsetTicks(this.offsetTicks(exitStep.getTargetOffset(), ticker, f3));
                OrderDirectory.register(mWOrder2);
                ag.a(mWOrder, mWOrder2);
                mWOrder.setLimitOrder(mWOrder2);
            }
            if (exitStep.isStopEnabled()) {
                f2 = this.calcOffset(exitStep.getStopOffset(), ticker, f3);
                mWOrder2 = null;
                if (exitStep.getStopType() == Enums$ExitStop.TRAIL && bs.u(account)) {
                    mWOrder2 = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.TRAIL);
                    mWOrder2.setQuantity(f4);
                    mWOrder2.setTif(enums$TIF);
                    if (bs.s(account)) {
                        float f5;
                        float f6 = f5 = bl2 ? ticker.getAskPrice() : ticker.getBidPrice();
                        if (f5 == 0.0f) {
                            f5 = ticker.getMidOrLast();
                        }
                        mWOrder2.setAuxPrice(ticker.round(bl2 ? f5 + f2 : f5 - f2));
                    } else if (bs.r(account)) {
                        mWOrder2.setAuxPrice(Math.abs(f2));
                    } else {
                        mWOrder2.setAuxPrice(f2 / (float)ticker.getTickSize());
                    }
                } else if (exitStep.getStopType() == Enums$ExitStop.STOP_LIMIT && bs.c(account, ticker.getInstrument())) {
                    float f7 = bl2 ? f3 + f2 : f3 - f2;
                    mWOrder2 = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.STPLMT, f4, enums$TIF, ticker.round(f7), Enums$OrderStatus.NEW);
                } else {
                    mWOrder2 = exitStep.getStopType() == Enums$ExitStop.MIT || !bs.b(account, ticker.getInstrument()) ? new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.MIT, f4, enums$TIF, ticker.round(bl2 ? f3 + f2 : f3 - f2), Enums$OrderStatus.NEW) : new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.STP, f4, enums$TIF, ticker.round(bl2 ? f3 + f2 : f3 - f2), Enums$OrderStatus.NEW);
                }
                mWOrder2.setOffsetTicks(this.offsetTicks(exitStep.getStopOffset(), ticker, f3));
                OrderDirectory.register(mWOrder2);
                ag.a(mWOrder, mWOrder2);
                mWOrder.setStopTrailOrder(mWOrder2);
            }
            return null;
        }
        return this.attach(gf2, enums$TIF, (List)h.b(new MWOrder[]{mWOrder}));
    }

    public ExitTrigger attach(gf gf2, Enums$TIF enums$TIF, List list) {
        com.motivewave.common.util.j j22;
        if (b.a().g() && !showingWarning) {
            showingWarning = true;
            UIUtil.a(() -> {
                try {
                    j j2 = ab.b(gf2, "TITLE_EXIT_STRATEGY_WARNING", "MSG_EXIT_STRATEGY_WARNING");
                    b.a().e(!j2.a());
                }
                finally {
                    showingWarning = false;
                }
            });
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (com.motivewave.common.util.j j22 : list) {
            arrayList.add(((MWOrder)j22).getOrderId());
        }
        MWOrder mWOrder = (MWOrder)list.get(0);
        j22 = new ExitTrigger(this, arrayList);
        ((ExitTrigger)j22).setAccountID(mWOrder.getAccountId());
        ((ExitTrigger)j22).setTicker(mWOrder.getTicker());
        ((ExitTrigger)j22).setContainer(gf2);
        ((ExitTrigger)j22).setQuantity(mWOrder.getAdjustedQuantity());
        ((ExitTrigger)j22).setTif(enums$TIF);
        OrderDirectory.createExitTrigger((ExitTrigger)j22);
        ((ExitTrigger)j22).updatePlaceholderOrders();
        return j22;
    }

    public List execute(gf gf2, Ticker ticker, String string, String string2, boolean bl2, float f2, float f3, Enums$TIF enums$TIF) {
        Object object32;
        h.a.warning("ExitStrategy::execute() name: " + this.getName() + " " + ticker.getSymbol() + " acct: " + string + " tradeId: " + string2 + " long: " + bl2 + " avgEntryPrice: " + f2 + " totalQty: " + f3 + " tif: " + String.valueOf((Object)enums$TIF));
        Account account = bs.a(string);
        MWInstrument mWInstrument = ticker.getInstrument();
        if (enums$TIF == null) {
            enums$TIF = mWInstrument.getDefaultTIF();
        }
        List list = Positions.getOpen(mWInstrument, string);
        for (Position position3 : new ArrayList(list)) {
            if (position3.getQuantity() < 0.0f && bl2) {
                list.remove(position3);
                continue;
            }
            if (!(position3.getQuantity() > 0.0f) || !bl2) continue;
            list.remove(position3);
        }
        Collections.sort(list, (position, position2) -> {
            if (position == position2) {
                return 0;
            }
            if (Math.abs(position.getQuantity()) > Math.abs(position2.getQuantity())) {
                return -1;
            }
            if (Math.abs(position.getQuantity()) == Math.abs(position2.getQuantity()) && position.getOpenTime() > position2.getOpenTime()) {
                return -1;
            }
            return 1;
        });
        Object object2 = bl2 ? Enums$OrderAction.SELL : Enums$OrderAction.BUY;
        boolean bl3 = object2 == Enums$OrderAction.BUY;
        double d2 = 0.0;
        for (Object object32 : this.getSteps()) {
            d2 += ((ExitStep)object32).getQtyPer();
        }
        boolean bl4 = Math.round(d2) == 100L;
        f3 = Math.abs(f3);
        object32 = this.getSteps();
        float f4 = f3;
        float f5 = 0.0f;
        ArrayList arrayList = new ArrayList();
        for (int i2 = 0; i2 < object32.size(); ++i2) {
            float f6;
            Object object422;
            ExitStep exitStep = (ExitStep)object32.get(i2);
            float f7 = Math.abs(mWInstrument.roundQty(f3 * (float)(exitStep.getQtyPer() / 100.0)));
            if (i2 == object32.size() - 1 && bl4) {
                f7 = f4;
            }
            if (f7 == 0.0f) {
                h.a.warning("ExitStrategy::execute() name: " + this.getName() + " quantity is 0 for step: " + (i2 + 1) + " ignoring.");
                continue;
            }
            f4 -= f7;
            Object object5 = null;
            if (!h.a((Collection)list)) {
                if (account.isHedging()) {
                    for (Object object422 : list) {
                        if (((Position)object422).getQuantity() != f7) continue;
                        object5 = object422;
                        if (f5 != 0.0f) continue;
                        f5 = Math.abs(((Position)object5).getQuantity());
                    }
                }
                if (object5 == null) {
                    object5 = (Position)list.get(0);
                    if (f5 == 0.0f) {
                        f5 = Math.abs(((Position)object5).getQuantity());
                    }
                }
            }
            String string3 = object5 == null ? null : ((Position)object5).getTicket();
            object422 = string2;
            if (h.g((String)object422)) {
                object422 = string3;
            }
            ArrayList<MWOrder> arrayList2 = new ArrayList<MWOrder>();
            MWOrder mWOrder = null;
            MWOrder mWOrder2 = null;
            if (exitStep.isStopEnabled()) {
                f6 = this.calcOffset(exitStep.getStopOffset(), ticker, f2);
                if (exitStep.getStopType() == Enums$ExitStop.TRAIL && bs.u(account)) {
                    mWOrder = new MWOrder(string, ticker, (Enums$OrderAction)((Object)object2), Enums$OrderType.TRAIL);
                    mWOrder.setQuantity(f7);
                    mWOrder.setTif(enums$TIF);
                    if (bs.s(account)) {
                        float f8;
                        float f9 = f8 = bl3 ? ticker.getAskPrice() : ticker.getBidPrice();
                        if (f8 == 0.0f) {
                            f8 = ticker.getMidOrLast();
                        }
                        mWOrder.setAuxPrice(mWInstrument.round(bl3 ? f8 + f6 : f8 - f6));
                    } else if (bs.r(account)) {
                        mWOrder.setAuxPrice(Math.abs(f6));
                    } else {
                        mWOrder.setAuxPrice(f6 / (float)ticker.getTickSize());
                    }
                } else if (exitStep.getStopType() == Enums$ExitStop.STOP_LIMIT && bs.c(account, mWInstrument)) {
                    float f10 = bl3 ? f2 + f6 : f2 - f6;
                    mWOrder = new MWOrder(string, ticker, (Enums$OrderAction)((Object)object2), Enums$OrderType.STPLMT, f7, enums$TIF, mWInstrument.round(f10), Enums$OrderStatus.NEW);
                } else {
                    mWOrder = exitStep.getStopType() == Enums$ExitStop.MIT || !bs.b(account, mWInstrument) ? new MWOrder(string, ticker, (Enums$OrderAction)((Object)object2), Enums$OrderType.MIT, f7, enums$TIF, mWInstrument.round(bl3 ? f2 + f6 : f2 - f6), Enums$OrderStatus.NEW) : new MWOrder(string, ticker, (Enums$OrderAction)((Object)object2), Enums$OrderType.STP, f7, enums$TIF, mWInstrument.round(bl3 ? f2 + f6 : f2 - f6), Enums$OrderStatus.NEW);
                }
                arrayList2.add(mWOrder);
            }
            if (exitStep.isTargetEnabled()) {
                f6 = this.calcOffset(exitStep.getTargetOffset(), ticker, f2);
                mWOrder2 = new MWOrder(string, ticker, (Enums$OrderAction)((Object)object2), exitStep.getTargetType() == Enums$ExitTarget.MIT ? Enums$OrderType.MIT : Enums$OrderType.LMT, f7, enums$TIF, mWInstrument.round(bl3 ? f2 - f6 : f2 + f6), Enums$OrderStatus.NEW);
                arrayList2.add(mWOrder2);
            }
            float f10 = f6 = bl2 ? ticker.getBidPrice() : ticker.getAskPrice();
            if (f6 == 0.0f) {
                f6 = ticker.getMidOrLast();
            }
            if (f6 != 0.0f) {
                boolean bl5 = true;
                for (MWOrder mWOrder3 : arrayList2) {
                    if (mWOrder3.isStop() || mWOrder3.isTrail()) {
                        if (mWOrder3.isBuy() && mWOrder3.getTriggerPrice() <= f6) {
                            bl5 = false;
                            break;
                        }
                        if (!mWOrder3.isSell() || !(mWOrder3.getTriggerPrice() >= f6)) continue;
                        bl5 = false;
                        break;
                    }
                    if (!mWOrder3.isLimit()) continue;
                    if (mWOrder3.isBuy() && mWOrder3.getTriggerPrice() >= f6) {
                        bl5 = false;
                        break;
                    }
                    if (!mWOrder3.isSell() || !(mWOrder3.getTriggerPrice() <= f6)) continue;
                    bl5 = false;
                    break;
                }
                if (!bl5) {
                    h.a.warning("ExitStrategy::execute() unable to execute exit strategy, 1 or more orders are invalid (price: " + f6 + ")");
                    for (MWOrder mWOrder4 : arrayList2) {
                        h.a.warning(mWOrder4.toString());
                    }
                }
            }
            for (MWOrder mWOrder5 : arrayList2) {
                if (bs.a(account)) {
                    mWOrder5.setParentId(string3);
                    mWOrder5.setTradeId((String)object422);
                    mWOrder5.setUsePips(false);
                    mWOrder5.setEntryOrder(false);
                    mWOrder5.setNetClose(false);
                }
                OrderDirectory.createOrder(mWOrder5);
            }
            if (account.isHedging() && object5 != null && f5 >= f7) {
                for (MWOrder mWOrder6 : arrayList2) {
                    mWOrder6.setTradeId((String)object422);
                    mWOrder6.setParentId(((Position)object5).getTicket());
                }
            }
            if ((f5 -= f7) <= 0.0f) {
                f5 = 0.0f;
                list.remove(object5);
            }
            if (h.a(arrayList2)) {
                h.a.warning("EntryExitStrategy::doExit() no orders!");
                continue;
            }
            try {
                if (arrayList2.size() == 1) {
                    bs.b((MWOrder)arrayList2.get(0), gf2);
                } else {
                    bs.c(arrayList2, gf2);
                }
                if (mWOrder != null && this.is("beEnabled")) {
                    h.a.warning("ExitStrategy::execute() creating break even trigger: " + String.valueOf(mWOrder));
                    float f12 = this.calcOffset((double)((Double)this.get("beTrigger")), ticker, f2);
                    float f11 = this.calcOffset((double)((Double)this.get("beOffset")), ticker, f2);
                    OrderAction orderAction = new OrderAction(OrderAction$ActionType.BREAK_EVEN, mWOrder, mWInstrument.round(bl3 ? f2 - f12 : f2 + f12), mWInstrument.round(bl3 ? f2 - f11 : f2 + f11));
                    orderAction.activate(ticker);
                }
                arrayList.add(arrayList2);
                continue;
            }
            catch (MWException mWException) {
                ag.a(mWException, gf2);
            }
        }
        return arrayList;
    }

    public List createPlaceHolderOrders(MWOrder mWOrder) {
        float f2;
        com.motivewave.common.util.j j22;
        Enums$OrderAction enums$OrderAction = mWOrder.isBuy() ? Enums$OrderAction.SELL : Enums$OrderAction.BUY;
        Ticker ticker = mWOrder.getTicker();
        Account account = mWOrder.getAccount();
        Enums$TIF enums$TIF = mWOrder.getTif();
        boolean bl2 = enums$OrderAction == Enums$OrderAction.BUY;
        List list = this.getSteps();
        double d2 = 0.0;
        for (com.motivewave.common.util.j j22 : list) {
            d2 += ((ExitStep)j22).getQtyPer();
        }
        boolean bl3 = Math.round(d2) == 100L;
        j22 = ticker.getInstrument();
        String string = account.getAccountID();
        float f3 = f2 = Math.abs(mWOrder.getQuantity());
        float f4 = mWOrder.getTriggerPrice();
        float f5 = 0.0f;
        ArrayList<MWOrder> arrayList = new ArrayList<MWOrder>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            float f6;
            ExitStep exitStep = (ExitStep)list.get(i2);
            float f7 = Math.abs(((MWInstrument)j22).roundQty(f2 * (float)(exitStep.getQtyPer() / 100.0)));
            if (i2 == list.size() - 1 && bl3) {
                f7 = f3;
            }
            if (f7 == 0.0f) continue;
            f3 -= f7;
            MWOrder mWOrder2 = null;
            MWOrder mWOrder3 = null;
            if (exitStep.isStopEnabled()) {
                f6 = this.calcOffset(exitStep.getStopOffset(), ticker, f4);
                if (exitStep.getStopType() == Enums$ExitStop.TRAIL && bs.u(account)) {
                    mWOrder2 = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.TRAIL, Enums$OrderStatus.PRE_SUBMITTED);
                    mWOrder2.setQuantity(f7);
                    mWOrder2.setTif(enums$TIF);
                    if (bs.s(account)) {
                        var24_25 = f4;
                        mWOrder2.setAuxPrice(((MWInstrument)j22).round(bl2 ? var24_25 + f6 : var24_25 - f6));
                    } else if (bs.r(account)) {
                        mWOrder2.setAuxPrice(Math.abs(f6));
                    } else {
                        mWOrder2.setAuxPrice(f6 / (float)ticker.getTickSize());
                    }
                } else if (exitStep.getStopType() == Enums$ExitStop.STOP_LIMIT && bs.c(account, (MWInstrument)j22)) {
                    var24_25 = ((MWInstrument)j22).round(bl2 ? f4 + f6 : f4 - f6);
                    mWOrder2 = new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.STPLMT, f7, enums$TIF, var24_25, Enums$OrderStatus.PRE_SUBMITTED);
                } else {
                    mWOrder2 = exitStep.getStopType() == Enums$ExitStop.MIT || !bs.b(account, (MWInstrument)j22) ? new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.MIT, f7, enums$TIF, ((MWInstrument)j22).round(bl2 ? f4 + f6 : f4 - f6), Enums$OrderStatus.PRE_SUBMITTED) : new MWOrder(string, ticker, enums$OrderAction, Enums$OrderType.STP, f7, enums$TIF, ((MWInstrument)j22).round(bl2 ? f4 + f6 : f4 - f6), Enums$OrderStatus.PRE_SUBMITTED);
                }
                mWOrder2.setExitStep(exitStep);
                mWOrder2.setParentId(mWOrder.getOrderId());
                arrayList.add(mWOrder2);
            }
            if (exitStep.isTargetEnabled()) {
                f6 = this.calcOffset(exitStep.getTargetOffset(), ticker, f4);
                mWOrder3 = new MWOrder(string, ticker, enums$OrderAction, exitStep.getTargetType() == Enums$ExitTarget.MIT ? Enums$OrderType.MIT : Enums$OrderType.LMT, f7, enums$TIF, ((MWInstrument)j22).round(bl2 ? f4 - f6 : f4 + f6), Enums$OrderStatus.PRE_SUBMITTED);
                mWOrder3.setParentId(mWOrder.getOrderId());
                mWOrder3.setExitStep(exitStep);
                arrayList.add(mWOrder3);
            }
            if (mWOrder3 != null && mWOrder2 != null) {
                String string2 = OrderDirectory.genOCOID();
                mWOrder3.setOCAId(string2);
                mWOrder2.setOCAId(string2);
            }
            if (!((f5 -= f7) <= 0.0f)) continue;
            f5 = 0.0f;
        }
        return arrayList;
    }

    int offsetTicks(double d2, Ticker ticker, float f2) {
        if (this.getOffsetType() == Enums$ExitOffset.PERCENT) {
            return (int)((double)ticker.round(f2 * (float)(d2 / 100.0)) / ticker.getTickSize());
        }
        return (int)d2;
    }

    public float calcOffset(double d2, Ticker ticker, float f2) {
        if (this.getOffsetType() == Enums$ExitOffset.PERCENT) {
            return ticker.round(f2 * (float)(d2 / 100.0));
        }
        return ticker.round((float)(d2 * ticker.getTickSize()));
    }

    public float calcOffset(double d2, MWInstrument mWInstrument, float f2) {
        if (this.getOffsetType() == Enums$ExitOffset.PERCENT) {
            return mWInstrument.round(f2 * (float)(d2 / 100.0));
        }
        return mWInstrument.round((float)(d2 * mWInstrument.getMinTick()));
    }

    @Override
    public Settings$Definition getDefinition() {
        return def;
    }

    @Override
    public ExitStrategy clone() {
        try {
            return (ExitStrategy)super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void addListener(UpdateListener updateListener) {
        listeners.a((Object)updateListener);
    }

    public static void removeListener(UpdateListener updateListener) {
        listeners.a((Object)updateListener);
    }

    public static void read() {
        ExitStrategy.clear();
        File file = Workspace.findFile("exit_strategies");
        if (file == null || !file.exists()) {
            all.a((Object)new ExitStrategy("bracket1", ab.a("LBL_BRACKET_EXIT_1", new Object[0]), (List)h.b(new ExitStep[]{new ExitStep(100.0, 10.0, 10.0)})));
            all.a((Object)new ExitStrategy("bracket2", ab.a("LBL_BRACKET_EXIT_2", new Object[0]), (List)h.b(new ExitStep[]{new ExitStep(50.0, 10.0, 10.0), new ExitStep(50.0, 10.0, 20.0)})));
            all.a((Object)new ExitStrategy("bracket3", ab.a("LBL_BRACKET_EXIT_3", new Object[0]), (List)h.b(new ExitStep[]{new ExitStep(33.0, 10.0, 10.0), new ExitStep(33.0, 10.0, 20.0), new ExitStep(34.0, 10.0, 30.0)})));
            return;
        }
        String string = h.c(file);
        if (h.g(string)) {
            return;
        }
        try {
            ArrayList<ExitStrategy> arrayList = new ArrayList<ExitStrategy>();
            JSONArray jSONArray = new JSONArray(string);
            for (JSONObject jSONObject : jSONArray.asObjList()) {
                ExitStrategy exitStrategy = new ExitStrategy();
                exitStrategy.fromJSON(jSONObject);
                arrayList.add(exitStrategy);
            }
            all.d(arrayList);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void saveAll() {
        h.c(new File(Workspace.findDir("exit_strategies"), "exit_strategies.json"), ExitStrategy.write());
    }

    public static void saveAll(File file) {
        h.a(new File(file, "exit_strategies.json"), ExitStrategy.write());
    }

    private static String write() {
        return new ai().b(all.a());
    }

    public static void register(ExitStrategy exitStrategy) {
        all.a((Object)exitStrategy);
        ExitStrategy.notifyUpdate();
    }

    public static void remove(List list) {
        all.c(list);
        ExitStrategy.notifyUpdate();
    }

    public static void setAll(List list) {
        all.d(list);
        ExitStrategy.notifyUpdate();
    }

    public static void clear() {
        all.b();
        ExitStrategy.notifyUpdate();
    }

    public static List getAll() {
        return all.a();
    }

    public static ExitStrategy getById(String string) {
        if (h.g(string)) {
            return null;
        }
        for (ExitStrategy exitStrategy : all.a()) {
            if (!h.a((Object)string, (Object)exitStrategy.getId())) continue;
            return exitStrategy;
        }
        return null;
    }

    public static void notifyUpdate() {
        for (UpdateListener updateListener : listeners.a()) {
            updateListener.updated();
        }
    }
}

