/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.b;
import com.motivewave.common.h;
import com.motivewave.common.util.g;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.a;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.Execution;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.service.bs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class Executions {
    private static List active = new ArrayList();
    private static SortedSet all = new TreeSet();
    private static Map id2Exec = new HashMap();
    private static Map posId2Exec = new HashMap();
    private static Set acctIds = new HashSet();
    private static g listeners = new g();
    private static boolean unsavedChanges = false;
    private static Comparator comparator = (execution, execution2) -> {
        if (execution == execution2) {
            return 0;
        }
        if (execution.getTime() > execution2.getTime()) {
            return 1;
        }
        if (execution.getTime() < execution2.getTime()) {
            return -1;
        }
        return execution.getId().compareTo(execution2.getId());
    };
    private static Runnable notifyUpdated = () -> {
        for (Runnable runnable : listeners.a()) {
            try {
                runnable.run();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void save() {
        if (!unsavedChanges) {
            return;
        }
        unsavedChanges = false;
        File file = Workspace.findDir("trade_history");
        PrintWriter printWriter = null;
        try {
            long l2 = System.currentTimeMillis();
            ArrayList<Execution> arrayList = new ArrayList<Execution>();
            List list = active;
            synchronized (list) {
                for (Object object : all) {
                    if (!((Execution)object).isPersistent()) continue;
                    arrayList.add((Execution)object);
                }
            }
            int n2 = 1;
            LinkedHashMap linkedHashMap = new LinkedHashMap();
            for (Execution execution : arrayList) {
                n2 = Execution.addIds(execution, linkedHashMap, n2);
            }
            printWriter = new PrintWriter(new File(file, "trade_history.csv"));
            a.a(printWriter, (Map)linkedHashMap);
            for (Execution execution : arrayList) {
                Execution.toCSV(execution, linkedHashMap, printWriter);
            }
            printWriter.flush();
            printWriter.close();
            h.a.info("Executions::write() wrote: %d records elapsed time: %d ms.".formatted(arrayList.size(), System.currentTimeMillis() - l2));
            h.a(printWriter);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            h.a(printWriter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void read(boolean bl2) {
        Object object;
        Object object2;
        File file = new File(bs.a().getConfigDir(), "trade_history.csv");
        if (!file.exists()) {
            return;
        }
        TreeSet<Execution> treeSet = new TreeSet<Execution>(comparator);
        long l2 = System.currentTimeMillis();
        try {
            object2 = new BufferedReader(new FileReader(file));
            Object object3 = ((BufferedReader)object2).readLine();
            if (object3 != null) {
                Object object4 = a.a((String)object3);
                if (object4 != null) {
                    object3 = ((BufferedReader)object2).readLine();
                }
                while (object3 != null) {
                    object = Execution.fromCSV((String)object3, (Map)object4);
                    if (object != null) {
                        treeSet.add((Execution)object);
                    }
                    object3 = ((BufferedReader)object2).readLine();
                }
            }
            ((BufferedReader)object2).close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        h.a.info("Executions::read() read: %d records elapsed time: %d ms".formatted(treeSet.size(), System.currentTimeMillis() - l2));
        object2 = active;
        synchronized (object2) {
            if (bl2) {
                all = treeSet;
            } else {
                all.addAll(treeSet);
            }
            posId2Exec.clear();
            active.clear();
            for (Object object4 : all) {
                id2Exec.put(((Execution)object4).getAccountId() + ":" + ((Execution)object4).getId(), object4);
                if (h.g(((Execution)object4).getPositionId())) continue;
                object = (List)posId2Exec.get(((Execution)object4).getPositionId());
                if (object == null) {
                    object = new ArrayList<Object>();
                    posId2Exec.put(((Execution)object4).getPositionId(), object);
                }
                object.remove(object4);
                if (object.size() > 0) {
                    Execution execution = (Execution)object.get(0);
                    execution.setLinkedTrade((Execution)object4);
                    ((Execution)object4).setLinkedTrade(execution);
                }
                object.add(object4);
            }
            Executions.updateActive();
        }
        Executions.notifyUpdated();
        unsavedChanges = !bl2;
    }

    public static void register(List list) {
        list.sort(comparator);
        for (Execution execution : new ArrayList(list)) {
            if (Executions.exists(execution.getAccountId(), execution.getId())) {
                list.remove(execution);
                continue;
            }
            Executions._register(execution);
        }
        if (h.a((Collection)list)) {
            return;
        }
        for (Execution execution : list) {
            execution.updateInfo();
        }
        Executions.notifyUpdated();
    }

    public static void register(Execution execution) {
        if (execution == null || Executions.exists(execution.getAccountId(), execution.getId())) {
            return;
        }
        Executions._register(execution);
        execution.updateInfo();
        Executions.notifyUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void _register(Execution execution) {
        if (execution == null) {
            return;
        }
        try {
            List list = active;
            synchronized (list) {
                List<Execution> list2;
                String string = execution.getAccountId() + ":" + execution.getId();
                if (id2Exec.containsKey(string)) {
                    return;
                }
                unsavedChanges = true;
                if (active.size() > com.motivewave.platform.common.b.b() + 100) {
                    while (active.size() >= com.motivewave.platform.common.b.b()) {
                        active.remove(0);
                    }
                }
                if (h.a((Collection)active)) {
                    active.add(execution);
                } else {
                    list2 = (Execution)active.get(active.size() - 1);
                    active.add(execution);
                    if (execution.getTime() < ((Execution)((Object)list2)).getTime()) {
                        active.sort(comparator);
                    }
                }
                all.add(execution);
                id2Exec.put(string, execution);
                if (h.g(execution.getPositionId())) {
                    return;
                }
                list2 = (List)posId2Exec.get(execution.getPositionId());
                if (list2 == null) {
                    list2 = new ArrayList<Execution>();
                    posId2Exec.put(execution.getPositionId(), list2);
                }
                list2.remove(execution);
                if (list2.size() > 0) {
                    Execution execution2 = (Execution)list2.get(0);
                    execution2.setLinkedTrade(execution);
                    execution.setLinkedTrade(execution2);
                }
                list2.add(execution);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List byPosition(String string) {
        List list = active;
        synchronized (list) {
            List list2 = (List)posId2Exec.get(string);
            return list2 == null ? new ArrayList() : new ArrayList(list2);
        }
    }

    public static List byAccountAndInstr(Account account, Instrument instrument) {
        return Executions.filter(Executions.getAll(), account, ((Ticker)instrument).getInstrument());
    }

    public static List byAccountAndInstr(Account account, MWInstrument mWInstrument) {
        return Executions.filter(Executions.getAll(), account, mWInstrument);
    }

    public static List filter(List list, Account account, MWInstrument mWInstrument) {
        if (account != null) {
            account = account.getLeadAccount();
        }
        if (mWInstrument.isCustomContinuous()) {
            mWInstrument = mWInstrument.getActiveContract();
        }
        MWInstrument mWInstrument2 = mWInstrument.getAcctInstrument(account);
        ArrayList<Execution> arrayList = new ArrayList<Execution>();
        for (Execution execution : list) {
            if (account != null && !account.isAccount(execution.getAccountId()) || !h.a((Object)execution.getMWInstrument(), new Object[]{mWInstrument2, mWInstrument})) continue;
            arrayList.add(execution);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List byAccount(Account account) {
        if (account != null) {
            account = account.getLeadAccount();
        }
        List list = active;
        synchronized (list) {
            ArrayList<Execution> arrayList = new ArrayList<Execution>();
            for (Execution execution : all) {
                if (account != null && !account.isAccount(execution.getAccountId())) continue;
                arrayList.add(execution);
            }
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearByAccount(Account account) {
        if (account != null) {
            account = account.getLeadAccount();
        }
        List list = active;
        synchronized (list) {
            for (Execution execution : new ArrayList(active)) {
                if (account != null && !account.isAccount(execution.getAccountId())) continue;
                active.remove(execution);
            }
            for (Execution execution : new ArrayList(all)) {
                if (account != null && !account.isAccount(execution.getAccountId())) continue;
                all.remove(execution);
                active.remove(execution);
                id2Exec.remove(execution.getAccountId() + ":" + execution.getId());
                posId2Exec.remove(execution.getPositionId());
                execution.destroy();
            }
        }
        unsavedChanges = true;
        Executions.notifyUpdated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAll() {
        List list = active;
        synchronized (list) {
            for (Execution execution : all) {
                execution.destroy();
            }
            all.clear();
            active.clear();
            posId2Exec.clear();
            id2Exec.clear();
            Account.clearExecReqs();
            unsavedChanges = true;
        }
        Executions.notifyUpdated();
    }

    public static void addListener(Runnable runnable) {
        listeners.a((Object)runnable);
    }

    public static void removeListener(Runnable runnable) {
        listeners.a((Object)runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Execution getLatest(Enums$ServiceType enums$ServiceType) {
        if (h.a((Collection)active)) {
            Executions.updateActive();
        }
        List list = active;
        synchronized (list) {
            if (h.a((Collection)active)) {
                return null;
            }
            Iterator iterator = h.a(active).iterator();
            while (iterator.hasNext()) {
                Execution execution = (Execution)iterator.next();
                if (execution.getServiceType() != enums$ServiceType) continue;
                return execution;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List byInstrument(MWInstrument mWInstrument) {
        List list = active;
        synchronized (list) {
            if (mWInstrument == null) {
                return Executions.getAll();
            }
            ArrayList<Execution> arrayList = new ArrayList<Execution>();
            for (Execution execution : active) {
                if (execution == null || !MWInstrument.isRelated(mWInstrument, execution.getMWInstrument())) continue;
                arrayList.add(execution);
            }
            return arrayList;
        }
    }

    public static boolean exists(String string, String string2) {
        return Executions.find(string, string2) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Execution find(String string, String string2) {
        List list = active;
        synchronized (list) {
            return (Execution)id2Exec.get(string + ":" + string2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        List list = active;
        synchronized (list) {
            if (active.size() <= com.motivewave.platform.common.b.b()) {
                return new ArrayList(active);
            }
            return h.a(active, active.size() - com.motivewave.platform.common.b.c() - 1, active.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getFiltered(cc.b b2) {
        if (b2 == null || h.a((Object)b2.a(), (Object)"all")) {
            return Executions.getAll();
        }
        List list = active;
        synchronized (list) {
            ArrayList<Execution> arrayList = new ArrayList<Execution>();
            for (Execution execution : active) {
                if (!b2.a(execution.getAccount())) continue;
                arrayList.add(execution);
            }
            if (arrayList.size() <= com.motivewave.platform.common.b.b()) {
                return arrayList;
            }
            return h.a(arrayList, arrayList.size() - com.motivewave.platform.common.b.c() - 1, arrayList.size());
        }
    }

    private static void notifyUpdated() {
        b.a(notifyUpdated, 100L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateActive() {
        List list = bs.v();
        List list2 = active;
        synchronized (list2) {
            Object object2;
            boolean bl2 = false;
            for (Object object2 : list) {
                if (acctIds.contains(((Account)object2).getAccountID())) continue;
                bl2 = true;
                break;
            }
            if (!bl2 && !active.isEmpty()) {
                return;
            }
            acctIds.clear();
            for (Object object2 : list) {
                acctIds.add(((Account)object2).getAccountID());
            }
            TreeSet treeSet = new TreeSet(comparator);
            object2 = h.a(new ArrayList(all)).iterator();
            while (object2.hasNext()) {
                Execution execution = (Execution)object2.next();
                if (!acctIds.contains(execution.getAccountId())) continue;
                treeSet.add(execution);
                if (treeSet.size() < com.motivewave.platform.common.b.b()) continue;
                break;
            }
            active.clear();
            active.addAll(treeSet);
        }
    }

    public static Execution register(MWInstrument mWInstrument, String string, String string2, String string3, String string4, String string5, String string6, long l2, String string7, Enums$OrderAction enums$OrderAction, float f2, float f3, double d2, boolean bl2, double d3) {
        return Executions.register(mWInstrument, string, string2, string3, string4, string5, string6, l2, string7, enums$OrderAction, f2, f3, d2, bl2, d3, 0.0);
    }

    public static Execution register(MWInstrument mWInstrument, String string, String string2, String string3, String string4, String string5, String string6, long l2, String string7, Enums$OrderAction enums$OrderAction, float f2, float f3, double d2, boolean bl2, double d3, double d4) {
        if (mWInstrument == null) {
            h.a.severe("TradeHistoryDirectory::register() instrument is null! orderId: " + string6);
            return null;
        }
        Execution execution = Executions.find(string3, string);
        if (execution != null) {
            return execution;
        }
        execution = new Execution(LiveTicker.get(mWInstrument), string, string2, string3, string4, string5, string6, l2, string7, enums$OrderAction, f2, f3, bl2, d3, d2, d4);
        Executions._register(execution);
        execution.updateInfo();
        if (!h.g(string5)) {
            for (Execution execution2 : Executions.byPosition(string5)) {
                execution2.updateInfo();
            }
        }
        Executions.notifyUpdated();
        return execution;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Execution byOrderId(String string) {
        List list = active;
        synchronized (list) {
            for (Execution execution : new ArrayList(active)) {
                if (!h.a((Object)execution.getOrderId(), (Object)string)) continue;
                return execution;
            }
        }
        return null;
    }

    static Execution register(String string, String string2, MWOrder mWOrder, boolean bl2, float f2, float f3, double d2) {
        if (mWOrder.getAcctInstrument() == null) {
            h.a.severe("Executions::register() order instrument is null! " + String.valueOf(mWOrder));
            return null;
        }
        Execution execution = Executions.find(mWOrder.getAccountId(), string);
        if (execution != null) {
            h.a.warning("Executions::register() already registered (2)! " + string);
            return execution;
        }
        long l2 = mWOrder.getLastFillTime();
        if (l2 == 0L) {
            l2 = bs.a();
        }
        execution = new Execution(mWOrder.getTicker(), string, null, mWOrder.getAccountId(), null, string2, mWOrder.getOrderId(), l2, mWOrder.getAcctInstrument().getExchange(), mWOrder.getAction(), Math.abs(f2), f3, bl2, d2, mWOrder.getCommission() * (double)Math.abs(f2) / (double)Math.abs(mWOrder.getFilled()), 0.0);
        Executions._register(execution);
        execution.updateInfo();
        for (Execution execution2 : Executions.byPosition(string2)) {
            execution2.updateInfo();
        }
        Executions.notifyUpdated();
        return execution;
    }
}

