/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.Enums$DayOfWeek;
import com.motivewave.common.h;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.Execution;
import com.motivewave.platform.databean.Executions;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.PeriodData;
import com.motivewave.platform.databean.StrategyMetric;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.databean.Trade;
import com.motivewave.platform.databean.TradingHours;
import com.motivewave.platform.databean.af;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.l;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import k.b;

public class ExecutionReport {
    private String acctId;
    private MWInstrument instrument;
    private long start;
    private long end;
    private int tradeCount = 0;
    private Map currentPosition = new HashMap();
    private List executions = new ArrayList();
    private List trades = new ArrayList();
    private double profit;
    private double profitLong;
    private double profitShort;
    private double grossProfit;
    private double grossProfitLong;
    private double grossProfitShort;
    private double grossLoss;
    private double grossLossLong;
    private double grossLossShort;
    private double commissions;
    private double commissionsLong;
    private double commissionsShort;
    private double maxDrawdown;
    private double maxDrawdownLong;
    private double maxDrawdownShort;
    private double maxDrawdownPercent;
    private double maxDrawdownPercentLong;
    private double maxDrawdownPercentShort;
    private int totalTrades;
    private int totalTradesLong;
    private int totalTradesShort;
    private int totalQuantity;
    private int totalQuantityLong;
    private int totalQuantityShort;
    private int winningTrades;
    private int winningTradesLong;
    private int winningTradesShort;
    private int losingTrades;
    private int losingTradesLong;
    private int losingTradesShort;
    private int maxConsecutiveWins;
    private int maxConsecutiveWinsLong;
    private int maxConsecutiveWinsShort;
    private int maxConsecutiveLosses;
    private int maxConsecutiveLossesLong;
    private int maxConsecutiveLossesShort;
    private double largestWinningTrade;
    private double largestWinningTradeLong;
    private double largestWinningTradeShort;
    private double largestLosingTrade;
    private double largestLosingTradeLong;
    private double largestLosingTradeShort;
    private double avgTrade;
    private double avgTradeLong;
    private double avgTradeShort;
    private double avgWinningTrade;
    private double avgWinningTradeLong;
    private double avgWinningTradeShort;
    private double avgLosingTrade;
    private double avgLosingTradeLong;
    private double avgLosingTradeShort;
    private double winningVsLosingTrade;
    private double winningVsLosingTradeLong;
    private double winningVsLosingTradeShort;
    private double avgMAE;
    private double avgMAELong;
    private double avgMAEShort;
    private double avgMAEPercent;
    private double avgMAEPercentLong;
    private double avgMAEPercentShort;
    private double avgMAEPoints;
    private double avgMAEPointsLong;
    private double avgMAEPointsShort;
    private double avgMFE;
    private double avgMFELong;
    private double avgMFEShort;
    private double avgMFEPercent;
    private double avgMFEPercentLong;
    private double avgMFEPercentShort;
    private double avgMFEPoints;
    private double avgMFEPointsLong;
    private double avgMFEPointsShort;
    private double profitPerDay;
    private double profitPerDayLong;
    private double profitPerDayShort;
    private long avgTimeInTrade;
    private long avgTimeInTradeLong;
    private long avgTimeInTradeShort;
    private int tradingDays;
    private double initialAccountValue;
    private List metrics;
    private Map dailyData = new LinkedHashMap();
    private Map weeklyData = new LinkedHashMap();
    private Map monthlyData = new LinkedHashMap();
    private Map dayOfWeekData = new LinkedHashMap();
    private Map hourOfDayData = new LinkedHashMap();
    private Map halfHourOfDayData = new LinkedHashMap();

    public ExecutionReport(Account account, MWInstrument mWInstrument, long l2, long l3) {
        this.acctId = account == null ? null : account.getAccountID();
        this.instrument = mWInstrument;
        this.start = l2;
        this.end = l3;
    }

    public String getAccountId() {
        return this.acctId;
    }

    public MWInstrument getInstrument() {
        return this.instrument;
    }

    public long getStartFilter() {
        return this.start;
    }

    public long getEndFilter() {
        return this.end;
    }

    public long getEndTime() {
        return this.end == -1L ? bs.a() : this.end;
    }

    public long getStartTime() {
        if (this.start != -1L) {
            return this.start;
        }
        if (h.a((Collection)this.executions)) {
            return bs.a();
        }
        return ((Execution)this.executions.get(0)).getTime();
    }

    public double getNetProfit() {
        return this.profit;
    }

    public double getGrossProfit() {
        return this.grossProfit;
    }

    public double getGrossLoss() {
        return this.grossLoss;
    }

    public double getCommissions() {
        return this.commissions;
    }

    public double getMaxDrawdown() {
        return this.maxDrawdown;
    }

    public int getExecutionCount() {
        return this.executions.size();
    }

    public List getExecutions() {
        return this.executions;
    }

    public List getTrades() {
        return this.trades;
    }

    public int getTotalTrades() {
        return this.totalTrades;
    }

    public int getTotalTradesLong() {
        return this.totalTradesLong;
    }

    public int getTotalTradesShort() {
        return this.totalTradesShort;
    }

    public List getMetrics() {
        return this.metrics;
    }

    public Map getDailyData() {
        return this.dailyData;
    }

    public Map getWeeklyData() {
        return this.weeklyData;
    }

    public Map getMonthlyData() {
        return this.monthlyData;
    }

    public Map getDayOfWeekData() {
        return this.dayOfWeekData;
    }

    public Map getHourOfDayData() {
        return this.hourOfDayData;
    }

    public Map getHalfHourOfDayData() {
        return this.halfHourOfDayData;
    }

    public void calculate() {
        this.tradeCount = 0;
        this.executions.clear();
        this.trades.clear();
        this.currentPosition.clear();
        List list = Executions.getAll();
        list.sort((execution, execution2) -> Long.compare(execution.getTime(), execution2.getTime()));
        for (Execution execution3 : list) {
            this.processTrade(execution3);
        }
        double d2 = 0.0;
        Account account = bs.a(this.acctId);
        if (account != null) {
            d2 = account.getAccountValue();
            if (d2 == 0.0) {
                d2 = account.getCashBalance();
            }
            if (d2 == 0.0) {
                d2 = account.getBalance();
            }
        }
        double d3 = 0.0;
        double d4 = 0.0;
        ArrayList<Instrument> arrayList = new ArrayList<Instrument>();
        for (Trade trade : this.trades) {
            if (!arrayList.contains(trade.getInstrument())) {
                arrayList.add(trade.getInstrument());
            }
            trade.setCumulativePnl(d3 += trade.getPnl());
            trade.setCumulativeCommisssion(d4 += trade.getCommission());
            d2 -= trade.getNetPnl();
        }
        this.initialAccountValue = d2;
        for (Instrument instrument : arrayList) {
            try {
                ObservableBean observableBean2;
                ArrayList<ObservableBean> arrayList2 = new ArrayList<ObservableBean>();
                long l2 = 0L;
                long l3 = 0L;
                boolean bl2 = false;
                for (ObservableBean observableBean2 : this.trades) {
                    if (((Trade)observableBean2).getInstrument() != instrument) continue;
                    if (l2 == 0L) {
                        l2 = ((Trade)observableBean2).getEntryTime();
                    }
                    if (((Trade)observableBean2).getEntryTime() > l3) {
                        l3 = ((Trade)observableBean2).getEntryTime();
                    }
                    if (((Trade)observableBean2).getExitTime() > l3) {
                        l3 = ((Trade)observableBean2).getExitTime();
                    }
                    if (((Trade)observableBean2).isOpen()) {
                        bl2 = true;
                    }
                    arrayList2.add(observableBean2);
                }
                Ticker ticker = (Ticker)instrument;
                l3 = bl2 ? h.d(ticker.getCurrentTime()) + 60000L : h.c(l3);
                observableBean2 = ticker.getInstrument();
                List list2 = l.a((MWInstrument)observableBean2, h.b(l2), l3, false);
                for (List list3 : list2) {
                    for (b b2 : list3) {
                        Trade trade;
                        Iterator iterator = arrayList2.iterator();
                        while (iterator.hasNext() && (trade = (Trade)iterator.next()).getEntryTime() <= b2.getEndTime()) {
                            if (trade.getExitTime() != 0L && trade.getExitTime() <= b2.getStartTime()) continue;
                            if (b2.getHigh() > trade.getMaxPrice() || trade.getMaxPrice() == 0.0f) {
                                trade.setMaxPrice(b2.getHigh());
                            }
                            if (!(b2.getLow() < trade.getMinPrice()) && trade.getMinPrice() != 0.0f) continue;
                            trade.setMinPrice(b2.getLow());
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        this.calculateReport();
    }

    private void calculateReport() {
        PeriodData periodData;
        PeriodData periodData2;
        Object object;
        Object object22;
        int n2;
        int n3;
        ArrayList<Instrument> arrayList = new ArrayList<Instrument>();
        if (h.a((Collection)this.trades)) {
            return;
        }
        long l2 = ((Trade)this.trades.get(0)).getEntryTime();
        Trade trade = (Trade)this.trades.get(this.trades.size() - 1);
        long l3 = trade.getEntryTime();
        if (trade.getExitTime() != 0L) {
            l3 = trade.getExitTime();
        }
        for (Object object3 : this.trades) {
            if (arrayList.contains(((Trade)object3).getInstrument())) continue;
            arrayList.add(((Trade)object3).getInstrument());
        }
        int n4 = 0;
        for (Instrument instrument : arrayList) {
            MWInstrument mWInstrument = ((Ticker)instrument).getInstrument();
            TradingHours tradingHours = mWInstrument.getTradingHours();
            n3 = 0;
            if (tradingHours != null) {
                long l4 = mWInstrument.getEndOfDay(l3, false);
                for (var13_16 = mWInstrument.getStartOfDay(l2, false); var13_16 <= l4; var13_16 += 86400000L) {
                    if (!tradingHours.isTradingDay(var13_16)) continue;
                    ++n3;
                }
            } else {
                for (var13_16 = l2; var13_16 <= l3; var13_16 += 86400000L) {
                    int n5 = h.a(var13_16);
                    if (!mWInstrument.isCrypto() && (n5 == 1 || n5 == 7)) continue;
                    ++n3;
                }
            }
            if (n3 <= n4) continue;
            n4 = n3;
        }
        this.tradingDays = n4;
        this.totalTrades = this.trades.size();
        this.totalTradesShort = 0;
        this.totalTradesLong = 0;
        this.winningTradesShort = 0;
        this.winningTradesLong = 0;
        this.winningTrades = 0;
        this.losingTradesShort = 0;
        this.losingTradesLong = 0;
        this.losingTrades = 0;
        this.maxConsecutiveLossesShort = 0;
        this.maxConsecutiveLossesLong = 0;
        this.maxConsecutiveLosses = 0;
        this.maxConsecutiveWinsShort = 0;
        this.maxConsecutiveWinsLong = 0;
        this.maxConsecutiveWins = 0;
        this.largestWinningTradeShort = 0.0;
        this.largestWinningTradeLong = 0.0;
        this.largestWinningTrade = 0.0;
        this.largestLosingTradeShort = 0.0;
        this.largestLosingTradeLong = 0.0;
        this.largestLosingTrade = 0.0;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        n3 = 0;
        int n10 = 0;
        long l5 = 0L;
        long l6 = 0L;
        long l7 = 0L;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        double d9 = 0.0;
        double d10 = 0.0;
        double d11 = 0.0;
        double d12 = 0.0;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        double d19 = 0.0;
        this.totalQuantityShort = 0;
        this.totalQuantityLong = 0;
        this.totalQuantity = 0;
        double d20 = this.initialAccountValue;
        double d21 = this.initialAccountValue;
        double d22 = this.initialAccountValue;
        for (Trade trade2 : this.trades) {
            long l8 = trade2.getExitTime() - trade2.getEntryTime();
            if (trade2.getExitTime() == 0L) {
                l8 = 0L;
            }
            d2 += trade2.getMAEPnl();
            d5 += trade2.getMAEPercent();
            d8 += trade2.getMAEPoints();
            d11 += trade2.getMFEPnl();
            d14 += trade2.getMFEPercent();
            d17 += trade2.getMFEPoints();
            l5 += l8;
            this.commissions += trade2.getCommission();
            this.profit += trade2.getPnl();
            this.totalQuantity = (int)((float)this.totalQuantity + trade2.getQuantity());
            trade2.setAccountValue(d20 += trade2.getNetPnl());
            if (trade2.isLong()) {
                ++this.totalTradesLong;
                l6 += l8;
                d3 += trade2.getMAEPnl();
                d6 += trade2.getMAEPercent();
                d9 += trade2.getMAEPoints();
                d12 += trade2.getMFEPnl();
                d15 += trade2.getMFEPercent();
                d18 += trade2.getMFEPoints();
                this.commissionsLong += trade2.getCommission();
                this.profitLong += trade2.getPnl();
                this.totalQuantityLong = (int)((float)this.totalQuantityLong + trade2.getQuantity());
                d21 += trade2.getNetPnl();
                trade2.setAccountValueLong(d20);
            } else {
                ++this.totalTradesShort;
                l7 += l8;
                d4 += trade2.getMAEPnl();
                d7 += trade2.getMAEPercent();
                d10 += trade2.getMAEPoints();
                d13 += trade2.getMFEPnl();
                d16 += trade2.getMFEPercent();
                d19 += trade2.getMFEPoints();
                this.commissionsShort += trade2.getCommission();
                this.profitShort += trade2.getPnl();
                this.totalQuantityShort = (int)((float)this.totalQuantityShort + trade2.getQuantity());
                d22 += trade2.getNetPnl();
                trade2.setAccountValueShort(d20);
            }
            if (trade2.getPnl() > 0.0) {
                this.grossProfit += trade2.getPnl();
                if (n9 > this.maxConsecutiveLosses) {
                    this.maxConsecutiveLosses = n9;
                }
                if (n3 > this.maxConsecutiveLossesLong) {
                    this.maxConsecutiveLossesLong = n3;
                }
                if (n10 > this.maxConsecutiveLossesShort) {
                    this.maxConsecutiveLossesShort = n10;
                }
                n10 = 0;
                n3 = 0;
                n9 = 0;
                if (trade2.getPnl() > this.largestWinningTrade) {
                    this.largestWinningTrade = trade2.getPnl();
                }
                ++this.winningTrades;
                ++n6;
                if (trade2.isLong()) {
                    this.grossProfitLong += trade2.getPnl();
                    ++this.winningTradesLong;
                    ++n7;
                    if (!(trade2.getPnl() > this.largestWinningTradeLong)) continue;
                    this.largestWinningTradeLong = trade2.getPnl();
                    continue;
                }
                this.grossProfitShort += trade2.getPnl();
                ++this.winningTradesShort;
                ++n8;
                if (!(trade2.getPnl() > this.largestWinningTradeShort)) continue;
                this.largestWinningTradeShort = trade2.getPnl();
                continue;
            }
            if (!(trade2.getPnl() < 0.0)) continue;
            this.grossLoss += trade2.getPnl();
            if (n6 > this.maxConsecutiveWins) {
                this.maxConsecutiveWins = n6;
            }
            if (n7 > this.maxConsecutiveWinsLong) {
                this.maxConsecutiveWinsLong = n7;
            }
            if (n8 > this.maxConsecutiveWinsShort) {
                this.maxConsecutiveWinsShort = n8;
            }
            if (trade2.getPnl() < this.largestLosingTrade) {
                this.largestLosingTrade = trade2.getPnl();
            }
            n8 = 0;
            n7 = 0;
            n6 = 0;
            ++this.losingTrades;
            ++n9;
            if (trade2.isLong()) {
                this.grossLossLong += trade2.getPnl();
                ++this.losingTradesLong;
                ++n3;
                if (!(trade2.getPnl() < this.largestLosingTradeLong)) continue;
                this.largestLosingTradeLong = trade2.getPnl();
                continue;
            }
            this.grossLossShort += trade2.getPnl();
            ++this.losingTradesShort;
            ++n10;
            if (!(trade2.getPnl() < this.largestLosingTradeShort)) continue;
            this.largestLosingTradeShort = trade2.getPnl();
        }
        if (n6 > this.maxConsecutiveWins) {
            this.maxConsecutiveWins = n6;
        }
        if (n7 > this.maxConsecutiveWinsLong) {
            this.maxConsecutiveWinsLong = n7;
        }
        if (n8 > this.maxConsecutiveWinsShort) {
            this.maxConsecutiveWinsShort = n8;
        }
        if (n9 > this.maxConsecutiveLosses) {
            this.maxConsecutiveLosses = n9;
        }
        if (n3 > this.maxConsecutiveLossesLong) {
            this.maxConsecutiveLossesLong = n3;
        }
        if (n10 > this.maxConsecutiveLossesShort) {
            this.maxConsecutiveLossesShort = n10;
        }
        double d23 = d20 = this.initialAccountValue;
        d21 = this.initialAccountValue;
        double d24 = d20;
        d22 = this.initialAccountValue;
        double d25 = d20;
        this.maxDrawdown = 0.0;
        for (Trade trade3 : this.trades) {
            double d26 = trade3.getNetPnl();
            if (d26 == 0.0) continue;
            if (d23 < (d20 += d26)) {
                d23 = d20;
            }
            if (trade3.isLong()) {
                if (d24 < (d21 += d26)) {
                    d24 = d21;
                }
            } else if (d25 < (d22 += d26)) {
                d25 = d22;
            }
            if (!(d26 < 0.0)) continue;
            double d27 = Math.abs(d23 - d20);
            if (d27 > this.maxDrawdown) {
                this.maxDrawdown = d27;
                this.maxDrawdownPercent = 1.0 - d20 / d23;
            }
            if (trade3.isLong()) {
                d27 = d24 - d21;
                if (!(d27 > this.maxDrawdownLong)) continue;
                this.maxDrawdownLong = d27;
                this.maxDrawdownPercentLong = 1.0 - d21 / d24;
                continue;
            }
            d27 = d25 - d22;
            if (!(d27 > this.maxDrawdownShort)) continue;
            this.maxDrawdownShort = d27;
            this.maxDrawdownPercentShort = 1.0 - d22 / d25;
        }
        if (this.totalTrades > 0) {
            this.avgTimeInTrade = l5 / (long)this.totalTrades;
            this.avgMAE = d2 / (double)this.totalTrades;
            this.avgMAEPercent = d5 / (double)this.totalQuantity;
            this.avgMAEPoints = d8 / (double)this.totalTrades;
            this.avgMFE = d11 / (double)this.totalTrades;
            this.avgMFEPercent = d14 / (double)this.totalQuantity;
            this.avgMFEPoints = d17 / (double)this.totalTrades;
            this.avgTrade = this.profit / (double)this.totalTrades;
        }
        if (this.totalTradesLong > 0) {
            this.avgTimeInTradeLong = l6 / (long)this.totalTradesLong;
            this.avgMAELong = d3 / (double)this.totalTradesLong;
            this.avgMAEPercentLong = d6 / (double)this.totalQuantityLong;
            this.avgMAEPointsLong = d9 / (double)this.totalTradesLong;
            this.avgMFELong = d12 / (double)this.totalTradesLong;
            this.avgMFEPercentLong = d15 / (double)this.totalQuantityLong;
            this.avgMFEPointsLong = d18 / (double)this.totalTradesLong;
            this.avgTradeLong = this.profitLong / (double)this.totalTradesLong;
        }
        if (this.totalTradesShort > 0) {
            this.avgTimeInTradeShort = l7 / (long)this.totalTradesShort;
            this.avgMAEShort = d4 / (double)this.totalTradesShort;
            this.avgMAEPercentShort = d7 / (double)this.totalQuantityShort;
            this.avgMAEPointsShort = d10 / (double)this.totalTradesShort;
            this.avgMFEShort = d13 / (double)this.totalTradesShort;
            this.avgMFEPercentShort = d16 / (double)this.totalQuantityShort;
            this.avgMFEPointsShort = d19 / (double)this.totalTradesShort;
            this.avgTradeShort = this.profitShort / (double)this.totalTradesShort;
        }
        if (this.winningTrades > 0) {
            this.avgWinningTrade = this.grossProfit / (double)this.winningTrades;
        }
        if (this.winningTradesLong > 0) {
            this.avgWinningTradeLong = this.grossProfitLong / (double)this.winningTradesLong;
        }
        if (this.winningTradesShort > 0) {
            this.avgWinningTradeShort = this.grossProfitShort / (double)this.winningTradesShort;
        }
        if (this.losingTrades > 0) {
            this.avgLosingTrade = this.grossLoss / (double)this.losingTrades;
        }
        if (this.losingTradesLong > 0) {
            this.avgLosingTradeLong = this.grossLossLong / (double)this.losingTradesLong;
        }
        if (this.losingTradesShort > 0) {
            this.avgLosingTradeShort = this.grossLossShort / (double)this.losingTradesShort;
        }
        if (this.avgLosingTrade != 0.0) {
            this.winningVsLosingTrade = Math.abs(this.avgWinningTrade / this.avgLosingTrade);
        }
        if (this.avgLosingTradeLong != 0.0) {
            this.winningVsLosingTradeLong = Math.abs(this.avgWinningTradeLong / this.avgLosingTradeLong);
        }
        if (this.avgLosingTradeShort != 0.0) {
            this.winningVsLosingTradeShort = Math.abs(this.avgWinningTradeShort / this.avgLosingTradeShort);
        }
        if (this.tradingDays > 0) {
            this.profitPerDay = this.profit / (double)this.tradingDays;
            this.profitPerDayLong = this.profitLong / (double)this.tradingDays;
            this.profitPerDayShort = this.profitShort / (double)this.tradingDays;
        }
        this.metrics = new ArrayList();
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_TOTAL_NET_PROFIT", new Object[0]), this.profit - this.commissions, this.profitLong - this.commissionsLong, this.profitShort - this.commissionsShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_TOTAL_PROFIT", new Object[0]), this.profit, this.profitLong, this.profitShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_GROSS_PROFIT", new Object[0]), this.grossProfit, this.grossProfitLong, this.grossProfitShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_GROSS_LOSS", new Object[0]), this.grossLoss, this.grossLossLong, this.grossLossShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_COMMISSION", new Object[0]), this.commissions, this.commissionsLong, this.commissionsShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_PROFIT_FACTOR", new Object[0]), Math.abs(this.grossProfit / this.grossLoss), Math.abs(this.grossProfitLong / this.grossLossLong), Math.abs(this.grossProfitShort / this.grossLossShort)));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_MAX_DRAWDOWN", new Object[0]), this.maxDrawdown, this.maxDrawdownLong, this.maxDrawdownShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_MAX_DRAWDOWN_PERCENT", new Object[0]), this.maxDrawdownPercent, this.maxDrawdownPercentLong, this.maxDrawdownPercentShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_NUM_TRADES", new Object[0]), this.totalTrades, this.totalTradesLong, this.totalTradesShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_PER_PROFITABLE", new Object[0]), (double)this.winningTrades / (double)this.totalTrades, (double)this.winningTradesLong / (double)this.totalTradesLong, (double)this.winningTradesShort / (double)this.totalTradesShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_WINNING_TRADES", new Object[0]), this.winningTrades, this.winningTradesLong, this.winningTradesShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_LOSING_TRADES", new Object[0]), this.losingTrades, this.losingTradesLong, this.losingTradesShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_TRADE", new Object[0]), this.avgTrade, this.avgTradeLong, this.avgTradeShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_WINNING_TRADE", new Object[0]), this.avgWinningTrade, this.avgWinningTradeLong, this.avgWinningTradeShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_LOSING_TRADE", new Object[0]), this.avgLosingTrade, this.avgLosingTradeLong, this.avgLosingTradeShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_WINNING_LOSING_TRADE", new Object[0]), this.winningVsLosingTrade, this.winningVsLosingTradeLong, this.winningVsLosingTradeShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_MAX_CON_WINNERS", new Object[0]), this.maxConsecutiveWins, this.maxConsecutiveWinsLong, this.maxConsecutiveWinsShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_MAX_CON_LOSERS", new Object[0]), this.maxConsecutiveLosses, this.maxConsecutiveLossesLong, this.maxConsecutiveLossesShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_LARGEST_WINNING_TRADE", new Object[0]), this.largestWinningTrade, this.largestWinningTradeLong, this.largestWinningTradeShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_LARGEST_LOSING_TRADE", new Object[0]), this.largestLosingTrade, this.largestLosingTradeLong, this.largestLosingTradeShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_NUM_TRADES_PER_DAY", new Object[0]), (double)this.totalTrades / (double)this.tradingDays, (double)this.totalTradesLong / (double)this.tradingDays, (double)this.totalTradesShort / (double)this.tradingDays));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_TIME_IN_MARKET", new Object[0]), this.avgTimeInTrade, this.avgTimeInTradeLong, this.avgTimeInTradeShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_PROFIT_PER_DAY", new Object[0]), this.profitPerDay, this.profitPerDayLong, this.profitPerDayShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_PROFIT_PER_WEEK", new Object[0]), this.profitPerDay * 5.0, this.profitPerDayLong * 5.0, this.profitPerDayShort * 5.0));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_PROFIT_PER_MONTH", new Object[0]), this.profitPerDay * 30.0, this.profitPerDayLong * 30.0, this.profitPerDayShort * 30.0));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_MAE", new Object[0]), this.avgMAE, this.avgMAELong, this.avgMAEShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_MAE_PERCENT", new Object[0]), this.avgMAEPercent, this.avgMAEPercentLong, this.avgMAEPercentShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_MAE_POINTS", new Object[0]), this.avgMAEPoints, this.avgMAEPointsLong, this.avgMAEPointsShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_MFE", new Object[0]), this.avgMFE, this.avgMFELong, this.avgMFEShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_MFE_PERCENT", new Object[0]), this.avgMFEPercent, this.avgMFEPercentLong, this.avgMFEPercentShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_MFE_POINTS", new Object[0]), this.avgMFEPoints, this.avgMFEPointsLong, this.avgMFEPointsShort));
        this.metrics.add(new StrategyMetric(com.motivewave.platform.common.af.a("METRIC_AVG_ETD", new Object[0]), this.avgMFE - this.avgTrade, this.avgMFELong - this.avgTradeLong, this.avgMFEShort - this.avgTradeShort));
        long l9 = h.l(l2);
        while (l9 <= l3) {
            this.dailyData.put(l9, new PeriodData(l9));
            l9 = h.M(l9);
        }
        long l10 = h.C(l2);
        while (l10 <= l3) {
            this.weeklyData.put(l10, new PeriodData(l10));
            l10 = h.D(l10);
        }
        long l11 = h.E(l2);
        while (l11 <= l3) {
            this.monthlyData.put(l11, new PeriodData(l11));
            l11 = h.G(l11);
        }
        this.dayOfWeekData.put(Enums$DayOfWeek.SUN, new PeriodData(Enums$DayOfWeek.SUN));
        this.dayOfWeekData.put(Enums$DayOfWeek.MON, new PeriodData(Enums$DayOfWeek.MON));
        this.dayOfWeekData.put(Enums$DayOfWeek.TUES, new PeriodData(Enums$DayOfWeek.TUES));
        this.dayOfWeekData.put(Enums$DayOfWeek.WED, new PeriodData(Enums$DayOfWeek.WED));
        this.dayOfWeekData.put(Enums$DayOfWeek.THUR, new PeriodData(Enums$DayOfWeek.THUR));
        this.dayOfWeekData.put(Enums$DayOfWeek.FRI, new PeriodData(Enums$DayOfWeek.FRI));
        this.dayOfWeekData.put(Enums$DayOfWeek.SAT, new PeriodData(Enums$DayOfWeek.SAT));
        for (n2 = 0; n2 < 24; ++n2) {
            this.hourOfDayData.put(n2 * 60 * 60 * 1000, new PeriodData(n2 * 60 * 60 * 1000));
        }
        for (n2 = 0; n2 < 48; ++n2) {
            this.halfHourOfDayData.put(n2 * 30 * 60 * 1000, new PeriodData(n2 * 30 * 60 * 1000));
        }
        for (Object object22 : this.trades) {
            l9 = h.l(((Trade)object22).getExitTime());
            object = (PeriodData)this.dailyData.get(l9);
            if (object == null) {
                h.a.warning("ExecutionReport::calculate() strategy data not found: " + h.s(l9));
                continue;
            }
            this.updateData((PeriodData)object, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            l10 = h.C(((Trade)object22).getExitTime());
            object = (PeriodData)this.weeklyData.get(l10);
            if (object == null) {
                h.a.warning("ExecutionReport::calculate() weekly strategy data not found: " + h.l(l10));
                continue;
            }
            this.updateData((PeriodData)object, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            l11 = h.E(((Trade)object22).getExitTime());
            object = (PeriodData)this.monthlyData.get(l11);
            if (object == null) {
                h.a.warning("ExecutionReport::calculate() monthly strategy data not found: " + h.l(l11));
                continue;
            }
            this.updateData((PeriodData)object, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            object = h.a(((Trade)object22).getExitTime());
            periodData2 = (PeriodData)this.dayOfWeekData.get(object);
            if (periodData2 == null) {
                h.a.warning("ExecutionReport::calculate() day of week strategy data not found: " + String.valueOf(object));
                continue;
            }
            this.updateData(periodData2, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            int n11 = h.d(((Trade)object22).getExitTime()) * 60 * 60 * 1000;
            periodData2 = (PeriodData)this.hourOfDayData.get(n11);
            if (periodData2 == null) {
                h.a.warning("ExecutionReport::calculate() hour strategy data not found: " + h.q(n11));
                continue;
            }
            this.updateData(periodData2, (Trade)object22);
        }
        for (Object object22 : this.trades) {
            int n12 = h.e(((Trade)object22).getExitTime()) * 30 * 60 * 1000;
            periodData2 = (PeriodData)this.halfHourOfDayData.get(n12);
            if (periodData2 == null) {
                h.a.warning("ExecutionReport::calculate() half hour strategy data not found: " + h.q(n12));
                continue;
            }
            this.updateData(periodData2, (Trade)object22);
        }
        Object object4 = null;
        object22 = this.dailyData.keySet().iterator();
        while (object22.hasNext()) {
            long l12 = (Long)object22.next();
            periodData = (PeriodData)this.dailyData.get(l12);
            this.updateCumulativeData((PeriodData)object4, periodData);
            object4 = periodData;
        }
        object4 = null;
        object22 = this.weeklyData.keySet().iterator();
        while (object22.hasNext()) {
            long l13 = (Long)object22.next();
            periodData = (PeriodData)this.weeklyData.get(l13);
            this.updateCumulativeData((PeriodData)object4, periodData);
            object4 = periodData;
        }
        object4 = null;
        object22 = this.monthlyData.keySet().iterator();
        while (object22.hasNext()) {
            long l14 = (Long)object22.next();
            periodData = (PeriodData)this.monthlyData.get(l14);
            this.updateCumulativeData((PeriodData)object4, periodData);
            object4 = periodData;
        }
        object4 = null;
        for (Enums$DayOfWeek enums$DayOfWeek : this.dayOfWeekData.keySet()) {
            periodData2 = (PeriodData)this.dayOfWeekData.get((Object)enums$DayOfWeek);
            this.updateCumulativeData((PeriodData)object4, periodData2);
            object4 = periodData2;
        }
        object4 = null;
        object22 = this.hourOfDayData.keySet().iterator();
        while (object22.hasNext()) {
            int n13 = (Integer)object22.next();
            periodData2 = (PeriodData)this.hourOfDayData.get(n13);
            this.updateCumulativeData((PeriodData)object4, periodData2);
            object4 = periodData2;
        }
        object4 = null;
        object22 = this.halfHourOfDayData.keySet().iterator();
        while (object22.hasNext()) {
            int n14 = (Integer)object22.next();
            periodData2 = (PeriodData)this.halfHourOfDayData.get(n14);
            this.updateCumulativeData((PeriodData)object4, periodData2);
            object4 = periodData2;
        }
        object22 = new ArrayList(this.dailyData.keySet()).iterator();
        while (object22.hasNext()) {
            long l15 = (Long)object22.next();
            periodData = (PeriodData)this.dailyData.get(l15);
            if (periodData.getTotalTrades() != 0) continue;
            this.dailyData.remove(l15);
        }
        object22 = new ArrayList(this.weeklyData.keySet()).iterator();
        while (object22.hasNext()) {
            long l16 = (Long)object22.next();
            periodData = (PeriodData)this.weeklyData.get(l16);
            if (periodData.getTotalTrades() != 0) continue;
            this.weeklyData.remove(l16);
        }
        object22 = new ArrayList(this.monthlyData.keySet()).iterator();
        while (object22.hasNext()) {
            long l17 = (Long)object22.next();
            periodData = (PeriodData)this.monthlyData.get(l17);
            if (periodData.getTotalTrades() != 0) continue;
            this.monthlyData.remove(l17);
        }
        for (Enums$DayOfWeek enums$DayOfWeek : new ArrayList(this.dayOfWeekData.keySet())) {
            periodData2 = (PeriodData)this.dayOfWeekData.get((Object)enums$DayOfWeek);
            if (periodData2.getTotalTrades() != 0) continue;
            this.dayOfWeekData.remove((Object)enums$DayOfWeek);
        }
        object22 = new ArrayList(this.hourOfDayData.keySet()).iterator();
        while (object22.hasNext()) {
            int n15 = (Integer)object22.next();
            periodData2 = (PeriodData)this.hourOfDayData.get(n15);
            if (periodData2.getTotalTrades() != 0) continue;
            this.hourOfDayData.remove(n15);
        }
        object22 = new ArrayList(this.halfHourOfDayData.keySet()).iterator();
        while (object22.hasNext()) {
            int n16 = (Integer)object22.next();
            periodData2 = (PeriodData)this.halfHourOfDayData.get(n16);
            if (periodData2.getTotalTrades() != 0) continue;
            this.halfHourOfDayData.remove(n16);
        }
    }

    private void processTrade(Execution execution) {
        Trade trade6;
        af af2;
        if (execution == null) {
            return;
        }
        MWInstrument mWInstrument = execution.getMWInstrument();
        if (!h.g(this.acctId) && !h.a((Object)execution.getAccountId(), (Object)this.acctId)) {
            return;
        }
        if (this.instrument != null && mWInstrument != this.instrument) {
            return;
        }
        if (this.start != -1L && execution.getTime() < this.start) {
            return;
        }
        if (this.end != -1L && execution.getTime() > this.end) {
            return;
        }
        double d2 = execution.getCommission();
        this.executions.add(execution);
        String string = mWInstrument.getKey() + ":" + execution.getAccountId();
        float f2 = Math.abs(execution.getQuantity());
        if (!execution.isBuy()) {
            f2 *= -1.0f;
        }
        if ((af2 = (af)this.currentPosition.get(string)) == null) {
            Trade trade2 = new Trade(++this.tradeCount, execution, f2, d2);
            this.trades.add(trade2);
            this.currentPosition.put(string, new af(trade2));
            return;
        }
        if (f2 > 0.0f && af2.a > 0.0f || f2 < 0.0f && af2.a < 0.0f) {
            af2.a += f2;
            Trade trade3 = new Trade(++this.tradeCount, execution, f2, d2);
            trade3.setPosition(af2.a);
            this.trades.add(trade3);
            af2.a.add(trade3);
            return;
        }
        if (Math.abs(f2) == Math.abs(af2.a)) {
            float f3 = f2;
            for (Trade trade4 : af2.a) {
                trade4.setExitTime(execution.getTime());
                trade4.adjustExitPrice(execution.getPrice(), f3);
                trade4.addCommission((double)Math.abs(trade4.getRemainingQuantity() / f2) * d2);
                trade4.addPnl(mWInstrument.calcPnL(trade4.getEntryPrice(), execution.getPrice(), trade4.getRemainingQuantity()));
                f3 += trade4.getRemainingQuantity();
                af2.a -= trade4.getRemainingQuantity();
                trade4.setRemainingQuantity(0.0f);
            }
            af2.a.clear();
            this.currentPosition.remove(string);
            return;
        }
        if (Math.abs(f2) < Math.abs(af2.a)) {
            float f4 = f2;
            for (Trade trade5 : new ArrayList(af2.a)) {
                if (Math.abs(trade5.getRemainingQuantity()) <= Math.abs(f4)) {
                    trade5.setExitTime(execution.getTime());
                    trade5.adjustExitPrice(execution.getPrice(), f4);
                    trade5.addCommission((double)Math.abs(trade5.getRemainingQuantity() / f2) * d2);
                    trade5.addPnl(mWInstrument.calcPnL(trade5.getEntryPrice(), execution.getPrice(), trade5.getRemainingQuantity()));
                    trade5.setRemainingQuantity(0.0f);
                    af2.a.remove(trade5);
                    if ((f4 += trade5.getRemainingQuantity()) != 0.0f) continue;
                    break;
                }
                trade5.setExitTime(execution.getTime());
                trade5.adjustExitPrice(execution.getPrice(), f4);
                trade5.addCommission((double)Math.abs(f4 / f2) * d2);
                trade5.addPnl(mWInstrument.calcPnL(trade5.getEntryPrice(), execution.getPrice(), f4 * -1.0f));
                trade5.setRemainingQuantity(trade5.getRemainingQuantity() + f4);
                break;
            }
            af2.a += f2;
            return;
        }
        float f5 = f2 + af2.a;
        for (Trade trade6 : new ArrayList(af2.a)) {
            trade6.setExitTime(execution.getTime());
            trade6.adjustExitPrice(execution.getPrice(), f5);
            trade6.addCommission((double)Math.abs(trade6.getRemainingQuantity() / f2) * d2);
            trade6.addPnl(mWInstrument.calcPnL(trade6.getEntryPrice(), execution.getPrice(), trade6.getRemainingQuantity()));
            f5 += trade6.getRemainingQuantity();
            trade6.setRemainingQuantity(0.0f);
        }
        af2.a.clear();
        this.currentPosition.remove(string);
        float f6 = f2 + af2.a;
        trade6 = new Trade(++this.tradeCount, execution, f6, (double)Math.abs(f6 / f2) * d2);
        this.trades.add(trade6);
        this.currentPosition.put(string, new af(trade6));
    }

    private void updateCumulativeData(PeriodData periodData, PeriodData periodData2) {
        if (periodData != null) {
            periodData2.setCumulativeCommissions(periodData.getCumulativeCommissions() + periodData2.getCommissions());
            periodData2.setCumulativeCommissionsLong(periodData.getCumulativeCommissionsLong() + periodData2.getCommissionsLong());
            periodData2.setCumulativeCommissionsShort(periodData.getCumulativeCommissionsShort() + periodData2.getCommissionsShort());
            periodData2.setCumulativeNetProfit(periodData.getCumulativeNetProfit() + periodData2.getNetProfit());
            periodData2.setCumulativeNetProfitLong(periodData.getCumulativeNetProfitLong() + periodData2.getNetProfitLong());
            periodData2.setCumulativeNetProfitShort(periodData.getCumulativeNetProfitShort() + periodData2.getNetProfitShort());
            periodData2.setCumulativeGrossProfit(periodData.getCumulativeGrossProfit() + periodData2.getGrossProfit());
            periodData2.setCumulativeGrossProfitLong(periodData.getCumulativeGrossProfitLong() + periodData2.getGrossProfitLong());
            periodData2.setCumulativeGrossProfitShort(periodData.getCumulativeGrossProfitShort() + periodData2.getGrossProfitShort());
            periodData2.setCumulativeGrossLoss(periodData.getCumulativeGrossLoss() + periodData2.getGrossLoss());
            periodData2.setCumulativeGrossLossLong(periodData.getCumulativeGrossLossLong() + periodData2.getGrossLossLong());
            periodData2.setCumulativeGrossLossShort(periodData.getCumulativeGrossLossShort() + periodData2.getGrossLossShort());
        } else {
            periodData2.setCumulativeCommissions(periodData2.getCommissions());
            periodData2.setCumulativeCommissionsLong(periodData2.getCommissionsLong());
            periodData2.setCumulativeCommissionsShort(periodData2.getCommissionsShort());
            periodData2.setCumulativeNetProfit(periodData2.getNetProfit());
            periodData2.setCumulativeNetProfitLong(periodData2.getNetProfitLong());
            periodData2.setCumulativeNetProfitShort(periodData2.getNetProfitShort());
            periodData2.setCumulativeGrossProfit(periodData2.getGrossProfit());
            periodData2.setCumulativeGrossProfitLong(periodData2.getGrossProfitLong());
            periodData2.setCumulativeGrossProfitShort(periodData2.getGrossProfitShort());
            periodData2.setCumulativeGrossLoss(periodData2.getGrossLoss());
            periodData2.setCumulativeGrossLossLong(periodData2.getGrossLossLong());
            periodData2.setCumulativeGrossLossShort(periodData2.getGrossLossShort());
        }
    }

    private void updateData(PeriodData periodData, Trade trade) {
        periodData.setCommissions(periodData.getCommissions() + trade.getCommission());
        periodData.setNetProfit(periodData.getNetProfit() + trade.getPnl());
        periodData.setTotalTrades(periodData.getTotalTrades() + 1);
        if (trade.getPnl() > 0.0) {
            periodData.setGrossProfit(periodData.getGrossProfit() + trade.getPnl());
            periodData.setTotalWinningTrades(periodData.getTotalWinningTrades() + 1);
            if (trade.getPnl() > periodData.getLargestWinningTrade()) {
                periodData.setLargestWinningTrade(trade.getPnl());
            }
        } else {
            periodData.setGrossLoss(periodData.getGrossLoss() + trade.getPnl());
            periodData.setTotalLosingTrades(periodData.getTotalLosingTrades() + 1);
            if (trade.getPnl() < periodData.getLargestLosingTrade()) {
                periodData.setLargestLosingTrade(trade.getPnl());
            }
        }
        periodData.setMAE(periodData.getMAE() + trade.getMAEPnl());
        periodData.setMFE(periodData.getMFE() + trade.getMFEPnl());
        if (trade.isLong()) {
            periodData.setTotalTradesLong(periodData.getTotalTradesLong() + 1);
            periodData.setCommissionsLong(periodData.getCommissionsLong() + trade.getCommission());
            periodData.setNetProfitLong(periodData.getNetProfitLong() + trade.getPnl());
            periodData.setMAELong(periodData.getMAELong() + trade.getMAEPnl());
            periodData.setMFELong(periodData.getMFELong() + trade.getMFEPnl());
            if (trade.getPnl() > 0.0) {
                periodData.setGrossProfitLong(periodData.getGrossProfitLong() + trade.getPnl());
                periodData.setTotalWinningTradesLong(periodData.getTotalWinningTradesLong() + 1);
                if (trade.getPnl() > periodData.getLargestWinningTradeLong()) {
                    periodData.setLargestWinningTradeLong(trade.getPnl());
                }
            } else if (trade.getPnl() < 0.0) {
                periodData.setGrossLossLong(periodData.getGrossLossLong() + trade.getPnl());
                if (trade.getPnl() < periodData.getLargestLosingTradeLong()) {
                    periodData.setLargestLosingTradeLong(trade.getPnl());
                }
                periodData.setTotalLosingTradesLong(periodData.getTotalLosingTradesLong() + 1);
            }
        } else {
            periodData.setTotalTradesShort(periodData.getTotalTradesShort() + 1);
            periodData.setCommissionsShort(periodData.getCommissionsShort() + trade.getCommission());
            periodData.setNetProfitShort(periodData.getNetProfitShort() + trade.getPnl());
            periodData.setMAEShort(periodData.getMAEShort() + trade.getMAEPnl());
            periodData.setMFEShort(periodData.getMFEShort() + trade.getMFEPnl());
            if (trade.getPnl() > 0.0) {
                periodData.setGrossProfitShort(periodData.getGrossProfitShort() + trade.getPnl());
                periodData.setTotalWinningTradesShort(periodData.getTotalWinningTradesShort() + 1);
                if (trade.getPnl() > periodData.getLargestWinningTradeShort()) {
                    periodData.setLargestWinningTradeShort(trade.getPnl());
                }
            } else if (trade.getPnl() < 0.0) {
                periodData.setGrossLossShort(periodData.getGrossLossShort() + trade.getPnl());
                if (trade.getPnl() < periodData.getLargestLosingTradeShort()) {
                    periodData.setLargestLosingTradeShort(trade.getPnl());
                }
                periodData.setTotalLosingTradesShort(periodData.getTotalLosingTradesShort() + 1);
            }
        }
    }
}

