/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import at.d;
import com.motivewave.common.h;
import com.motivewave.common.util.j;
import com.motivewave.platform.common.Enums$OrderAction;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.Executions;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.Positions;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.sdk.common.Instrument;
import com.motivewave.platform.sdk.order_mgmt.Trade;
import com.motivewave.platform.service.SymbolUtil;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.by;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import o.g;

public class Execution
extends ObservableBean
implements Trade,
Comparable {
    private String id;
    private String userId;
    private String accountId;
    private String positionId;
    private String orderId;
    private String fillId;
    private double balance;
    private long execTime;
    private String exchange;
    private Enums$OrderAction action;
    private float quantity;
    private float price;
    private boolean entry;
    private double pnl;
    private double realizedPnl;
    private float pips;
    private double commission;
    private Execution linkedTrade;
    private float openQuantity;
    private Boolean supportsPL = null;
    private Ticker ticker;
    private g plListener = (mWInstrument, string, d2) -> {
        if (!this.isOpen()) {
            return;
        }
        this.updatePnl();
        this.updatePips();
    };

    public static Execution fromCSV(String string, Map map) {
        List list = a.a(string);
        if (h.a((Collection)list)) {
            return null;
        }
        String string2 = a.a((String)list.get(1), map);
        MWInstrument mWInstrument = MWInstrument.resolveFromKey(string2);
        if (mWInstrument == null) {
            h.a.warning("Execution::fromCSV() unable to resolve instrument: " + string2);
            return null;
        }
        Execution execution = new Execution();
        execution.id = (String)list.get(0);
        execution.ticker = LiveTicker.get(mWInstrument);
        execution.exchange = a.a((String)list.get(2), map);
        if (h.a((Object)execution.exchange, (Object)mWInstrument.getExchange())) {
            execution.exchange = null;
        }
        execution.accountId = a.a((String)list.get(3), map);
        execution.userId = a.a((String)list.get(4), map);
        execution.orderId = (String)list.get(5);
        execution.positionId = (String)list.get(6);
        execution.fillId = (String)list.get(7);
        execution.action = h.b((Object)h.j((String)list.get(8)), (Object)"B") ? Enums$OrderAction.BUY : Enums$OrderAction.SELL;
        execution.entry = a.a((String)list.get(9));
        execution.execTime = a.a((String)list.get(10));
        execution.price = a.a((String)list.get(11));
        String string3 = (String)list.get(12);
        if (string3.indexOf(46) >= 0 && Character.isDigit(string3.charAt(string3.length() - 1))) {
            execution.quantity = a.a(string3);
        } else {
            try {
                execution.quantity = ab.a(string3);
            }
            catch (Exception exception) {
                execution.quantity = h.b(string3);
                h.a.warning("Execution::fromCSV() unable to parse quantity: " + string3);
            }
        }
        execution.pnl = a.a((String)list.get(13));
        execution.balance = a.a((String)list.get(14));
        execution.commission = a.a((String)list.get(15));
        if (execution.commission == 0.0) {
            execution.commission = execution.ticker.calcCommission(execution.getQuantity());
        }
        if (h.g(execution.id)) {
            if (mWInstrument.isRithmic()) {
                execution.id = execution.orderId;
            } else if (!h.g(execution.fillId)) {
                execution.id = execution.fillId;
            } else if (!h.g(execution.orderId)) {
                execution.id = execution.orderId;
            }
        }
        execution.init();
        return execution;
    }

    public static void toCSV(Execution execution, Map map, PrintWriter printWriter) {
        String string = execution.exchange;
        if (h.a((Object)string, (Object)execution.ticker.getExchangeSymbol())) {
            string = "";
        }
        String string2 = execution.userId;
        if (h.a((Object)execution.accountId, (Object)"simulated") || execution.isReplay()) {
            string2 = null;
        }
        String string3 = execution.id;
        a.a(printWriter, string3, a.a(execution.ticker.getKey(), map), a.a(string, map), a.a(execution.accountId, map), a.a(string2, map), execution.orderId, execution.positionId, execution.fillId, execution.isBuy() ? "B" : "S", execution.entry, execution.execTime, h.c(execution.price, 8), ab.a(execution.quantity), h.d(execution.getPnl(), 4), h.d(execution.balance, 4), h.d(execution.commission, 8));
    }

    public static int addIds(Execution execution, Map map, int n2) {
        String string = execution.exchange;
        if (h.a((Object)string, (Object)execution.ticker.getExchangeSymbol())) {
            string = "";
        }
        n2 = a.a(string, map, n2);
        String string2 = execution.userId;
        if (h.a((Object)execution.accountId, (Object)"simulated")) {
            string2 = null;
        }
        n2 = a.a(string2, map, n2);
        if (execution.ticker != null) {
            n2 = a.a(execution.ticker.getKey(), map, n2);
        }
        return a.a(execution.accountId, map, n2);
    }

    public static Execution from(d d2) {
        j j2;
        String string = d2.c();
        LiveTicker liveTicker = LiveTicker.byKey(string);
        if (liveTicker == null) {
            if (bs.C() && string.indexOf(46) > 0 && (j2 = SymbolUtil.a(string)) != null) {
                MWInstrument mWInstrument = j2.a();
                MWInstrument.create(mWInstrument);
                liveTicker = LiveTicker.byKey(mWInstrument.getKey());
            }
            if (liveTicker == null) {
                h.a.warning("Execution::from() instrument not found: " + d2.c());
                return null;
            }
        }
        j2 = new Execution(liveTicker, d2.a(), d2.g(), d2.b(), d2.h(), d2.e(), d2.d(), d2.a(), d2.f(), d2.a() ? Enums$OrderAction.BUY : Enums$OrderAction.SELL, d2.a(), d2.b(), d2.a() != null && d2.a() != false, 0.0, d2.a(), 0.0);
        return j2;
    }

    private Execution() {
    }

    public Execution(Ticker ticker, String string2, String string3, String string4, String string5, String string6, String string7, long l2, String string8, Enums$OrderAction enums$OrderAction, float f2, float f3, boolean bl2, double d3, double d4, double d5) {
        this.ticker = ticker;
        this.id = string2;
        this.userId = string3;
        this.accountId = string4;
        this.fillId = string5;
        this.positionId = string6;
        this.orderId = string7;
        this.execTime = l2;
        this.exchange = string8;
        if (h.a((Object)string8, (Object)ticker.getExchangeSymbol())) {
            this.exchange = null;
        }
        this.action = enums$OrderAction;
        this.quantity = Math.abs(f2);
        this.price = f3;
        this.entry = bl2;
        this.pnl = d3;
        this.commission = d4;
        this.balance = d5;
        if (d4 == 0.0) {
            this.commission = ticker.calcCommission(f2);
        }
        this.init();
    }

    private void init() {
        if (this.entry) {
            this.openQuantity = Math.abs(this.quantity);
            if (!this.isBuy()) {
                this.openQuantity *= -1.0f;
            }
        }
        if (this.isEntry() && !h.g(this.positionId) && this.supportsPL()) {
            Positions.addPLListener(this.getMWInstrument(), this.getAccountId(), this.plListener);
        }
        this.updatePnl();
        this.updatePips();
    }

    @Override
    public void destroy() {
        this.destroyed = true;
        Positions.removePLListener(this.plListener);
    }

    public int compareTo(Execution execution) {
        if (execution == this) {
            return 0;
        }
        if (execution.execTime > this.execTime) {
            return 1;
        }
        if (execution.execTime < this.execTime) {
            return -1;
        }
        return this.id.compareTo(execution.id);
    }

    @Override
    public String formatPrice(float f2) {
        return this.getMWInstrument().formatValue(f2);
    }

    @Override
    public String format(String string) {
        switch (string) {
            case "execTime": {
                return ab.i(this.execTime, b.b());
            }
            case "underlying": {
                return this.getMWInstrument() == null ? "" : this.getMWInstrument().getUnderlying();
            }
            case "action": {
                return this.isBuy() ? af.a("LBL_BOT", new Object[0]) : af.a("LBL_SLD", new Object[0]);
            }
            case "symbol": {
                return this.getMWInstrument() == null ? "" : this.getMWInstrument().getSymbol();
            }
            case "exchange": {
                return h.b((Object)this.getExchange());
            }
            case "symbolDisplay": {
                return this.getMWInstrument() == null ? "" : this.getMWInstrument().getSymbolDisplay();
            }
            case "fillId": {
                return this.fillId;
            }
            case "orderId": {
                return this.orderId;
            }
            case "price": 
            case "avgPrice": 
            case "entryPrice": 
            case "exitPrice": {
                if (this.getMWInstrument() == null) {
                    return "";
                }
                float f2 = ((Float)this.getProperty(string)).floatValue();
                if (!this.getMWInstrument().isValueValid(f2)) {
                    return "";
                }
                return this.formatPrice(f2);
            }
            case "quantity": {
                return ab.b(Math.abs(this.quantity), this.getMWInstrument());
            }
            case "pips": {
                return h.c((double)this.pips, 1);
            }
            case "pnl": {
                return ab.a(this.getPnl());
            }
            case "balance": {
                return ab.a(this.getBalance());
            }
            case "commission": {
                if (this.getMWInstrument() != null && this.getMWInstrument().isCrypto()) {
                    return h.b(this.getCommission());
                }
                return ab.a(this.getCommission());
            }
            case "entry": {
                if (this.entry) {
                    return af.a("LBL_ENTRY", new Object[0]);
                }
                return af.a("LBL_EXIT", new Object[0]);
            }
            case "serviceType": {
                return this.getServiceType() == null ? "" : this.getServiceType().toString();
            }
        }
        return h.b(this.getProperty(string));
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccount() == null ? "" : this.getAccount().getDisplayName();
            }
            case "accountCurrency": {
                return this.getAccount() == null ? "" : this.getAccount().getBaseCurrency();
            }
            case "action": {
                return this.getAction();
            }
            case "commission": {
                return this.getCommission();
            }
            case "entryPrice": {
                return Float.valueOf(this.getEntryPrice());
            }
            case "exchange": {
                return this.getExchange();
            }
            case "execTime": {
                return this.getTime();
            }
            case "exitPrice": {
                return Float.valueOf(this.getExitPrice());
            }
            case "id": {
                return this.getId();
            }
            case "linkedTrade": {
                return this.getLinkedTrade();
            }
            case "orderId": {
                return this.getOrderId();
            }
            case "pips": {
                return Float.valueOf(this.pips);
            }
            case "pnl": {
                return this.getPnl();
            }
            case "positionId": {
                return this.getPositionId();
            }
            case "price": 
            case "avgPrice": {
                return Float.valueOf(this.getPrice());
            }
            case "symbol": {
                return this.getMWInstrument().getSymbol();
            }
            case "symbolDisplay": {
                return this.getMWInstrument().getSymbolDisplay();
            }
            case "quantity": {
                return Float.valueOf(this.getQuantity());
            }
            case "instrument": {
                return this.getMWInstrument();
            }
            case "underlying": {
                return this.getMWInstrument().getUnderlying();
            }
            case "userId": {
                return this.getUserId();
            }
            case "buy": {
                return this.isBuy();
            }
            case "entry": {
                return this.isEntry();
            }
            case "open": {
                return this.isOpen();
            }
            case "serviceType": {
                return this.getServiceType();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "realizedPnl": {
                return this.realizedPnl;
            }
            case "fillId": {
                return this.fillId;
            }
            case "ticket": {
                if (this.isReplay()) {
                    return this.orderId;
                }
                if (!h.g(this.fillId)) {
                    return this.fillId;
                }
                if (!h.g(this.orderId)) {
                    return this.orderId;
                }
                if (!h.g(this.positionId)) {
                    return this.positionId;
                }
                return this.id;
            }
        }
        return super.getProperty(string);
    }

    private String getServiceName() {
        by by2 = bs.a(this.getAccount());
        if (by2 != null) {
            return by2.a().getType().toString();
        }
        return "";
    }

    private String getConnectionName() {
        by by2 = bs.a(this.getAccount());
        if (by2 != null) {
            return by2.a().getName();
        }
        return "";
    }

    @Override
    public String getKey() {
        String string = this.id;
        if (h.g(string)) {
            string = this.fillId;
        }
        if (h.g(string)) {
            string = this.orderId;
        }
        return this.getMWInstrument().getKey() + "|" + this.getAccountId() + "|" + string;
    }

    public String getOrderId() {
        return this.orderId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public Instrument getInstrument() {
        return this.ticker;
    }

    public double getCommission() {
        return this.commission;
    }

    public void setCommission(double d2) {
        this.notify("commission", (Object)this.commission, (Object)(this.commission == d2 ? 1 : 0));
    }

    public long getTime() {
        return this.execTime;
    }

    public boolean isBuy() {
        return this.action == Enums$OrderAction.BUY || this.action == Enums$OrderAction.BUY_TO_COVER;
    }

    public float getQuantity() {
        return this.quantity;
    }

    public void setQuantity(float f2) {
        this.quantity = Math.abs(f2);
    }

    public float getAvgPrice() {
        return this.getPrice();
    }

    public Account getAccount() {
        return bs.a(this.accountId);
    }

    public String getUserId() {
        return this.userId;
    }

    public Position getPosition() {
        if (!this.isOpen() || h.g(this.positionId)) {
            return null;
        }
        return Positions.find(this.positionId);
    }

    public String getPositionId() {
        return this.positionId;
    }

    public String getFillId() {
        return this.fillId;
    }

    public void setFillId(String string) {
        this.fillId = string;
        this.notify("fillId", this.fillId, this.fillId);
    }

    public MWInstrument getMWInstrument() {
        return this.ticker.getInstrument();
    }

    public String getExchange() {
        if (!h.g(this.exchange)) {
            return this.exchange;
        }
        MWInstrument mWInstrument = this.getMWInstrument();
        return mWInstrument == null ? null : mWInstrument.getExchange();
    }

    public Enums$OrderAction getAction() {
        return this.action;
    }

    public float getPrice() {
        return this.price;
    }

    public float getPips() {
        return this.pips;
    }

    private void setPips(float f2) {
        this.pips = f2;
        this.notify("pips", this.pips, this.pips);
    }

    public double getBalance() {
        return this.balance;
    }

    public boolean isEntry() {
        return this.entry;
    }

    public boolean isOpen() {
        if (!this.isEntry() || h.g(this.getPositionId())) {
            return false;
        }
        Position position = Positions.find(this.getPositionId());
        if (position == null) {
            return false;
        }
        return position.isOpen();
    }

    public Execution getLinkedTrade() {
        return this.linkedTrade;
    }

    public void setLinkedTrade(Execution execution) {
        this.linkedTrade = execution;
    }

    private float getEntryPrice() {
        if (this.isEntry()) {
            return this.price;
        }
        if (this.linkedTrade != null && this.linkedTrade.isEntry()) {
            return this.linkedTrade.getPrice();
        }
        return 0.0f;
    }

    private float getExitPrice() {
        return this.isEntry() ? 0.0f : this.getPrice();
    }

    public Enums$ServiceType getServiceType() {
        return this.getMWInstrument().getSourceType();
    }

    private String getBaseCurrency() {
        return ab.e(this.getAccountId());
    }

    public float fill(float f2, float f3) {
        if (this.openQuantity == 0.0f) {
            return f2;
        }
        if (this.openQuantity > 0.0f && f2 > 0.0f || this.openQuantity < 0.0f && f2 < 0.0f) {
            return f2;
        }
        MWInstrument mWInstrument = this.getMWInstrument();
        if (Math.abs(this.openQuantity) > Math.abs(f2)) {
            this.realizedPnl += mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f3, -f2, this.getBaseCurrency());
            this.openQuantity += f2;
            this.updateInfo();
            return 0.0f;
        }
        this.realizedPnl += mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f3, this.openQuantity, this.getBaseCurrency());
        this.openQuantity = 0.0f;
        this.updatePnl();
        return f2 += this.openQuantity;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        try {
            Execution execution = (Execution)object;
            if (!h.a((Object)execution.getMWInstrument(), (Object)this.getMWInstrument())) {
                return false;
            }
            if (!h.a((Object)this.accountId, (Object)execution.accountId)) {
                return false;
            }
            if (this.id == null && execution.id == null) {
                if (this.orderId == null || execution.orderId == null) {
                    return false;
                }
                return this.orderId.equals(execution.orderId);
            }
            return this.id.equals(execution.id);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public double getPnl() {
        return this.supportsPL() ? this.pnl : 0.0;
    }

    private void setPnl(double d2) {
        this.pnl = d2;
        this.notify("pnl", this.pnl, this.pnl);
    }

    public void updateInfo() {
        this.updatePips();
        this.updatePnl();
    }

    private void updatePnl() {
        Account account = this.getAccount();
        if (account == null || bs.d(account) || bs.c(account) || !this.supportsPL()) {
            return;
        }
        if (this.isEntry()) {
            if (account.isSimulatedAccount()) {
                this.setPnl(0.0);
                this.realizedPnl = 0.0;
                return;
            }
            float f2 = this.ticker.getCurrentPrice(this.openQuantity);
            MWInstrument mWInstrument = this.getMWInstrument();
            if (this.isReplay()) {
                if (this.openQuantity == 0.0f) {
                    this.setPnl(this.realizedPnl);
                } else {
                    this.setPnl(this.realizedPnl + mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f2, this.openQuantity, this.getBaseCurrency()));
                }
                return;
            }
            List list = Executions.byPosition(this.getPositionId());
            list.remove(this);
            if (h.a((Collection)list)) {
                this.setPnl(this.realizedPnl + mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f2, this.openQuantity, this.getBaseCurrency()));
                return;
            }
            float f3 = this.openQuantity;
            float f4 = 0.0f;
            for (Execution execution : list) {
                if (execution.isEntry()) {
                    h.a.severe("Execution::getPnl() linked trade is entry!!! id: " + this.getId() + " linked id: " + execution.getId());
                    continue;
                }
                float f5 = Math.abs(execution.getQuantity());
                if (!execution.isBuy()) {
                    f5 *= -1.0f;
                }
                f3 += f5;
                f4 = (float)((double)f4 + execution.getPnl());
            }
            if (f3 == 0.0f) {
                this.setPnl(f4);
                return;
            }
            if (this.isOpen()) {
                this.setPnl((double)f4 + this.realizedPnl + mWInstrument.calcPnLAndConvert(this.getEntryPrice(), f2, f3, this.getBaseCurrency()));
                return;
            }
            this.setPnl(f4);
            return;
        }
        if (this.getPnl() != 0.0) {
            return;
        }
        if (this.linkedTrade != null) {
            this.setPnl(this.linkedTrade.getPnl());
        }
    }

    private void updatePips() {
        if (!this.supportsPips()) {
            return;
        }
        float f2 = 0.0f;
        if (this.linkedTrade != null) {
            f2 = (float)Math.abs((double)(this.getPrice() - this.linkedTrade.getPrice()) / this.getMWInstrument().getPointSize());
        } else {
            float f3 = 0.0f;
            if (this.quantity < 0.0f) {
                f3 = this.ticker.getAskPrice();
            } else if (this.quantity > 0.0f) {
                f3 = this.ticker.getBidPrice();
            }
            if (f3 == 0.0f) {
                f3 = this.ticker.getLastPrice();
            }
            f2 = (float)Math.abs((double)(this.getPrice() - f3) / this.getMWInstrument().getPointSize());
        }
        if (this.getPnl() > 0.0) {
            this.setPips(f2);
        } else {
            this.setPips(-1.0f * f2);
        }
    }

    public String toString() {
        return "Execution::acct: " + this.accountId + " id: " + this.id + " userId: " + this.userId + " symbol: " + this.getMWInstrument().getKey() + " orderId: " + this.orderId + " posId: " + this.positionId + " action: " + String.valueOf((Object)this.action) + " qty: " + this.quantity + " price: " + this.price + " entry: " + this.entry + " pnl: " + this.pnl;
    }

    public boolean supportsPL() {
        if (this.isReplay()) {
            return true;
        }
        if (this.supportsPL != null) {
            return this.supportsPL;
        }
        Account account = this.getAccount();
        if (account == null) {
            return false;
        }
        this.supportsPL = bs.g(account);
        return this.supportsPL;
    }

    public boolean supportsPips() {
        if (!this.getMWInstrument().isCash()) {
            return false;
        }
        if (!this.supportsPL()) {
            return false;
        }
        return !bs.d(this.getAccount()) && !bs.c(this.getAccount());
    }

    public boolean isReplay() {
        Account account = this.getAccount();
        if (account == null) {
            if (h.g(this.accountId)) {
                return false;
            }
            return this.accountId.startsWith("REPLAY-");
        }
        return account.isReplay();
    }

    public boolean isPersistent() {
        Account account = this.getAccount();
        if (account == null) {
            if (h.g(this.accountId)) {
                return true;
            }
            return !this.accountId.startsWith("REPLAY-");
        }
        return account.isPersistent();
    }
}

