/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.util.g;
import com.motivewave.platform.common.a;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.service.bs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import javafx.beans.InvalidationListener;

public class Exchange
implements Comparable {
    private String symbol;
    private String description;
    private static Map symbolMap = new HashMap();
    private static SortedSet allExchanges = new TreeSet();
    private static g listeners = new g();
    private static boolean unsavedChanges = false;

    public Exchange(String string, String string2) {
        this.symbol = string;
        this.description = string2;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public int compareTo(Exchange exchange) {
        if (exchange == null) {
            return -1;
        }
        return this.symbol.compareTo(exchange.symbol);
    }

    public String toString() {
        return this.symbol;
    }

    public static void save() {
        Workspace workspace = bs.a();
        if (workspace == null) {
            return;
        }
        File file = new File(workspace.getConfigDir(), "exchanges.csv");
        if (!unsavedChanges && file.exists()) {
            return;
        }
        unsavedChanges = false;
        Exchange.save(workspace, Exchange.getAll());
    }

    public static void save(Workspace workspace, List list) {
        try {
            PrintWriter printWriter = new PrintWriter(new File(workspace.getConfigDir(), "exchanges.csv"));
            for (Exchange exchange : list) {
                Exchange.toCSV(exchange, printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Object object = Exchange.class;
        synchronized (Exchange.class) {
            symbolMap.clear();
            allExchanges.clear();
            // ** MonitorExit[var0] (shouldn't be in output)
            object = bs.a();
            for (Exchange exchange : Exchange.load((Workspace)object)) {
                Exchange.register(exchange);
            }
            unsavedChanges = false;
            return;
        }
    }

    public static List load(File file) {
        ArrayList<Exchange> arrayList = new ArrayList<Exchange>();
        if (!file.exists()) {
            return arrayList;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                Exchange exchange = Exchange.fromCSV(string);
                if (exchange != null) {
                    arrayList.add(exchange);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static List load(Workspace workspace) {
        return Exchange.load(new File(workspace.getConfigDir(), "exchanges.csv"));
    }

    private static Exchange fromCSV(String string) {
        List list = a.a(string);
        if (h.a((Collection)list)) {
            return null;
        }
        if (list.size() == 2) {
            return new Exchange((String)list.get(0), (String)list.get(1));
        }
        return null;
    }

    private static void toCSV(Exchange exchange, PrintWriter printWriter) {
        a.a(printWriter, exchange.symbol, exchange.description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Exchange exchange) {
        if (exchange == null || Exchange.exists(exchange.getSymbol())) {
            return;
        }
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            symbolMap.put(exchange.getSymbol(), exchange);
            allExchanges.add(exchange);
            unsavedChanges = true;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean exists(String string) {
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            Exchange exchange = (Exchange)symbolMap.get(string);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return exchange != null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exchange get(String string) {
        if (h.g(string)) {
            return null;
        }
        Exchange exchange = null;
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            exchange = (Exchange)symbolMap.get(string);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (exchange != null) {
                return exchange;
            }
            exchange = new Exchange(string, "");
            Exchange.register(exchange);
            Exchange.notifyUpdated();
            return exchange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Exchange get(String string, String string2) {
        if (h.g(string)) {
            return null;
        }
        Exchange exchange = null;
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            exchange = (Exchange)symbolMap.get(string);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            if (exchange != null) {
                return exchange;
            }
            exchange = new Exchange(string, string2);
            Exchange.register(exchange);
            Exchange.notifyUpdated();
            return exchange;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return new ArrayList(allExchanges);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List listByName() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            for (Exchange exchange : allExchanges) {
                arrayList.add(exchange.getSymbol());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return arrayList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void remove(Exchange exchange) {
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            allExchanges.remove(exchange);
            symbolMap.remove(exchange.getSymbol());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            Exchange.notifyUpdated();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeUnused() {
        Class<Exchange> clazz = Exchange.class;
        synchronized (Exchange.class) {
            ArrayList<Exchange> arrayList = new ArrayList<Exchange>();
            for (Exchange exchange : Exchange.getAll()) {
                boolean bl2 = false;
                for (MWInstrument mWInstrument : MWInstrument.getAll()) {
                    if (!h.b((Object)mWInstrument.getExchange(), (Object)exchange.getSymbol())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                arrayList.add(exchange);
            }
            for (Exchange exchange : arrayList) {
                allExchanges.remove(exchange);
                symbolMap.remove(exchange.getSymbol());
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            Exchange.notifyUpdated();
            unsavedChanges = false;
            return;
        }
    }

    public static void addListener(InvalidationListener invalidationListener) {
        listeners.a((Object)invalidationListener);
    }

    public static void removeListener(InvalidationListener invalidationListener) {
        listeners.a((Object)invalidationListener);
    }

    private static void notifyUpdated() {
        for (InvalidationListener invalidationListener : listeners.a()) {
            invalidationListener.invalidated(null);
        }
    }
}

