/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.Enums$WaveDegree;
import com.motivewave.platform.common.o;
import java.awt.Color;
import java.awt.Font;
import java.awt.Stroke;
import java.util.List;
import org.json.JSONObject;

public class DegreeDescriptor
implements aa,
w {
    private Enums$WaveDegree degree;
    private Font font;
    private Color fontColor;
    private Color lineColor;
    private float lineWidth = 1.0f;
    private float[] lineDash = null;
    private boolean lineUseFontColor = false;
    private Stroke stroke = null;
    private int spacing = 0;
    private double labelHeight = -1.0;

    public DegreeDescriptor(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public DegreeDescriptor(Enums$WaveDegree enums$WaveDegree, Font font, Color color) {
        this(enums$WaveDegree);
        this.fontColor = color;
        this.font = font;
        this.lineUseFontColor = true;
    }

    public DegreeDescriptor(Enums$WaveDegree enums$WaveDegree) {
        this.degree = enums$WaveDegree;
        this.reset();
    }

    public void reset() {
        this.fontColor = null;
        this.lineColor = null;
        this.lineUseFontColor = false;
        this.lineWidth = 1.0f;
        this.lineDash = null;
        this.stroke = null;
        this.font = DegreeDescriptor.getDefaultFont(this.degree);
        this.spacing = 0;
        this.labelHeight = -1.0;
    }

    private static Font getDefaultFont(Enums$WaveDegree enums$WaveDegree) {
        switch (enums$WaveDegree) {
            case SUPER_MILLENNIUM: {
                return o.a;
            }
            case MILLENNIUM: {
                return o.b;
            }
            case SUB_MILLENNIUM: {
                return o.c;
            }
            case GRAND_SUPERCYCLE: {
                return o.d;
            }
            case SUPERCYCLE: {
                return o.e;
            }
            case CYCLE: {
                return o.f;
            }
            case PRIMARY: {
                return o.g;
            }
            case INTERMEDIATE: {
                return o.h;
            }
            case MINOR: {
                return o.i;
            }
            case MINUTE: {
                return o.j;
            }
            case MINUETTE: {
                return o.k;
            }
            case SUBMINUETTE: {
                return o.l;
            }
            case MICRO: {
                return o.m;
            }
            case SUBMICRO: {
                return o.n;
            }
            case MINISCULE: {
                return o.o;
            }
            case NANO: {
                return o.p;
            }
            case SUBNANO: {
                return o.q;
            }
            case PICO: {
                return o.r;
            }
        }
        return null;
    }

    public Enums$WaveDegree getDegree() {
        return this.degree;
    }

    public void setDegree(Enums$WaveDegree enums$WaveDegree) {
        this.degree = enums$WaveDegree;
        this.labelHeight = -1.0;
    }

    public Font getFont() {
        return this.font == null ? DegreeDescriptor.getDefaultFont(this.degree) : this.font;
    }

    public void setFont(Font font) {
        this.font = font;
        this.labelHeight = -1.0;
    }

    public Color getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(Color color) {
        this.fontColor = color;
    }

    public float getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(float f2) {
        this.lineWidth = f2;
        this.stroke = null;
    }

    public float[] getLineDash() {
        return this.lineDash;
    }

    public void setLineDash(float[] fArray) {
        this.lineDash = fArray;
        this.stroke = null;
    }

    public Color getLineColor() {
        return this.lineColor;
    }

    public void setLineColor(Color color) {
        this.lineColor = color;
    }

    public boolean isLineUseFontColor() {
        return this.lineUseFontColor;
    }

    public void setLineUseFontColor(boolean bl2) {
        this.lineUseFontColor = bl2;
    }

    public Stroke getLineStroke() {
        if (this.stroke == null) {
            this.stroke = UIUtil.a(this.lineWidth, this.lineDash);
        }
        return this.stroke;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int n2) {
        this.spacing = n2;
        this.labelHeight = -1.0;
    }

    public double getLabelHeight() {
        if (this.labelHeight > 0.0) {
            return this.labelHeight;
        }
        this.labelHeight = UIUtil.a(this.getFont()).getHeight() + this.spacing;
        if (this.degree.circle) {
            this.labelHeight += 8.0;
        }
        return this.labelHeight;
    }

    @Override
    public List getNVPs() {
        return h.b(new String[]{this.a("degree", (Object)this.degree), this.a("width", this.lineWidth, 1.0f), this.a("dash", this.lineDash), this.a("useFontColor", this.lineUseFontColor, false), this.a("fontColor", this.fontColor), this.a("lineColor", this.lineColor), this.a("font", (Object)this.font, (Object)DegreeDescriptor.getDefaultFont(this.degree)), this.a("spacing", this.spacing)});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        try {
            this.degree = Enums$WaveDegree.valueOf(jSONObject.str("degree"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.lineWidth = jSONObject.getFloat("width", 1.0f);
        this.lineDash = jSONObject.getDash("dash");
        this.lineUseFontColor = jSONObject.is("useFontColor", false);
        this.fontColor = jSONObject.getColor("fontColor");
        this.lineColor = jSONObject.getColor("lineColor");
        this.font = jSONObject.getFont("font");
        if (this.font == null) {
            this.font = DegreeDescriptor.getDefaultFont(this.degree);
        }
        this.spacing = jSONObject.getInt("spacing");
        this.labelHeight = -1.0;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof DegreeDescriptor)) {
            return false;
        }
        DegreeDescriptor degreeDescriptor = (DegreeDescriptor)object;
        if (this.degree != degreeDescriptor.degree) {
            return false;
        }
        if (!h.a((Object)this.font, (Object)degreeDescriptor.font)) {
            return false;
        }
        if (!h.a((Object)this.fontColor, (Object)degreeDescriptor.fontColor)) {
            return false;
        }
        if (!h.a((Object)this.lineColor, (Object)degreeDescriptor.lineColor)) {
            return false;
        }
        if (this.lineWidth != degreeDescriptor.lineWidth) {
            return false;
        }
        if (!h.a(this.lineDash, degreeDescriptor.lineDash)) {
            return false;
        }
        if (this.lineUseFontColor != degreeDescriptor.lineUseFontColor) {
            return false;
        }
        return this.spacing == degreeDescriptor.spacing;
    }

    @Override
    public DegreeDescriptor clone() {
        try {
            return (DegreeDescriptor)super.clone();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

