/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.Enums$DayOfWeek;
import com.motivewave.common.h;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.w;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.json.JSONObject;

public class DailyHours
implements aa,
w {
    private Enums$DayOfWeek day;
    private int startTime1;
    private int endTime1;
    private int startTime2 = -1;
    private int endTime2 = -1;
    private int tradeTime;
    private boolean enabled = true;
    private static SimpleDateFormat cHHMMSSFormat = new SimpleDateFormat("HH:mm:ss");

    public DailyHours(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public DailyHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, boolean bl2) {
        this.day = enums$DayOfWeek;
        this.startTime1 = n2;
        this.endTime1 = n3;
        this.enabled = bl2;
        this.updateTradeTime();
    }

    public DailyHours(Enums$DayOfWeek enums$DayOfWeek, int n2, int n3, int n4, int n5, boolean bl2) {
        this.day = enums$DayOfWeek;
        this.startTime1 = n2;
        this.endTime1 = n3;
        this.startTime2 = n4;
        this.endTime2 = n5;
        this.enabled = bl2;
        this.updateTradeTime();
    }

    public DailyHours(Enums$DayOfWeek enums$DayOfWeek, DailyHours dailyHours) {
        this(enums$DayOfWeek, dailyHours.getStartTime1(), dailyHours.getEndTime1(), dailyHours.getStartTime2(), dailyHours.getEndTime2(), dailyHours.isEnabled());
    }

    public int getMinutesInDay() {
        int n2 = (int)((long)this.tradeTime / 60000L);
        if (n2 <= 0 || n2 > 1440) {
            return 1440;
        }
        return n2;
    }

    public int getStartTime1() {
        return this.startTime1;
    }

    public int getEndTime1() {
        return this.endTime1;
    }

    public int getStartTime2() {
        return this.startTime2;
    }

    public int getEndTime2() {
        return this.endTime2;
    }

    public int getEndTime() {
        if (this.hasSecondaryTime()) {
            return this.endTime2;
        }
        return this.endTime1;
    }

    public boolean hasSecondaryTime() {
        return this.endTime2 != -1;
    }

    public int getTradingTime() {
        return this.tradeTime;
    }

    public boolean isValidTime(int n2) {
        if (n2 < this.startTime1) {
            return false;
        }
        if (this.hasSecondaryTime()) {
            if (this.startTime1 < 0 && n2 > this.endTime2 && (n2 -= 86400000) >= this.startTime1) {
                return true;
            }
            if (n2 >= this.endTime2) {
                return false;
            }
            return n2 < this.endTime1 || n2 >= this.startTime2;
        }
        if (this.startTime1 < 0 && n2 >= this.endTime1 && (n2 -= 86400000) >= this.startTime1) {
            return true;
        }
        return n2 < this.endTime1;
    }

    public int getRemainingTime(int n2) {
        if (n2 <= this.startTime1) {
            return this.tradeTime;
        }
        if (this.endTime2 != -1) {
            if (n2 >= this.endTime2) {
                return 0;
            }
            if (n2 >= this.startTime2) {
                return this.endTime2 - n2;
            }
            if (n2 >= this.endTime1) {
                return this.endTime2 - this.startTime2;
            }
            return this.endTime1 - n2 + (this.endTime2 - this.startTime2);
        }
        if (n2 >= this.endTime1) {
            return 0;
        }
        return this.endTime1 - n2;
    }

    public int getTradingTime(int n2, int n3) {
        if (n3 <= this.startTime1) {
            return 0;
        }
        if (n2 < this.startTime1) {
            n2 = this.startTime1;
        }
        if (this.endTime2 == -1 || n3 < this.startTime2) {
            if (n3 > this.endTime1) {
                n3 = this.endTime1;
            }
            return n3 - n2;
        }
        if (n2 < this.endTime1 && n3 > this.startTime2) {
            if (n3 > this.endTime2) {
                n3 = this.endTime2;
            }
            return this.endTime1 - n2 + (n3 - this.startTime2);
        }
        if (n2 >= this.endTime1 && n3 <= this.startTime2) {
            return 0;
        }
        if (n2 < this.startTime2) {
            n2 = this.startTime2;
        }
        if (n3 > this.endTime2) {
            n3 = this.endTime2;
        }
        return n3 - n2;
    }

    public int getConsumedTime(int n2) {
        return this.tradeTime - this.getRemainingTime(n2);
    }

    public boolean isSameHours(DailyHours dailyHours) {
        return this.startTime1 == dailyHours.startTime1 && this.endTime1 == dailyHours.endTime1 && this.startTime2 == dailyHours.startTime2 && this.endTime2 == dailyHours.endTime2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof DailyHours)) {
            return false;
        }
        DailyHours dailyHours = (DailyHours)object;
        return this.day == dailyHours.day && this.startTime1 == dailyHours.startTime1 && this.endTime1 == dailyHours.endTime1 && this.startTime2 == dailyHours.startTime2 && this.endTime2 == dailyHours.endTime2 && this.enabled == dailyHours.enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Enums$DayOfWeek getDayOfWeek() {
        return this.day;
    }

    public String toString() {
        return "DailyHours() " + String.valueOf((Object)this.day) + " start: " + this.format(this.startTime1) + " end: " + this.format(this.endTime2 != -1 ? this.endTime2 : this.endTime1);
    }

    @Override
    public DailyHours clone() {
        try {
            return (DailyHours)super.clone();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public List getNVPs() {
        return h.b(new String[]{this.a("day", (Object)this.day), this.a("enabled", this.enabled), this.a("start1", this.startTime1), this.a("end1", this.endTime1), this.a("start2", this.startTime2, -1), this.a("end2", this.endTime2, -1)});
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        try {
            this.day = Enums$DayOfWeek.valueOf(jSONObject.str("day"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.enabled = jSONObject.is("enabled");
        this.startTime1 = jSONObject.getInt("start1");
        this.endTime1 = jSONObject.getInt("end1");
        this.startTime2 = jSONObject.getInt("start2", -1);
        this.endTime2 = jSONObject.getInt("end2", -1);
        this.updateTradeTime();
    }

    private void updateTradeTime() {
        this.tradeTime = this.hasSecondaryTime() ? this.endTime1 - this.startTime1 + (this.endTime2 - this.startTime2) : this.endTime1 - this.startTime1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String format(int n2) {
        SimpleDateFormat simpleDateFormat = cHHMMSSFormat;
        synchronized (simpleDateFormat) {
            return cHHMMSSFormat.format(new Date(n2));
        }
    }

    static {
        cHHMMSSFormat.setTimeZone(h.e);
    }
}

