/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bo.n;
import cf.fg;
import com.motivewave.common.b;
import com.motivewave.common.h;
import com.motivewave.platform.databean.CustomColumn;
import com.motivewave.platform.databean.DirectoryListener;
import com.motivewave.platform.databean.FormatRule;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.StudyCondition;
import com.motivewave.platform.databean.TickerStudyProperty;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.sdk.common.DataSeries;
import com.motivewave.platform.sdk.common.desc.ValueDescriptor;
import java.util.Collection;

public class CustomColumnProperty
extends TickerStudyProperty
implements DirectoryListener {
    private CustomColumn column;

    CustomColumnProperty(LiveTicker liveTicker, CustomColumn customColumn) {
        super(liveTicker);
        this.column = customColumn;
        CustomColumn.addListener(this);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        super.destroy();
        CustomColumn.removeListener(this);
    }

    @Override
    public FormatRule getApplicableRule() {
        n n2 = this.dataContext;
        if (n2 == null) {
            return null;
        }
        DataSeries dataSeries = n2.getDataSeries();
        if (this.column == null || h.a((Collection)this.column.getFormatRules()) || dataSeries == null) {
            return null;
        }
        FormatRule formatRule = null;
        for (FormatRule formatRule2 : this.column.getFormatRules()) {
            if (formatRule2.isDefaultRule()) {
                formatRule = formatRule2;
                continue;
            }
            if (h.a((Collection)formatRule2.getConditions())) continue;
            boolean bl2 = true;
            for (StudyCondition studyCondition : formatRule2.getConditions()) {
                if (studyCondition == null || studyCondition.evaluate(dataSeries)) continue;
                bl2 = false;
                break;
            }
            if (!bl2) continue;
            return formatRule2;
        }
        return formatRule;
    }

    @Override
    protected ValueDescriptor getStudyValue() {
        return this.column == null ? null : this.column.getStudyValue();
    }

    @Override
    protected String getProperty() {
        return this.column.getId();
    }

    @Override
    protected fg getStudyWithModel() {
        return this.column.getStudy();
    }

    @Override
    protected BarSize getBarSize() {
        return this.column.getStudyBarSize();
    }

    @Override
    protected boolean isRthData() {
        return this.column.isRthData();
    }

    public void updated(CustomColumn customColumn) {
        if (customColumn != this.column) {
            return;
        }
        if (!h.a((Object)customColumn.getStudyBarSize(), (Object)this.dataSource.a()) || !h.a(this.model.d(), customColumn.getStudy().a().d())) {
            b.d(() -> this.reinitialize());
        }
    }
}

