/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.platform.common.a;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.service.bs;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class Currency
implements Comparable {
    private String symbol;
    private String description;
    private static Map symbolMap = new HashMap();
    private static SortedSet allCurrencies = new TreeSet();
    private static SortedSet allSymbols = new TreeSet();
    private static boolean unsavedChanges = false;

    public Currency(String string, String string2) {
        this.symbol = string;
        this.description = string2;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getDescription() {
        return this.description;
    }

    public int compareTo(Currency currency) {
        if (currency == null) {
            return -1;
        }
        return this.symbol.compareTo(currency.symbol);
    }

    public String toString() {
        return this.symbol;
    }

    public static void save() {
        Workspace workspace = bs.a();
        File file = new File(workspace.getConfigDir(), "currencies.csv");
        if (!unsavedChanges && file.exists()) {
            return;
        }
        unsavedChanges = false;
        Currency.save(workspace, Currency.getAll());
    }

    public static void save(Workspace workspace, List list) {
        try {
            PrintWriter printWriter = new PrintWriter(new File(workspace.getConfigDir(), "currencies.csv"));
            for (Currency currency : list) {
                Currency.toCSV(currency, printWriter);
            }
            printWriter.flush();
            printWriter.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void load() {
        Iterator iterator = allCurrencies;
        synchronized (iterator) {
            symbolMap.clear();
            allCurrencies.clear();
            allSymbols.clear();
        }
        for (Currency currency : Currency.load(bs.a())) {
            Currency.register(currency);
        }
        if (allCurrencies.isEmpty()) {
            for (Currency currency : Currency.getDefaults()) {
                Currency.register(currency);
            }
        }
        unsavedChanges = false;
    }

    public static List load(File file) {
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        if (!file.exists()) {
            return arrayList;
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            String string = bufferedReader.readLine();
            while (string != null) {
                Currency currency = Currency.fromCSV(string);
                if (currency != null) {
                    arrayList.add(currency);
                }
                string = bufferedReader.readLine();
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList;
    }

    public static List load(Workspace workspace) {
        File file = new File(workspace.getConfigDir(), "currencies.csv");
        return Currency.load(file);
    }

    private static Currency fromCSV(String string) {
        if (h.g(string) || string.indexOf(44) < 0) {
            return null;
        }
        List list = a.a(string);
        if (h.a((Collection)list)) {
            return null;
        }
        if (list.size() == 2) {
            return new Currency((String)list.get(0), (String)list.get(1));
        }
        if (list.size() == 3) {
            return new Currency((String)list.get(1), (String)list.get(2));
        }
        return null;
    }

    private static void toCSV(Currency currency, PrintWriter printWriter) {
        a.a(printWriter, currency.symbol, currency.description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(Currency currency) {
        if (currency == null || currency.getSymbol() == null) {
            return;
        }
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            if (symbolMap.get(currency.getSymbol()) == currency) {
                return;
            }
            symbolMap.put(currency.getSymbol(), currency);
            allCurrencies.add(currency);
            allSymbols.add(currency.getSymbol());
            unsavedChanges = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Currency get(String string) {
        if (h.g(string)) {
            return null;
        }
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            return (Currency)symbolMap.get(string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAll() {
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            return new ArrayList(allCurrencies);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List getAllSymbols() {
        SortedSet sortedSet = allCurrencies;
        synchronized (sortedSet) {
            return new ArrayList(allSymbols);
        }
    }

    public static List getDefaults() {
        return h.b(new Currency[]{new Currency("USD", "US Dollar"), new Currency("CAD", "Canadian Dollar"), new Currency("AUD", "Australian Dollar"), new Currency("EUR", "European Union Euro"), new Currency("GBP", "Great Britain (UK) Pound"), new Currency("HKD", "Hong Kong Dollar"), new Currency("NZD", "New Zealand Dollar"), new Currency("KRW", "Korean Won"), new Currency("NOK", "Norwegian Krone"), new Currency("SEK", "Sweden Kronor"), new Currency("CHF", "Switzerland Franc"), new Currency("JPY", "Japanese Yen"), new Currency("CNY", "Chinese Yuan"), new Currency("BSD", "Bahamas Dollar"), new Currency("BBD", "Barbados Dollar"), new Currency("ARS", "Argentina Pesos"), new Currency("AWG", "Aruba Dollar"), new Currency("BMD", "Bermuda Dollar"), new Currency("BRL", "Brazil Reais"), new Currency("KYD", "Cayman Islands Dollar"), new Currency("CLP", "Chile Pesos"), new Currency("CRC", "Costa Rica Colon"), new Currency("COP", "Columbia Pesos"), new Currency("HRK", "Croatia Kruna"), new Currency("CZK", "Czech Republic, Koruny"), new Currency("DKK", "Denmark Kroner"), new Currency("DOP", "Dominican Republic, Pesos"), new Currency("EGP", "Egypt Pounds"), new Currency("HUF", "Hungary Forint"), new Currency("ISK", "Iceland Kronur"), new Currency("INR", "India Rupees"), new Currency("ILS", "Israel New Shekels"), new Currency("JMD", "Jamaica Dollars"), new Currency("MXN", "Mexico Pesos"), new Currency("RUB", "Russia Rubles"), new Currency("SGD", "Singapore Dollars"), new Currency("TWD", "Taiwan New Dollars"), new Currency("TRY", "Turkish Liras"), new Currency("XAG", "Silver Ounce"), new Currency("XAU", "Gold Ounce"), new Currency("ZAR", "South African Rand")});
    }
}

