/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.b;
import com.motivewave.common.h;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.service.TickType;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.srvc.j;
import com.motivewave.platform.service.t;
import com.motivewave.platform.service.v;
import java.util.Map;
import o.i;

public class ContinuousTicker
extends LiveTicker
implements v,
i {
    private LiveTicker ticker;
    private MWInstrument activeContract;

    protected ContinuousTicker(MWInstrument mWInstrument) {
        super(mWInstrument);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void destroyTicker() {
        if (this.hasListeners()) {
            this.removeAllListeners();
        }
        if (!bs.V()) {
            h.a.info("Destroying Ticker: " + this.getSymbol());
        }
        Map map = directory;
        synchronized (map) {
            try {
                bs.a();
                this.ticker.removePropertyChangeListener(this);
                this.ticker.removeTickListener(this);
                this.ticker.removeDepthListener(this);
                this.clearHistory();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                bs.b();
            }
        }
    }

    @Override
    protected void registerLevel1() {
        b.d(() -> this.updateTickers());
    }

    @Override
    protected void registerLevel2() {
        if (this.ticker == null) {
            return;
        }
        this.ticker.addDepthListener(this);
    }

    public void instrumentUpdated() {
        this.clear();
        this.updateTickers();
        this.clearHistory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTickers() {
        MWInstrument mWInstrument = this.getInstrument();
        if (!mWInstrument.isCustomContinuous()) {
            h.a.severe("ContinuousTicker::updateTickers() not a continuous instrument! " + String.valueOf(this));
            return;
        }
        MWInstrument mWInstrument2 = mWInstrument.getActiveContract();
        if (mWInstrument2 == null) {
            h.a.severe("ContinuousTicker::updateTicker() active contract not found: " + mWInstrument.getKey());
            h.c();
            return;
        }
        if (mWInstrument2 == this.activeContract) {
            h.a.info("ContinuousTicker::updateTickers() already using active contract: " + String.valueOf(mWInstrument2));
            return;
        }
        bs.a();
        try {
            LiveTicker liveTicker;
            h.a.info("ContinuousTicker::updateTicker() updating using active contract: " + mWInstrument2.getKey());
            if (this.activeContract != null && this.activeContract != mWInstrument2) {
                h.a.info("ContinuousTicker::updateTicker() disconnecting existing active contract: " + this.activeContract.getKey());
                liveTicker = LiveTicker.get(this.activeContract);
                liveTicker.removePropertyChangeListener(this);
                liveTicker.removeTickListener(this);
                liveTicker.removeDepthListener(this);
                liveTicker.removeDepedantTicker(this);
            }
            liveTicker = LiveTicker.get(mWInstrument2);
            liveTicker.addPropertyChangeListener(this);
            liveTicker.addTickListener(this);
            if (!this.depthListeners.a()) {
                liveTicker.addDepthListener(this);
            }
            liveTicker.addDependantTicker(this);
            this.activeContract = mWInstrument2;
            this.ticker = liveTicker;
            if (liveTicker.isValueValid(liveTicker.getLastPrice())) {
                this.update(TickType.LAST_PRICE, Float.valueOf(liveTicker.getLastPrice()));
            }
            if (liveTicker.getLastSizeAsFloat() > 0.0f) {
                this.update(TickType.LAST_SIZE, Float.valueOf(liveTicker.getLastSizeAsFloat()));
            }
            if (liveTicker.isValueValid(liveTicker.getAskPrice())) {
                this.update(TickType.ASK_PRICE, Float.valueOf(liveTicker.getAskPrice()));
            }
            if (liveTicker.getAskSizeAsFloat() > 0.0f) {
                this.update(TickType.ASK_SIZE, Float.valueOf(liveTicker.getAskSizeAsFloat()));
            }
            if (liveTicker.isValueValid(liveTicker.getBidPrice())) {
                this.update(TickType.BID_PRICE, Float.valueOf(liveTicker.getBidPrice()));
            }
            if (liveTicker.getBidSizeAsFloat() > 0.0f) {
                this.update(TickType.BID_SIZE, Float.valueOf(liveTicker.getBidSizeAsFloat()));
            }
            if (liveTicker.isValueValid(liveTicker.getHigh())) {
                this.update(TickType.HIGH, Float.valueOf(liveTicker.getHigh()));
            }
            if (liveTicker.isValueValid(liveTicker.getHighPrevDay())) {
                this.update(TickType.HIGH_PREV_DAY, Float.valueOf(liveTicker.getHighPrevDay()));
            }
            if (liveTicker.isValueValid(liveTicker.getLow())) {
                this.update(TickType.LOW, Float.valueOf(liveTicker.getLow()));
            }
            if (liveTicker.isValueValid(liveTicker.getLowPrevDay())) {
                this.update(TickType.LOW_PREV_DAY, Float.valueOf(liveTicker.getLowPrevDay()));
            }
            if (liveTicker.isValueValid(liveTicker.getClose())) {
                this.update(TickType.CLOSE, Float.valueOf(liveTicker.getClose()));
            }
            if (liveTicker.isValueValid(liveTicker.getOpen())) {
                this.update(TickType.OPEN, Float.valueOf(liveTicker.getOpen()));
            }
            if (liveTicker.isValueValid(liveTicker.getSettlement())) {
                this.update(TickType.SETTLE, Float.valueOf(liveTicker.getSettlement()));
            }
            if (liveTicker.getOpenInterest() > 0) {
                this.update(TickType.OPEN_INTEREST, liveTicker.getOpenInterest());
            }
            if (liveTicker.getDayVolume() > 0.0f) {
                this.update(TickType.VOLUME, Float.valueOf(liveTicker.getDayVolume()));
            }
            if (liveTicker.getAvgVolume() > 0.0f) {
                this.update(TickType.AVG_VOLUME, Float.valueOf(liveTicker.getAvgVolume()));
            }
            if (liveTicker.getYesterdayVolume() > 0.0f) {
                this.update(TickType.YESTERDAY_VOLUME, Float.valueOf(liveTicker.getYesterdayVolume()));
            }
            if (liveTicker.getLastTimestamp() > 0L) {
                this.update(TickType.LAST_TIMESTAMP, liveTicker.getLastTimestamp());
            }
            mWInstrument.setExpiryDate(liveTicker.getExpiryDate());
            mWInstrument.setPointValue(liveTicker.getPointValue());
            mWInstrument.setContractValue(liveTicker.getInstrument().getContractValue());
            mWInstrument.setCurrency(liveTicker.getCurrency());
            mWInstrument.setExchange(liveTicker.getExchange());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            bs.b();
        }
        long l2 = bs.a();
        long l3 = mWInstrument2.getEndOfDay(l2, false);
        if (l3 <= l2) {
            l3 = mWInstrument2.getStartOfNextDay(l2, false);
        }
        b.a(() -> {
            if (!this.hasListeners() && this.tickListeners.a() && this.depthListeners.a()) {
                return;
            }
            h.a.info("CustomTicker::updateTickers() checking active contract: " + String.valueOf(this));
            this.updateTickers();
        }, l3 - l2);
    }

    @Override
    public void addDepthListener(v v2) {
        boolean bl2 = this.depthListeners.a();
        this.depthListeners.a((Object)v2);
        if (bl2) {
            this.registerLevel2();
        } else {
            t t2;
            j j2 = bs.c(this.activeContract);
            if (j2 != null && (t2 = j2.a(this.activeContract)) != null) {
                b.d(() -> this.notifyBookUpdate(t2));
            }
        }
    }

    @Override
    public void removeDepthListener(v v2) {
        if (!this.depthListeners.c(v2)) {
            return;
        }
        this.depthListeners.a((Object)v2);
        if (this.depthListeners.a() && this.ticker != null) {
            b.a(() -> {
                if (!this.depthListeners.a()) {
                    return;
                }
                try {
                    if (!bs.V()) {
                        h.a.info("ContinuousTicker::removeDepthListener() releasing depth data: " + this.getKey());
                    }
                    this.ticker.removeDepthListener(this);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }, 5000L);
        }
    }

    @Override
    public void bookUpdate(t t2) {
        for (v v2 : this.depthListeners.a()) {
            if (v2 == null) continue;
            v2.bookUpdate(t2);
        }
    }

    @Override
    public t getDepthBook() {
        j j2 = bs.c(this.activeContract);
        if (j2 == null) {
            return null;
        }
        return j2.a(this.activeContract);
    }

    @Override
    public void tick(k.v v2) {
        this.recordTick(v2.a());
    }
}

