/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.platform.databean.n;
import com.motivewave.platform.sdk.common.BaseInfo;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.LinearGradient;
import javafx.scene.paint.Stop;
import org.json.JSONObject;

public class ColorMap
extends BaseInfo {
    private List colors;

    public ColorMap(JSONObject jSONObject) {
        super(true);
        this.fromJSON(jSONObject);
    }

    public ColorMap(java.awt.Color ... colorArray) {
        super(true);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (java.awt.Color color : colorArray) {
            if (color == null) continue;
            arrayList.add(UIUtil.a(color));
        }
        this.colors = arrayList;
    }

    public ColorMap(Color ... colorArray) {
        super(true);
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (Color color : colorArray) {
            if (color == null) continue;
            arrayList.add(color);
        }
        this.colors = arrayList;
    }

    public ColorMap(List list) {
        super(true);
        this.colors = list;
    }

    public ColorMap(List list, boolean bl2) {
        super(bl2);
        this.colors = list;
    }

    public LinearGradient getGradient(int n2, int n3) {
        if (this.colors.size() <= 1) {
            return null;
        }
        ArrayList<Stop> arrayList = new ArrayList<Stop>();
        double d2 = 0.0;
        double d3 = 1.0 / (double)(this.colors.size() - 1);
        for (Color color : this.colors) {
            arrayList.add(new Stop(d2, color));
            d2 += d3;
        }
        return new LinearGradient((double)n2, 0.0, (double)n3, 0.0, false, CycleMethod.REPEAT, arrayList);
    }

    public List getColors() {
        return this.colors;
    }

    public void setColors(List list) {
        this.colors = list;
    }

    public List getAWTColors() {
        ArrayList<java.awt.Color> arrayList = new ArrayList<java.awt.Color>();
        for (Color color : this.colors) {
            arrayList.add(UIUtil.a(color));
        }
        return arrayList;
    }

    public void setEnabled(boolean bl2) {
        super.setEnabled(bl2);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            ColorMap colorMap = (ColorMap)((Object)object);
            return h.c(colorMap.colors, this.colors);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String toJSON() {
        n n2 = new n(this);
        return n2.a(new String[]{n2.a("colors", this.colors), n2.a("enabled", this.isEnabled())});
    }

    public void fromJSON(JSONObject jSONObject) {
        if (jSONObject == null) {
            return;
        }
        this.colors = jSONObject.getFXColors("colors");
        this.setEnabled(jSONObject.is("enabled"));
    }

    public String toString() {
        return this.toJSON();
    }

    public Object toJson(BaseInfo baseInfo) {
        ColorMap colorMap = null;
        if (baseInfo != null) {
            colorMap = (ColorMap)baseInfo;
        }
        if (this.equals((Object)colorMap)) {
            return null;
        }
        if (!this.isEnabled() && colorMap != null && h.c(this.colors, colorMap.colors)) {
            return "N";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.isEnabled()) {
            stringBuffer.append("N,");
        }
        boolean bl2 = true;
        for (Color color : this.colors) {
            if (bl2) {
                bl2 = false;
            } else {
                stringBuffer.append(",");
            }
            stringBuffer.append(UIUtil.c(UIUtil.a(color)));
        }
        return stringBuffer.toString();
    }

    public static ColorMap fromJson(Object object, ColorMap colorMap) {
        boolean bl2;
        String string = "";
        if (object != null) {
            string = object.toString();
        }
        if (string.equals("") && colorMap != null) {
            return colorMap;
        }
        if (string.startsWith("{")) {
            try {
                return new ColorMap(new JSONObject(string));
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (h.a((Object)string, (Object)"N") && colorMap != null) {
            return new ColorMap(colorMap.colors, false);
        }
        boolean bl3 = bl2 = !string.startsWith("N,");
        if (!bl2) {
            string = string.substring(2);
        }
        String[] stringArray = string.split(",");
        ArrayList<Color> arrayList = new ArrayList<Color>();
        for (String string2 : stringArray) {
            Color color = UIUtil.a(UIUtil.a(string2));
            if (color == null) continue;
            arrayList.add(color);
        }
        return new ColorMap(arrayList, bl2);
    }
}

