/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import at.c;
import com.motivewave.common.h;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.service.bs;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;

public class Balance
extends ObservableBean
implements PropertyChangeListener {
    private String exchange;
    private String accountId;
    private String currency;
    private String name;
    private double held;
    private double available;
    private double totalBTC;
    private Map tickerMap = new HashMap();
    private Map ticker2CurrencyMap = new HashMap();

    public Balance(String string, String string2) {
        this.accountId = string;
        this.currency = string2;
    }

    public Balance(c c2) {
        this.accountId = c2.a();
        this.currency = c2.b();
        this.available = c2.b();
        this.held = c2.a();
        this.name = c2.c();
    }

    public void updateFrom(c c2) {
        this.setAvailable(c2.b());
        this.setHeld(c2.a());
        this.setName(c2.c());
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.tickerMap == null) {
            return;
        }
        for (LiveTicker liveTicker : this.tickerMap.values()) {
            liveTicker.removePropertyChangeListener(this);
        }
        this.tickerMap.clear();
        this.ticker2CurrencyMap.clear();
    }

    public String getCurrency() {
        return this.currency;
    }

    public Account getAccount() {
        return bs.a(this.accountId);
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getAccountName() {
        Account account = this.getAccount();
        if (account == null) {
            return "";
        }
        return account.getDisplayName();
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "currency": {
                return this.getCurrency();
            }
            case "account": {
                return this.getAccount();
            }
            case "accountId": {
                return this.getAccountId();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "name": {
                return this.getName();
            }
            case "held": {
                return this.getHeld();
            }
            case "available": {
                return this.getHeld();
            }
            case "total": {
                return this.getTotal();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "serviceType": {
                return this.getServiceType();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "totalUSD": {
                return this.getTotal("USD");
            }
            case "totalBTC": {
                return this.getTotalBTC();
            }
            case "totalEUR": {
                return this.getTotal("EUR");
            }
            case "totalGBP": {
                return this.getTotal("GBP");
            }
            case "totalCAD": {
                return this.getTotal("CAD");
            }
            case "totalAUD": {
                return this.getTotal("AUD");
            }
        }
        return super.getProperty(string);
    }

    @Override
    public String format(String string) {
        return switch (string) {
            case "currency" -> this.getCurrency();
            case "accountId" -> this.getAccountId();
            case "accountName" -> this.getAccountName();
            case "name" -> this.getName();
            case "held" -> ab.a(this.getHeld(), this.getCurrency());
            case "available" -> ab.a(this.getAvailable(), this.getCurrency());
            case "total" -> ab.a(this.getTotal(), this.getCurrency());
            case "serviceName" -> this.getServiceName();
            case "serviceType" -> {
                if (this.getServiceType() == null) {
                    yield "";
                }
                yield this.getServiceType().toString();
            }
            case "connectionName" -> this.getConnectionName();
            case "totalUSD" -> ab.a(this.getTotal("USD"), "USD");
            case "totalBTC" -> ab.a(this.getTotal("BTC"), "BTC");
            case "totalEUR" -> ab.a(this.getTotal("EUR"), "EUR");
            case "totalGBP" -> ab.a(this.getTotal("GBP"), "GBP");
            case "totalCAD" -> ab.a(this.getTotal("CAD"), "CAD");
            case "totalAUD" -> ab.a(this.getTotal("AUD"), "AUD");
            default -> super.format(string);
        };
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getExchange() {
        return this.exchange;
    }

    public void setExchange(String string) {
        this.exchange = string;
    }

    public double getHeld() {
        return this.held;
    }

    public void setHeld(double d2) {
        double d3 = this.getTotal();
        double d4 = this.held;
        this.held = d2;
        this.notify("held", d4, d2);
        this.notify("total", d3, this.getTotal());
    }

    public double getAvailable() {
        return this.available;
    }

    public void setAvailable(double d2) {
        double d3 = this.getTotal();
        double d4 = this.available;
        this.available = d2;
        this.notify("available", d4, d2);
        this.notify("total", d3, this.getTotal());
    }

    public double getTotal() {
        return this.getAvailable() + this.getHeld();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public double getTotal(String string) {
        if (h.b((Object)string, (Object)this.currency)) {
            return this.getTotal();
        }
        if (h.b((Object)string, (Object)"BTC") && this.totalBTC != 0.0) {
            return this.totalBTC;
        }
        if (this.totalBTC == 0.0) {
            return this.getTotal();
        }
        Map map = this.tickerMap;
        synchronized (map) {
            LiveTicker liveTicker = (LiveTicker)this.tickerMap.get(string);
            if (liveTicker == null) {
                MWInstrument mWInstrument = MWInstrument.get("BTC/" + string, this.exchange, this.getServiceType());
                if (mWInstrument == null) {
                    mWInstrument = MWInstrument.get("BTC/" + string, this.getServiceType());
                }
                if (mWInstrument == null) {
                    return 0.0;
                }
                liveTicker = LiveTicker.get(mWInstrument);
                liveTicker.addPropertyChangeListener(this);
                this.tickerMap.put(string, liveTicker);
                this.ticker2CurrencyMap.put(liveTicker, string);
            }
            return this.totalBTC * (double)liveTicker.getSellPrice();
        }
    }

    public void setTotalBTC(double d2) {
        double d3 = this.totalBTC;
        this.totalBTC = d2;
        this.notify("totalBTC", d3, d2);
    }

    public double getTotalBTC() {
        return this.totalBTC == 0.0 ? this.getTotal("BTC") : this.totalBTC;
    }

    public String getServiceName() {
        Account account = this.getAccount();
        return account == null ? "" : account.getServiceName();
    }

    public Enums$ServiceType getServiceType() {
        Account account = this.getAccount();
        return account == null ? null : account.getServiceType();
    }

    public String getConnectionName() {
        Account account = this.getAccount();
        return account == null ? "" : account.getConnectionName();
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (h.a(propertyChangeEvent.getPropertyName(), "lastPrice", "bidPrice", "askPrice")) {
            return;
        }
        String string = (String)this.ticker2CurrencyMap.get(propertyChangeEvent.getSource());
        if (string == null) {
            return;
        }
        this.notify("total" + string, 0.0, this.getTotal(string));
    }
}

