/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.f;
import com.motivewave.platform.databean.Analysis;
import com.motivewave.platform.databean.AnalysisInfo;
import com.motivewave.platform.databean.AnalysisListener;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.g;
import com.motivewave.platform.service.bs;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AnalysisDirectory {
    private static com.motivewave.common.util.g listeners = new com.motivewave.common.util.g();

    public static void addListener(AnalysisListener analysisListener) {
        listeners.a((Object)analysisListener);
    }

    public static void removeListener(AnalysisListener analysisListener) {
        listeners.a((Object)analysisListener);
    }

    public static Analysis load(MWInstrument mWInstrument, String string) {
        Analysis analysis;
        Object object;
        Object object2;
        if (mWInstrument == null) {
            return null;
        }
        Workspace workspace = bs.a();
        if (workspace.isOverrideRepository()) {
            object2 = workspace.getAnalysisSources().iterator();
            while (object2.hasNext()) {
                object = (AnalysisSource)object2.next();
                Object object3 = mWInstrument.getAnalysisFile((AnalysisSource)object, string);
                if (object3 == null || !((File)object3).exists() || (analysis = AnalysisDirectory.readAnalysis((File)object3, mWInstrument)) == null) continue;
                if (((AnalysisSource)object).isReadOnly()) {
                    analysis.setReadOnly(true);
                }
                return analysis;
            }
        }
        if ((object2 = mWInstrument.getAnalysisFile(string)) != null && ((File)object2).exists()) {
            object = AnalysisDirectory.readAnalysis((File)object2, mWInstrument);
            if (object == null) {
                object = new Analysis(string, mWInstrument);
                ((Analysis)object).setLastUpdated(((File)object2).lastModified());
                ((Analysis)object).setSrcFile((File)object2);
            }
            return object;
        }
        for (Object object3 : workspace.getAnalysisSources()) {
            object2 = mWInstrument.getAnalysisFile((AnalysisSource)object3, string);
            if (object2 == null || !((File)object2).exists() || (analysis = AnalysisDirectory.readAnalysis((File)object2, mWInstrument)) == null) continue;
            if (((AnalysisSource)object3).isReadOnly()) {
                analysis.setReadOnly(true);
            }
            return analysis;
        }
        try {
            object = mWInstrument.getAnalysisFile(string);
            if (object == null) {
                return null;
            }
            long l2 = System.currentTimeMillis();
            Analysis analysis2 = new Analysis(string, mWInstrument);
            analysis2.setLastUpdated(l2);
            analysis2.setSrcFile((File)object);
            return analysis2;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public static void rename(Analysis analysis, String string) {
        if (analysis == null || h.a((Object)analysis.getName(), (Object)string)) {
            return;
        }
        if (analysis.isReadOnly()) {
            h.a.warning("AnalysisDirectory::rename() cannot rename read only: " + analysis.getInstrument().getSymbol() + " - " + analysis.getName());
            throw new MWException(f.E_ANALYSIS_RENAME_READONLY, analysis.getInstrument().getSymbol() + " - " + analysis.getName());
        }
        String string2 = analysis.getName();
        analysis.setName(string);
        if (analysis.getSrcFile() != null) {
            if (analysis.getSrcFile().exists() && !analysis.getSrcFile().delete()) {
                h.a.warning("AnalysisDirectory::rename() unable to delete src file: " + analysis.getSrcFile().getAbsolutePath());
            }
            analysis.setSrcFile(null);
        }
        AnalysisDirectory.write(analysis, false, true);
        for (AnalysisListener analysisListener : listeners.a()) {
            try {
                analysisListener.renamed(analysis, string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static void writeTo(Analysis analysis, AnalysisSource analysisSource) {
        if (analysis == null) {
            return;
        }
        MWInstrument mWInstrument = analysis.getInstrument();
        if (analysis.isReadOnly() || analysisSource.isReadOnly()) {
            h.a.warning("AnalysisDirectory::writeTo() cannot write read only: " + mWInstrument.getSymbol() + " - " + analysis.getName() + " " + analysisSource.getName());
            return;
        }
        File file = mWInstrument.getAnalysisFile(analysisSource, analysis.getName());
        if (file == null) {
            h.a.warning("AnalysisDirectory::writeTo() cannot write file: " + mWInstrument.getSymbol() + " - " + analysis.getName() + " " + analysisSource.getName());
            return;
        }
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            h.a(file, analysis.getData());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void write(Analysis analysis, boolean bl2) {
        AnalysisDirectory.write(analysis, bl2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(Analysis analysis, boolean bl2, boolean bl3) {
        if (analysis == null) {
            return;
        }
        MWInstrument mWInstrument = analysis.getInstrument();
        if (mWInstrument == null) {
            h.a.warning("AnalysisDirectory::write() instrument is missing for analysis: " + analysis.getName());
            h.c();
            return;
        }
        if (analysis.isReadOnly()) {
            h.a.warning("AnalysisDirectory::write() cannot write read only: " + mWInstrument.getSymbol() + " - " + analysis.getName());
            throw new MWException(f.E_ANALYSIS_SAVE_READONLY, mWInstrument.getSymbol() + " - " + analysis.getName());
        }
        try {
            block18: {
                analysis.setWriteInProgress(true);
                if (!bl3) {
                    analysis.setLastUpdated(System.currentTimeMillis());
                }
                if (analysis.getSrcFile() == null) {
                    try {
                        File file = mWInstrument.getAnalysisFile(analysis.getName());
                        if (file == null) {
                            h.a.warning("AnalysisDirectory::write() unable to get source file: " + mWInstrument.getSymbol() + " - " + analysis.getName());
                            break block18;
                        }
                        h.a(file, analysis.getData());
                        analysis.setSrcFile(file);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                } else if (analysis.getSrcFile() != null) {
                    try {
                        h.a(analysis.getSrcFile(), analysis.getData());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            if (bl3) {
                analysis.getSrcFile().setLastModified(analysis.getLastUpdated());
            }
            analysis.updateTimestamp();
        }
        finally {
            analysis.setWriteInProgress(false);
        }
        if (bl2) {
            for (AnalysisListener analysisListener : listeners.a()) {
                analysisListener.added(analysis);
            }
        }
    }

    public static void delete(Analysis analysis) {
        if (analysis == null) {
            return;
        }
        MWInstrument mWInstrument = analysis.getInstrument();
        if (analysis.isReadOnly()) {
            h.a.warning("AnalysisDirectory::delete() cannot delete read only: " + mWInstrument.getSymbol() + " - " + analysis.getName());
            return;
        }
        File file = analysis.getSrcFile();
        if (file != null && file.exists() && !file.delete()) {
            h.a.warning("AnalysisDirectory::delete() unable to delete src file: " + file.getAbsolutePath());
        }
        for (AnalysisListener analysisListener : listeners.a()) {
            analysisListener.removed(analysis);
        }
    }

    public static List getNames(MWInstrument mWInstrument) {
        List list = AnalysisDirectory.getInfos(mWInstrument);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AnalysisInfo analysisInfo : list) {
            if (h.g(analysisInfo.getName())) continue;
            arrayList.add(analysisInfo.getName());
        }
        if (h.a(arrayList)) {
            arrayList.add("Primary Analysis");
        } else if (!arrayList.contains("Primary Analysis")) {
            arrayList.add(0, "Primary Analysis");
        }
        return arrayList;
    }

    private static File getRootDir() {
        Workspace workspace = bs.a();
        return workspace.isUseDatabase() ? Workspace.getWorkspaceDir() : workspace.getRepoDir();
    }

    public static List getAll(MWInstrument mWInstrument) {
        File file = mWInstrument.getAnalysisDirectory(AnalysisDirectory.getRootDir());
        ArrayList arrayList = new ArrayList();
        if (file == null || !file.exists()) {
            return arrayList;
        }
        AnalysisDirectory.readAnalysisFiles(file, arrayList);
        return arrayList;
    }

    public static Analysis getNoCreate(MWInstrument mWInstrument, String string) {
        for (Analysis analysis : AnalysisDirectory.getAll(mWInstrument)) {
            if (!h.a((Object)analysis.getName(), (Object)string) && (!h.g(string) || !analysis.isPrimary())) continue;
            return analysis;
        }
        return null;
    }

    public static List getAllInfos() {
        ArrayList arrayList = new ArrayList();
        for (MWInstrument mWInstrument : MWInstrument.getAll()) {
            AnalysisDirectory.addFromDir(mWInstrument.getAnalysisDirectory(AnalysisDirectory.getRootDir()), mWInstrument, arrayList);
        }
        return arrayList;
    }

    public static List getInfos(MWInstrument mWInstrument) {
        return AnalysisDirectory.getInfos(mWInstrument, true);
    }

    public static List getInfos(MWInstrument mWInstrument, boolean bl2) {
        ArrayList<AnalysisInfo> arrayList = new ArrayList<AnalysisInfo>();
        AnalysisDirectory.addFromDir(mWInstrument.getAnalysisDirectory(AnalysisDirectory.getRootDir()), mWInstrument, arrayList);
        for (Object object : bs.a().getAnalysisSources()) {
            AnalysisDirectory.addFromDir(mWInstrument.getAnalysisDirectory((AnalysisSource)object), mWInstrument, arrayList);
        }
        if (bl2) {
            boolean bl3 = false;
            for (AnalysisInfo analysisInfo : arrayList) {
                if (!analysisInfo.isPrimary()) continue;
                bl3 = true;
            }
            if (!bl3) {
                arrayList.add(0, new AnalysisInfo(mWInstrument, "Primary Analysis", System.currentTimeMillis()));
            }
        }
        return arrayList;
    }

    public static AnalysisInfo getInfo(MWInstrument mWInstrument, String string) {
        AnalysisInfo analysisInfo = AnalysisDirectory.getFromDir(mWInstrument.getAnalysisDirectory(AnalysisDirectory.getRootDir()), mWInstrument, string);
        if (analysisInfo != null) {
            return analysisInfo;
        }
        for (AnalysisSource analysisSource : bs.a().getAnalysisSources()) {
            analysisInfo = AnalysisDirectory.getFromDir(mWInstrument.getAnalysisDirectory(analysisSource), mWInstrument, string);
            if (analysisInfo == null) continue;
            return analysisInfo;
        }
        return null;
    }

    private static AnalysisInfo getFromDir(File file, MWInstrument mWInstrument, String string) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return null;
        }
        File file2 = new File(file, string + ".mwml");
        if (!file2.exists()) {
            file2 = new File(file, string + ".MWML");
        }
        if (!file2.exists()) {
            return null;
        }
        return new AnalysisInfo(mWInstrument, string, file2.lastModified());
    }

    private static void addFromDir(File file, MWInstrument mWInstrument, List list) {
        if (file == null || !file.exists() || !file.isDirectory()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            Object object;
            Object object2;
            if (file2.isDirectory() || !((String)(object2 = file2.getName())).toUpperCase().endsWith(".MWML")) continue;
            if (h.g((String)(object2 = ((String)object2).substring(0, ((String)object2).lastIndexOf(46))))) {
                object = h.c(file2);
                if (((String)object).startsWith("[{")) {
                    file2.delete();
                    continue;
                }
                object2 = "unnamed";
                File file3 = new File(file, (String)object2 + ".mwml");
                int n2 = 2;
                while (file3.exists()) {
                    object2 = "unnamed" + n2++;
                    file3 = new File(file, (String)object2 + ".mwml");
                }
                file2.renameTo(file3);
            }
            if (list.contains(object = new AnalysisInfo(mWInstrument, (String)object2, file2.lastModified()))) continue;
            list.add(object);
        }
    }

    private static void readAnalysisFiles(File file, List list) {
        if (file == null || !file.exists()) {
            return;
        }
        for (File file2 : file.listFiles()) {
            if (file2.isDirectory()) {
                AnalysisDirectory.readAnalysisFiles(file2, list);
                continue;
            }
            if (!file2.getName().toUpperCase().endsWith(".MWML")) continue;
            try {
                Analysis analysis = AnalysisDirectory.readAnalysis(file2);
                if (analysis == null) continue;
                list.add(analysis);
            }
            catch (Exception exception) {
                h.a.warning("AnalysisDirectory::readAnalysisFile() error reading analysis file: " + file2.getAbsolutePath() + " error: " + exception.getMessage());
                exception.printStackTrace();
            }
        }
    }

    private static Analysis readAnalysis(File file, MWInstrument mWInstrument) {
        Analysis analysis = AnalysisDirectory.readAnalysis(file);
        if (analysis == null || mWInstrument == null) {
            return analysis;
        }
        if (analysis.getInstrument() != null && analysis.getInstrument() != mWInstrument) {
            h.a.warning("AnalysisDirectory::readAnalysis() instrument does not match instrument in file: " + analysis.getInstrument().getKey() + " " + mWInstrument.getKey() + " file: " + file.getPath());
        }
        analysis.setInstrument(mWInstrument);
        return analysis;
    }

    private static Analysis readAnalysis(File file) {
        if (file == null || !file.exists()) {
            return null;
        }
        try {
            Object object;
            String string = file.getName();
            string = string.substring(0, string.lastIndexOf(46));
            long l2 = file.lastModified();
            String string2 = h.c(file);
            if (h.g(string2)) {
                return null;
            }
            MWInstrument mWInstrument = MWInstrument.byKey(file.getParentFile().getName());
            if (mWInstrument == null) {
                if (w.a(string2)) {
                    object = new JSONObject(string2);
                    if (!((JSONObject)object).has("instr")) {
                        h.a.warning("AnalsisDirectory::readAnalysis() instrument not defined: " + file.getAbsolutePath() + " contents: " + string2);
                        return null;
                    }
                    mWInstrument = new g().a(((JSONObject)object).str("instr"));
                } else {
                    object = com.motivewave.common.util.h.a(string2);
                    if (object == null) {
                        h.a.warning("AnalsisDirectoryt::readAnalysis() unable to read xml file: " + file.getAbsolutePath() + " contents: " + string2);
                        return null;
                    }
                    Node node = object.getDocumentElement();
                    if (!h.b((Object)node.getTagName(), (Object)"analysis")) {
                        node = com.motivewave.common.util.h.b("analysis", node);
                    }
                    if (node == null) {
                        return null;
                    }
                    mWInstrument = MWInstrument.read((Element)com.motivewave.common.util.h.b("instrument", node));
                }
            }
            if (mWInstrument == null) {
                return null;
            }
            object = new Analysis(string, mWInstrument);
            ((Analysis)object).setLastUpdated(l2);
            ((Analysis)object).setData(string2);
            ((Analysis)object).setSrcFile(file);
            return object;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }
}

