/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.h;
import com.motivewave.common.util.w;
import com.motivewave.platform.databean.AnalysisSource;
import com.motivewave.platform.databean.InstrumentListener;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.f;
import com.motivewave.platform.service.bs;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class Analysis
extends ObservableBean {
    public static final String PRIMARY_NAME = "Primary Analysis";
    private MWInstrument instrument;
    private String name = "";
    private String data;
    private Map json;
    private long lastUpdated;
    private File srcFile;
    private long srcLastUpdated = 0L;
    private boolean readOnly = false;
    private boolean writeInProgress = false;
    private InstrumentListener instrListener = new f(this);

    public Analysis(MWInstrument mWInstrument) {
        this.setInstrument(mWInstrument);
    }

    public Analysis(MWInstrument mWInstrument, Map map) {
        this.setInstrument(mWInstrument);
        this.json = map;
    }

    public Analysis(String string, MWInstrument mWInstrument) {
        this(mWInstrument);
        this.name = string;
    }

    @Override
    public void destroy() {
        super.destroy();
        if (this.instrument == null) {
            return;
        }
        this.instrument.removeListener(this.instrListener);
        this.instrument = null;
    }

    @Override
    public String format(String string) {
        return switch (string) {
            case "lastUpdated" -> h.k(this.lastUpdated);
            case "name" -> h.b((Object)this.name);
            case "primary" -> h.b((Object)this.isPrimary());
            case "untitled" -> h.b((Object)this.isUntitled());
            case "readOnly" -> h.b((Object)this.isReadOnly());
            case "instrument" -> {
                if (this.instrument == null) {
                    yield "";
                }
                yield this.instrument.getKey();
            }
            default -> h.b(this.getProperty(string));
        };
    }

    @Override
    public Object getProperty(String string) {
        return switch (string) {
            case "lastUpdated" -> this.lastUpdated;
            case "name" -> this.name;
            case "data" -> this.data;
            case "srcFile" -> this.srcFile;
            case "srcLastUpdated" -> this.srcLastUpdated;
            case "primary" -> this.isPrimary();
            case "untitled" -> this.isUntitled();
            case "readOnly" -> this.isReadOnly();
            case "instrument" -> this.instrument;
            case "writeInProgress" -> this.isWriteInProgress();
            default -> super.getProperty(string);
        };
    }

    public boolean isUntitled() {
        return h.g(this.name);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String string) {
        this.data = string;
        this.json = null;
    }

    public Map getJson() {
        if (this.json == null) {
            try {
                this.json = w.a(this.data);
            }
            catch (Exception exception) {
                h.a.warning("Analysis::getJson() bad format: " + exception.getMessage() + "\n" + this.data);
                exception.printStackTrace();
                this.json = new HashMap();
            }
        }
        return this.json;
    }

    public long getLastUpdated() {
        return this.lastUpdated;
    }

    public void setLastUpdated(long l2) {
        this.lastUpdated = l2;
    }

    public boolean isPrimary() {
        return h.a((Object)this.name, (Object)PRIMARY_NAME);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl2) {
        this.readOnly = bl2;
    }

    public MWInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(MWInstrument mWInstrument) {
        if (mWInstrument == this.instrument) {
            return;
        }
        if (this.instrument != null) {
            this.instrument.removeListener(this.instrListener);
        }
        this.instrument = mWInstrument;
        if (this.instrument != null) {
            this.instrument.addListener(this.instrListener);
        }
    }

    public File checkNewSrcFile() {
        Workspace workspace = bs.a();
        if (!workspace.isOverrideRepository()) {
            return null;
        }
        for (AnalysisSource analysisSource : workspace.getAnalysisSources()) {
            File file = this.getInstrument().getAnalysisFile(analysisSource, this.getName());
            if (file == null || !file.exists() || this.srcFile != null && this.srcFile.equals(file)) continue;
            return file;
        }
        return null;
    }

    public File getSrcFile() {
        return this.srcFile;
    }

    public void setSrcFile(File file) {
        this.srcFile = file;
        this.updateTimestamp();
        if (this.srcFile != null && this.srcFile.exists() && !this.srcFile.canWrite()) {
            this.readOnly = true;
        }
    }

    public void clearSrcFile() {
        this.srcFile = null;
        this.readOnly = false;
        this.srcLastUpdated = 0L;
    }

    public long getSrcLastUpdated() {
        return this.srcLastUpdated;
    }

    public void setSrcLastUpdated(long l2) {
        this.srcLastUpdated = l2;
    }

    public void updateTimestamp() {
        if (this.srcFile == null || !this.srcFile.exists()) {
            return;
        }
        this.srcLastUpdated = this.srcFile.lastModified();
    }

    @Override
    public Analysis clone() {
        return (Analysis)super.clone();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof Analysis)) {
            return false;
        }
        Analysis analysis = (Analysis)object;
        return this.name.equals(analysis.name) && this.instrument == analysis.instrument;
    }

    public boolean isWriteInProgress() {
        return this.writeInProgress;
    }

    void setWriteInProgress(boolean bl2) {
        this.writeInProgress = bl2;
    }
}

