/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import com.motivewave.common.b;
import com.motivewave.common.h;
import com.motivewave.common.util.g;
import com.motivewave.platform.databean.Alert;
import com.motivewave.platform.databean.AlertHistory;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.databean.d;
import com.motivewave.platform.databean.e;
import com.motivewave.platform.ui.draw.graph.u;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import o.a;
import org.json.JSONArray;
import org.json.JSONObject;

public class Alerts {
    private static g history = new g();
    private static g allAlerts = new g();
    private static g listeners = new g();
    private static boolean unsavedHistory = false;

    public static void addListener(a a2) {
        listeners.a((Object)a2);
    }

    public static void removeListener(a a2) {
        listeners.a((Object)a2);
    }

    public static void register(List list) {
        if (h.a((Collection)list)) {
            return;
        }
        Alerts.register(list.toArray(new Alert[0]));
    }

    public static void register(Alert ... alertArray) {
        try {
            if (allAlerts.a(alertArray)) {
                for (Alert alert : alertArray) {
                    alert.listen();
                }
                b.d(() -> Alerts.notifyUpdated());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void remove(List list) {
        if (h.a((Collection)list)) {
            return;
        }
        Alerts.remove(list.toArray(new Alert[0]));
    }

    public static void remove(Alert ... alertArray) {
        if (allAlerts.b(alertArray)) {
            b.d(() -> {
                Class<Alerts> clazz = Alerts.class;
                synchronized (Alerts.class) {
                    Alerts.notifyUpdated();
                    for (Alert alert : alertArray) {
                        alert.destroy();
                    }
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void activated(Alert alert, String string) {
        AlertHistory alertHistory = new AlertHistory(alert.getInstrument(), alert.isReplay(), alert.getInput(), alert.getName(), alert.getComments(), alert.getBarSize(), alert.isSignal(), alert.getSignalName(), alert.getMessage(), alert.getFormattedLastTriggeredValue(), alert.getLastTriggeredValue(), alert.getLastActivated(), alert.getLastLocation(), string, alert.getColor(), alert.getGraph());
        g g2 = history;
        synchronized (g2) {
            history.a(com.motivewave.platform.common.b.c(), com.motivewave.platform.common.b.c() + 50);
            history.a(0, (Object)alertHistory);
            unsavedHistory = true;
        }
        b.d(() -> Alerts.notifyUpdated());
        Alerts.notifyHistoryUpdated();
    }

    public static List byInstrument(MWInstrument mWInstrument) {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        for (Alert alert : allAlerts.a()) {
            if (alert.getInstrument() != mWInstrument) continue;
            arrayList.add(alert);
        }
        return arrayList;
    }

    public static List byComponent(long l2) {
        ArrayList<Alert> arrayList = new ArrayList<Alert>();
        for (Alert alert : allAlerts.a()) {
            if (alert.getComponentId() != l2) continue;
            arrayList.add(alert);
        }
        return arrayList;
    }

    public static List getHistory() {
        return history.a();
    }

    public static List getHistory(MWInstrument mWInstrument) {
        ArrayList<AlertHistory> arrayList = new ArrayList<AlertHistory>();
        for (AlertHistory alertHistory : history.a()) {
            if (alertHistory.getInstrument() != mWInstrument) continue;
            arrayList.add(alertHistory);
        }
        return arrayList;
    }

    public static void clearReplayHistory(u u2) {
        for (AlertHistory alertHistory : history.a()) {
            if (!alertHistory.isReplay() || alertHistory.getGraph() != u2) continue;
            history.a((Object)alertHistory);
        }
        Alerts.notifyHistoryUpdated();
    }

    public static List getAll() {
        return allAlerts.a();
    }

    public static void clearHistory() {
        File file = Workspace.findDir("alert_history");
        h.a(new File(file, "alert_history.json"), "");
        history.b();
        Alerts.notifyHistoryUpdated();
    }

    public static void removeHistory(AlertHistory ... alertHistoryArray) {
        if (!history.b(alertHistoryArray)) {
            return;
        }
        unsavedHistory = true;
        Alerts.notifyHistoryUpdated();
    }

    public static void saveAll() {
        File file = Workspace.findDir("alerts");
        Alerts.saveAlerts(file);
        if (unsavedHistory) {
            Alerts.saveHistory(file);
        }
        unsavedHistory = false;
    }

    private static void saveAlerts(File file) {
        Object object = h.b(new Alert[0]);
        for (Alert alert : allAlerts.a()) {
            if (!alert.isGlobal()) continue;
            object.add(alert);
        }
        h.a(new File(file, "alerts.json"), new d().b((Collection)object));
    }

    private static void saveHistory(File file) {
        List list = new ArrayList(history.a());
        if (list.size() > com.motivewave.platform.common.b.c()) {
            Collections.sort(list, (alertHistory, alertHistory2) -> {
                if (alertHistory == null) {
                    return -1;
                }
                if (alertHistory2 == null) {
                    return 1;
                }
                return Long.compare(alertHistory2.getActivated(), alertHistory.getActivated());
            });
            list = h.a(list, 0, com.motivewave.platform.common.b.c());
        }
        h.a(new File(file, "alert_history.json"), new e().b(list));
    }

    public static void saveAll(File file) {
        Alerts.saveAlerts(file);
        Alerts.saveHistory(file);
    }

    private static void readAlerts(File file) {
        String string = h.c(file);
        allAlerts.b();
        if (h.g(string)) {
            return;
        }
        try {
            for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                Alert alert = Alert.fromJson(jSONObject);
                if (alert.isExpired() || alert.getInstrument() == null) continue;
                for (Alert alert2 : allAlerts.a()) {
                    if (!alert.is(alert2)) continue;
                    h.a.warning("AlertDirectory::read() removing duplicate alert:\n" + String.valueOf(alert2) + "\n" + String.valueOf(alert));
                    allAlerts.a((Object)alert2);
                }
                allAlerts.a((Object)alert);
                alert.listen();
            }
        }
        catch (Exception exception) {
            h.a.warning("AlertDirectory::loadAlerts() error reading alerts: " + exception.getMessage() + " " + string);
            exception.printStackTrace();
        }
    }

    public static void read() {
        File file = Workspace.findFile("alerts");
        if (file != null) {
            Alerts.readAlerts(file);
        }
        if ((file = Workspace.findFile("alert_history")) != null) {
            try {
                history.b();
                String string = h.c(file);
                if (!h.g(string)) {
                    long l2 = 86400000L * (long)com.motivewave.platform.common.b.a().getHistoryDays();
                    for (JSONObject jSONObject : new JSONArray(string).asObjList()) {
                        AlertHistory alertHistory = new AlertHistory(jSONObject);
                        if (alertHistory.getActivated() <= l2) continue;
                        history.a((Object)alertHistory);
                    }
                }
                unsavedHistory = false;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return;
        }
        unsavedHistory = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void notifyUpdated() {
        Class<Alerts> clazz = Alerts.class;
        synchronized (Alerts.class) {
            for (a a2 : listeners.a()) {
                try {
                    a2.a();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    static void notifyHistoryUpdated() {
        b.d(() -> {
            Class<Alerts> clazz = Alerts.class;
            synchronized (Alerts.class) {
                for (a a2 : listeners.a()) {
                    try {
                        a2.b();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
        });
    }
}

