/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import bi.d;
import com.motivewave.common.h;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.Enums$AlertInput;
import com.motivewave.platform.common.Enums$AlertOperator;
import com.motivewave.platform.databean.Alert;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.ui.draw.graph.q;
import com.motivewave.platform.ui.draw.graph.u;
import java.util.Collection;
import java.util.List;
import org.json.JSONObject;

public class AlertCondition
implements w {
    private String input;
    private String targetInput;
    private String targetOption;
    private Enums$AlertOperator operator;
    private double targetValue;
    private boolean useTargetInput = false;
    private Enums$AlertInput inputAI;
    private Enums$AlertInput targetInputAI;
    private boolean aiResolved = false;

    public AlertCondition(JSONObject jSONObject) {
        this.fromJSON(jSONObject);
    }

    public AlertCondition(Enums$AlertOperator enums$AlertOperator) {
        this.operator = enums$AlertOperator;
    }

    public AlertCondition(String string, Enums$AlertOperator enums$AlertOperator, double d2) {
        this.input = string;
        this.targetValue = d2;
        this.operator = enums$AlertOperator;
    }

    public AlertCondition(String string, Enums$AlertOperator enums$AlertOperator, double d2, String string2, String string3, boolean bl2) {
        this(string, enums$AlertOperator, d2);
        this.targetOption = string2;
        this.targetInput = string3;
        this.useTargetInput = bl2;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            AlertCondition alertCondition = (AlertCondition)object;
            if (this.operator != alertCondition.operator) {
                return false;
            }
            if (this.targetValue != alertCondition.targetValue) {
                return false;
            }
            if (this.useTargetInput != alertCondition.useTargetInput) {
                return false;
            }
            if (!h.a((Object)this.input, (Object)alertCondition.input)) {
                return false;
            }
            if (!h.a((Object)this.targetOption, (Object)alertCondition.targetOption)) {
                return false;
            }
            return h.a((Object)this.targetInput, (Object)alertCondition.targetInput);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getInput() {
        return this.input;
    }

    public boolean isInput(String string) {
        if (h.a((Object)string, (Object)this.input)) {
            return true;
        }
        Enums$AlertInput enums$AlertInput = this.getInputAI();
        return enums$AlertInput != null && h.a((Object)enums$AlertInput.getTickerProperty(), (Object)string);
    }

    public Enums$AlertOperator getOperator() {
        return this.operator;
    }

    public double getTargetValue() {
        return this.targetValue;
    }

    public void setTargetValue(double d2) {
        this.targetValue = d2;
    }

    public boolean isUseTargetInput() {
        return this.useTargetInput;
    }

    public String getTargetInput() {
        return this.targetInput;
    }

    public boolean isTargetInput(String string) {
        if (!this.useTargetInput) {
            return false;
        }
        if (h.a((Object)string, (Object)this.targetInput)) {
            return true;
        }
        Enums$AlertInput enums$AlertInput = this.getTargetInputAI();
        return enums$AlertInput != null && h.a((Object)enums$AlertInput.getTickerProperty(), (Object)string);
    }

    public String getTargetOption() {
        return this.targetOption;
    }

    public boolean eval(Alert alert) {
        Enums$AlertOperator enums$AlertOperator = this.getOperator();
        if (alert == null || enums$AlertOperator == null) {
            return false;
        }
        Double d2 = this.computeInputValue(alert);
        if (d2 == null) {
            return false;
        }
        Double d3 = this.computeTargetValue(alert);
        if (d3 == null) {
            return false;
        }
        switch (enums$AlertOperator) {
            case GTE: {
                return d2 >= d3;
            }
            case GT: {
                return d2 > d3;
            }
            case LTE: {
                return d2 <= d3;
            }
            case LT: {
                return d2 < d3;
            }
            case EQUALS: {
                return d2 == d3;
            }
            case NOT_EQUALS: {
                return d2 != d3;
            }
        }
        return false;
    }

    public boolean eval(double d2, List list, double d3, double d4) {
        Enums$AlertOperator enums$AlertOperator = this.getOperator();
        if (enums$AlertOperator == null) {
            return false;
        }
        switch (enums$AlertOperator) {
            case GTE: {
                return d2 >= d3;
            }
            case GT: {
                return d2 > d3;
            }
            case LTE: {
                return d2 <= d3;
            }
            case LT: {
                return d2 < d3;
            }
            case EQUALS: {
                return d2 == d3;
            }
            case NOT_EQUALS: {
                return d2 != d3;
            }
            case CROSSES_ABOVE: {
                if (list.isEmpty()) {
                    return false;
                }
                if (d2 > d3) {
                    for (Double d5 : list) {
                        if (d5 > d3) {
                            return false;
                        }
                        if (!(d5 < d3)) continue;
                        return true;
                    }
                }
                return false;
            }
            case CROSSES_BELOW: {
                if (list.isEmpty()) {
                    return false;
                }
                if (d2 < d3) {
                    for (Double d6 : list) {
                        if (d6 < d3) {
                            return false;
                        }
                        if (!(d6 > d3)) continue;
                        return true;
                    }
                }
                return false;
            }
            case CROSSES: {
                if (list.isEmpty()) {
                    return false;
                }
                if (d2 > d3) {
                    for (Double d7 : list) {
                        if (d7 > d3) {
                            return false;
                        }
                        if (!(d7 < d3)) continue;
                        return true;
                    }
                } else if (d2 < d3) {
                    for (Double d8 : list) {
                        if (d8 < d3) {
                            return false;
                        }
                        if (!(d8 > d3)) continue;
                        return true;
                    }
                }
                return false;
            }
            case TOUCHES: {
                if (list.isEmpty()) {
                    return false;
                }
                if (d2 >= d3 && (Double)list.get(0) < d4) {
                    return true;
                }
                return d2 <= d3 && (Double)list.get(0) > d4;
            }
        }
        return false;
    }

    public int getIndex(u u2, String string) {
        if (u2 == null || h.a((Collection)u2.a().b())) {
            return -1;
        }
        return u2.a(string);
    }

    public Double computeInputValue(Alert alert) {
        Enums$AlertInput enums$AlertInput = this.getInputAI();
        if (enums$AlertInput != null) {
            Ticker ticker = alert.getTicker();
            return ticker == null ? null : Double.valueOf(h.a(ticker.getProperty(enums$AlertInput.getTickerProperty())));
        }
        return this.resolveValue(alert.getGraph(), this.getInput());
    }

    public Double computeTargetValue(Alert alert) {
        if (!h.g(this.targetOption)) {
            d d2 = alert.getComponent();
            Double d3 = d2 == null ? null : d2.a(this.targetOption);
            this.setTargetValue(d3 == null ? 0.0 : d3);
            return d3;
        }
        if (this.isUseTargetInput()) {
            Enums$AlertInput enums$AlertInput = this.getTargetInputAI();
            Ticker ticker = alert.getTicker();
            Double d4 = null;
            if (enums$AlertInput != null && ticker != null) {
                d4 = h.a(ticker.getProperty(enums$AlertInput.getTickerProperty()));
            } else if (alert.getGraph() != null) {
                d4 = this.resolveValue(alert.getGraph(), this.getTargetInput());
            }
            this.setTargetValue(d4 == null ? 0.0 : d4);
            return d4;
        }
        return this.getTargetValue();
    }

    private Double resolveValue(u u2, String string) {
        int n2;
        Object object3;
        if (u2 == null) {
            return null;
        }
        Double d2 = null;
        Object object2 = u2;
        q q2 = u2.a(string);
        if (q2 == null) {
            for (Object object3 : u2.a().d()) {
                if (object3 == u2 || (q2 = ((u)object3).a(string)) == null) continue;
                object2 = object3;
                break;
            }
            if (q2 == null) {
                return d2;
            }
        }
        if ((object3 = q2.a((u)object2, n2 = this.getIndex((u)object2, string))) == null) {
            object3 = q2.a((u)object2, n2 - 1);
        }
        if (object3 instanceof Number) {
            d2 = h.a(object3);
        }
        return d2;
    }

    @Override
    public List getNVPs() {
        Object object = h.b(new String[]{this.a("input", this.input), this.a("op", (Object)this.operator), this.a("ti", this.targetInput), this.a("uti", this.useTargetInput, false), this.a("to", this.targetOption)});
        if (h.g(this.targetOption) && !this.isUseTargetInput()) {
            object.add(this.a("tv", this.targetValue));
        }
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        this.input = jSONObject.str("input");
        try {
            this.operator = Enums$AlertOperator.valueOf(jSONObject.str("op"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.targetInput = jSONObject.str("ti");
        this.targetValue = jSONObject.getDouble("tv");
        this.useTargetInput = jSONObject.is("uti", false);
        this.targetOption = jSONObject.str("to");
        this.aiResolved = false;
    }

    public Enums$AlertInput getInputAI() {
        if (this.aiResolved) {
            return this.inputAI;
        }
        this.resolveAI();
        return this.inputAI;
    }

    public Enums$AlertInput getTargetInputAI() {
        if (this.aiResolved) {
            return this.targetInputAI;
        }
        this.resolveAI();
        return this.targetInputAI;
    }

    private synchronized void resolveAI() {
        try {
            this.inputAI = Enums$AlertInput.valueOf(this.input);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.targetInputAI = Enums$AlertInput.valueOf(this.targetInput);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.aiResolved = true;
    }
}

