/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import az.f;
import bi.d;
import cf.dh;
import cf.dk;
import cf.gf;
import com.motivewave.common.MWException;
import com.motivewave.common.h;
import com.motivewave.common.ui.UIUtil;
import com.motivewave.common.util.aa;
import com.motivewave.common.util.g;
import com.motivewave.platform.common.Enums$AlertInput;
import com.motivewave.platform.common.Enums$AlertOperator;
import com.motivewave.platform.common.Enums$Align;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.af;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.aj;
import com.motivewave.platform.common.themes.Colors;
import com.motivewave.platform.databean.Account;
import com.motivewave.platform.databean.AlertBase;
import com.motivewave.platform.databean.AlertCondition;
import com.motivewave.platform.databean.AlertHistory;
import com.motivewave.platform.databean.Alerts;
import com.motivewave.platform.databean.LiveTicker;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.MWOrder;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Positions;
import com.motivewave.platform.databean.Ticker;
import com.motivewave.platform.sdk.common.BarSize;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.ui.console.Console;
import com.motivewave.platform.ui.draw.graph.bn;
import com.motivewave.platform.ui.draw.graph.l;
import com.motivewave.platform.ui.draw.graph.q;
import com.motivewave.platform.ui.draw.graph.u;
import com.motivewave.platform.ui.table.c;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import k.b;
import org.json.JSONObject;
import p.a;

public class Alert
extends AlertBase
implements PropertyChangeListener {
    public static final com.motivewave.platform.ui.table.b converter = tableColumnInfo -> switch (tableColumnInfo.getProperty()) {
        case "chart" -> new c("chart", ab.a("LBL_CHART", new Object[0]), 75.0, m2 -> Colors.getBuyBtnBlue(), m2 -> Colors.white, m2 -> ((AlertBase)m2.a()).getGraph() == null ? null : ab.a("LBL_CHART", new Object[0]), m2 -> {
            l l2;
            u u2 = ((AlertBase)m2.a()).getGraph();
            l l3 = l2 = u2 == null || u2.isDestroyed() ? null : u2.a();
            if (l2 == null) {
                return null;
            }
            dh dh2 = l2.a().a().a();
            if (dh2 == null) {
                return null;
            }
            dh2.a(l2);
            if (dh2.isIconified()) {
                dh2.setIconified(false);
            }
            dh2.toFront();
            return null;
        });
        case "cancel" -> new c("cancel", ab.a("LBL_CANCEL", new Object[0]), 30.0, m2 -> Colors.getCancelBtn(), m2 -> Colors.black, m2 -> "C", m2 -> {
            Alerts.remove((Alert)m2.a());
            return null;
        });
        case "remove" -> new c("remove", ab.a("LBL_REMOVE", new Object[0]), 30.0, m2 -> Colors.getCancelBtn(), m2 -> Colors.black, m2 -> "X", m2 -> {
            Alerts.removeHistory((AlertHistory)m2.a());
            return null;
        });
        default -> null;
    };
    private long expires = -1L;
    private int session1Start = 32400000;
    private int session1End = 57600000;
    private boolean session1Enabled = false;
    private boolean session2Enabled = false;
    private int session2Start = 32400000;
    private int session2End = 57600000;
    private TimeZone timeZone;
    private boolean signal = false;
    private boolean replay = false;
    private boolean closePosition = false;
    private boolean useDefaultTimeZone = true;
    private boolean showAlert = com.motivewave.platform.common.b.a().isShowAlert();
    private boolean playSound = com.motivewave.platform.common.b.a().isPlaySound();
    private boolean usePresetSound = com.motivewave.platform.common.b.a().isPresetSound();
    private boolean sendEmail = com.motivewave.platform.common.b.a().isSendEmail();
    private boolean attachImage = com.motivewave.platform.common.b.a().isAttachImage();
    private String id;
    private String name;
    private String signalName;
    private String comments;
    private String label;
    private String message;
    private String emailAddress = com.motivewave.platform.common.b.g();
    private File soundFile = com.motivewave.platform.common.b.a().getSoundFile();
    private BarSize barSize;
    private long lastActivated;
    private long lastLocation;
    private Ticker ticker;
    private MWOrder order;
    private String closeAcctId;
    private MWInstrument closeInstr;
    private boolean orderSubmitted = false;
    private boolean triggerMultiple = false;
    private boolean multiplePerBar = true;
    private boolean enabled = true;
    private static long lastDupWarning = 0L;
    private List conditions = new ArrayList();
    private HashSet inputProps = null;
    private d component;
    private long componentId = 0L;
    private Boolean showBtn;
    private Boolean showLine;
    private Boolean showLabel;
    private Enums$Align align;
    private Color color = null;
    private g prevValues = new g();
    private double lastValue;
    private double lastTriggeredValue;
    private String formattedLastValue;
    private String formattedLastTriggeredValue = "";
    private Set triggerHistory = new HashSet(1);
    private Double prevTarget;
    private Map targetValues = new HashMap(1);

    public static Alert fromJson(JSONObject jSONObject) {
        return Alert.fromJson(jSONObject.toMap(), Collections.emptyList());
    }

    public static Alert fromJson(Map map, List list) {
        Alert alert = new Alert();
        alert.fromJSON(new JSONObject(map));
        if (alert.graphId != 0L && !h.a((Collection)list)) {
            for (u u2 : list) {
                if (u2.a().a() != alert.graphId) continue;
                alert.setGraph(u2);
                if (alert.getInstrument() != null) break;
                alert.setInstrument(u2.a().a());
                break;
            }
        }
        return alert;
    }

    public Alert() {
        this.id = h.a();
    }

    public Alert(d d2) {
        this(d2.a(), d2.a().a().a());
        this.component = d2;
        this.componentId = d2.a();
    }

    public Alert(u u2, Ticker ticker) {
        this();
        this.setGraph(u2);
        this.ticker = ticker;
        this.replay = ticker.isReplay();
        this.triggerMultiple = com.motivewave.platform.common.b.a().is("triggerMultiple");
    }

    public boolean is(Alert alert) {
        if (alert == null) {
            return false;
        }
        if (alert == this) {
            return true;
        }
        if (this.expires != alert.expires) {
            return false;
        }
        if (this.replay != alert.replay) {
            return false;
        }
        if (this.ticker != alert.ticker) {
            return false;
        }
        if (this.signal != alert.signal) {
            return false;
        }
        if (!h.a((Object)this.componentId, (Object)alert.componentId)) {
            return false;
        }
        if (!h.a((Object)this.barSize, (Object)alert.barSize)) {
            return false;
        }
        if (!h.c(this.conditions, alert.conditions)) {
            return false;
        }
        return h.a((Object)this.signalName, (Object)alert.signalName);
    }

    @Override
    public void destroy() {
        if (this.destroyed) {
            return;
        }
        super.destroy();
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        this.removeGraphListeners();
    }

    public int hashCode() {
        return h.g(this.id) ? super.hashCode() : this.id.hashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            return h.a((Object)this.id, (Object)((Alert)object).id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void reset() {
        this.prevValues.b();
        this.lastValue = 0.0;
        this.formattedLastValue = null;
        this.formattedLastTriggeredValue = null;
        this.lastTriggeredValue = 0.0;
        this.triggerHistory.clear();
        this.prevTarget = null;
        this.targetValues.clear();
    }

    private HashSet getInputProps() {
        if (this.inputProps != null) {
            return this.inputProps;
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (AlertCondition alertCondition : this.conditions) {
            if (alertCondition.getInputAI() != null) {
                hashSet.add(alertCondition.getInputAI().getTickerProperty());
            } else {
                hashSet.add(alertCondition.getInput());
            }
            if (!alertCondition.isUseTargetInput()) continue;
            if (alertCondition.getTargetInputAI() != null) {
                hashSet.add(alertCondition.getTargetInputAI().getTickerProperty());
                continue;
            }
            hashSet.add(alertCondition.getTargetInput());
        }
        this.inputProps = hashSet;
        return this.inputProps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        Object object;
        Ticker ticker = this.getTicker();
        if (this.destroyed || !this.enabled || !this.isValidTime() || this.conditions.isEmpty() || ticker == null) {
            return;
        }
        AlertCondition alertCondition = (AlertCondition)this.conditions.get(0);
        d d2 = this.getComponent();
        if (this.isExpired() || d2 != null && !d2.a(alertCondition.getTargetOption())) {
            Alerts.remove(this);
            return;
        }
        String string = propertyChangeEvent.getPropertyName();
        if (!this.getInputProps().contains(string)) {
            return;
        }
        MWInstrument mWInstrument = ticker.getInstrument();
        Double d3 = null;
        d3 = alertCondition.isInput(string) ? Double.valueOf(h.a(propertyChangeEvent.getNewValue())) : alertCondition.computeInputValue(this);
        if (d3 == null || alertCondition.getInputAI() != null && alertCondition.getInputAI() != Enums$AlertInput.DAY_VOLUME && !mWInstrument.isValueValid(d3)) {
            return;
        }
        Double d4 = null;
        d4 = alertCondition.isTargetInput(string) ? Double.valueOf(h.a(propertyChangeEvent.getNewValue())) : alertCondition.computeTargetValue(this);
        if (d4 == null || alertCondition.getTargetInputAI() != null && alertCondition.getTargetInputAI() != Enums$AlertInput.DAY_VOLUME && !mWInstrument.isValueValid(d4)) {
            return;
        }
        if (this.isGlobal() || this.isReplay() && !this.isComponent() && !this.isStudy()) {
            if (!this.hasPrevValues() && propertyChangeEvent.getOldValue() != null && alertCondition.isInput(string)) {
                double d5 = h.a(propertyChangeEvent.getOldValue());
                if ((d5 = mWInstrument.round(d5)) != 0.0 && d5 != -1.0) {
                    this.addPrevValue(d5);
                }
            }
            boolean bl2 = alertCondition.eval(d3, this.getPrevValues(), d4, d4);
            this.addPrevValue(d3);
            if (d3 != this.lastValue) {
                this.formattedLastValue = this.format(d3, alertCondition.getInputAI(), alertCondition.getInput(), ticker, this.getGraph());
                this.setLastValue(d3);
            }
            if (!bl2) {
                return;
            }
            this.clearPrevValues();
            for (AlertCondition alertCondition2 : this.conditions) {
                if (alertCondition2 == alertCondition || alertCondition2.eval(this)) continue;
                return;
            }
            this.fireAlert();
            return;
        }
        u u2 = this.getGraph();
        if (u2 == null || h.a((Collection)u2.a().b())) {
            return;
        }
        bn bn2 = u2.a();
        if (bn2 == null) {
            return;
        }
        d3 = bn2.b(d3);
        d4 = bn2.b(d4);
        this.targetValues.put(u2.b(), d4);
        if (this.prevTarget == null || d4.doubleValue() != this.prevTarget.doubleValue()) {
            this.updateName();
        }
        this.prevTarget = d4;
        int n2 = -1;
        if (u2.a(alertCondition.getTargetInput()) && u2.a(alertCondition.getInput()) && (n2 = u2.a(alertCondition.getTargetInput())) < u2.a() && (object = u2.a(alertCondition.getInput(), n2)) != null) {
            d3 = h.a(object);
        }
        if (d3 != this.lastValue) {
            this.formattedLastValue = this.format(d3, alertCondition.getInputAI(), alertCondition.getInput(), ticker, u2);
            this.setLastValue(d3);
        }
        try {
            if (!this.hasPrevValues()) {
                object = null;
                object = n2 > 0 ? u2.a(alertCondition.getInput(), n2 - 1) : u2.b(alertCondition.getInput());
                if (object == null) {
                    return;
                }
                this.addPrevValue(h.a(object));
            }
            if (this.triggerHistory.contains(u2.b()) && !this.multiplePerBar) {
                this.prevValues.b();
                return;
            }
            double d6 = d4;
            Double d7 = (Double)this.targetValues.get(u2.c());
            if (d7 != null && h.a((double)d7)) {
                d6 = d7;
            }
            d6 = bn2.b(d6);
            if (!alertCondition.eval(d3, this.getPrevValues(), d4, d6)) {
                return;
            }
            this.clearPrevValues();
            for (AlertCondition alertCondition3 : this.conditions) {
                if (alertCondition3 == this.conditions.get(0)) continue;
                if (alertCondition3.eval(this)) continue;
                return;
            }
            if (!this.multiplePerBar) {
                this.triggerHistory.add(u2.b());
            }
            this.setBarSize(u2.a().a());
            int n3 = alertCondition.getIndex(this.getGraph(), alertCondition.getInput());
            if (n3 < u2.a() && n3 > 0) {
                this.setLastLocation(((b)u2.a().b().get(n3)).getStartTime());
            }
            this.fireAlert();
        }
        finally {
            this.addPrevValue(d3);
        }
    }

    private void fireAlert() {
        if (!this.isTriggerMultiple()) {
            this.enabled = false;
        }
        this.lastTriggeredValue = this.lastValue;
        this.formattedLastTriggeredValue = this.formattedLastValue;
        long l2 = this.getCurrentTime();
        com.motivewave.common.b.a(() -> {
            this.doNotification(l2);
            if (!this.isTriggerMultiple()) {
                Alerts.remove(this);
            }
        });
    }

    public void updateLastValue() {
        if (this.destroyed || h.a((Collection)this.conditions)) {
            return;
        }
        AlertCondition alertCondition = (AlertCondition)this.conditions.get(0);
        Double d2 = alertCondition.computeInputValue(this);
        if (d2 == null || d2 == this.lastValue) {
            return;
        }
        this.formattedLastValue = this.format(d2, alertCondition.getInputAI(), alertCondition.getInput(), this.getTicker(), this.getGraph());
        this.setLastValue(d2);
    }

    private String format(Double d2, Enums$AlertInput enums$AlertInput, String string, Ticker ticker, u u2) {
        if (d2 == null) {
            return "";
        }
        if (ticker != null && enums$AlertInput != null) {
            if (enums$AlertInput == Enums$AlertInput.DAY_VOLUME) {
                return ab.b((float)d2.longValue(), ticker.getInstrument());
            }
            return ticker.format(d2);
        }
        if (u2 == null) {
            return "" + d2;
        }
        bn bn2 = null;
        q q2 = u2.a(string);
        if (q2 != null) {
            bn2 = u2.a(q2);
        } else {
            for (u u3 : u2.a().d()) {
                if (u3 == u2 || (q2 = u3.a(string)) == null) continue;
                bn2 = u3.a(q2);
                break;
            }
        }
        if (bn2 == null) {
            return "" + d2;
        }
        return bn2.a((double)d2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doNotification(long l2) {
        String string = this.formattedLastTriggeredValue;
        u u2 = this.getGraph();
        Object object = Alert.class;
        synchronized (Alert.class) {
            Object object2;
            Object object3;
            long l3;
            Object object4 = Alerts.getHistory().iterator();
            while (object4.hasNext() && (l3 = l2 - ((AlertHistory)(object3 = (AlertHistory)object4.next())).getActivated()) <= 5000L) {
                if (!this.isEquivalent((AlertHistory)object3) || this.isReplay()) continue;
                if (System.currentTimeMillis() - lastDupWarning > 30000L) {
                    h.a.warning("Alert::doNotification() ignoring duplicate alert: " + this.toString() + " value: " + this.getLastTriggeredValue() + " : " + ((AlertHistory)object3).getLastValue());
                    lastDupWarning = System.currentTimeMillis();
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
                return;
            }
            this.setLastActivated(l2);
            object4 = this.getOrderName();
            if (this.orderSubmitted) {
                object4 = "";
            }
            Alerts.activated(this, (String)object4);
            // ** MonitorExit[var5_4] (shouldn't be in output)
            object = u2 == null ? Console.a() : u2.a().a();
            object4 = null;
            if (ai.f() && !this.orderSubmitted) {
                object3 = this.order;
                MWInstrument mWInstrument = this.closeInstr;
                if (mWInstrument == null) {
                    mWInstrument = this.getInstrument();
                }
                if (this.closePosition && !h.g(this.closeAcctId) && mWInstrument != null) {
                    object2 = bs.a(this.closeAcctId);
                    if (object2 == null) {
                        h.a.warning("Alert::doNotification() closePosition: account not found: " + this.closeAcctId);
                    } else {
                        float f2 = Positions.getPosition(mWInstrument = mWInstrument.getAcctInstrument((Account)object2), (Account)object2);
                        if (f2 != 0.0f) {
                            this.orderSubmitted = true;
                            try {
                                bs.a((Account)object2, mWInstrument, true, false, null);
                            }
                            catch (MWException mWException) {
                                object4 = mWException.getMessage();
                            }
                        } else {
                            h.a.warning("Alert::doNotification() closePosition: no position found for: " + mWInstrument.getKey() + " acct: " + this.closeAcctId);
                        }
                    }
                } else if (object3 != null && ((MWOrder)object3).isNew() && !this.closePosition) {
                    this.orderSubmitted = true;
                    try {
                        object2 = ((MWOrder)object3).getLimitOrder();
                        MWOrder mWOrder = ((MWOrder)object3).getStopTrailOrder();
                        OrderDirectory.createOrder((MWOrder)object3);
                        if (object2 != null || mWOrder != null) {
                            h.a.warning("Alert::doNotification() submitting order with attached stop/limit: " + String.valueOf(object3) + " acct: " + this.closeAcctId);
                            bs.a((MWOrder)object3, null, null, mWOrder, (MWOrder)object2, false, null, null, (gf)object);
                        } else {
                            h.a.warning("Alert::doNotification() submitting order: " + String.valueOf(object3) + " acct: " + this.closeAcctId);
                            bs.b((MWOrder)object3, (gf)object);
                        }
                    }
                    catch (MWException mWException) {
                        object4 = mWException.getMessage();
                        h.a.warning("Alert::doNotification() error placing order: " + (String)object4);
                        mWException.printStackTrace();
                    }
                }
            }
            if (this.isShowAlert() && !com.motivewave.platform.common.b.a().isDisableWindow()) {
                f.d();
            }
            if (!h.g((String)object4)) {
                Object object5 = object3 = this.isShowAlert() ? f.a() : object.b();
                if (object3 == null) {
                    object3 = (dk)UIUtil.a();
                }
                if (object3 == null) {
                    object3 = Console.a();
                }
                if (object3 != null) {
                    ((dk)object3).d("TITLE_ERROR_PLACE_ALERT_ORDER", (String)object4);
                }
            }
            if (this.isPlaySound()) {
                if (this.isUsePresetSound()) {
                    aj.a().a();
                } else {
                    aj.a().j(this.getSoundFile());
                }
            }
            if (this.isSendEmail()) {
                String string2;
                object3 = af.a("EMAIL_ALERT_SUBJECT", new Object[0]);
                if (!h.g(this.getLabel())) {
                    object3 = (String)object3 + " " + this.getLabel();
                }
                object3 = (String)object3 + " " + this.getSymbolDisplay() + " " + h.b((Object)this.getName()) + " " + h.b((Object)this.getSignalName());
                if (!h.g(string)) {
                    object3 = (String)object3 + " (" + af.a("LBL_VALUE", new Object[0]) + ": " + string + ")";
                }
                String string3 = af.a("LBL_ALL", new Object[0]);
                if (this.barSize != null) {
                    string3 = this.barSize.toString();
                }
                object2 = h.l(l2);
                Object object6 = "";
                if (!h.g(this.getSignalName())) {
                    object6 = af.a("EMAIL_SIGNAL_BODY", new Object[0]) + "\r\n";
                    if (!h.g(this.getLabel())) {
                        object6 = (String)object6 + af.a("LBL_LABEL", this.getLabel()) + "\r\n";
                    }
                    object6 = (String)object6 + af.a("LBL_TIME", new Object[0]) + ": " + (String)object2 + "\r\n";
                    object6 = (String)object6 + af.a("LBL_SYMBOL", new Object[0]) + ": " + this.getSymbolDisplay();
                    string2 = "";
                    if (this.getInstrument() != null) {
                        string2 = this.getInstrument().getDescription();
                        if (h.g(string2)) {
                            string2 = this.getInstrument().getTitle();
                        }
                        if (h.a((Object)string2, (Object)this.getSymbolDisplay())) {
                            string2 = "";
                        }
                    }
                    if (!h.g(string2)) {
                        object6 = (String)object6 + " - " + string2;
                    }
                    object6 = (String)object6 + "\r\n";
                    object6 = (String)object6 + af.a("LBL_BAR_SIZE", new Object[0]) + ": " + string3 + "\r\n";
                    object6 = (String)object6 + af.a("LBL_NAME", new Object[0]) + ": " + this.getName() + "\r\n";
                    object6 = (String)object6 + af.a("LBL_SIGNAL", new Object[0]) + ": " + this.getSignalName() + "\r\n";
                    object6 = (String)object6 + af.a("LBL_MESSAGE", new Object[0]) + ": " + this.getMessage() + "\r\n";
                    if (!h.g(string)) {
                        object6 = (String)object6 + af.a("LBL_VALUE", new Object[0]) + ": " + string + "\r\n";
                    }
                } else {
                    object6 = af.a("EMAIL_ALERT_BODY", new Object[0]) + "\r\n";
                    if (!h.g(this.getLabel())) {
                        object6 = (String)object6 + af.a("LBL_LABEL", new Object[0]) + ": " + this.getLabel() + "\r\n";
                    }
                    object6 = (String)object6 + af.a("LBL_TIME", new Object[0]) + ": " + (String)object2 + "\r\n";
                    object6 = (String)object6 + af.a("LBL_SYMBOL", new Object[0]) + ": " + this.getSymbolDisplay();
                    string2 = "";
                    if (this.getInstrument() != null) {
                        string2 = this.getInstrument().getDescription();
                        if (h.g(string2)) {
                            string2 = this.getInstrument().getTitle();
                        }
                        if (h.a((Object)string2, (Object)this.getSymbolDisplay())) {
                            string2 = "";
                        }
                    }
                    if (!h.g(string2)) {
                        object6 = (String)object6 + " - " + string2;
                    }
                    object6 = (String)object6 + "\r\n";
                    object6 = (String)object6 + af.a("LBL_BAR_SIZE", new Object[0]) + ": " + string3 + "\r\n";
                    object6 = (String)object6 + af.a("LBL_CONDITION", new Object[0]) + ": " + this.getName() + "\r\n";
                    if (!h.g(string)) {
                        object6 = (String)object6 + af.a("LBL_VALUE", new Object[0]) + ": " + string + "\r\n";
                    }
                }
                if (!h.g(this.getComments())) {
                    object6 = (String)object6 + "\r\n" + af.a("EMAIL_ALERT_COMMENTS", this.getComments());
                }
                if (h.g(string2 = this.getEmailAddress())) {
                    string2 = com.motivewave.platform.common.b.g();
                }
                if (h.g(string2)) {
                    h.a.warning("Alert::doNotification() toEmail is empty");
                } else {
                    try {
                        if (u2 != null && u2.a() != null && this.isAttachImage()) {
                            String string4 = string2;
                            Object object7 = object3;
                            Object object8 = object6;
                            UIUtil.b(() -> Alert.lambda$doNotification$0(u2, string4, (String)object7, (String)object8));
                        } else {
                            a.a(string2, (String)object3, (String)object6);
                        }
                    }
                    catch (Exception exception) {
                        dk dk2 = object.b();
                        if (dk2 != null) {
                            dk2.d("TITLE_ERROR_SEND_EMAIL", exception.getMessage());
                        }
                        exception.printStackTrace();
                    }
                }
            }
            return;
        }
    }

    public boolean isExpired() {
        return this.expires <= 0L ? false : this.expires < this.getCurrentTime();
    }

    public boolean isValidTime() {
        long l2;
        if (!this.session1Enabled) {
            return true;
        }
        long l3 = this.getCurrentTime();
        if (l3 >= (l2 = h.a(l3, this.getTimeZone())) + (long)this.session1Start && l3 <= l2 + (long)this.session1End) {
            return true;
        }
        if (!this.session2Enabled) {
            return false;
        }
        return l3 >= l2 + (long)this.session2Start && l3 <= l2 + (long)this.session2End;
    }

    public long getCurrentTime() {
        u u2 = this.getGraph();
        if (u2 != null) {
            return u2.a().b();
        }
        return bs.a();
    }

    public void addCondition(String string, Enums$AlertOperator enums$AlertOperator, double d2) {
        this.conditions.add(new AlertCondition(string, enums$AlertOperator, d2));
        this.inputProps = null;
    }

    public List getConditions() {
        return this.conditions;
    }

    public void setConditions(List list) {
        if (h.c(list, this.conditions)) {
            return;
        }
        this.removeGraphListeners();
        this.conditions = list;
        this.inputProps = null;
        this.reset();
        this.notify("conditions", null, list);
        this.addGraphListeners();
    }

    public long getExpires() {
        return this.expires;
    }

    public void setExpires(long l2) {
        this.expires = l2;
        this.notify("expires", this.expires, this.expires);
    }

    public int getSession1Start() {
        return this.session1Start;
    }

    public void setSession1Start(int n2) {
        this.session1Start = n2;
        this.notify("session1Start", this.session1Start, this.session1Start);
    }

    public int getSession1End() {
        return this.session1End;
    }

    public void setSession1End(int n2) {
        this.session1End = n2;
        this.notify("session1End", this.session1End, this.session1End);
    }

    public boolean isSession1Enabled() {
        return this.session1Enabled;
    }

    public void setSession1Enabled(boolean bl2) {
        this.session1Enabled = bl2;
        this.notify("session1Enabled", this.session1Enabled, this.session1Enabled);
    }

    public int getSession2Start() {
        return this.session2Start;
    }

    public void setSession2Start(int n2) {
        this.session2Start = n2;
        this.notify("session2Start", this.session2Start, this.session2Start);
    }

    public int getSession2End() {
        return this.session2End;
    }

    public void setSession2End(int n2) {
        this.session2End = n2;
        this.notify("session2End", this.session2End, this.session2End);
    }

    public boolean isSession2Enabled() {
        return this.session2Enabled;
    }

    public void setSession2Enabled(boolean bl2) {
        this.session2Enabled = bl2;
        this.notify("session2Enabled", this.session2Enabled, this.session2Enabled);
    }

    public TimeZone getTimeZone() {
        if (this.useDefaultTimeZone || this.timeZone == null) {
            u u2 = this.getGraph();
            if (u2 != null && !u2.isDestroyed()) {
                return u2.a().a();
            }
            return com.motivewave.platform.common.b.b();
        }
        return this.timeZone;
    }

    public void setTimeZone(TimeZone timeZone) {
        this.timeZone = timeZone;
        this.notify("timeZone", this.timeZone, this.timeZone);
    }

    public boolean isUseDefaultTimeZone() {
        return this.useDefaultTimeZone;
    }

    public void setUseDefaultTimeZone(boolean bl2) {
        this.useDefaultTimeZone = bl2;
        this.notify("useDefaultTimeZone", this.useDefaultTimeZone, this.useDefaultTimeZone);
    }

    public boolean isOrderSubmitted() {
        return this.orderSubmitted;
    }

    public boolean isTriggerMultiple() {
        return this.triggerMultiple;
    }

    public void setTriggerMultiple(boolean bl2) {
        this.triggerMultiple = bl2;
    }

    public boolean isMultiplePerBar() {
        return this.multiplePerBar;
    }

    public void setMultiplePerBar(boolean bl2) {
        this.multiplePerBar = bl2;
    }

    public boolean isShowAlert() {
        return this.showAlert;
    }

    public void setShowAlert(boolean bl2) {
        this.showAlert = bl2;
    }

    public boolean isPlaySound() {
        return this.playSound;
    }

    public void setPlaySound(boolean bl2) {
        this.playSound = bl2;
    }

    public boolean isUsePresetSound() {
        return this.usePresetSound;
    }

    public void setUsePresetSound(boolean bl2) {
        this.usePresetSound = bl2;
    }

    public File getSoundFile() {
        return this.soundFile;
    }

    public void setSoundFile(File file) {
        this.soundFile = file;
    }

    public boolean isSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(boolean bl2) {
        this.sendEmail = bl2;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String string) {
        this.emailAddress = string;
    }

    public boolean isAttachImage() {
        return this.attachImage;
    }

    public void setAttachImage(boolean bl2) {
        this.attachImage = bl2;
    }

    public long getLastActivated() {
        return this.lastActivated;
    }

    public void setLastActivated(long l2) {
        this.lastActivated = l2;
        this.notify("lastActivated", 0L, this.lastActivated);
    }

    public long getLastLocation() {
        return this.lastLocation == 0L ? this.lastActivated : this.lastLocation;
    }

    public void setLastLocation(long l2) {
        this.lastLocation = l2;
        this.notify("lastLocation", 0L, this.lastLocation);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
        this.notify("name", this.name, this.name);
    }

    public void updateName() {
        String string = this.name;
        StringBuffer stringBuffer = new StringBuffer();
        l l2 = this.getGraph() == null ? null : this.getGraph().a();
        for (AlertCondition alertCondition : this.conditions) {
            Object object;
            if (alertCondition != this.conditions.get(0)) {
                stringBuffer.append(" AND ");
            }
            if (alertCondition.getInputAI() != null) {
                stringBuffer.append((Object)alertCondition.getInputAI());
            } else if (l2 != null) {
                object = l2.a(alertCondition.getInput());
                if (object != null) {
                    stringBuffer.append(object);
                } else {
                    stringBuffer.append(alertCondition.getInput());
                }
            }
            switch (alertCondition.getOperator()) {
                case CROSSES_ABOVE: {
                    stringBuffer.append(" > ");
                    break;
                }
                case CROSSES_BELOW: {
                    stringBuffer.append(" < ");
                    break;
                }
                default: {
                    stringBuffer.append(" ").append((Object)alertCondition.getOperator()).append(" ");
                }
            }
            if (alertCondition.isUseTargetInput()) {
                if (alertCondition.getTargetInputAI() != null) {
                    stringBuffer.append((Object)alertCondition.getTargetInputAI());
                    continue;
                }
                if (l2 == null) continue;
                object = l2.a(alertCondition.getTargetInput());
                if (object != null) {
                    stringBuffer.append(object);
                    continue;
                }
                stringBuffer.append(alertCondition.getTargetInput());
                continue;
            }
            object = alertCondition.computeTargetValue(this);
            stringBuffer.append(this.format((Double)object, alertCondition.getInputAI(), alertCondition.getInput(), this.getTicker(), this.getGraph()));
        }
        String string2 = stringBuffer.toString();
        if (!h.a((Object)string, (Object)string2)) {
            this.setName(string2);
        }
    }

    public String getSignalName() {
        return this.signalName;
    }

    public void setSignalName(String string) {
        this.signalName = string;
        this.notify("signalName", this.signalName, this.signalName);
    }

    public String getComments() {
        return this.comments;
    }

    public void setComments(String string) {
        this.comments = string;
        this.notify("comments", this.comments, this.comments);
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String string) {
        this.label = string;
        this.notify("label", this.label, this.label);
    }

    public boolean isSignal() {
        return this.signal;
    }

    public void setSignal(boolean bl2) {
        this.signal = bl2;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        this.message = string;
        this.notify("message", this.message, this.message);
    }

    public void setBarSize(BarSize barSize) {
        this.barSize = barSize;
    }

    public BarSize getBarSize() {
        return this.barSize;
    }

    public String getSymbol() {
        return this.getInstrument() == null ? "" : this.getInstrument().getSymbol();
    }

    public String getSymbolDisplay() {
        return this.getInstrument() == null ? "" : this.getInstrument().getSymbolDisplay();
    }

    public String getInput() {
        return this.conditions.isEmpty() ? "" : ((AlertCondition)this.conditions.get(0)).getInput();
    }

    public String getTargetInput() {
        return this.conditions.isEmpty() ? "" : ((AlertCondition)this.conditions.get(0)).getTargetInput();
    }

    public String getTargetOption() {
        return this.conditions.isEmpty() ? "" : ((AlertCondition)this.conditions.get(0)).getTargetOption();
    }

    public Double computeTargetValue() {
        return this.conditions.isEmpty() ? null : ((AlertCondition)this.conditions.get(0)).computeTargetValue(this);
    }

    public d getComponent() {
        if (this.component != null) {
            return this.component;
        }
        if (this.componentId == 0L) {
            return null;
        }
        u u2 = this.getGraph();
        return u2 == null ? null : (this.component = (d)u2.a(this.componentId));
    }

    public long getComponentId() {
        return this.componentId;
    }

    public Ticker getTicker() {
        return this.ticker;
    }

    public double getLastValue() {
        return this.lastValue;
    }

    public void setLastValue(double d2) {
        this.lastValue = d2;
        this.notify("lastValue", this.lastValue, this.lastValue);
    }

    public void setFormattedLastTriggeredValue(String string) {
        this.formattedLastTriggeredValue = string;
    }

    public String getFormattedLastTriggeredValue() {
        return this.formattedLastTriggeredValue;
    }

    public void setLastTriggeredValue(double d2) {
        this.lastTriggeredValue = d2;
    }

    public double getLastTriggeredValue() {
        return this.lastTriggeredValue;
    }

    boolean isEquivalent(AlertHistory alertHistory) {
        long l2 = Math.abs(this.lastActivated - alertHistory.getActivated());
        if (l2 > 5000L) {
            return false;
        }
        if (this.barSize != null && this.barSize.isLinear() ? l2 > 2000L : l2 > 1000L) {
            return false;
        }
        if (this.isSignal()) {
            return h.a((Object)this.getInstrument(), (Object)alertHistory.getInstrument()) && h.a((Object)this.signalName, (Object)alertHistory.getSignalName()) && h.a((Object)this.barSize, (Object)alertHistory.getBarSize()) && h.a((Object)this.name, (Object)alertHistory.getName()) && h.a((Object)this.message, (Object)alertHistory.getMessage()) && this.lastTriggeredValue == alertHistory.getLastValue();
        }
        return h.a((Object)this.getInstrument(), (Object)alertHistory.getInstrument()) && h.a((Object)this.name, (Object)alertHistory.getName()) && h.a((Object)this.barSize, (Object)alertHistory.getBarSize());
    }

    public String toString() {
        if (this.isSignal()) {
            return "Signal: " + this.getSymbolDisplay() + " " + this.format("barSize") + " " + this.getSignalName() + " " + this.getMessage() + " Value: " + this.formattedLastTriggeredValue;
        }
        return "Alert: " + this.getSymbolDisplay() + " " + this.format("barSize") + " " + this.getName() + " Value: " + this.formattedLastTriggeredValue;
    }

    @Override
    public String formatPrice(float f2) {
        return this.ticker == null ? super.formatPrice(f2) : this.getInstrument().formatValue(f2);
    }

    @Override
    public String format(String string) {
        if (h.g(string)) {
            return "";
        }
        switch (string) {
            case "name": {
                return this.getName();
            }
            case "chart": 
            case "cancel": {
                return "";
            }
            case "replay": {
                return this.isReplay() ? "Y" : "N";
            }
            case "orderName": {
                return this.getOrderName();
            }
            case "comments": {
                return h.b((Object)this.comments);
            }
            case "signalName": {
                return h.g(this.getSignalName()) ? h.b((Object)this.getLabel()) : this.getSignalName();
            }
            case "lastValue": {
                return h.b((Object)this.formattedLastValue);
            }
            case "lastActivated": {
                return this.lastActivated <= 0L ? "" : ab.a(this.lastActivated, com.motivewave.platform.common.b.b());
            }
            case "expires": {
                return this.expires <= 0L ? "" : ab.a(this.expires, com.motivewave.platform.common.b.b());
            }
            case "barSize": {
                return this.barSize == null ? "N/A" : this.barSize.toString();
            }
            case "symbol": {
                return this.getInstrument() == null ? "" : this.getInstrument().getSymbolDisplay();
            }
        }
        return super.format(string);
    }

    public boolean isGlobal() {
        return this.componentId == 0L && !this.replay && !this.isStudy();
    }

    public boolean isReplay() {
        return this.replay;
    }

    public boolean isComponent() {
        return this.componentId != 0L;
    }

    public boolean isStudy() {
        u u2 = this.getGraph();
        if (u2 == null) {
            return false;
        }
        for (AlertCondition alertCondition : this.getConditions()) {
            q q2 = u2.a(alertCondition.getInput());
            if (q2 != null && q2.a() != null) {
                return true;
            }
            if (!alertCondition.isUseTargetInput() || (q2 = u2.a(alertCondition.getTargetInput())) == null || q2.a() == null) continue;
            return true;
        }
        return false;
    }

    private void addGraphListeners() {
        u u2 = this.getGraph();
        if (u2 == null || this.isGlobal() || this.conditions.isEmpty()) {
            return;
        }
        AlertCondition alertCondition = (AlertCondition)this.conditions.get(0);
        u2.a(alertCondition.getInput(), this);
        if (alertCondition.isUseTargetInput()) {
            u2.a(alertCondition.getTargetInput(), this);
        }
    }

    private void removeGraphListeners() {
        u u2 = this.getGraph();
        if (u2 == null || this.isGlobal() || this.conditions.isEmpty()) {
            return;
        }
        AlertCondition alertCondition = (AlertCondition)this.conditions.get(0);
        u2.b(alertCondition.getInput(), this);
        if (alertCondition.isUseTargetInput()) {
            u2.b(alertCondition.getTargetInput(), this);
        }
    }

    public MWOrder getOrder() {
        return this.orderSubmitted ? null : this.order;
    }

    public void setOrder(MWOrder mWOrder) {
        MWOrder mWOrder2 = this.order;
        if (mWOrder != null && mWOrder.isNew()) {
            this.orderSubmitted = false;
        }
        this.order = mWOrder;
        this.notify("order", mWOrder2, mWOrder);
        this.notify("orderName", null, this.getOrderName());
    }

    public boolean isClosePosition() {
        return this.closePosition;
    }

    public void setClosePosition(boolean bl2) {
        if (bl2) {
            this.orderSubmitted = false;
        }
        this.closePosition = bl2;
        this.notify("closePosition", this.closePosition, this.closePosition);
    }

    public String getCloseAcctId() {
        return this.closeAcctId;
    }

    public void setCloseAcctId(String string) {
        this.closeAcctId = string;
    }

    public MWInstrument getCloseInstr() {
        return this.closeInstr;
    }

    public void setCloseInstr(MWInstrument mWInstrument) {
        this.closeInstr = mWInstrument;
        if (this.closeInstr == this.getInstrument()) {
            this.closeInstr = null;
        }
    }

    public String getOrderName() {
        if (this.order == null) {
            return "";
        }
        MWInstrument mWInstrument = this.order.getAcctInstrument();
        String string = String.valueOf((Object)this.order.getAction()) + " " + mWInstrument.getSymbol();
        if (this.order.isMarket()) {
            string = string + "@MKT";
        }
        if (this.order.isLimit()) {
            string = string + " " + String.valueOf((Object)this.order.getType()) + "@" + mWInstrument.formatValue(this.order.getLimitPrice());
        } else if (this.order.isStop()) {
            string = string + " " + String.valueOf((Object)this.order.getType()) + "@" + mWInstrument.formatValue(this.order.getStopPrice());
        }
        return string;
    }

    public void setInstrument(MWInstrument mWInstrument) {
        if (this.ticker != null && this.ticker.getInstrument() == mWInstrument) {
            return;
        }
        if (this.ticker != null) {
            this.ticker.removePropertyChangeListener(this);
        }
        this.ticker = LiveTicker.get(mWInstrument);
    }

    public MWInstrument getInstrument() {
        return this.ticker == null ? null : this.ticker.getInstrument();
    }

    public void listen() {
        if (this.ticker == null) {
            return;
        }
        this.ticker.removePropertyChangeListener(this);
        if (this.isGlobal()) {
            this.ticker = LiveTicker.get(this.ticker.getInstrument());
        }
        this.ticker.addPropertyChangeListener(this);
        this.addGraphListeners();
        this.updateLastValue();
    }

    public boolean isShowBtn() {
        return this.showBtn == null ? com.motivewave.platform.common.b.a().isShowBtns() : this.showBtn.booleanValue();
    }

    public void setShowBtn(boolean bl2) {
        this.showBtn = bl2 == com.motivewave.platform.common.b.a().isShowBtns() ? null : Boolean.valueOf(bl2);
        this.notify("showBtn", this.showBtn, this.showBtn);
    }

    public boolean isShowLine() {
        return this.showLine == null ? com.motivewave.platform.common.b.a().isShowLines() : this.showLine.booleanValue();
    }

    public void setShowLine(boolean bl2) {
        this.showLine = bl2 == com.motivewave.platform.common.b.a().isShowLines() ? null : Boolean.valueOf(bl2);
        this.notify("showLine", this.showLine, this.showLine);
    }

    public boolean isShowLabel() {
        return this.showLabel == null ? com.motivewave.platform.common.b.a().isShowLbls() : this.showLabel.booleanValue();
    }

    public void setShowLabel(boolean bl2) {
        this.showLabel = bl2 == com.motivewave.platform.common.b.a().isShowLbls() ? null : Boolean.valueOf(bl2);
        this.notify("showLabel", this.showLabel, this.showLabel);
    }

    public Enums$Align getAlign() {
        return this.align == null ? com.motivewave.platform.common.b.a().getAlign() : this.align;
    }

    public void setAlign(Enums$Align enums$Align) {
        this.align = enums$Align == com.motivewave.platform.common.b.a().getAlign() ? null : enums$Align;
        this.notify("align", (Object)this.align, (Object)this.align);
    }

    public Color getColor() {
        return this.color == null ? Colors.white : this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.notify("color", this.color, this.color);
    }

    private List getPrevValues() {
        return this.prevValues.a();
    }

    private void addPrevValue(double d2) {
        if (this.prevValues.a() > 0 && (Double)this.prevValues.a(0) == d2) {
            return;
        }
        this.prevValues.b(0, (Object)d2);
        this.prevValues.a(5, 10);
    }

    private boolean hasPrevValues() {
        return this.prevValues.a() > 0;
    }

    private void clearPrevValues() {
        this.prevValues.b();
    }

    private Enums$AlertOperator readCondition(String string) {
        if (h.g(string)) {
            return Enums$AlertOperator.CROSSES;
        }
        if (h.a(string, new String[]{"GT", "GTE"})) {
            return Enums$AlertOperator.CROSSES_ABOVE;
        }
        if (h.a(string, new String[]{"LT", "LTE"})) {
            return Enums$AlertOperator.CROSSES_BELOW;
        }
        try {
            return Enums$AlertOperator.valueOf(string);
        }
        catch (Exception exception) {
            h.a.warning("Alert::read() invalid condition: " + string);
            return Enums$AlertOperator.CROSSES;
        }
    }

    @Override
    public List getNVPs() {
        MWOrder mWOrder;
        Object object = h.b(new String[]{this.a("id", this.id)});
        if (this.isSignal()) {
            object.add(this.b("name", this.getName()));
        }
        h.a((Collection)object, (Object[])new String[]{this.b("signalName", this.getSignalName()), this.b("label", this.getLabel()), this.b("comments", this.getComments()), this.a("triggerMultiple", this.triggerMultiple, false), this.a("multiplePerBar", this.multiplePerBar, true), this.a("useDefaultTimeZone", this.useDefaultTimeZone, true)});
        object.add(this.a("conditions", (Collection)this.conditions));
        if (!this.isUseDefaultTimeZone()) {
            object.add(this.b("timeZone", this.getTimeZone().getID()));
        }
        h.a((Collection)object, (Object[])new String[]{this.a("expires", this.expires, -1L), this.a("start1", this.session1Start, 32400000), this.a("end1", this.session1End, 57600000), this.a("session1Enabled", this.session1Enabled, false), this.a("start2", this.session2Start, 32400000), this.a("end2", this.session2End, 57600000), this.a("session2Enabled", this.session2Enabled, false), this.a("showAlert", this.isShowAlert(), true), this.a("showBtn", (Object)this.showBtn), this.a("showLine", (Object)this.showLine), this.a("showLabel", (Object)this.showLabel), this.a("align", (Object)this.align), this.a("color", this.color, Colors.white)});
        u u2 = this.getGraph();
        if (u2 != null) {
            object.add(this.a("graphId", u2.a().a()));
        }
        if (this.componentId != 0L) {
            object.add(this.a("componentId", this.componentId));
        }
        object.add(this.a("sound", this.a(this.a("enabled", this.playSound), this.a("usePreset", this.usePresetSound), this.b("file", this.getSoundFile() == null ? null : this.getSoundFile().getAbsolutePath()))));
        object.add(this.a("email", this.a(this.a("enabled", this.sendEmail, false), this.b("emailAddress", this.emailAddress), this.a("attachImage", this.attachImage))));
        MWInstrument mWInstrument = this.getInstrument();
        if (mWInstrument != null && (this.isGlobal() || u2 != null && u2.a().a() != mWInstrument)) {
            object.add(this.a("instr", mWInstrument.getKey()));
        }
        object.add(this.a("closePosition", this.closePosition, false));
        if (this.closePosition) {
            object.add(this.b("closeAcctId", this.closeAcctId));
            if (this.closeInstr != null) {
                object.add(this.a("closeInstr", this.closeInstr.getKey()));
            }
        }
        if ((mWOrder = this.getOrder()) != null && !this.isOrderSubmitted() && mWOrder.isNew()) {
            List list = mWOrder.getNVPs();
            list.add(this.a("limit", mWOrder.getLimitOrder()));
            list.add(this.a("stopTrail", mWOrder.getStopTrailOrder()));
            object.add(this.a("order", this.a((Collection)list)));
        }
        return object;
    }

    @Override
    public void fromJSON(JSONObject jSONObject) {
        aa aa2;
        JSONObject jSONObject22;
        this.id = jSONObject.str("id");
        this.setName(jSONObject.str("name"));
        this.setSignalName(jSONObject.str("signalName"));
        this.setLabel(jSONObject.str("label"));
        this.setComments(jSONObject.str("comments"));
        this.conditions.clear();
        if (jSONObject.has("input")) {
            this.conditions = h.b(new AlertCondition[]{new AlertCondition(jSONObject.str("input"), this.readCondition(jSONObject.str("condition")), jSONObject.getDouble("targetValue"), jSONObject.str("targetOption"), jSONObject.str("targetInput"), jSONObject.is("useTargetInput", false))});
        } else if (jSONObject.has("conditions")) {
            for (JSONObject jSONObject22 : jSONObject.getObjList("conditions")) {
                this.conditions.add(new AlertCondition(jSONObject22));
            }
        }
        this.inputProps = null;
        this.triggerMultiple = jSONObject.is("triggerMultiple", false);
        this.multiplePerBar = jSONObject.is("multiplePerBar", true);
        this.expires = jSONObject.getLong("expires", -1L);
        if (jSONObject.has("timeZone")) {
            this.timeZone = TimeZone.getTimeZone(jSONObject.str("timeZone"));
        }
        this.useDefaultTimeZone = jSONObject.is("useDefaultTimeZone", true);
        this.session1Start = jSONObject.getInt("start1", 32400000);
        this.session1End = jSONObject.getInt("end1", 57600000);
        this.session1Enabled = jSONObject.is("session1Enabled", false);
        this.session2Start = jSONObject.getInt("start2", 32400000);
        this.session2End = jSONObject.getInt("end2", 57600000);
        this.session2Enabled = jSONObject.is("session2Enabled", false);
        this.showAlert = jSONObject.is("showAlert");
        if (jSONObject.has("showBtn")) {
            this.showBtn = jSONObject.is("showBtn");
        }
        if (jSONObject.has("showLine")) {
            this.showLine = jSONObject.is("showLine");
        }
        if (jSONObject.has("showLabel")) {
            this.showLabel = jSONObject.is("showLabel");
        }
        if (jSONObject.has("color")) {
            this.color = jSONObject.getColor("color");
        }
        if (jSONObject.has("align")) {
            try {
                this.align = Enums$Align.valueOf(jSONObject.str("align"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (jSONObject.has("componentId")) {
            this.componentId = jSONObject.getLong("componentId");
        }
        if (jSONObject.has("graphId")) {
            this.graphId = jSONObject.getLong("graphId");
        } else if (this.isComponent() || this.isStudy()) {
            this.graphId = -1L;
        }
        JSONObject jSONObject3 = jSONObject.obj("sound");
        if (jSONObject3 != null) {
            this.setPlaySound(jSONObject3.is("enabled"));
            this.setUsePresetSound(jSONObject3.is("usePreset"));
            if (jSONObject3.has("file")) {
                this.setSoundFile(new File(jSONObject3.str("file")));
            }
        }
        if ((jSONObject22 = jSONObject.obj("email")) != null) {
            this.setSendEmail(jSONObject22.is("enabled", false));
            this.setEmailAddress(jSONObject22.str("emailAddress"));
            this.setAttachImage(jSONObject22.is("attachImage"));
        }
        if (jSONObject.has("instr") && this.getInstrument() == null) {
            aa2 = MWInstrument.byKey(jSONObject.str("instr"));
            if (aa2 == null) {
                aa2 = this.a(jSONObject, "instr");
            }
            if (aa2 != null) {
                this.setInstrument((MWInstrument)aa2);
            } else {
                h.a.warning("Alert::fromJSON() instrument not found: " + String.valueOf(jSONObject.obj("instr")));
            }
        }
        this.closePosition = jSONObject.is("closePosition", false);
        this.closeAcctId = jSONObject.strDef("closeAcctId", null);
        if (jSONObject.has("closeInstr")) {
            this.closeInstr = MWInstrument.byKey(jSONObject.str("closeInstr"));
        }
        if (jSONObject.has("order") && ai.f()) {
            aa2 = jSONObject.obj("order");
            MWOrder mWOrder = new MWOrder((JSONObject)aa2);
            if (((JSONObject)aa2).has("limit")) {
                mWOrder.setLimitOrder(new MWOrder(((JSONObject)aa2).obj("limit")));
            }
            if (((JSONObject)aa2).has("stopTrail")) {
                mWOrder.setStopTrailOrder(new MWOrder(((JSONObject)aa2).obj("stopTrail")));
            }
            this.setOrder(mWOrder);
        }
        if (!this.isSignal()) {
            this.updateName();
        }
    }

    private static /* synthetic */ void lambda$doNotification$0(u u2, String string, String string2, String string3) {
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = u2.a().a();
            if (bufferedImage == null) {
                h.a.warning("Alert::doNotification() unable to get image of graph.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            a.a(string, string2, string3, bufferedImage);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

