/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.databean;

import cf.dk;
import com.motivewave.common.h;
import com.motivewave.common.util.g;
import com.motivewave.common.util.w;
import com.motivewave.platform.common.Enums$Align;
import com.motivewave.platform.common.Enums$InstrumentType;
import com.motivewave.platform.common.Enums$ServiceType;
import com.motivewave.platform.common.a;
import com.motivewave.platform.common.ab;
import com.motivewave.platform.common.ai;
import com.motivewave.platform.common.b;
import com.motivewave.platform.databean.Execution;
import com.motivewave.platform.databean.Executions;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.databean.ObservableBean;
import com.motivewave.platform.databean.OrderDirectory;
import com.motivewave.platform.databean.Position;
import com.motivewave.platform.databean.Positions;
import com.motivewave.platform.databean.Workspace;
import com.motivewave.platform.service.bs;
import com.motivewave.platform.service.by;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

public class Account
extends ObservableBean {
    protected String id;
    protected double balance;
    protected double statementBalance;
    protected double minimumBalance;
    protected String baseCurrency = "USD";
    protected double unrealizedPL;
    protected boolean readOnly = false;
    protected String accountName;
    protected boolean useAccountName = false;
    protected boolean simulatedAccount = false;
    protected boolean billing = false;
    protected boolean primary = false;
    protected String type;
    protected String typeDesc;
    protected String status;
    protected String statusDesc;
    private double accountValue;
    private double accountCredit;
    private double longValue;
    private double shortValue;
    private double equity;
    private double overnightBuyingPower;
    private double buyingPower;
    private double reservedBuyingPower;
    private double usedBuyingPower;
    private double optionBuyingPower;
    private double optionRequirement;
    private double stockBuyingPower;
    private double cashBalance;
    private double availableFunds;
    private double initialCashBalance;
    private double initialAccountValue;
    private double initialMarginBalance;
    private double maintenanceMargin;
    private double maintenanceExcess;
    private double maintenanceRequirement;
    private double netLiquidationValue;
    private double netEquity;
    private double openTradeEquity;
    private double marginBalance;
    private double minimumMarginBalance;
    private double initialMarginEquity;
    private double marginEquity;
    private double sessionPL;
    private double totalPL;
    private double unclearedDeposit;
    private double excessEquity;
    private double morningExcessEquity;
    private double overnightExcessEquity;
    private double marginDebit;
    private double percentEquity;
    private double marginAvailable;
    private double marginRate;
    private double marginUsed;
    private double positionValue;
    private double currentRequirement;
    private double marketValue;
    private double totalEquity;
    private double pendingCash;
    private double tradableFunds;
    private double totalMarginRequirement;
    private double accruedInterest;
    private int pendingOrders;
    private boolean hedging = false;
    private boolean netOrders = false;
    private List supportedTypes = new ArrayList();
    private String fcmId;
    private double lossLimit;
    private double open;
    private int buyLimit;
    private int sellLimit;
    private boolean dayTrading;
    protected boolean includeCommission = false;
    private int roundTrips = 0;
    private double usdBalance = 0.0;
    private double cadBalance = 0.0;
    private int freeTradeBalance = 0;
    private boolean interestFree = false;
    private boolean longOnly = false;
    private String serviceName = null;
    private Enums$ServiceType serviceType = null;
    private static g simAccounts = new g();
    private static String defaultAccountId;
    private static boolean simulatedEnabled;
    private static boolean tradeSimOnly;
    private static boolean fillMarketImmediate;
    private static boolean includeCommissions;
    private static long uniqueCounter;
    private static long uniqueReplayCounter;
    private static String ID_SYNC;
    private static Map srvcId2ExecReq;

    public Account(String string) {
        this.id = string;
    }

    public boolean isAccount(String string) {
        if (h.a((Object)string, (Object)this.id)) {
            return true;
        }
        return h.a((Object)string, (Object)this.accountName);
    }

    public void displayNameUpdated() {
        this.notify("displayName", null, this.getDisplayName());
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean supportsDelete() {
        return false;
    }

    public void delete(dk dk2, Runnable runnable) {
    }

    public boolean supportsEdit() {
        return false;
    }

    public void edit(dk dk2, Runnable runnable) {
        if (this.isSimulatedAccount()) {
            bd.a a2 = new bd.a(this, false);
            a2.showAndWait();
            if (!a2.a_()) {
                bs.i();
            }
            if (runnable != null) {
                runnable.run();
            }
        }
    }

    @Override
    public Object getProperty(String string) {
        switch (string) {
            case "accountID": {
                return this.getAccountID();
            }
            case "accountName": {
                return this.getAccountName();
            }
            case "displayName": {
                return this.getDisplayName();
            }
            case "accountValue": {
                return this.getAccountValue();
            }
            case "accountCredit": {
                return this.getAccountCredit();
            }
            case "sessionPL": {
                return this.getSessionPL();
            }
            case "unrealizedPL": {
                return this.getUnrealizedPL();
            }
            case "totalPL": {
                return this.getTotalPL();
            }
            case "type": {
                return this.getType();
            }
            case "typeDesc": {
                return this.getTypeDesc();
            }
            case "status": {
                return this.getStatus();
            }
            case "statusDesc": {
                return this.getStatusDesc();
            }
            case "baseCurrency": {
                return this.getBaseCurrency();
            }
            case "primary": {
                return this.isPrimary();
            }
            case "default": {
                return this.isDefault();
            }
            case "billing": {
                return this.isBilling();
            }
            case "groupAccount": {
                return this.isGroupAccount();
            }
            case "simulatedAccount": {
                return this.isSimulatedAccount();
            }
            case "initialMarginBalance": {
                return this.getInitialMarginBalance();
            }
            case "marginBalance": {
                return this.getMarginBalance();
            }
            case "minimumMarginBalance": {
                return this.getMinimumMarginBalance();
            }
            case "initialMarginEquity": {
                return this.getInitialMarginEquity();
            }
            case "marginEquity": {
                return this.getMarginEquity();
            }
            case "initialCashBalance": {
                return this.getInitialCashBalance();
            }
            case "cashBalance": {
                return this.getCashBalance();
            }
            case "usdBalance": {
                return this.getUsdBalance();
            }
            case "cadBalance": {
                return this.getCadBalance();
            }
            case "initialAccountValue": {
                return this.getInitialAccountValue();
            }
            case "equity": {
                return this.getEquity();
            }
            case "totalEquity": {
                return this.getTotalEquity();
            }
            case "accruedInterest": {
                return this.getAccruedInterest();
            }
            case "netEquity": {
                return this.getNetEquity();
            }
            case "openTradeEquity": {
                return this.getOpenTradeEquity();
            }
            case "tradableFunds": {
                return this.getTradableFunds();
            }
            case "totalMarginRequirement": {
                return this.getTotalMarginRequirement();
            }
            case "overnightBuyingPower": {
                return this.getOvernightBuyingPower();
            }
            case "buyingPower": {
                return this.getBuyingPower();
            }
            case "reservedBuyingPower": {
                return this.getReservedBuyingPower();
            }
            case "usedBuyingPower": {
                return this.getUsedBuyingPower();
            }
            case "optionBuyingPower": {
                return this.getOptionBuyingPower();
            }
            case "stockBuyingPower": {
                return this.getStockBuyingPower();
            }
            case "optionRequirement": {
                return this.getOptionRequirement();
            }
            case "balance": {
                return this.getBalance();
            }
            case "statementBalance": {
                return this.getStatementBalance();
            }
            case "minimumBalance": {
                return this.getMinimumBalance();
            }
            case "availableFunds": {
                return this.getAvailableFunds();
            }
            case "unclearedDeposit": {
                return this.getUnclearedDeposit();
            }
            case "marginDebit": {
                return this.getMarginDebit();
            }
            case "excessEquity": {
                return this.getExcessEquity();
            }
            case "morningExcessEquity": {
                return this.getMorningExcessEquity();
            }
            case "overnightExcessEquity": {
                return this.getOvernightExcessEquity();
            }
            case "marginAvailable": {
                return this.getMarginAvailable();
            }
            case "marginUsed": {
                return this.getMarginUsed();
            }
            case "netAssetValue": {
                return this.getNetAssetValue();
            }
            case "positionValue": {
                return this.getPositionValue();
            }
            case "longValue": {
                return this.getLongValue();
            }
            case "shortValue": {
                return this.getShortValue();
            }
            case "percentEquity": {
                return this.getPercentEquity();
            }
            case "marginRate": {
                return this.getMarginRate();
            }
            case "readOnly": {
                return this.isReadOnly();
            }
            case "maintenanceRequirement": {
                return this.getMaintenanceRequirement();
            }
            case "maintenanceMargin": {
                return this.getMaintenanceMargin();
            }
            case "maintenanceExcess": {
                return this.getMaintenanceExcess();
            }
            case "netLiquidationValue": {
                return this.getNetLiquidationValue();
            }
            case "currentRequirement": {
                return this.getCurrentRequirement();
            }
            case "marketValue": {
                return this.getMarketValue();
            }
            case "pendingCash": {
                return this.getPendingCash();
            }
            case "pendingOrders": {
                return this.getPendingOrders();
            }
            case "replayAccount": {
                return this.isReplay();
            }
            case "hedging": {
                return this.isHedging();
            }
            case "netOrders": {
                return this.isNetOrders();
            }
            case "open": {
                return this.getOpen();
            }
            case "buyLimit": {
                return this.getBuyLimit();
            }
            case "sellLimit": {
                return this.getSellLimit();
            }
            case "lossLimit": {
                return this.getLossLimit();
            }
            case "dayTrading": {
                return this.isDayTrading();
            }
            case "longOnly": {
                return this.isLongOnly();
            }
            case "interestFree": {
                return this.isInterestFree();
            }
            case "freeTradeBalance": {
                return this.getFreeTradeBalance();
            }
            case "serviceName": {
                return this.getServiceName();
            }
            case "serviceType": {
                return this.getServiceType();
            }
            case "connectionName": {
                return this.getConnectionName();
            }
            case "roundTrips": {
                return this.roundTrips;
            }
        }
        return null;
    }

    @Override
    public String format(String string) {
        Object object = this.getProperty(string);
        if (h.a(string, "initialMarginBalance", "minimumMarginBalance", "marginBalance", "initialMarginEquity", "marginEquity", "initialCashBalance", "cashBalance", "initialAccountValue", "accountValue", "accountCredit", "equity", "overnightBuyingPower", "buyingPower", "usedBuyingPower", "reservedBuyingPower", "unrealizedPL", "balance", "statementBalance", "minimumBalance", "availableFunds", "sessionPL", "totalPL", "unclearedDeposit", "marginDebit", "morningExcessEquity", "overnightExessEquity", "excessEquity", "marginAvailable", "marginUsed", "netAssetValue", "positionValue", "maintenanceRequirement", "maintenanceMargin", "maintenanceExcess", "netLiquidationValue", "pendingCash", "accruedInterest", "totalEquity", "marketValue", "optionBuyingPower", "stockBuyingPower", "optionRequirement", "longValue", "shortValue", "open", "buyLimit", "sellLimit", "lossLimit", "cadBalance", "usdBalance", "netEquity", "openTradeEquity", "tradableFunds", "totalMarginRequirement")) {
            double d2 = h.a(object);
            if (d2 == 0.0 || d2 > -0.01 && d2 < 0.01) {
                return "";
            }
            return ab.a(d2);
        }
        if (h.a(string, new String[]{"percentEquity", "marginRate"})) {
            double d3 = h.a(object);
            if (d3 == 0.0) {
                return "";
            }
            return h.a(d3, 2);
        }
        if (h.a(string, "dayTrading", "billing", "primary", "default", "interestFree", "longOnly", "hedging")) {
            return this.getBoolean(string) ? "Y" : "N";
        }
        if (string == "serviceName") {
            return this.getServiceName();
        }
        if (string == "serviceType") {
            return this.getServiceType() == null ? "" : this.getServiceType().toString();
        }
        if (string == "connectionName") {
            return this.getConnectionName();
        }
        return h.b(object);
    }

    public String getServiceName() {
        if (this.serviceName != null) {
            return this.serviceName;
        }
        by by2 = bs.a(this);
        if (by2 != null) {
            this.serviceName = by2.a().getType().toString();
        }
        return this.serviceName;
    }

    public Enums$ServiceType getServiceType() {
        if (this.serviceType != null) {
            return this.serviceType;
        }
        by by2 = bs.a(this);
        if (by2 != null) {
            this.serviceType = by2.a().getType();
        }
        return this.serviceType;
    }

    public boolean isIB() {
        return this.getServiceType() != null && this.getServiceType().isIB();
    }

    public String getConnectionName() {
        by by2 = bs.a(this);
        if (by2 != null) {
            return by2.a().getName();
        }
        return "";
    }

    public boolean isSimulatedAccount() {
        return this.simulatedAccount;
    }

    public boolean isTradeCopier() {
        return false;
    }

    public boolean isReplay() {
        return false;
    }

    public String getAccountID() {
        return this.id;
    }

    public String getLeadAccountId() {
        return this.id;
    }

    public Account getLeadAccount() {
        return this;
    }

    public String getAccountName() {
        return h.g(this.accountName) ? this.getAccountID() : this.accountName;
    }

    public void setAccountName(String string) {
        String string2 = this.accountName;
        this.accountName = string;
        this.notify("accountName", string2, this.accountName);
        this.displayNameUpdated();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String string) {
        String string2 = this.type;
        this.type = string;
        this.notify("type", string2, this.type);
    }

    public boolean isBilling() {
        return this.billing;
    }

    public void setBilling(boolean bl2) {
        boolean bl3 = this.billing;
        this.billing = bl2;
        this.notify("billing", bl3, this.billing);
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public void setPrimary(boolean bl2) {
        boolean bl3 = this.primary;
        this.primary = bl2;
        this.notify("primary", bl3, this.primary);
    }

    public boolean isHedging() {
        return this.hedging;
    }

    public void setHedging(boolean bl2) {
        boolean bl3 = this.hedging;
        this.hedging = bl2;
        this.notify("hedging", bl3, this.hedging);
    }

    public boolean isNetOrders() {
        return this.netOrders;
    }

    public void setNetOrders(boolean bl2) {
        boolean bl3 = this.netOrders;
        this.netOrders = bl2;
        this.notify("netOrders", bl3, this.netOrders);
    }

    public String getTypeDesc() {
        return this.typeDesc;
    }

    public void setTypeDesc(String string) {
        String string2 = this.typeDesc;
        this.typeDesc = string;
        this.notify("typeDesc", string2, this.typeDesc);
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String string) {
        String string2 = this.status;
        this.status = string;
        this.notify("status", string2, this.status);
    }

    public String getStatusDesc() {
        return this.statusDesc;
    }

    public void setStatusDesc(String string) {
        String string2 = this.statusDesc;
        this.statusDesc = string;
        this.notify("statusDesc", string2, this.statusDesc);
    }

    public String getBaseCurrency() {
        return this.baseCurrency;
    }

    public void setBaseCurrency(String string) {
        String string2 = this.baseCurrency;
        this.baseCurrency = string;
        this.notify("baseCurrency", string2, this.baseCurrency);
    }

    public double getBalance() {
        return this.balance;
    }

    public void setBalance(double d2) {
        double d3 = this.balance;
        double d4 = this.getNetAssetValue();
        this.balance = d2;
        this.notify("balance", d3, this.balance);
        this.notify("netAssetValue", d4, this.getNetAssetValue());
    }

    public double getStatementBalance() {
        return this.statementBalance;
    }

    public void setStatementBalance(double d2) {
        double d3 = this.statementBalance;
        this.statementBalance = d2;
        this.notify("statementBalance", d3, this.statementBalance);
    }

    public double getRiskBalance() {
        return this.cashBalance > 0.0 ? this.cashBalance : this.getBalance();
    }

    public double getMinimumBalance() {
        return this.minimumBalance;
    }

    public void setMinimumBalance(double d2) {
        double d3 = this.minimumBalance;
        this.minimumBalance = d2;
        this.notify("minimumBalance", d3, this.minimumBalance);
    }

    public double getNetAssetValue() {
        return this.getBalance() + this.getUnrealizedPL();
    }

    public double getUnrealizedPL() {
        return this.unrealizedPL;
    }

    public void setUnrealizedPL(double d2) {
        double d3 = this.unrealizedPL;
        double d4 = this.getNetAssetValue();
        this.unrealizedPL = d2;
        this.notify("unrealizedPL", d3, this.unrealizedPL);
        this.notify("netAssetValue", d4, this.getNetAssetValue());
    }

    public double getSessionPL() {
        return this.sessionPL;
    }

    public void setSessionPL(double d2) {
        double d3 = this.sessionPL;
        this.sessionPL = d2;
        this.notify("sessionPL", d3, this.sessionPL);
    }

    public double getTotalPL() {
        return this.totalPL;
    }

    public void setTotalPL(double d2) {
        double d3 = this.totalPL;
        this.totalPL = d2;
        this.notify("totalPL", d3, this.totalPL);
    }

    public boolean isDefault() {
        return h.a((Object)this.getAccountID(), (Object)defaultAccountId);
    }

    public void setDefault(boolean bl2) {
        boolean bl3 = h.a((Object)defaultAccountId, (Object)this.getAccountID());
        if (bl2) {
            defaultAccountId = this.getAccountID();
        } else if (bl3) {
            defaultAccountId = null;
        }
        this.notify("default", !bl2, bl2);
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean bl2) {
        boolean bl3 = this.readOnly;
        this.readOnly = bl2;
        this.notify("readOnly", bl3, this.readOnly);
    }

    public void calcPnl() {
        double d2 = 0.0;
        List list = Positions.getAll();
        if (h.a((Collection)list)) {
            this.setUnrealizedPL(d2);
            return;
        }
        for (Position position : list) {
            if (!position.isOpen() || !h.g(position.getAccountId()) && !h.a((Object)position.getAccountId(), (Object)this.id)) continue;
            d2 += position.getUnrealizedPnL();
        }
        d2 = h.a(d2, 2);
        this.setUnrealizedPL(d2);
    }

    public boolean isGroupAccount() {
        return false;
    }

    public boolean isUseAccountName() {
        return this.useAccountName || this.isSimulatedAccount();
    }

    public void setUseAccountName(boolean bl2) {
        this.useAccountName = bl2;
    }

    public double getCashBalance() {
        return this.cashBalance;
    }

    public void setCashBalance(double d2) {
        double d3 = this.cashBalance;
        this.cashBalance = d2;
        this.notify("cashBalance", d3, this.cashBalance);
    }

    public double getUsdBalance() {
        return this.usdBalance;
    }

    public void setUsdBalance(double d2) {
        double d3 = this.usdBalance;
        this.usdBalance = d2;
        this.notify("usdBalance", d3, this.usdBalance);
    }

    public double getCadBalance() {
        return this.cadBalance;
    }

    public void setCadBalance(double d2) {
        double d3 = this.cadBalance;
        this.cadBalance = d2;
        this.notify("cadBalance", d3, this.cadBalance);
    }

    public void adjustAccount(double d2) {
        this.setBalance(this.balance + d2);
        this.setCashBalance(this.cashBalance + d2);
        this.setSessionPL(this.sessionPL + d2);
        this.setTotalPL(this.totalPL + d2);
    }

    public double getAvailableFunds() {
        return this.availableFunds;
    }

    public void setAvailableFunds(double d2) {
        double d3 = this.availableFunds;
        this.availableFunds = d2;
        this.notify("availableFunds", d3, this.availableFunds);
    }

    public double getInitialCashBalance() {
        return this.initialCashBalance;
    }

    public void setInitialCashBalance(double d2) {
        double d3 = this.initialCashBalance;
        this.initialCashBalance = d2;
        this.notify("initialCashBalance", d3, this.initialCashBalance);
    }

    public double getInitialAccountValue() {
        return this.initialAccountValue;
    }

    public void setInitialAccountValue(double d2) {
        double d3 = this.initialAccountValue;
        this.initialAccountValue = d2;
        this.notify("initialAccountValue", d3, this.initialAccountValue);
    }

    public double getAccountValue() {
        return this.accountValue;
    }

    public void setAccountValue(double d2) {
        double d3 = this.accountValue;
        this.accountValue = d2;
        this.notify("accountValue", d3, this.accountValue);
    }

    public double getAccountCredit() {
        return this.accountCredit;
    }

    public void setAccountCredit(double d2) {
        double d3 = this.accountCredit;
        this.accountCredit = d2;
        this.notify("accountCredit", d3, this.accountCredit);
    }

    public double getLongValue() {
        return this.longValue;
    }

    public void setLongValue(double d2) {
        double d3 = this.longValue;
        this.longValue = d2;
        this.notify("longValue", d3, this.longValue);
    }

    public double getShortValue() {
        return this.shortValue;
    }

    public void setShortValue(double d2) {
        double d3 = this.shortValue;
        this.shortValue = d2;
        this.notify("shortValue", d3, this.shortValue);
    }

    public double getEquity() {
        return this.equity;
    }

    public void setEquity(double d2) {
        double d3 = this.equity;
        this.equity = d2;
        this.notify("equity", d3, this.equity);
    }

    public double getBuyingPower() {
        return this.buyingPower;
    }

    public void setBuyingPower(double d2) {
        double d3 = this.buyingPower;
        this.buyingPower = d2;
        this.notify("buyingPower", d3, this.buyingPower);
    }

    public double getUsedBuyingPower() {
        return this.usedBuyingPower;
    }

    public void setUsedBuyingPower(double d2) {
        double d3 = this.usedBuyingPower;
        this.usedBuyingPower = d2;
        this.notify("usedBuyingPower", d3, this.usedBuyingPower);
    }

    public double getReservedBuyingPower() {
        return this.reservedBuyingPower;
    }

    public void setReservedBuyingPower(double d2) {
        double d3 = this.reservedBuyingPower;
        this.reservedBuyingPower = d2;
        this.notify("reservedBuyingPower", d3, this.reservedBuyingPower);
    }

    public double getOvernightBuyingPower() {
        return this.overnightBuyingPower;
    }

    public void setOvernightBuyingPower(double d2) {
        double d3 = this.overnightBuyingPower;
        this.overnightBuyingPower = d2;
        this.notify("overnightBuyingPower", d3, this.overnightBuyingPower);
    }

    public double getOptionBuyingPower() {
        return this.optionBuyingPower;
    }

    public void setOptionBuyingPower(double d2) {
        double d3 = this.optionBuyingPower;
        this.optionBuyingPower = d2;
        this.notify("optionBuyingPower", d3, this.optionBuyingPower);
    }

    public double getStockBuyingPower() {
        return this.stockBuyingPower;
    }

    public void setStockBuyingPower(double d2) {
        double d3 = this.stockBuyingPower;
        this.stockBuyingPower = d2;
        this.notify("stockBuyingPower", d3, this.stockBuyingPower);
    }

    public double getOptionRequirement() {
        return this.optionRequirement;
    }

    public void setOptionRequirement(double d2) {
        double d3 = this.optionRequirement;
        this.optionRequirement = d2;
        this.notify("optionRequirement", d3, this.optionRequirement);
    }

    public double getInitialMarginBalance() {
        return this.initialMarginBalance;
    }

    public void setInitialMarginBalance(double d2) {
        double d3 = this.initialMarginBalance;
        this.initialMarginBalance = d2;
        this.notify("initialMarginBalance", d3, this.initialMarginBalance);
    }

    public double getMaintenanceRequirement() {
        return this.maintenanceRequirement;
    }

    public void setMaintenanceRequirement(double d2) {
        double d3 = this.maintenanceRequirement;
        this.maintenanceRequirement = d2;
        this.notify("maintenanceRequirement", d3, this.maintenanceRequirement);
    }

    public double getMaintenanceMargin() {
        return this.maintenanceMargin;
    }

    public void setMaintenanceMargin(double d2) {
        double d3 = this.maintenanceMargin;
        this.maintenanceMargin = d2;
        this.notify("maintenanceMargin", d3, this.maintenanceMargin);
    }

    public double getMaintenanceExcess() {
        return this.maintenanceExcess;
    }

    public void setMaintenanceExcess(double d2) {
        double d3 = this.maintenanceExcess;
        this.maintenanceExcess = d2;
        this.notify("maintenanceExcess", d3, this.maintenanceExcess);
    }

    public double getNetLiquidationValue() {
        return this.netLiquidationValue;
    }

    public void setNetLiquidationValue(double d2) {
        double d3 = this.netLiquidationValue;
        this.netLiquidationValue = d2;
        this.notify("netLiquidationValue", d3, this.netLiquidationValue);
    }

    public double getMarginBalance() {
        return this.marginBalance;
    }

    public void setMarginBalance(double d2) {
        double d3 = this.marginBalance;
        this.marginBalance = d2;
        this.notify("marginBalance", d3, this.marginBalance);
    }

    public double getMinimumMarginBalance() {
        return this.minimumMarginBalance;
    }

    public void setMinimumMarginBalance(double d2) {
        double d3 = this.minimumMarginBalance;
        this.minimumMarginBalance = d2;
        this.notify("minimumMarginBalance", d3, this.minimumMarginBalance);
    }

    public double getInitialMarginEquity() {
        return this.initialMarginEquity;
    }

    public void setInitialMarginEquity(double d2) {
        double d3 = this.initialMarginEquity;
        this.initialMarginEquity = d2;
        this.notify("initialMarginEquity", d3, this.initialMarginEquity);
    }

    public double getMarginEquity() {
        return this.marginEquity;
    }

    public void setMarginEquity(double d2) {
        double d3 = this.marginEquity;
        this.marginEquity = d2;
        this.notify("marginEquity", d3, this.marginEquity);
    }

    public double getUnclearedDeposit() {
        return this.unclearedDeposit;
    }

    public void setUnclearedDeposit(double d2) {
        double d3 = this.unclearedDeposit;
        this.unclearedDeposit = d2;
        this.notify("unclearedDeposit", d3, this.unclearedDeposit);
    }

    public double getExcessEquity() {
        return this.excessEquity;
    }

    public void setExcessEquity(double d2) {
        double d3 = this.excessEquity;
        this.excessEquity = d2;
        this.notify("excessEquity", d3, this.excessEquity);
    }

    public double getMorningExcessEquity() {
        return this.morningExcessEquity;
    }

    public void setMorningExcessEquity(double d2) {
        double d3 = this.morningExcessEquity;
        this.morningExcessEquity = d2;
        this.notify("morningExcessEquity", d3, this.morningExcessEquity);
    }

    public double getOvernightExcessEquity() {
        return this.overnightExcessEquity;
    }

    public void setOvernightExcessEquity(double d2) {
        double d3 = this.overnightExcessEquity;
        this.overnightExcessEquity = d2;
        this.notify("overnightExcessEquity", d3, this.overnightExcessEquity);
    }

    public double getMarginDebit() {
        return this.marginDebit;
    }

    public void setMarginDebit(double d2) {
        double d3 = this.marginDebit;
        this.marginDebit = d2;
        this.notify("marginDebit", d3, this.marginDebit);
    }

    public double getPercentEquity() {
        return this.percentEquity;
    }

    public void setPercentEquity(double d2) {
        double d3 = this.percentEquity;
        this.percentEquity = d2;
        this.notify("percentEquity", d3, this.percentEquity);
    }

    public double getMarginAvailable() {
        return this.marginAvailable;
    }

    public void setMarginAvailable(double d2) {
        double d3 = this.marginAvailable;
        this.marginAvailable = d2;
        this.notify("marginAvailable", d3, this.marginAvailable);
    }

    public double getMarginRate() {
        return this.marginRate;
    }

    public void setMarginRate(double d2) {
        double d3 = this.marginRate;
        this.marginRate = d2;
        this.notify("marginRate", d3, this.marginRate);
    }

    public double getMarginUsed() {
        return this.marginUsed;
    }

    public void setMarginUsed(double d2) {
        double d3 = this.marginUsed;
        this.marginUsed = d2;
        this.notify("marginUsed", d3, this.marginUsed);
    }

    public double getPositionValue() {
        return this.positionValue;
    }

    public void setPositionValue(double d2) {
        double d3 = this.positionValue;
        this.positionValue = d2;
        this.notify("positionValue", d3, this.positionValue);
    }

    public double getCurrentRequirement() {
        return this.currentRequirement;
    }

    public void setCurrentRequirement(double d2) {
        double d3 = this.currentRequirement;
        this.currentRequirement = d2;
        this.notify("currentRequirement", d3, this.currentRequirement);
    }

    public double getMarketValue() {
        return this.marketValue;
    }

    public void setMarketValue(double d2) {
        double d3 = this.marketValue;
        this.marketValue = d2;
        this.notify("marketValue", d3, this.marketValue);
    }

    public double getAccruedInterest() {
        return this.accruedInterest;
    }

    public void setAccruedInterest(double d2) {
        double d3 = this.accruedInterest;
        this.accruedInterest = d2;
        this.notify("accruedInterest", d3, this.accruedInterest);
    }

    public double getTotalEquity() {
        return this.totalEquity;
    }

    public void setTotalEquity(double d2) {
        double d3 = this.totalEquity;
        this.totalEquity = d2;
        this.notify("totalEquity", d3, this.totalEquity);
    }

    public double getNetEquity() {
        return this.netEquity;
    }

    public void setNetEquity(double d2) {
        double d3 = this.netEquity;
        this.netEquity = d2;
        this.notify("netEquity", d3, this.netEquity);
    }

    public double getOpenTradeEquity() {
        return this.openTradeEquity;
    }

    public void setOpenTradeEquity(double d2) {
        double d3 = this.openTradeEquity;
        this.openTradeEquity = d2;
        this.notify("openTradeEquity", d3, this.openTradeEquity);
    }

    public double getTradableFunds() {
        return this.tradableFunds;
    }

    public void setTradableFunds(double d2) {
        double d3 = this.tradableFunds;
        this.tradableFunds = d2;
        this.notify("tradableFunds", d3, this.tradableFunds);
    }

    public double getTotalMarginRequirement() {
        return this.totalMarginRequirement;
    }

    public void setTotalMarginRequirement(double d2) {
        double d3 = this.totalMarginRequirement;
        this.totalMarginRequirement = d2;
        this.notify("totalMarginRequirement", d3, this.totalMarginRequirement);
    }

    public double getPendingCash() {
        return this.pendingCash;
    }

    public void setPendingCash(double d2) {
        double d3 = this.pendingCash;
        this.pendingCash = d2;
        this.notify("pendingCash", d3, this.pendingCash);
    }

    public int getPendingOrders() {
        return this.pendingOrders;
    }

    public void setPendingOrders(int n2) {
        int n3 = this.pendingOrders;
        this.pendingOrders = n2;
        this.notify("pendingOrders", n3, this.pendingOrders);
    }

    public boolean supportsInstrument(MWInstrument mWInstrument) {
        if (h.a((Collection)this.supportedTypes)) {
            return true;
        }
        return this.supportedTypes.contains((Object)mWInstrument.getType());
    }

    public boolean supportsInstrument(Enums$InstrumentType enums$InstrumentType) {
        if (h.a((Collection)this.supportedTypes)) {
            return true;
        }
        return this.supportedTypes.contains((Object)enums$InstrumentType);
    }

    public void addSupportedType(Enums$InstrumentType enums$InstrumentType) {
        if (!this.supportedTypes.contains((Object)enums$InstrumentType)) {
            this.supportedTypes.add(enums$InstrumentType);
        }
    }

    public String getDisplayName() {
        String string;
        String string2 = string = this.isUseAccountName() ? this.accountName : this.id;
        if (b.a().isMaskAccount() && !this.isReplay() && !this.isSimulatedAccount()) {
            int n2 = b.a().getMaskChars();
            Enums$Align enums$Align = b.a().getMaskSide();
            if (n2 >= string.length()) {
                return string;
            }
            StringBuffer stringBuffer = new StringBuffer();
            if (enums$Align == Enums$Align.LEFT) {
                for (int i2 = 0; i2 < string.length() - n2; ++i2) {
                    stringBuffer.append('X');
                }
                stringBuffer.append(string.substring(string.length() - n2));
            } else {
                stringBuffer.append(string.substring(0, n2));
                for (int i3 = 0; i3 < string.length() - n2; ++i3) {
                    stringBuffer.append('X');
                }
            }
            string = stringBuffer.toString();
        }
        return string;
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        try {
            Account account = (Account)object;
            return h.a((Object)this.id, (Object)account.id);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public String getFcmId() {
        return this.fcmId;
    }

    public void setFcmId(String string) {
        this.fcmId = string;
    }

    public double getOpen() {
        return this.open;
    }

    public void setOpen(double d2) {
        double d3 = this.open;
        this.open = d2;
        this.notify("open", d3, this.open);
    }

    public double getLossLimit() {
        return this.lossLimit;
    }

    public void setLossLimit(double d2) {
        double d3 = this.lossLimit;
        this.lossLimit = d2;
        this.notify("lossLimit", d3, this.lossLimit);
    }

    public int getBuyLimit() {
        return this.buyLimit;
    }

    public void setBuyLimit(int n2) {
        int n3 = this.buyLimit;
        this.buyLimit = n2;
        this.notify("buyLimit", n3, this.buyLimit);
    }

    public int getSellLimit() {
        return this.sellLimit;
    }

    public void setSellLimit(int n2) {
        int n3 = this.sellLimit;
        this.sellLimit = n2;
        this.notify("sellLimit", n3, this.sellLimit);
    }

    public boolean isDayTrading() {
        return this.dayTrading;
    }

    public void setDayTrading(boolean bl2) {
        boolean bl3 = this.dayTrading;
        this.dayTrading = bl2;
        this.notify("dayTrading", bl3, this.dayTrading);
    }

    public boolean isLongOnly() {
        return this.longOnly;
    }

    public void setLongOnly(boolean bl2) {
        boolean bl3 = this.longOnly;
        this.longOnly = bl2;
        this.notify("longOnly", bl3, this.longOnly);
    }

    public boolean isInterestFree() {
        return this.interestFree;
    }

    public void setInterestFree(boolean bl2) {
        boolean bl3 = this.interestFree;
        this.interestFree = bl2;
        this.notify("interestFree", bl3, this.interestFree);
    }

    public int getFreeTradeBalance() {
        return this.freeTradeBalance;
    }

    public void setFreeTradeBalance(int n2) {
        int n3 = this.freeTradeBalance;
        this.freeTradeBalance = n2;
        this.notify("freeTradeBalance", n3, this.freeTradeBalance);
    }

    public boolean isIncludeCommission() {
        if (this.isSimulatedAccount()) {
            return Account.isIncludeCommissions();
        }
        return this.includeCommission;
    }

    public void setIncludeCommission(boolean bl2) {
        this.includeCommission = bl2;
    }

    public int getRoundTrips() {
        return this.roundTrips;
    }

    public void setRoundTrips(int n2) {
        int n3 = this.roundTrips;
        this.roundTrips = n2;
        this.notify("roundTrips", n3, this.roundTrips);
    }

    public static Account getSimulatedAccount() {
        return h.b((Object)simAccounts) ? null : (Account)simAccounts.a(0);
    }

    public static boolean isSimulatedAccount(String string) {
        for (Account account : simAccounts.a()) {
            if (!h.a((Object)account.getAccountID(), (Object)string)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSimulatedEnabled() {
        return simulatedEnabled;
    }

    public static void setSimulatedEnabled(boolean bl2) {
        simulatedEnabled = bl2;
    }

    public static boolean isTradeSimOnly() {
        return tradeSimOnly;
    }

    public static void setTradeSimOnly(boolean bl2) {
        tradeSimOnly = bl2;
    }

    public static boolean isFillMarketImmediate() {
        return fillMarketImmediate;
    }

    public static void setFillMarketImmediate(boolean bl2) {
        fillMarketImmediate = bl2;
    }

    public static boolean isIncludeCommissions() {
        return includeCommissions;
    }

    public static void setIncludeCommissions(boolean bl2) {
        includeCommissions = bl2;
    }

    public static void save() {
        h.c(new File(Workspace.findDir("account"), "account.json"), Account.write());
    }

    public static List getSimAccounts() {
        return simAccounts.a();
    }

    public static void setSimAccounts(List list) {
        simAccounts.d(list);
    }

    public static Account createSimAccount() {
        int n2 = 2;
        ArrayList arrayList = new ArrayList(Account.getSimAccounts());
        for (Account account : arrayList) {
            String string = account.getAccountID();
            int n3 = 1;
            if (string.indexOf("-") > 0) {
                n3 = h.b(string.substring(string.indexOf("-") + 1));
            }
            if (n3 < n2) continue;
            n2 = n3 + 1;
        }
        String string = "simulated-" + n2;
        return Account.createSimAccount(string);
    }

    public static Account createSimAccount(String string) {
        Account account = new Account(string);
        account.simulatedAccount = true;
        account.accountName = string;
        account.setBalance(100000.0);
        account.setBaseCurrency("USD");
        account.setInitialCashBalance(100000.0);
        account.setCashBalance(100000.0);
        return account;
    }

    public static void write(File file) {
        h.a(file, Account.write());
    }

    private static String write() {
        com.motivewave.common.util.ab ab2 = new com.motivewave.common.util.ab();
        ab2.put("v", "7");
        ab2.put("simEnabled", (Object)simulatedEnabled);
        ab2.put("tradeSimOnly", (Object)tradeSimOnly);
        if (!h.g(defaultAccountId)) {
            ab2.put("defaultAcct", defaultAccountId);
        }
        ab2.put("idCounter", (Object)uniqueCounter);
        ab2.put("fillMarketImmediate", (Object)fillMarketImmediate);
        ab2.put("includeCommissions", (Object)includeCommissions);
        ArrayList arrayList = new ArrayList();
        for (Object object : Account.getSimAccounts()) {
            Iterator iterator = new com.motivewave.common.util.ab();
            ((com.motivewave.common.util.ab)((Object)iterator)).put("id", ((Account)object).getAccountID());
            ((com.motivewave.common.util.ab)((Object)iterator)).put("name", ((Account)object).getAccountName());
            ((com.motivewave.common.util.ab)((Object)iterator)).put("cash", (Object)((Account)object).getBalance());
            ((com.motivewave.common.util.ab)((Object)iterator)).put("totalPL", (Object)((Account)object).getTotalPL());
            ((com.motivewave.common.util.ab)((Object)iterator)).put("baseCurrency", ((Account)object).getBaseCurrency());
            arrayList.add(iterator);
        }
        ab2.put("simAccounts", arrayList);
        ArrayList arrayList2 = new ArrayList();
        for (Iterator iterator : Account.getSimAccounts()) {
            for (Position position : Positions.byAccount(((Account)((Object)iterator)).getAccountID())) {
                arrayList2.add(position.toCSV());
            }
        }
        ab2.put("positions", arrayList2);
        if (!srvcId2ExecReq.isEmpty()) {
            Object object;
            object = new com.motivewave.common.util.ab();
            for (Map.Entry entry : srvcId2ExecReq.entrySet()) {
                if (entry.getValue() == null) continue;
                ((com.motivewave.common.util.ab)object).put((String)entry.getKey(), entry.getValue());
            }
            ab2.put("execReqs", object);
        }
        return w.a(ab2);
    }

    public static void read() {
        Account.read(Workspace.findFile("account"));
    }

    private static void read(File file) {
        try {
            Account account = Account.createSimAccount("simulated");
            simulatedEnabled = !bs.s() || !ai.g();
            tradeSimOnly = false;
            account.setDefault(simulatedEnabled);
            simAccounts.b();
            simAccounts.a((Object)account);
            if (file != null && file.exists()) {
                Object object;
                JSONObject jSONObject = new JSONObject(h.c(file));
                simulatedEnabled = jSONObject.is("simEnabled", false);
                tradeSimOnly = jSONObject.is("tradeSimOnly", false);
                defaultAccountId = jSONObject.str("defaultAcct");
                uniqueCounter = jSONObject.getLong("idCounter");
                fillMarketImmediate = jSONObject.is("fillMarketImmediate");
                includeCommissions = jSONObject.is("includeCommissions");
                if (!jSONObject.has("v")) {
                    account.setBaseCurrency(jSONObject.str("baseCurrency"));
                    account.setBalance(jSONObject.getDouble("cash"));
                    account.setCashBalance(jSONObject.getDouble("cash"));
                    account.setTotalPL(jSONObject.getDouble("totalPL"));
                } else if (jSONObject.has("simAccounts")) {
                    simAccounts.b();
                    for (Iterator iterator : jSONObject.getObjList("simAccounts")) {
                        Object object2 = Account.createSimAccount(((JSONObject)((Object)iterator)).str("id"));
                        ((Account)object2).setAccountName(((JSONObject)((Object)iterator)).str("name"));
                        ((Account)object2).setBaseCurrency(((JSONObject)((Object)iterator)).str("baseCurrency"));
                        ((Account)object2).setBalance(((JSONObject)((Object)iterator)).getDouble("cash"));
                        ((Account)object2).setCashBalance(((JSONObject)((Object)iterator)).getDouble("cash"));
                        ((Account)object2).setTotalPL(((JSONObject)((Object)iterator)).getDouble("totalPL"));
                        simAccounts.a(object2);
                    }
                    if (simAccounts.a()) {
                        simAccounts.a((Object)account);
                    }
                }
                if (jSONObject.has("positions")) {
                    object = new ArrayList();
                    if (jSONObject.has("v")) {
                        for (Object object2 : jSONObject.getStringList("positions")) {
                            try {
                                var6_7 = Position.fromCSV(a.a((String)object2));
                                if (var6_7 == null || var6_7.getInstrument() == null) continue;
                                ((ArrayList)object).add(var6_7);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    } else {
                        for (Object object2 : jSONObject.getObjList("positions")) {
                            try {
                                var6_7 = new Position((JSONObject)object2);
                                if (var6_7.getInstrument() == null || h.g(var6_7.getId())) continue;
                                ((ArrayList)object).add(var6_7);
                                Positions.created(var6_7);
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    Positions.register((List)object);
                }
                if (jSONObject.has("execReqs")) {
                    object = jSONObject.obj("execReqs");
                    srvcId2ExecReq.clear();
                    for (Object object2 : ((JSONObject)object).keySet()) {
                        srvcId2ExecReq.put(object2, ((JSONObject)object).getLong((String)object2));
                    }
                }
            }
            bs.i();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public static void updateSimCounter() {
        if (!Account.isSimulatedEnabled()) {
            return;
        }
        for (Account account : Account.getSimAccounts()) {
            for (ObservableBean observableBean : Positions.byAccount(account.getAccountID())) {
                Account.updateCounter(((Position)observableBean).getId());
            }
            for (ObservableBean observableBean : Executions.byAccount(account)) {
                String string = ((Execution)observableBean).getId();
                if (!string.startsWith("SIM-")) continue;
                Account.updateCounter(string);
                Account.updateCounter(((Execution)observableBean).getOrderId());
                Account.updateCounter(((Execution)observableBean).getPositionId());
            }
        }
    }

    public static void resetSimulatedAccount(Account account) {
        try {
            OrderDirectory.removeByAccount(account.getAccountID());
            Positions.removeByAccount(account.getAccountID());
            Executions.clearByAccount(account);
            if (simAccounts.a() <= 1) {
                uniqueCounter = 1L;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static void updateCounter(String string) {
        if (string == null || !string.startsWith("SIM-")) {
            return;
        }
        long l2 = h.c(h.q(string.substring(4)));
        if (l2 > uniqueCounter) {
            uniqueCounter = l2 + 1L;
        }
    }

    public static void loadTrades() {
        if (!Account.isSimulatedEnabled()) {
            return;
        }
        for (Account account : Account.getSimAccounts()) {
            Executions.register(Executions.byAccount(account));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genUniqueID() {
        String string = ID_SYNC;
        synchronized (string) {
            return "SIM-" + uniqueCounter++;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String genUniqueReplayID() {
        String string = ID_SYNC;
        synchronized (string) {
            return "RPLY-" + uniqueReplayCounter++;
        }
    }

    public static String getDefaultAccountID() {
        return defaultAccountId;
    }

    public static void setDefaultAccountID(String string) {
        defaultAccountId = string;
    }

    public static void setLastExecRequest(String string, long l2) {
        srvcId2ExecReq.put(string, h.l(l2));
    }

    public static long getLastExecRequest(String string) {
        Long l2 = (Long)srvcId2ExecReq.get(string);
        return l2 == null ? 0L : l2;
    }

    public static void clearExecReqs() {
        srvcId2ExecReq.clear();
    }

    static {
        simulatedEnabled = false;
        tradeSimOnly = false;
        fillMarketImmediate = true;
        includeCommissions = true;
        uniqueCounter = 1L;
        uniqueReplayCounter = 1L;
        ID_SYNC = new String(h.a());
        srvcId2ExecReq = Collections.synchronizedMap(new HashMap());
    }
}

