/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.common;

import com.motivewave.common.h;
import com.motivewave.platform.sdk.common.Enums;

public enum Enums$ServiceType {
    GOOGLE("Google/Yahoo"),
    AMP("AMP Global Clearing - Rithmic WS (Beta)", "AMP Global Clearing", "AMP", "https://www.ampfutures.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    AMP_RITHMIC_GATEWAY("AMP Global Clearing - Rithmic", "Edge Clear", "AMP", "https://edgeclear.com/", "", "HELP_RITHMIC", true, false),
    AMP_CQG("AMP Global Clearing - CQG", "AMP Global Clearing", "AMP", "https://www.ampfutures.com/", "https://vip.ampfutures.com/motivewave-cqg", "HELP_CQG_GENERIC", false, true),
    BARCHART("BarChart", "BarChart", "BC", "https://www.barchart.com/register/realtime/form.php?ID=MW", null, null, false, false),
    DXFEED("dxFeed", "dxFeed", "DX", "https://get.dxfeed.com/orders/new/motivewave", null, null, false, false),
    IQFEED("IQFeed"),
    TRADE_STATION("TradeStation"),
    SCHWAB("Schwab"),
    IB("Interactive Brokers", "IB", false, false),
    MEINTRADE("meinTrade.ch"),
    OPTIMUS("Optimus Trading Group - Rithmic", "Optimus Trading Group", "OTG", "https://optimusfutures.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    OPTIMUS_CQG("Optimus Trading Group - CQG", "Optimus Trading Group", "OTG", "https://optimusfutures.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    TRADIER("Tradier"),
    DEEP_DISCOUNT("Deep Discount Trading", "Deep Discount Trading", "DDT", "https://www.deepdiscounttrading.com", null, "HELP_RITHMIC_GENERIC", true, false),
    STAGE5_OEC("Stage Five Trading Corp", false, false),
    STAGE5_CQG("Stage Five Trading Corp - CQG", "Stage Five Trading Corp", "Stage5CQG", "https://stage5trading.com/", "https://stage5trading.com/web/s5demo/S5CQGDemoForm.html", "HELP_CQG_GENERIC", false, true),
    STAGE5("Stage Five Trading Corp - Rithmic", "Stage Five Trading Corp", "Stage5", "https://stage5trading.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    TF4L("Trade Futures 4 Less", "Trade Futures 4 Less", "TF4L", "https://tradefutures4less.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    TOP_STEP("Topstep", "Topstep", "TST", "https://www.topsteptrader.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    MES_CAPITAL("MES Capital", "MES Capital", "MES", "https://mescapitalgroup.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    TRADE_PRO_FUTURES("Trade Pro Futures", "Trade Pro Futures", "TP", "https://tradeprofutures.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    FOREX("FOREX.com"),
    RITHMIC_GATEWAY("Rithmic", "Rithmic", "RN", "https://www.rithmic.com", "", "HELP_RITHMIC", true, false),
    RITHMIC("Rithmic WS (Beta)", "Rithmic", "Rithmic", "https://www.rithmic.com", "", "HELP_RITHMIC_WS", true, false),
    CTS("CTS", "CTS", "CTS", "https://futures-technologies.plus500.com/", "", "HELP_CTS", false, false, true),
    BERKLEY_FUTURES("Berkley Futures", "Berkley Futures", "BF", "https://www.bfl.co.uk/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    UNITED_FUTURES("United Futures - CQG", "United Futures", "UF", "https://www.unitedfutures.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    UNITED_FUTURES_RITHMIC("United Futures - Rithmic", "United Futures", "UFR", "https://www.unitedfutures.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    ZYTRADE("Zytrade", "Zytrade Futures", "ZT", "https://www.zytrade.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    GFF("GFF Brokers - Rithmic", "GFF Brokers", "GFFR", "https://www.gffbrokers.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    CANNON("Cannon Trading - Rithmic", "Cannon Trading", "CANNON", "https://www.cannontrading.com/", null, "HELP_RITHMIC_GENERIC", true, false),
    CANNON_CQG("Cannon Trading - CQG", "Cannon Trading", "CANNON", "https://www.cannontrading.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    ITG_CQG("ITG Futures - CQG", "ITG Futures", "ITG", "https://itg-futures.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    ITG_RITHMIC("ITG Futures - Rithmic", "ITG Futures", "ITG", "https://itg-futures.com/", "", "HELP_RITHMIC_GENERIC", true, false),
    EC_CQG("Edge Clear - CQG", "Edge Clear", "EC", "https://edgeclear.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    EC_RITHMIC("Edge Clear - Rithmic WS (Beta)", "Edge Clear", "EC", "https://edgeclear.com/", "", "HELP_RITHMIC_GENERIC", true, false),
    EC_RITHMIC_GATEWAY("Edge Clear - Rithmic", "Edge Clear", "RN", "https://edgeclear.com/", "", "HELP_RITHMIC", true, false),
    EC_CTS("Edge Clear - CTS", "Edge Clear", "EC", "https://edgeclear.com/", "", "HELP_CTS", false, false, true),
    IRB_CQG("IronBeam - CQG", "IronBeam", "IRB", "https://www.ironbeam.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    IRB_RITHMIC("IronBeam - Rithmic", "IronBeam", "IRB", "https://www.ironbeam.com/", "", "HELP_RITHMIC_GENERIC", true, false),
    DORMAN_CQG("Dorman Trading", "Dorman Trading", "Dorman", "https://www.dormantrading.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    DAW_CQG("DAW Trading", "DAW Trading", "DAW", "https://dawtradingdiv.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    DT("Discount Trading", "Discount Trading", "DT", "https://www.discounttrading.com/", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG_GENERIC", false, true),
    GFF_CQG("GFF Brokers - CQG", "GFF Brokers", "GFF", "https://www.gffbrokers.com/", "https://demo.cqgtrader.com/demorequest/sigma360/", "HELP_CQG_GENERIC", false, true),
    CQG("CQG", "CQG", "CQG", "https://www.cqg.com", "https://demo.cqgtrader.com/demorequest/motivewave/", "HELP_CQG", false, true),
    FXCM("FXCM"),
    FXCM2("FXCM2"),
    SAXO_BANK("Saxo Bank"),
    CRYPTO_COMPARE("CryptoCompare"),
    GLOBAL_DATA_FEEDS("Global Data Feeds"),
    TRUEDATA("TrueData"),
    BINANCE("Binance", "Binance", "BN", "https://www.binance.com", null, "HELP_BINANCE", false, false),
    BINANCE_FUTURES("Binance Futures", "Binance", "BF", "https://www.binance.com/en/futures", null, "HELP_BINANCE_FUTURES", false, false),
    KRAKEN("Kraken", "Kraken", "KN", "https://www.kraken.com", null, "HELP_KRAKEN", false, false),
    KRAKEN_FUTURES("Kraken Futures", "Kraken", "KF", "https://futures.kraken.com", null, "HELP_KRAKEN_FUTURES", false, false),
    COINBASE_ADV("Coinbase", "Coinbase", "CB", "https://www.coinbase.com/", null, "HELP_COINBASE", false, false),
    IG("IG Markets"),
    TASTY_TRADE("TastyTrade"),
    METASTOCK("Metastock Xenith"),
    OANDAV20("OANDAV20"),
    BITSTAMP("Bitstamp", "Bitstamp", "BS", "https://www.bitstamp.com", null, "HELP_BITSTAMP", false, false),
    QUESTRADE("Questrade"),
    QUOTE_MEDIA("QuoteMedia");

    private String label;
    private String shortName;
    private String companyName;
    private String websiteUrl;
    private String demoUrl;
    private String help;
    private boolean rithmic = false;
    private boolean cqg = false;
    private boolean cts = false;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Enums$ServiceType() {
        this((String)var1_-1, (int)var2_-1, (String)var3_2, false, false);
        void var3_2;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Enums$ServiceType(boolean bl2, boolean bl3) {
        this((String)var1_-1, (int)var2_-1, (String)bl2, (String)bl2, (String)bl3, "", "", "", (boolean)var5_3, (boolean)var6_4);
        void var6_4;
        void var5_3;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Enums$ServiceType(boolean bl2) {
        this((String)var1_-1, (int)var2_-1, (String)bl2, (String)bl2, "", "", "", "", (boolean)var4_2, (boolean)var5_3);
        void var5_3;
        void var4_2;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Enums$ServiceType(String string3, String string4, String string5, String string6, boolean bl2, boolean bl3) {
        this((String)var1_-1, (int)var2_-1, string3, string4, string5, string6, (String)bl2, (String)bl3, (boolean)var9_7, (boolean)var10_8, false);
        void var10_8;
        void var9_7;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Enums$ServiceType(String string3, String string4, String string5, String string6, boolean bl2, boolean bl3, boolean bl4) {
        void var11_9;
        void var10_8;
        this.label = string3;
        this.shortName = string5;
        this.companyName = string4;
        this.websiteUrl = string6;
        this.demoUrl = (String)bl2;
        this.help = (String)bl3;
        this.rithmic = bl4;
        this.cqg = var10_8;
        this.cts = var11_9;
    }

    public Enums.Service getService() {
        return switch (this.ordinal()) {
            case 9 -> Enums.Service.IB;
            case 10 -> Enums.Service.IB;
            case 46 -> Enums.Service.FXCM;
            case 22 -> Enums.Service.FOREX;
            case 0 -> Enums.Service.GOOGLE;
            case 4 -> Enums.Service.BARCHART;
            case 5 -> Enums.Service.DXFEED;
            case 6 -> Enums.Service.IQFEED;
            case 59 -> Enums.Service.METASTOCK;
            case 7 -> Enums.Service.TRADE_STATION;
            case 13 -> Enums.Service.TRADIER;
            case 62 -> Enums.Service.QUESTRADE;
            case 14 -> Enums.Service.DEEP_DISCOUNT;
            case 15 -> Enums.Service.STAGE5;
            case 17 -> Enums.Service.STAGE5;
            case 18 -> Enums.Service.TF4L;
            case 19 -> Enums.Service.TOP_STEP;
            case 21 -> Enums.Service.TRADE_PRO_FUTURES;
            case 11 -> Enums.Service.OPTIMUS;
            case 1 -> Enums.Service.AMP;
            case 3 -> Enums.Service.AMP;
            case 41 -> Enums.Service.DORMAN;
            case 42 -> Enums.Service.DAW;
            case 43 -> Enums.Service.DT;
            case 45 -> Enums.Service.CQG;
            case 25 -> Enums.Service.CTS;
            case 60 -> Enums.Service.OANDA;
            case 24 -> Enums.Service.RITHMIC;
            case 23 -> Enums.Service.RITHMIC;
            case 37 -> Enums.Service.RITHMIC;
            case 48 -> Enums.Service.SAXO_BANK;
            case 49 -> Enums.Service.CRYPTO_COMPARE;
            case 54 -> Enums.Service.KRAKEN;
            case 55 -> Enums.Service.KRAKEN_FUTURES;
            case 52 -> Enums.Service.BINANCE;
            case 53 -> Enums.Service.BINANCE_FUTURES;
            case 61 -> Enums.Service.BITSTAMP;
            case 35, 36, 38 -> Enums.Service.EDGE_CLEAR;
            case 50 -> Enums.Service.GLOBAL_DATA_FEEDS;
            case 51 -> Enums.Service.TRUEDATA;
            default -> null;
        };
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getWebsiteUrl() {
        return this.websiteUrl;
    }

    public String getDemoUrl() {
        return this.demoUrl;
    }

    public String getShortName() {
        return this.shortName;
    }

    public String getHelp() {
        return this.help;
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        if (this == RITHMIC_GATEWAY) {
            return "RITHMIC";
        }
        return this.getBaseService().name();
    }

    public String toString() {
        return this.label;
    }

    public boolean isWindowsOnly() {
        return h.a((Object)this, new Object[]{METASTOCK, STAGE5_OEC});
    }

    public boolean supportsMultiple() {
        return this.isRithmic() || this.isCQG() || h.a((Object)this, new Object[]{RITHMIC, CQG, IB, CTS, KRAKEN, KRAKEN_FUTURES, COINBASE_ADV, BINANCE, BINANCE_FUTURES, FOREX, FXCM, FXCM2, SCHWAB, TRADE_STATION, TRADIER});
    }

    public static Enums$ServiceType read(String string) {
        if (h.g(string)) {
            return null;
        }
        if (h.a((Object)string, (Object)"Interactive Brokers")) {
            return IB;
        }
        if (h.a((Object)string, (Object)"IQFeed")) {
            return IQFEED;
        }
        if (h.a((Object)string, (Object)"BarChart")) {
            return BARCHART;
        }
        if (h.a((Object)string, (Object)"FXCM")) {
            return FXCM;
        }
        if (h.a((Object)string, (Object)"GAIN_FX")) {
            return FOREX;
        }
        if (h.a((Object)string, (Object)"Forex")) {
            return FOREX;
        }
        if (h.a((Object)string, (Object)"Forex (Auto EX)")) {
            return FOREX;
        }
        if (h.a((Object)string, (Object)"Google/Yahoo")) {
            return GOOGLE;
        }
        if (h.a((Object)string, (Object)"OANDA")) {
            return OANDAV20;
        }
        if (h.a((Object)string, (Object)"RWS")) {
            return RITHMIC;
        }
        if (h.a((Object)string, (Object)"TRADOVATE")) {
            return CQG;
        }
        if (h.a((Object)string, (Object)"DIRECTFX")) {
            return CQG;
        }
        if (h.a((Object)string, (Object)"STOCKWATCH")) {
            return null;
        }
        try {
            return Enums$ServiceType.valueOf(string);
        }
        catch (Exception exception) {
            h.a.warning("ServiceType::read() unable to read service type: " + string);
            return null;
        }
    }

    public boolean isIB() {
        return this == IB || this == MEINTRADE;
    }

    public boolean isFXCM() {
        return this == FXCM || this == FXCM2;
    }

    public boolean isRithmic() {
        return this.rithmic;
    }

    public boolean isCQG() {
        return this.cqg;
    }

    public boolean isCTS() {
        return this.cts;
    }

    public boolean is2DigitYear() {
        if (this.isCQG()) {
            return true;
        }
        return h.a((Object)this, new Object[]{IQFEED, BARCHART, TRADE_STATION, METASTOCK, DXFEED, CTS});
    }

    public boolean isCompatible(Enums$ServiceType enums$ServiceType) {
        if (enums$ServiceType == null) {
            return false;
        }
        if (enums$ServiceType == this) {
            return true;
        }
        if (this.rithmic && enums$ServiceType.rithmic) {
            return true;
        }
        if (this.cqg && enums$ServiceType.cqg) {
            return true;
        }
        return this.isIB() && enums$ServiceType.isIB();
    }

    public Enums$ServiceType getBaseService() {
        if (this.isCTS()) {
            return CTS;
        }
        if (this.isCQG()) {
            return CQG;
        }
        if (this.isFXCM()) {
            return FXCM;
        }
        if (this == RITHMIC_GATEWAY || this == EC_RITHMIC_GATEWAY) {
            return RITHMIC_GATEWAY;
        }
        if (this.isRithmic()) {
            return RITHMIC;
        }
        if (this.isIB()) {
            return IB;
        }
        return this;
    }

    public static boolean isCompatible(Enums$ServiceType enums$ServiceType, Enums$ServiceType enums$ServiceType2) {
        if (enums$ServiceType == null || enums$ServiceType2 == null) {
            return true;
        }
        return enums$ServiceType.isCompatible(enums$ServiceType2);
    }

    public boolean isSymbolUnique() {
        if (this.isCQG() || this.isFXCM() || this.isCTS()) {
            return true;
        }
        if (this.isIB() || this.isRithmic()) {
            return false;
        }
        return h.a((Object)this, new Object[]{OANDAV20, BARCHART, IG, IQFEED, BITSTAMP, BINANCE, BINANCE_FUTURES, KRAKEN, KRAKEN_FUTURES, COINBASE_ADV, TRADE_STATION, TRADIER, QUESTRADE, FOREX, METASTOCK});
    }
}

