/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.common;

import com.motivewave.common.h;
import com.motivewave.platform.common.Enums;
import com.motivewave.platform.sdk.common.ItemMeta;

public enum Enums$InstrumentType implements ItemMeta
{
    STOCK("S"),
    FUTURE("F", true, false, true),
    INDEX("I"),
    INDICATOR("IND"),
    CASH("FX"),
    CURRENCY_OPTION("CO", false, true, true),
    OPTION("O", false, true, true),
    FUTURE_OPTION("FO", false, true, true),
    INDEX_OPTION("IO", false, true, true),
    COMMODITY("CMDY"),
    MUTUAL_FUND("MF"),
    BOND("B"),
    MM_FUND("MMF"),
    MKTSTATS("MS"),
    SPREAD("SP"),
    SPOT("SPT"),
    FORWARD("FWD"),
    CALC("CAL"),
    STRIP("STRP"),
    SS_FUTURE("SSF"),
    FUTDEPTH("FD"),
    PRECMTL("P"),
    SPRDEPTH("SD"),
    EQTYDEPTH("ED"),
    ICSSPREAD("IS"),
    STRATSPREAD("SS"),
    TREASURIES("T"),
    SWAPS("SW"),
    CFD("CFD"),
    WARRANT("W"),
    CRYPTO_CURRENCY("CC"),
    CRYPTO_SCFUT("CSCF"),
    CRYPTO_MCFUT("CMCF"),
    CONT_FUTURE("CT", true, false, true),
    CUSTOM("CUST"),
    CUSTOM_CONTINUOUS("CCF"),
    UNKNOWN("U"),
    PRODUCT("PROD"),
    FUTURE_STRATEGY("FS"),
    EQUITY_STRATEGY("ES"),
    SYNTHETIC("SYN");

    private String label = Enums.a("IT_" + this.name(), new Object[0]);
    private String shortCode;
    private boolean option;
    private boolean future;
    private boolean expiry;

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Enums$InstrumentType() {
        this((String)var1_-1, (int)var2_-1, (String)var3_2, false, false, false);
        void var3_2;
        void var2_-1;
        void var1_-1;
    }

    /*
     * WARNING - Possible parameter corruption
     * WARNING - void declaration
     */
    private Enums$InstrumentType(boolean bl2, boolean bl3) {
        void var6_4;
        void var5_3;
        this.shortCode = (String)bl2;
        this.option = var5_3;
        this.future = bl3;
        this.expiry = var6_4;
    }

    public Enums$InstrumentType getOptionRoot() {
        return switch (this.ordinal()) {
            case 6 -> STOCK;
            case 7 -> FUTURE;
            case 5 -> CASH;
            case 8 -> INDEX;
            default -> this;
        };
    }

    public Enums$InstrumentType getOptionType() {
        return switch (this.ordinal()) {
            case 0 -> OPTION;
            case 6 -> OPTION;
            case 1 -> FUTURE_OPTION;
            case 7 -> FUTURE_OPTION;
            case 5 -> CURRENCY_OPTION;
            case 4 -> CURRENCY_OPTION;
            case 8 -> INDEX_OPTION;
            case 2 -> INDEX_OPTION;
            default -> null;
        };
    }

    public boolean isCrypto() {
        return this == CRYPTO_CURRENCY || this == CRYPTO_MCFUT || this == CRYPTO_SCFUT;
    }

    public boolean isOption() {
        return this.option;
    }

    public boolean isFuture() {
        return this.future;
    }

    public boolean hasExpiry() {
        return this.expiry;
    }

    public String getShortCode() {
        return this.shortCode;
    }

    public String toString() {
        return this.label;
    }

    public static Enums$InstrumentType read(String string) {
        if (h.g(string)) {
            return STOCK;
        }
        string = h.a(string, "\"", "");
        string = h.a(string, "'", "");
        string = h.q(string).toUpperCase();
        string = h.a(string, " ", "_");
        try {
            return switch (string) {
                case "STK", "EQUITY" -> STOCK;
                case "FUT" -> FUTURE;
                case "CASH", "FOREX", "FX" -> CASH;
                case "CMDY" -> COMMODITY;
                case "OPT", "STOCK OPTION", "STOCKOPTION" -> OPTION;
                case "FUTURE OPTION", "FUTUREOPTION" -> FUTURE_OPTION;
                default -> Enums$InstrumentType.valueOf(string);
            };
        }
        catch (Exception exception) {
            Enums$InstrumentType enums$InstrumentType = Enums$InstrumentType.fromShortCode(string);
            if (enums$InstrumentType != null && enums$InstrumentType != UNKNOWN) {
                return enums$InstrumentType;
            }
            if (string.startsWith("CRYPTO")) {
                return CRYPTO_CURRENCY;
            }
            return STOCK;
        }
    }

    public static Enums$InstrumentType fromShortCode(String string) {
        return switch (string) {
            case "S" -> STOCK;
            case "F" -> FUTURE;
            case "I" -> INDEX;
            case "IND" -> INDICATOR;
            case "FX" -> CASH;
            case "O" -> OPTION;
            case "CO" -> CURRENCY_OPTION;
            case "FO" -> FUTURE_OPTION;
            case "IO" -> INDEX_OPTION;
            case "CMDY" -> COMMODITY;
            case "MF" -> MUTUAL_FUND;
            case "B" -> BOND;
            case "MMF" -> MM_FUND;
            case "MS" -> MKTSTATS;
            case "SP" -> SPREAD;
            case "SPT" -> SPOT;
            case "FWD" -> FORWARD;
            case "CAL" -> CALC;
            case "STRP" -> STRIP;
            case "SSF" -> SS_FUTURE;
            case "FD" -> FUTDEPTH;
            case "P" -> PRECMTL;
            case "SD" -> SPRDEPTH;
            case "ED" -> EQTYDEPTH;
            case "IS" -> ICSSPREAD;
            case "SS" -> STRATSPREAD;
            case "T" -> TREASURIES;
            case "SW" -> SWAPS;
            case "CFD" -> CFD;
            case "W" -> WARRANT;
            case "GI" -> INDEX;
            case "CUST" -> CUSTOM;
            case "CCF" -> CUSTOM_CONTINUOUS;
            case "CC" -> CRYPTO_CURRENCY;
            case "CSCF" -> CRYPTO_SCFUT;
            case "CMCF" -> CRYPTO_MCFUT;
            case "CT" -> CONT_FUTURE;
            case "U" -> UNKNOWN;
            case "PROD" -> PRODUCT;
            case "FS" -> FUTURE_STRATEGY;
            case "ES" -> EQUITY_STRATEGY;
            case "SYN" -> SYNTHETIC;
            default -> UNKNOWN;
        };
    }
}

