/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.platform.common;

import com.motivewave.platform.common.Enums;
import com.motivewave.platform.databean.MWInstrument;
import com.motivewave.platform.service.bs;

public enum Enums$AlertInput {
    LAST_PRICE,
    BID_PRICE,
    ASK_PRICE,
    DAY_HIGH,
    DAY_LOW,
    DAY_OPEN,
    DAY_CLOSE,
    HIGH_YEAR,
    LOW_YEAR,
    HIGH_52_WEEK,
    LOW_52_WEEK,
    HIGH_26_WEEK,
    LOW_26_WEEK,
    HIGH_13_WEEK,
    LOW_13_WEEK,
    DAY_VOLUME,
    SETTLE;

    private String label = Enums.a("AI_" + this.name(), new Object[0]);

    public String toString() {
        return this.label;
    }

    public boolean isSupported(MWInstrument mWInstrument) {
        if (this == LAST_PRICE && !bs.n(mWInstrument)) {
            return false;
        }
        if (this == SETTLE && !bs.K()) {
            return false;
        }
        if (this == DAY_HIGH && !bs.a(mWInstrument, "high")) {
            return false;
        }
        if (this == DAY_LOW && !bs.a(mWInstrument, "low")) {
            return false;
        }
        if (this == DAY_OPEN && !bs.a(mWInstrument, "open")) {
            return false;
        }
        if (this == HIGH_YEAR && !bs.a(mWInstrument, "highCalendarYear")) {
            return false;
        }
        if (this == LOW_YEAR && !bs.a(mWInstrument, "lowCalendarYear")) {
            return false;
        }
        if (this == HIGH_52_WEEK && !bs.a(mWInstrument, "high52Week")) {
            return false;
        }
        if (this == LOW_52_WEEK && !bs.a(mWInstrument, "low52Week")) {
            return false;
        }
        if (this == HIGH_26_WEEK && !bs.a(mWInstrument, "high26Week")) {
            return false;
        }
        if (this == LOW_26_WEEK && !bs.a(mWInstrument, "low26Week")) {
            return false;
        }
        if (this == HIGH_13_WEEK && !bs.a(mWInstrument, "high13Week")) {
            return false;
        }
        if (this == LOW_13_WEEK && !bs.a(mWInstrument, "low13Week")) {
            return false;
        }
        return this != DAY_VOLUME || bs.a(mWInstrument, "dayVolume");
    }

    public String getTickerProperty() {
        return switch (this.ordinal()) {
            case 2 -> "askPrice";
            case 0 -> "lastPrice";
            case 1 -> "bidPrice";
            case 3 -> "high";
            case 4 -> "low";
            case 5 -> "open";
            case 6 -> "close";
            case 7 -> "highCalendarYear";
            case 8 -> "lowCalendarYear";
            case 9 -> "high52Week";
            case 10 -> "low52Week";
            case 11 -> "high26Week";
            case 12 -> "low26Week";
            case 13 -> "high13Week";
            case 14 -> "low13Week";
            case 15 -> "dayVolume";
            case 16 -> "settle";
            default -> null;
        };
    }

    public static Enums$AlertInput fromTickerProperty(String string) {
        return switch (string) {
            case "askPrice" -> ASK_PRICE;
            case "lastPrice" -> LAST_PRICE;
            case "bidPrice" -> BID_PRICE;
            case "high" -> DAY_HIGH;
            case "low" -> DAY_LOW;
            case "open" -> DAY_OPEN;
            case "close" -> DAY_CLOSE;
            case "highCalendarYear" -> HIGH_YEAR;
            case "lowCalendarYear" -> LOW_YEAR;
            case "high52Week" -> HIGH_52_WEEK;
            case "low52Week" -> LOW_52_WEEK;
            case "high26Week" -> HIGH_26_WEEK;
            case "low26Week" -> LOW_26_WEEK;
            case "high13Week" -> HIGH_13_WEEK;
            case "low13Week" -> LOW_13_WEEK;
            case "dayVolume" -> DAY_VOLUME;
            case "settle" -> SETTLE;
            default -> null;
        };
    }
}

