/*
 * Decompiled with CFR 0.152.
 */
package com.motivewave.common.ui.fx.chart;

import com.motivewave.common.h;
import com.motivewave.common.ui.fx.chart.DateAxis$Interval;
import com.motivewave.common.ui.fx.chart.b;
import com.motivewave.common.ui.fx.chart.c;
import com.motivewave.common.ui.fx.chart.d;
import com.motivewave.common.ui.fx.chart.e;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.beans.property.LongProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleLongProperty;
import javafx.beans.value.WritableValue;
import javafx.scene.Parent;
import javafx.scene.chart.Axis;
import javafx.util.Duration;
import javafx.util.StringConverter;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DateAxis
extends Axis {
    private final LongProperty a;
    private final LongProperty b;
    private final ObjectProperty a;
    private LocalDateTime a;
    private LocalDateTime b;
    private ObjectProperty b;
    private ObjectProperty c;
    private b a;
    private Object a;
    private DateAxis$Interval a;

    public DateAxis() {
        this("", LocalDateTime.now(), LocalDateTime.now().plusHours(1L), true);
    }

    public DateAxis(boolean bl2) {
        this("", LocalDateTime.now(), LocalDateTime.now().plusHours(1L), bl2);
    }

    public DateAxis(LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        this("", localDateTime, localDateTime2, true);
    }

    public DateAxis(LocalDateTime localDateTime, LocalDateTime localDateTime2, boolean bl2) {
        this("", localDateTime, localDateTime2, bl2);
    }

    public DateAxis(String string, LocalDateTime localDateTime, LocalDateTime localDateTime2, boolean bl2) {
        if (localDateTime.isAfter(localDateTime2)) {
            throw new IllegalArgumentException("Lower bound must be before upper bound!!!");
        }
        this.a = new SimpleLongProperty((Object)this, "currentLowerBound");
        this.b = new SimpleLongProperty((Object)this, "currentUpperBound");
        this.a = new c(this);
        this.b = new d(this, localDateTime);
        this.c = new e(this, localDateTime2);
        this.a = new b((Parent)this);
        this.a = DateAxis$Interval.DECADE;
        this.setLabel(string);
        this.setAutoRanging(bl2);
    }

    protected Object getRange() {
        return new Object[]{this.a(), this.b()};
    }

    protected void setRange(Object object, boolean bl2) {
        Object[] objectArray = (Object[])object;
        LocalDateTime localDateTime = this.a();
        LocalDateTime localDateTime2 = this.b();
        LocalDateTime localDateTime3 = (LocalDateTime)objectArray[0];
        LocalDateTime localDateTime4 = (LocalDateTime)objectArray[1];
        this.a(localDateTime3);
        this.b(localDateTime4);
        if (bl2) {
            this.a.a(this.a);
            this.a = this.a.a(new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)this.a, (Object)this.a(localDateTime)), new KeyValue((WritableValue)this.b, (Object)this.a(localDateTime2))}), new KeyFrame(Duration.millis((double)700.0), new KeyValue[]{new KeyValue((WritableValue)this.a, (Object)this.a(localDateTime3)), new KeyValue((WritableValue)this.b, (Object)this.a(localDateTime4))}));
        } else {
            this.a.set(this.a(this.a()));
            this.b.set(this.a(this.b()));
        }
    }

    public void invalidateRange(List list) {
        super.invalidateRange(list);
        h.b(list);
        if (list.isEmpty()) {
            this.a = this.b = LocalDateTime.now();
        } else if (list.size() == 1) {
            this.a = this.b = (LocalDateTime)list.get(0);
        } else if (list.size() > 1) {
            this.a = (LocalDateTime)list.get(0);
            this.b = (LocalDateTime)list.get(list.size() - 1);
        }
    }

    protected Object autoRange(double d2) {
        if (this.isAutoRanging()) {
            return new Object[]{this.a, this.b};
        }
        if (null == this.a() || null == this.b()) {
            throw new IllegalArgumentException("If autoRanging is false, a lower and upper bound must be set.");
        }
        return this.getRange();
    }

    public double getZeroPosition() {
        return 0.0;
    }

    public double a(LocalDateTime localDateTime) {
        double d2 = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double d3 = this.b.get() - this.a.get();
        double d4 = d2 - this.getZeroPosition();
        double d5 = (double)(this.a(localDateTime) - this.a.get()) / d3;
        if (this.getSide().isVertical()) {
            return this.getHeight() - d5 * d4 + this.getZeroPosition();
        }
        return d5 * d4 + this.getZeroPosition();
    }

    public LocalDateTime a(double d2) {
        double d3 = this.getSide().isHorizontal() ? this.getWidth() : this.getHeight();
        double d4 = this.b.get() - this.a.get();
        double d5 = d3 - this.getZeroPosition();
        Instant instant = this.getSide().isVertical() ? Instant.ofEpochMilli((long)((d2 - this.getZeroPosition() - this.getHeight()) / -d5 * d4 + (double)this.a.get())) : Instant.ofEpochMilli((long)((d2 - this.getZeroPosition()) / d5 * d4 + (double)this.a.get()));
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public boolean a(LocalDateTime localDateTime) {
        return this.a(localDateTime) > this.a.get() && this.a(localDateTime) < this.b.get();
    }

    protected List calculateTickValues(double d2, Object object) {
        Object[] objectArray = (Object[])object;
        LocalDateTime localDateTime = (LocalDateTime)objectArray[0];
        LocalDateTime localDateTime2 = (LocalDateTime)objectArray[1];
        ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
        LocalDateTime localDateTime3 = LocalDateTime.now();
        double d3 = 100.0;
        double d4 = d2 / d3;
        ArrayList<LocalDateTime> arrayList2 = new ArrayList<LocalDateTime>();
        DateAxis$Interval dateAxis$Interval = DateAxis$Interval.values()[0];
        for (DateAxis$Interval object2 : DateAxis$Interval.values()) {
            localDateTime3 = LocalDateTime.of(localDateTime.toLocalDate(), localDateTime.toLocalTime());
            arrayList.clear();
            arrayList2.clear();
            this.a = object2;
            while (localDateTime3.isBefore(localDateTime2)) {
                arrayList.add(localDateTime3);
                localDateTime3 = localDateTime3.plus(object2.AMOUNT, object2.INTERVAL);
            }
            if ((double)arrayList.size() > d4) {
                localDateTime3 = LocalDateTime.of(localDateTime.toLocalDate(), localDateTime.toLocalTime());
                while (localDateTime3.isBefore(localDateTime2) || localDateTime3.isEqual(localDateTime2)) {
                    arrayList2.add(localDateTime3);
                    localDateTime3 = localDateTime3.plus(dateAxis$Interval.AMOUNT, dateAxis$Interval.INTERVAL);
                }
                break;
            }
            dateAxis$Interval = object2;
        }
        if ((double)arrayList2.size() - d4 > d4 - (double)arrayList.size()) {
            arrayList = arrayList2;
            this.a = dateAxis$Interval;
        }
        arrayList.add(localDateTime2);
        List list = this.a(arrayList);
        if (list.size() > 2) {
            LocalDateTime localDateTime4 = (LocalDateTime)list.get(1);
            LocalDateTime localDateTime5 = (LocalDateTime)list.get(2);
            LocalDateTime localDateTime6 = (LocalDateTime)list.get(arrayList.size() - 2);
            LocalDateTime localDateTime7 = (LocalDateTime)list.get(arrayList.size() - 3);
            if ((double)(localDateTime4.toEpochSecond(ZoneOffset.ofHours(0)) - localDateTime.toEpochSecond(ZoneOffset.ofHours(0))) < (double)(localDateTime5.toEpochSecond(ZoneOffset.ofHours(0)) - localDateTime4.toEpochSecond(ZoneOffset.ofHours(0))) * 0.5) {
                list.remove(localDateTime4);
            }
            if ((double)(localDateTime2.toEpochSecond(ZoneOffset.ofHours(0)) - localDateTime6.toEpochSecond(ZoneOffset.ofHours(0))) < (double)(localDateTime6.toEpochSecond(ZoneOffset.ofHours(0)) - localDateTime7.toEpochSecond(ZoneOffset.ofHours(0))) * 0.5) {
                list.remove(localDateTime6);
            }
        }
        return list;
    }

    protected void layoutChildren() {
        if (!this.isAutoRanging()) {
            this.a.set(this.a(this.a()));
            this.b.set(this.a(this.b()));
        }
        super.layoutChildren();
    }

    protected String a(LocalDateTime localDateTime) {
        DateTimeFormatter dateTimeFormatter;
        StringConverter stringConverter = this.a();
        if (stringConverter != null) {
            return stringConverter.toString((Object)localDateTime);
        }
        LocalDateTime localDateTime2 = LocalDateTime.of(localDateTime.toLocalDate(), localDateTime.toLocalTime());
        if (this.a.INTERVAL == ChronoUnit.YEARS && localDateTime2.getMonthValue() == 0 && localDateTime2.getDayOfMonth() == 1) {
            dateTimeFormatter = DateTimeFormatter.ofPattern("yyyy");
        } else if (this.a.INTERVAL == ChronoUnit.MONTHS && localDateTime2.getDayOfMonth() == 1) {
            dateTimeFormatter = DateTimeFormatter.ofPattern("MMMM yy");
        } else {
            switch (this.a.INTERVAL) {
                default: {
                    dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
                    break;
                }
                case HOURS: 
                case MINUTES: {
                    dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT);
                    break;
                }
                case SECONDS: {
                    dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM);
                    break;
                }
                case MILLIS: {
                    dateTimeFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.FULL);
                }
            }
        }
        return dateTimeFormatter.format(localDateTime);
    }

    private List a(List list) {
        if (list.size() > 2) {
            ArrayList<LocalDateTime> arrayList = new ArrayList<LocalDateTime>();
            for (int i2 = 0; i2 < list.size(); ++i2) {
                LocalDateTime localDateTime = (LocalDateTime)list.get(i2);
                switch (this.a.INTERVAL) {
                    case YEARS: {
                        if (i2 != 0 && i2 != list.size() - 1) {
                            localDateTime = localDateTime.withMonth(1).withDayOfMonth(1);
                        }
                        localDateTime = localDateTime.withHour(0).withMinute(0).withSecond(0).withNano(6000000);
                        break;
                    }
                    case MONTHS: {
                        if (i2 != 0 && i2 != list.size() - 1) {
                            localDateTime = localDateTime.withDayOfMonth(1);
                        }
                        localDateTime = localDateTime.withHour(0).withMinute(0).withSecond(0).withNano(5000000);
                        break;
                    }
                    case WEEKS: {
                        localDateTime = localDateTime.withHour(0).withMinute(0).withSecond(0).withNano(4000000);
                        break;
                    }
                    case DAYS: {
                        localDateTime = localDateTime.withHour(0).withMinute(0).withSecond(0).withNano(3000000);
                        break;
                    }
                    case HOURS: {
                        if (i2 != 0 && i2 != list.size() - 1) {
                            localDateTime = localDateTime.withSecond(0);
                        }
                        localDateTime = localDateTime.withNano(2000000);
                        break;
                    }
                    case MINUTES: {
                        localDateTime = localDateTime.withNano(1000000);
                        break;
                    }
                    case SECONDS: {
                        localDateTime = localDateTime.withSecond(0);
                        break;
                    }
                }
                arrayList.add(localDateTime);
            }
            return arrayList;
        }
        return list;
    }

    public final LocalDateTime a() {
        return (LocalDateTime)this.b.get();
    }

    public final void a(LocalDateTime localDateTime) {
        this.b.set((Object)localDateTime);
    }

    public final ObjectProperty a() {
        return this.b;
    }

    public final LocalDateTime b() {
        return (LocalDateTime)this.c.get();
    }

    public final void b(LocalDateTime localDateTime) {
        this.c.set((Object)localDateTime);
    }

    public final ObjectProperty b() {
        return this.c;
    }

    public final StringConverter a() {
        return (StringConverter)this.a.getValue();
    }

    public final void a(StringConverter stringConverter) {
        this.a.setValue((Object)stringConverter);
    }

    public final ObjectProperty c() {
        return this.a;
    }

    public double b(LocalDateTime localDateTime) {
        return this.a(localDateTime);
    }

    public LocalDateTime b(double d2) {
        return this.a((long)d2);
    }

    private long a(LocalDateTime localDateTime) {
        ZoneOffset zoneOffset = localDateTime.atZone(ZoneId.systemDefault()).getOffset();
        return localDateTime.toInstant(zoneOffset).getEpochSecond() * 1000L;
    }

    private LocalDateTime a(long l2) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(l2), ZoneId.systemDefault());
    }

    protected /* synthetic */ String getTickMarkLabel(Object object) {
        return this.a((LocalDateTime)object);
    }

    public /* synthetic */ Object toRealValue(double d2) {
        return this.b(d2);
    }

    public /* synthetic */ double toNumericValue(Object object) {
        return this.b((LocalDateTime)object);
    }

    public /* synthetic */ boolean isValueOnAxis(Object object) {
        return this.a((LocalDateTime)object);
    }

    public /* synthetic */ Object getValueForDisplay(double d2) {
        return this.a(d2);
    }

    public /* synthetic */ double getDisplayPosition(Object object) {
        return this.a((LocalDateTime)object);
    }

    static /* synthetic */ void a(DateAxis dateAxis) {
        dateAxis.invalidateRange();
    }

    static /* synthetic */ void b(DateAxis dateAxis) {
        dateAxis.invalidateRange();
    }

    static /* synthetic */ void c(DateAxis dateAxis) {
        dateAxis.invalidateRange();
    }
}

