/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.filter;

import com.dxfeed.ipf.filter.IPFSymbolFilter;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

class IPFUpdater {
    private static final ScheduledThreadPoolExecutor EXECUTOR = new ScheduledThreadPoolExecutor(0, r -> {
        Thread thread = new Thread(r, "IPFUpdater");
        thread.setDaemon(true);
        return thread;
    });

    private IPFUpdater() {
    }

    public static Future<?> track(IPFSymbolFilter filter) {
        long delay = filter.getUpdateMillis();
        long initialDelay = Math.max(0L, Math.min(delay, filter.getLastChecked() + delay - System.currentTimeMillis()));
        return EXECUTOR.scheduleWithFixedDelay(new UpdateTask(filter), initialDelay, delay, TimeUnit.MILLISECONDS);
    }

    static {
        EXECUTOR.setMaximumPoolSize(1);
        EXECUTOR.setKeepAliveTime(100L, TimeUnit.MILLISECONDS);
    }

    private static class UpdateTask
    implements Runnable {
        private final IPFSymbolFilter filter;

        UpdateTask(IPFSymbolFilter filter) {
            this.filter = filter;
        }

        @Override
        public void run() {
            this.filter.update();
        }
    }
}

