/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.filter;

import com.devexperts.io.URLInputStream;
import com.devexperts.logging.Logging;
import com.devexperts.qd.DataRecord;
import com.devexperts.qd.DataScheme;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.QDFilter;
import com.devexperts.qd.SymbolCodec;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.util.QDConfig;
import com.devexperts.qd.util.SymbolSet;
import com.devexperts.util.LogUtil;
import com.devexperts.util.TimeFormat;
import com.devexperts.util.TimePeriod;
import com.dxfeed.ipf.InstrumentProfile;
import com.dxfeed.ipf.InstrumentProfileReader;
import com.dxfeed.ipf.filter.IPFRegistry;
import com.dxfeed.ipf.filter.IPFUpdater;
import com.dxfeed.schedule.Schedule;
import com.dxfeed.schedule.Session;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;

public class IPFSymbolFilter
extends QDFilter {
    private static final boolean TRACE_LOG = IPFSymbolFilter.class.desiredAssertionStatus();
    private final Logging log = new Logging(IPFSymbolFilter.class.getName()){

        @Override
        protected String decorateLogMessage(String msg) {
            return "[" + LogUtil.hideCredentials(IPFSymbolFilter.this.address) + "] " + super.decorateLogMessage(msg);
        }
    };
    static final String FILTER_NAME_PREFIX = "ipf";
    static final String UPDATE_PROPERTY = "update";
    static final String SCHEDULE_PROPERTY = "schedule";
    private static final int STATE_NEW = 0;
    private static final int STATE_READING = 1;
    private static final int STATE_ACTIVE = 2;
    private final int wildcard;
    private final String address;
    private final Config config;
    private SymbolSet set = SymbolSet.createInstance();
    private final Set<String> tradingHours = new HashSet<String>();
    private final List<Schedule> tradingSchedules = new ArrayList<Schedule>();
    private int state = 0;
    private IOException error;
    private long lastModified;
    private long lastLoaded;
    private long lastChecked;
    private Future<?> updateTask;

    public static IPFSymbolFilter create(DataScheme scheme, String spec) {
        ArrayList<String> props = new ArrayList<String>();
        String prefix = QDConfig.parseProperties(spec, props);
        if (!prefix.equals(FILTER_NAME_PREFIX)) {
            throw new IllegalArgumentException("ipf filter specification must start with ipf");
        }
        String address = QDConfig.unescape((String)props.get(0));
        Config config = new Config();
        QDConfig.setProperties(config, props.subList(1, props.size()));
        config.validate();
        IPFSymbolFilter filter = new IPFSymbolFilter(scheme, address, config, null);
        if (filter.isDynamic()) {
            filter = IPFRegistry.registerShared(filter);
        }
        try {
            filter.readOrWaitActive();
        }
        catch (IOException e) {
            throw new FilterSyntaxException("Failed to create ipf filter \"" + filter + "\": " + e.getMessage(), e);
        }
        return filter;
    }

    IPFSymbolFilter(DataScheme scheme, String address, Config config, QDFilter source) {
        super(scheme, source);
        this.wildcard = scheme.getCodec().getWildcardCipher();
        this.address = address;
        this.config = config;
    }

    private synchronized boolean checkActive() {
        return this.state == 2;
    }

    private synchronized boolean makeReading() {
        if (this.state == 0) {
            this.state = 1;
            return true;
        }
        return false;
    }

    private synchronized void makeActive(IOException error) {
        this.state = 2;
        this.error = error;
        this.notifyAll();
    }

    private synchronized void waitActive() throws IOException {
        while (this.state != 2) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
        if (this.error != null) {
            throw this.error;
        }
    }

    private void readOrWaitActive() throws IOException {
        if (this.makeReading()) {
            try {
                this.read();
            }
            catch (IOException e) {
                this.error = e;
            }
            this.makeActive(this.error);
        }
        this.waitActive();
    }

    private void read() throws IOException {
        boolean readTradingHours = false;
        if (this.config.schedule != null) {
            if (this.config.schedule.isEmpty()) {
                readTradingHours = true;
            } else {
                this.tradingHours.add(this.config.schedule);
            }
        }
        this.log.info("Downloading IPF");
        SymbolCodec symbolCodec = this.getScheme().getCodec();
        InstrumentProfileReader reader = new InstrumentProfileReader();
        List<InstrumentProfile> list = reader.readFromFile(this.address, this.config.user, this.config.password);
        for (InstrumentProfile profile : list) {
            int cipher = symbolCodec.encode(profile.getSymbol());
            this.set.add(cipher, profile.getSymbol());
            if (!readTradingHours || profile.getTradingHours().length() <= 0) continue;
            this.tradingHours.add(profile.getTradingHours());
        }
        this.set = this.set.unmodifiable();
        this.lastModified = reader.getLastModified();
        this.lastLoaded = System.currentTimeMillis();
        this.lastChecked = System.currentTimeMillis();
        this.log.info("Downloaded " + this.set.size() + " symbols" + (this.lastModified == 0L ? "" : " (last modified on " + TimeFormat.DEFAULT.format(this.lastModified) + ")"));
        if (readTradingHours) {
            this.log.info("Found " + this.tradingHours.size() + " distinct trading hours descriptions to avoid updates");
        }
        for (String s : this.tradingHours) {
            this.tradingSchedules.add(Schedule.getInstance(s));
        }
    }

    @Override
    protected void dynamicTrackingStart() {
        this.updateTask = IPFUpdater.track(this);
    }

    @Override
    protected void dynamicTrackingStop() {
        this.updateTask.cancel(false);
    }

    public void update() {
        if (TRACE_LOG) {
            this.log.trace("update()");
        }
        if (!this.checkActive()) {
            return;
        }
        if (this.getUpdatedFilter() != this) {
            return;
        }
        for (Schedule schedule : this.tradingSchedules) {
            Session session = schedule.getSessionByTime(System.currentTimeMillis());
            if (!session.isTrading()) continue;
            if (this.log.debugEnabled()) {
                this.log.debug("Skip update check because of trading session " + session + " in schedule " + schedule);
            }
            return;
        }
        this.updateCheck();
    }

    public void forceUpdate() {
        this.log.info("Forcing update via JMX");
        if (this.checkActive()) {
            this.downloadUpdate();
        }
    }

    private void updateCheck() {
        if (TRACE_LOG) {
            this.log.trace("updateCheck() @" + Integer.toHexString(System.identityHashCode(this)));
        }
        if (this.lastModified == 0L) {
            this.log.warn("Last modified time is not known, will download file to compare contents");
        } else {
            if (TRACE_LOG) {
                this.log.trace("Checking last modified time @" + Integer.toHexString(System.identityHashCode(this)));
            }
            long lastModified = 0L;
            try {
                String url = InstrumentProfileReader.resolveSourceURL(this.address);
                lastModified = URLInputStream.getLastModified(URLInputStream.resolveURL(url), this.config.user, this.config.password);
            }
            catch (IOException e) {
                this.log.warn("Failed to get last modified time: " + e.getMessage() + ", will download file to compare contents");
            }
            if (lastModified == this.lastModified) {
                this.lastChecked = System.currentTimeMillis();
                if (TRACE_LOG) {
                    this.log.trace("No change in time @" + Integer.toHexString(System.identityHashCode(this)));
                }
                return;
            }
        }
        this.downloadUpdate();
    }

    private void downloadUpdate() {
        IPFSymbolFilter other = new IPFSymbolFilter(this.getScheme(), this.address, this.config, this);
        try {
            other.readOrWaitActive();
        }
        catch (IOException e) {
            this.log.error("Failed to update IPF filter: " + e.getMessage(), e);
            return;
        }
        if (this.hasSameContents(other)) {
            this.log.info("Symbols in IPF has not changed");
            this.lastModified = other.lastModified;
            this.lastChecked = System.currentTimeMillis();
            return;
        }
        this.fireFilterUpdated(IPFRegistry.registerUpdate(other));
    }

    private boolean hasSameContents(IPFSymbolFilter other) {
        return this.set.equals(other.set) && this.tradingHours.equals(other.tradingHours);
    }

    public long getUpdateMillis() {
        TimePeriod update = this.config.update;
        return update == null ? 0L : update.getTime();
    }

    public int getNumberOfSymbols() {
        return this.set.size();
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public long getLastLoaded() {
        return this.lastLoaded;
    }

    public long getLastChecked() {
        return this.lastChecked;
    }

    @Override
    public boolean isDynamic() {
        TimePeriod update = this.config.update;
        return update != null && update.getTime() > 0L;
    }

    @Override
    public final QDFilter.Kind getKind() {
        return QDFilter.Kind.SYMBOL_SET_WITH_ATTRIBUTES;
    }

    @Override
    public boolean isFast() {
        return true;
    }

    @Override
    public final SymbolSet getSymbolSet() {
        return this.set;
    }

    @Override
    public final boolean accept(QDContract contract, DataRecord record, int cipher, String symbol) {
        if (cipher == this.wildcard) {
            return true;
        }
        if (this.set.contains(cipher, symbol)) {
            return true;
        }
        if (symbol == null || symbol.length() < 2 || symbol.charAt(symbol.length() - 1) != '}') {
            return false;
        }
        int i = symbol.indexOf(123);
        if (i < 0) {
            return false;
        }
        String prefix = symbol.substring(0, i);
        return this.set.contains(this.getScheme().getCodec().encode(prefix), prefix);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        return this.set.equals(((IPFSymbolFilter)o).set);
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    @Override
    public String getDefaultName() {
        return "ipf[" + QDConfig.escape(this.address) + this.config.suffixString() + "]";
    }

    public static class Config {
        TimePeriod update;
        String schedule;
        String user;
        String password;

        void validate() throws FilterSyntaxException {
            if (this.schedule != null && (this.update == null || this.update.getTime() == 0L)) {
                throw new FilterSyntaxException("\"schedule\" property can only be used with \"update\" property");
            }
        }

        public TimePeriod getUpdate() {
            return this.update;
        }

        public void setUpdate(TimePeriod update) {
            if (update != null && update.getTime() < 0L) {
                throw new FilterSyntaxException("\"update\" property for ipf filter cannot be negative");
            }
            this.update = update;
        }

        public String getSchedule() {
            return this.schedule;
        }

        public void setSchedule(String schedule) {
            this.schedule = schedule;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        String suffixString() {
            StringBuilder sb = new StringBuilder();
            for (String kv : QDConfig.getProperties(this)) {
                sb.append(",");
                sb.append(kv);
            }
            return sb.toString();
        }
    }
}

