/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.filter;

import com.devexperts.logging.Logging;
import com.devexperts.management.Management;
import com.devexperts.qd.DataScheme;
import com.devexperts.util.IndexedSet;
import com.devexperts.util.TimeFormat;
import com.dxfeed.ipf.filter.IPFRegistryMXBean;
import com.dxfeed.ipf.filter.IPFSymbolFilter;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashSet;

class IPFRegistry
implements IPFRegistryMXBean {
    private static final ReferenceQueue<IPFSymbolFilter> QUEUE = new ReferenceQueue();
    private static final IndexedSet<Key, FilterReference> REFS = IndexedSet.create(ref -> ref.key);
    private static Management.Registration registration;

    private IPFRegistry() {
    }

    public static synchronized IPFSymbolFilter registerShared(IPFSymbolFilter filter) {
        IPFSymbolFilter registered;
        FilterReference ref = REFS.getByKey(new Key(filter));
        if (ref != null && (registered = (IPFSymbolFilter)ref.get()) != null) {
            return registered;
        }
        return IPFRegistry.registerUpdate(filter);
    }

    public static synchronized IPFSymbolFilter registerUpdate(IPFSymbolFilter filter) {
        REFS.add(new FilterReference(filter));
        IPFRegistry.cleanupQueue();
        if (registration == null) {
            registration = Management.registerMBean(new IPFRegistry(), IPFRegistryMXBean.class, Management.getMBeanNameForClass(IPFRegistry.class));
        }
        return filter;
    }

    private static void cleanupQueue() {
        Reference<IPFSymbolFilter> ref;
        while ((ref = QUEUE.poll()) != null) {
            REFS.remove(ref);
        }
        if (REFS.isEmpty() && registration != null) {
            registration.unregister();
            registration = null;
        }
    }

    @Override
    public synchronized int getRegisteredFiltersCount() {
        return REFS.size();
    }

    @Override
    public synchronized String[] getRegisteredFilters() {
        IPFRegistry.cleanupQueue();
        HashSet<String> result = new HashSet<String>();
        for (FilterReference ref : REFS) {
            result.add(ref.key.spec);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public synchronized String reportStats() {
        IPFRegistry.cleanupQueue();
        ArrayList<String[]> data = new ArrayList<String[]>();
        data.add(new String[]{"Filter", "Symbols", "Modified", "Loaded", "Checked"});
        for (String[] ref : REFS) {
            String[] a = new String[]{ref.key.spec, "N/A", "N/A", "N/A", "N/A"};
            IPFSymbolFilter filter = (IPFSymbolFilter)ref.get();
            if (filter != null) {
                a[1] = Integer.toString(filter.getNumberOfSymbols());
                a[2] = TimeFormat.DEFAULT.format(filter.getLastModified());
                a[3] = TimeFormat.DEFAULT.format(filter.getLastLoaded());
                a[4] = TimeFormat.DEFAULT.format(filter.getLastChecked());
            }
            data.add(a);
        }
        StringBuilder html = new StringBuilder();
        html.append("Total IPF filters: ").append(REFS.size()).append("<br>");
        html.append("<table border=\"1\"><tr>");
        for (String s : (String[])data.get(0)) {
            html.append("<th>").append(s).append("</th>");
        }
        html.append("</tr>");
        for (int i = 1; i < data.size(); ++i) {
            html.append("<tr>");
            for (String s : (String[])data.get(i)) {
                html.append("<td>").append(s).append("</td>");
            }
            html.append("</tr>");
        }
        html.append("</table>");
        String filler = "                                                                                                    ";
        for (int i = 0; i < ((String[])data.get(0)).length; ++i) {
            int j;
            int n = 0;
            for (j = 0; j < data.size(); ++j) {
                n = Math.max(n, ((String[])data.get(j))[i].length());
            }
            for (j = 0; j < data.size(); ++j) {
                ((String[])data.get((int)j))[i] = ((String[])data.get(j))[i] + filler.substring(Math.max(0, filler.length() - (n - ((String[])data.get(j))[i].length())));
            }
        }
        StringBuilder text = new StringBuilder();
        text.append("Total IPF filters: ").append(REFS.size());
        for (String[] a : data) {
            text.append("\n\t");
            for (String s : a) {
                text.append(s).append("    ");
            }
        }
        Logging.getLogging(this.getClass()).info(text.toString());
        return html.toString();
    }

    @Override
    public String forceUpdate(String filterSpec) {
        IPFRegistry.cleanupQueue();
        int cnt = 0;
        for (FilterReference ref : REFS) {
            IPFSymbolFilter filter;
            if (!ref.key.spec.equals(filterSpec) || (filter = (IPFSymbolFilter)ref.get()) == null) continue;
            filter.forceUpdate();
            ++cnt;
        }
        return "Forced update on " + cnt + " instances";
    }

    static class Key {
        private final DataScheme scheme;
        private final String spec;

        Key(IPFSymbolFilter filter) {
            this.scheme = filter.getScheme();
            this.spec = filter.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Key)) {
                return false;
            }
            Key that = (Key)o;
            return this.scheme.equals(that.scheme) && this.spec.equals(that.spec);
        }

        public int hashCode() {
            return 31 * this.scheme.hashCode() + this.spec.hashCode();
        }
    }

    private static class FilterReference
    extends WeakReference<IPFSymbolFilter> {
        final Key key;

        FilterReference(IPFSymbolFilter filter) {
            super(filter);
            this.key = new Key(filter);
        }
    }
}

