/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.ipf.filter;

import com.devexperts.qd.QDFilter;
import com.devexperts.qd.QDLog;
import com.devexperts.qd.SpecificSubscriptionFilter;
import com.devexperts.qd.kit.FilterSyntaxException;
import com.devexperts.qd.kit.SymbolSetFilter;
import com.devexperts.qd.spi.QDFilterContext;
import com.devexperts.qd.spi.QDFilterFactory;
import com.devexperts.services.ServiceProvider;
import com.dxfeed.ipf.filter.IPFSymbolFilter;

@ServiceProvider(order=-200)
public class IPFFilterFactory
extends QDFilterFactory {
    @SpecificSubscriptionFilter(value="IPF symbol filter for specified <url> (file, ftp or http), accepts all records, accepts optional symbol parameters like {tho=true} or {price=bid}. Additional attributes for this filter can be specified after its <url>, separated by commas:\nuse 'update=<period>(s|m|h)' to create dynamic filter that reloads IPF on a specified period of time;\nuse 'schedule[=<schedule>]' to avoid checks on a specified schedule or, by default, on trading hours of symbols in the given IPF file.")
    public static final String IPF_DESC = "ipf[<url>]";

    @Override
    public QDFilter createFilter(String spec) {
        return this.createFilter(spec, QDFilterContext.DEFAULT);
    }

    @Override
    public QDFilter createFilter(String spec, QDFilterContext context) {
        if (context == QDFilterContext.REMOTE_FILTER) {
            return null;
        }
        IPFSymbolFilter filter = null;
        if (spec.startsWith("ipf[") && spec.endsWith("]")) {
            filter = IPFSymbolFilter.create(this.getScheme(), spec);
        } else if (context == QDFilterContext.SYMBOL_SET && spec.contains(".ipf")) {
            try {
                filter = IPFSymbolFilter.create(this.getScheme(), "ipf[" + spec + "]");
            }
            catch (FilterSyntaxException e) {
                QDLog.log.error("Failed to read potential IPF \"" + spec + "\", treating as individual symbol or pattern", e);
            }
        }
        if (context == QDFilterContext.SYMBOL_SET && filter != null) {
            return new SymbolSetFilter(filter);
        }
        return filter;
    }
}

