/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class UnderlyingMapping
extends RecordMapping {
    private final int iTime;
    private final int iSequence;
    private final int iVolatility;
    private final int iFrontVolatility;
    private final int iBackVolatility;
    private final int iCallVolume;
    private final int iPutVolume;
    private final int iPutCallRatio;

    public UnderlyingMapping(DataRecord record) {
        super(record);
        this.iTime = MappingUtil.findIntField(record, "Time", false);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", false);
        this.iVolatility = this.findIntField("Volatility", false);
        this.iFrontVolatility = this.findIntField("FrontVolatility", false);
        this.iBackVolatility = this.findIntField("BackVolatility", false);
        this.iCallVolume = this.findIntField("CallVolume", false);
        this.iPutVolume = this.findIntField("PutVolume", false);
        this.iPutCallRatio = this.findIntField("PutCallRatio", false);
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, sequence);
    }

    public double getVolatility(RecordCursor cursor) {
        if (this.iVolatility < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iVolatility);
    }

    public void setVolatility(RecordCursor cursor, double volatility) {
        if (this.iVolatility < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iVolatility, volatility);
    }

    public int getVolatilityDecimal(RecordCursor cursor) {
        if (this.iVolatility < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iVolatility);
    }

    public void setVolatilityDecimal(RecordCursor cursor, int volatility) {
        if (this.iVolatility < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iVolatility, volatility);
    }

    public long getVolatilityWideDecimal(RecordCursor cursor) {
        if (this.iVolatility < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iVolatility);
    }

    public void setVolatilityWideDecimal(RecordCursor cursor, long volatility) {
        if (this.iVolatility < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iVolatility, volatility);
    }

    public double getFrontVolatility(RecordCursor cursor) {
        if (this.iFrontVolatility < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iFrontVolatility);
    }

    public void setFrontVolatility(RecordCursor cursor, double frontVolatility) {
        if (this.iFrontVolatility < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iFrontVolatility, frontVolatility);
    }

    public int getFrontVolatilityDecimal(RecordCursor cursor) {
        if (this.iFrontVolatility < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iFrontVolatility);
    }

    public void setFrontVolatilityDecimal(RecordCursor cursor, int frontVolatility) {
        if (this.iFrontVolatility < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iFrontVolatility, frontVolatility);
    }

    public long getFrontVolatilityWideDecimal(RecordCursor cursor) {
        if (this.iFrontVolatility < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iFrontVolatility);
    }

    public void setFrontVolatilityWideDecimal(RecordCursor cursor, long frontVolatility) {
        if (this.iFrontVolatility < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iFrontVolatility, frontVolatility);
    }

    public double getBackVolatility(RecordCursor cursor) {
        if (this.iBackVolatility < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iBackVolatility);
    }

    public void setBackVolatility(RecordCursor cursor, double backVolatility) {
        if (this.iBackVolatility < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iBackVolatility, backVolatility);
    }

    public int getBackVolatilityDecimal(RecordCursor cursor) {
        if (this.iBackVolatility < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iBackVolatility);
    }

    public void setBackVolatilityDecimal(RecordCursor cursor, int backVolatility) {
        if (this.iBackVolatility < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iBackVolatility, backVolatility);
    }

    public long getBackVolatilityWideDecimal(RecordCursor cursor) {
        if (this.iBackVolatility < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iBackVolatility);
    }

    public void setBackVolatilityWideDecimal(RecordCursor cursor, long backVolatility) {
        if (this.iBackVolatility < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iBackVolatility, backVolatility);
    }

    public double getCallVolume(RecordCursor cursor) {
        if (this.iCallVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iCallVolume);
    }

    public void setCallVolume(RecordCursor cursor, double callVolume) {
        if (this.iCallVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iCallVolume, callVolume);
    }

    public int getCallVolumeDecimal(RecordCursor cursor) {
        if (this.iCallVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iCallVolume);
    }

    public void setCallVolumeDecimal(RecordCursor cursor, int callVolume) {
        if (this.iCallVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iCallVolume, callVolume);
    }

    public long getCallVolumeWideDecimal(RecordCursor cursor) {
        if (this.iCallVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iCallVolume);
    }

    public void setCallVolumeWideDecimal(RecordCursor cursor, long callVolume) {
        if (this.iCallVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iCallVolume, callVolume);
    }

    public double getPutVolume(RecordCursor cursor) {
        if (this.iPutVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iPutVolume);
    }

    public void setPutVolume(RecordCursor cursor, double putVolume) {
        if (this.iPutVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iPutVolume, putVolume);
    }

    public int getPutVolumeDecimal(RecordCursor cursor) {
        if (this.iPutVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iPutVolume);
    }

    public void setPutVolumeDecimal(RecordCursor cursor, int putVolume) {
        if (this.iPutVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iPutVolume, putVolume);
    }

    public long getPutVolumeWideDecimal(RecordCursor cursor) {
        if (this.iPutVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iPutVolume);
    }

    public void setPutVolumeWideDecimal(RecordCursor cursor, long putVolume) {
        if (this.iPutVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iPutVolume, putVolume);
    }

    public double getPutCallRatio(RecordCursor cursor) {
        if (this.iPutCallRatio < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iPutCallRatio);
    }

    public void setPutCallRatio(RecordCursor cursor, double putCallRatio) {
        if (this.iPutCallRatio < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iPutCallRatio, putCallRatio);
    }

    public int getPutCallRatioDecimal(RecordCursor cursor) {
        if (this.iPutCallRatio < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iPutCallRatio);
    }

    public void setPutCallRatioDecimal(RecordCursor cursor, int putCallRatio) {
        if (this.iPutCallRatio < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iPutCallRatio, putCallRatio);
    }

    public long getPutCallRatioWideDecimal(RecordCursor cursor) {
        if (this.iPutCallRatio < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iPutCallRatio);
    }

    public void setPutCallRatioWideDecimal(RecordCursor cursor, long putCallRatio) {
        if (this.iPutCallRatio < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iPutCallRatio, putCallRatio);
    }
}

