/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class SeriesMapping
extends RecordMapping {
    private final int iIndex;
    private final int iTime;
    private final int iSequence;
    private final int iExpiration;
    private final int iVolatility;
    private final int iCallVolume;
    private final int iPutVolume;
    private final int iPutCallRatio;
    private final int iForwardPrice;
    private final int iDividend;
    private final int iInterest;

    public SeriesMapping(DataRecord record) {
        super(record);
        this.iIndex = MappingUtil.findIntField(record, "Index", false);
        this.iTime = MappingUtil.findIntField(record, "Time", false);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", false);
        this.iExpiration = MappingUtil.findIntField(record, "Expiration", true);
        this.iVolatility = this.findIntField("Volatility", true);
        this.iCallVolume = this.findIntField("CallVolume", false);
        this.iPutVolume = this.findIntField("PutVolume", false);
        this.iPutCallRatio = this.findIntField("PutCallRatio", true);
        this.iForwardPrice = this.findIntField("ForwardPrice", true);
        this.iDividend = this.findIntField("Dividend", false);
        this.iInterest = this.findIntField("Interest", false);
    }

    public int getIndex(RecordCursor cursor) {
        if (this.iIndex < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iIndex);
    }

    public void setIndex(RecordCursor cursor, int index) {
        if (this.iIndex < 0) {
            return;
        }
        this.setInt(cursor, this.iIndex, index);
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, sequence);
    }

    public int getExpiration(RecordCursor cursor) {
        return this.getInt(cursor, this.iExpiration);
    }

    public void setExpiration(RecordCursor cursor, int expiration) {
        this.setInt(cursor, this.iExpiration, expiration);
    }

    public double getVolatility(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iVolatility);
    }

    public void setVolatility(RecordCursor cursor, double volatility) {
        this.setAsDouble(cursor, this.iVolatility, volatility);
    }

    public int getVolatilityDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iVolatility);
    }

    public void setVolatilityDecimal(RecordCursor cursor, int volatility) {
        this.setAsTinyDecimal(cursor, this.iVolatility, volatility);
    }

    public long getVolatilityWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iVolatility);
    }

    public void setVolatilityWideDecimal(RecordCursor cursor, long volatility) {
        this.setAsWideDecimal(cursor, this.iVolatility, volatility);
    }

    public double getCallVolume(RecordCursor cursor) {
        if (this.iCallVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iCallVolume);
    }

    public void setCallVolume(RecordCursor cursor, double callVolume) {
        if (this.iCallVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iCallVolume, callVolume);
    }

    public int getCallVolumeDecimal(RecordCursor cursor) {
        if (this.iCallVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iCallVolume);
    }

    public void setCallVolumeDecimal(RecordCursor cursor, int callVolume) {
        if (this.iCallVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iCallVolume, callVolume);
    }

    public long getCallVolumeWideDecimal(RecordCursor cursor) {
        if (this.iCallVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iCallVolume);
    }

    public void setCallVolumeWideDecimal(RecordCursor cursor, long callVolume) {
        if (this.iCallVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iCallVolume, callVolume);
    }

    public double getPutVolume(RecordCursor cursor) {
        if (this.iPutVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iPutVolume);
    }

    public void setPutVolume(RecordCursor cursor, double putVolume) {
        if (this.iPutVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iPutVolume, putVolume);
    }

    public int getPutVolumeDecimal(RecordCursor cursor) {
        if (this.iPutVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iPutVolume);
    }

    public void setPutVolumeDecimal(RecordCursor cursor, int putVolume) {
        if (this.iPutVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iPutVolume, putVolume);
    }

    public long getPutVolumeWideDecimal(RecordCursor cursor) {
        if (this.iPutVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iPutVolume);
    }

    public void setPutVolumeWideDecimal(RecordCursor cursor, long putVolume) {
        if (this.iPutVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iPutVolume, putVolume);
    }

    public double getPutCallRatio(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPutCallRatio);
    }

    public void setPutCallRatio(RecordCursor cursor, double putCallRatio) {
        this.setAsDouble(cursor, this.iPutCallRatio, putCallRatio);
    }

    public int getPutCallRatioDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPutCallRatio);
    }

    public void setPutCallRatioDecimal(RecordCursor cursor, int putCallRatio) {
        this.setAsTinyDecimal(cursor, this.iPutCallRatio, putCallRatio);
    }

    public long getPutCallRatioWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPutCallRatio);
    }

    public void setPutCallRatioWideDecimal(RecordCursor cursor, long putCallRatio) {
        this.setAsWideDecimal(cursor, this.iPutCallRatio, putCallRatio);
    }

    public double getForwardPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iForwardPrice);
    }

    public void setForwardPrice(RecordCursor cursor, double forwardPrice) {
        this.setAsDouble(cursor, this.iForwardPrice, forwardPrice);
    }

    public int getForwardPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iForwardPrice);
    }

    public void setForwardPriceDecimal(RecordCursor cursor, int forwardPrice) {
        this.setAsTinyDecimal(cursor, this.iForwardPrice, forwardPrice);
    }

    public long getForwardPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iForwardPrice);
    }

    public void setForwardPriceWideDecimal(RecordCursor cursor, long forwardPrice) {
        this.setAsWideDecimal(cursor, this.iForwardPrice, forwardPrice);
    }

    public double getDividend(RecordCursor cursor) {
        if (this.iDividend < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDividend);
    }

    public void setDividend(RecordCursor cursor, double dividend) {
        if (this.iDividend < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDividend, dividend);
    }

    public int getDividendDecimal(RecordCursor cursor) {
        if (this.iDividend < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDividend);
    }

    public void setDividendDecimal(RecordCursor cursor, int dividend) {
        if (this.iDividend < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDividend, dividend);
    }

    public long getDividendWideDecimal(RecordCursor cursor) {
        if (this.iDividend < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDividend);
    }

    public void setDividendWideDecimal(RecordCursor cursor, long dividend) {
        if (this.iDividend < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDividend, dividend);
    }

    public double getInterest(RecordCursor cursor) {
        if (this.iInterest < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iInterest);
    }

    public void setInterest(RecordCursor cursor, double interest) {
        if (this.iInterest < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iInterest, interest);
    }

    public int getInterestDecimal(RecordCursor cursor) {
        if (this.iInterest < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iInterest);
    }

    public void setInterestDecimal(RecordCursor cursor, int interest) {
        if (this.iInterest < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iInterest, interest);
    }

    public long getInterestWideDecimal(RecordCursor cursor) {
        if (this.iInterest < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iInterest);
    }

    public void setInterestWideDecimal(RecordCursor cursor, long interest) {
        if (this.iInterest < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iInterest, interest);
    }
}

