/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;

public class GreeksMapping
extends RecordMapping {
    private final int iTime;
    private final int iSequence;
    private final int iPrice;
    private final int iVolatility;
    private final int iDelta;
    private final int iGamma;
    private final int iTheta;
    private final int iRho;
    private final int iVega;

    public GreeksMapping(DataRecord record) {
        super(record);
        this.iTime = MappingUtil.findIntField(record, "Time", false);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", false);
        this.iPrice = this.findIntField("Greeks.Price", true);
        this.iVolatility = this.findIntField("Volatility", true);
        this.iDelta = this.findIntField("Delta", true);
        this.iGamma = this.findIntField("Gamma", true);
        this.iTheta = this.findIntField("Theta", true);
        this.iRho = this.findIntField("Rho", true);
        this.iVega = this.findIntField("Vega", true);
        this.putNonDefaultPropertyName("Greeks.Price", "Price");
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, sequence);
    }

    @Deprecated
    public double getGreeksPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    @Deprecated
    public void setGreeksPrice(RecordCursor cursor, double greeksPrice) {
        this.setAsDouble(cursor, this.iPrice, greeksPrice);
    }

    @Deprecated
    public int getGreeksPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    @Deprecated
    public void setGreeksPriceDecimal(RecordCursor cursor, int greeksPrice) {
        this.setAsTinyDecimal(cursor, this.iPrice, greeksPrice);
    }

    @Deprecated
    public long getGreeksPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    @Deprecated
    public void setGreeksPriceWideDecimal(RecordCursor cursor, long greeksPrice) {
        this.setAsWideDecimal(cursor, this.iPrice, greeksPrice);
    }

    public double getPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        this.setAsDouble(cursor, this.iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        this.setAsTinyDecimal(cursor, this.iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        this.setAsWideDecimal(cursor, this.iPrice, price);
    }

    public double getVolatility(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iVolatility);
    }

    public void setVolatility(RecordCursor cursor, double volatility) {
        this.setAsDouble(cursor, this.iVolatility, volatility);
    }

    public int getVolatilityDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iVolatility);
    }

    public void setVolatilityDecimal(RecordCursor cursor, int volatility) {
        this.setAsTinyDecimal(cursor, this.iVolatility, volatility);
    }

    public long getVolatilityWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iVolatility);
    }

    public void setVolatilityWideDecimal(RecordCursor cursor, long volatility) {
        this.setAsWideDecimal(cursor, this.iVolatility, volatility);
    }

    public double getDelta(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iDelta);
    }

    public void setDelta(RecordCursor cursor, double delta) {
        this.setAsDouble(cursor, this.iDelta, delta);
    }

    public int getDeltaDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iDelta);
    }

    public void setDeltaDecimal(RecordCursor cursor, int delta) {
        this.setAsTinyDecimal(cursor, this.iDelta, delta);
    }

    public long getDeltaWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iDelta);
    }

    public void setDeltaWideDecimal(RecordCursor cursor, long delta) {
        this.setAsWideDecimal(cursor, this.iDelta, delta);
    }

    public double getGamma(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iGamma);
    }

    public void setGamma(RecordCursor cursor, double gamma) {
        this.setAsDouble(cursor, this.iGamma, gamma);
    }

    public int getGammaDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iGamma);
    }

    public void setGammaDecimal(RecordCursor cursor, int gamma) {
        this.setAsTinyDecimal(cursor, this.iGamma, gamma);
    }

    public long getGammaWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iGamma);
    }

    public void setGammaWideDecimal(RecordCursor cursor, long gamma) {
        this.setAsWideDecimal(cursor, this.iGamma, gamma);
    }

    public double getTheta(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iTheta);
    }

    public void setTheta(RecordCursor cursor, double theta) {
        this.setAsDouble(cursor, this.iTheta, theta);
    }

    public int getThetaDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iTheta);
    }

    public void setThetaDecimal(RecordCursor cursor, int theta) {
        this.setAsTinyDecimal(cursor, this.iTheta, theta);
    }

    public long getThetaWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iTheta);
    }

    public void setThetaWideDecimal(RecordCursor cursor, long theta) {
        this.setAsWideDecimal(cursor, this.iTheta, theta);
    }

    public double getRho(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iRho);
    }

    public void setRho(RecordCursor cursor, double rho) {
        this.setAsDouble(cursor, this.iRho, rho);
    }

    public int getRhoDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iRho);
    }

    public void setRhoDecimal(RecordCursor cursor, int rho) {
        this.setAsTinyDecimal(cursor, this.iRho, rho);
    }

    public long getRhoWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iRho);
    }

    public void setRhoWideDecimal(RecordCursor cursor, long rho) {
        this.setAsWideDecimal(cursor, this.iRho, rho);
    }

    public double getVega(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iVega);
    }

    public void setVega(RecordCursor cursor, double vega) {
        this.setAsDouble(cursor, this.iVega, vega);
    }

    public int getVegaDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iVega);
    }

    public void setVegaDecimal(RecordCursor cursor, int vega) {
        this.setAsTinyDecimal(cursor, this.iVega, vega);
    }

    public long getVegaWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iVega);
    }

    public void setVegaWideDecimal(RecordCursor cursor, long vega) {
        this.setAsWideDecimal(cursor, this.iVega, vega);
    }
}

