/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.option.Series;
import com.dxfeed.event.option.impl.SeriesMapping;
import java.util.EnumSet;

public final class SeriesDelegate
extends EventDelegate<Series> {
    private final SeriesMapping m;

    public SeriesDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(SeriesMapping.class);
    }

    @Override
    public SeriesMapping getMapping() {
        return this.m;
    }

    @Override
    public Series createEvent() {
        return new Series();
    }

    @Override
    public Series getEvent(Series event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex(this.m.getIndex(cursor));
        event.setTimeSequence((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setExpiration(this.m.getExpiration(cursor));
        event.setVolatility(this.m.getVolatility(cursor));
        event.setCallVolume(this.m.getCallVolume(cursor));
        event.setPutVolume(this.m.getPutVolume(cursor));
        event.setPutCallRatio(this.m.getPutCallRatio(cursor));
        event.setForwardPrice(this.m.getForwardPrice(cursor));
        event.setDividend(this.m.getDividend(cursor));
        event.setInterest(this.m.getInterest(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Series event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        int index = (int)event.getIndex();
        this.m.setIndex(cursor, index);
        this.m.setTimeSeconds(cursor, (int)(event.getTimeSequence() >>> 32));
        this.m.setSequence(cursor, (int)event.getTimeSequence());
        this.m.setExpiration(cursor, event.getExpiration());
        this.m.setVolatility(cursor, event.getVolatility());
        this.m.setCallVolume(cursor, event.getCallVolume());
        this.m.setPutVolume(cursor, event.getPutVolume());
        this.m.setPutCallRatio(cursor, event.getPutCallRatio());
        this.m.setForwardPrice(cursor, event.getForwardPrice());
        this.m.setDividend(cursor, event.getDividend());
        this.m.setInterest(cursor, event.getInterest());
        return cursor;
    }
}

