/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.SerialFieldType;
import com.devexperts.qd.ng.RecordMapping;
import com.devexperts.qd.ng.RecordMappingFactory;
import com.devexperts.services.ServiceProvider;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFactory;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.api.impl.SchemeBuilder;
import com.dxfeed.api.impl.SchemeFieldTime;
import com.dxfeed.event.option.GreeksDelegate;
import com.dxfeed.event.option.SeriesDelegate;
import com.dxfeed.event.option.TheoPriceDelegate;
import com.dxfeed.event.option.UnderlyingDelegate;
import com.dxfeed.event.option.impl.GreeksMapping;
import com.dxfeed.event.option.impl.SeriesMapping;
import com.dxfeed.event.option.impl.TheoPriceMapping;
import com.dxfeed.event.option.impl.UnderlyingMapping;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;

@ServiceProvider(order=-50)
public final class OptionFactoryImpl
extends EventDelegateFactory
implements RecordMappingFactory {
    @Override
    public void buildScheme(SchemeBuilder builder) {
        builder.addOptionalField("Greeks", "Time", SerialFieldType.TIME_SECONDS, "Greeks", "Time", true, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addOptionalField("Greeks", "Sequence", SerialFieldType.SEQUENCE, "Greeks", "Sequence", true, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addRequiredField("Greeks", "Greeks.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("Greeks", "Volatility", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("Greeks", "Delta", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("Greeks", "Gamma", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("Greeks", "Theta", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("Greeks", "Rho", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("Greeks", "Vega", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("TheoPrice", "Theo.Time", SerialFieldType.TIME_SECONDS, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addOptionalField("TheoPrice", "Theo.Sequence", SerialFieldType.SEQUENCE, "TheoPrice", "Sequence", true, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addRequiredField("TheoPrice", "Theo.Price", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TheoPrice", "Theo.UnderlyingPrice", this.select(SerialFieldType.DECIMAL, "dxscheme.price"));
        builder.addRequiredField("TheoPrice", "Theo.Delta", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("TheoPrice", "Theo.Gamma", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addOptionalField("TheoPrice", "Theo.Dividend", this.select(SerialFieldType.DECIMAL, new String[0]), "TheoPrice", "Dividend", true);
        builder.addOptionalField("TheoPrice", "Theo.Interest", this.select(SerialFieldType.DECIMAL, new String[0]), "TheoPrice", "Interest", true);
        builder.addOptionalField("Underlying", "Time", SerialFieldType.TIME_SECONDS, "Underlying", "Time", true, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addOptionalField("Underlying", "Sequence", SerialFieldType.SEQUENCE, "Underlying", "Sequence", true, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("Underlying", "Volatility", this.select(SerialFieldType.DECIMAL, new String[0]), "Underlying", "Volatility", true);
        builder.addOptionalField("Underlying", "FrontVolatility", this.select(SerialFieldType.DECIMAL, new String[0]), "Underlying", "FrontVolatility", true);
        builder.addOptionalField("Underlying", "BackVolatility", this.select(SerialFieldType.DECIMAL, new String[0]), "Underlying", "BackVolatility", true);
        builder.addOptionalField("Underlying", "CallVolume", this.select(SerialFieldType.DECIMAL, new String[0]), "Underlying", "CallVolume", true);
        builder.addOptionalField("Underlying", "PutVolume", this.select(SerialFieldType.DECIMAL, new String[0]), "Underlying", "PutVolume", true);
        builder.addOptionalField("Underlying", "PutCallRatio", this.select(SerialFieldType.DECIMAL, new String[0]), "Underlying", "PutCallRatio", true);
        builder.addOptionalField("Series", "Void", SerialFieldType.VOID, "Series", "Void", true, SchemeFieldTime.FIRST_TIME_INT_FIELD);
        builder.addOptionalField("Series", "Index", SerialFieldType.COMPACT_INT, "Series", "Index", true, SchemeFieldTime.SECOND_TIME_INT_FIELD);
        builder.addOptionalField("Series", "Time", SerialFieldType.TIME_SECONDS, "Series", "Time", true);
        builder.addOptionalField("Series", "Sequence", SerialFieldType.SEQUENCE, "Series", "Sequence", true);
        builder.addRequiredField("Series", "Expiration", SerialFieldType.DATE);
        builder.addRequiredField("Series", "Volatility", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addOptionalField("Series", "CallVolume", this.select(SerialFieldType.DECIMAL, new String[0]), "Series", "CallVolume", true);
        builder.addOptionalField("Series", "PutVolume", this.select(SerialFieldType.DECIMAL, new String[0]), "Series", "PutVolume", true);
        builder.addRequiredField("Series", "PutCallRatio", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addRequiredField("Series", "ForwardPrice", this.select(SerialFieldType.DECIMAL, new String[0]));
        builder.addOptionalField("Series", "Dividend", this.select(SerialFieldType.DECIMAL, new String[0]), "Series", "Dividend", true);
        builder.addOptionalField("Series", "Interest", this.select(SerialFieldType.DECIMAL, new String[0]), "Series", "Interest", true);
    }

    @Override
    public Collection<EventDelegate<?>> createDelegates(DataRecord record) {
        ArrayList result = new ArrayList();
        if (record.getMapping(GreeksMapping.class) != null) {
            result.add(new GreeksDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new GreeksDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new GreeksDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        } else if (record.getMapping(TheoPriceMapping.class) != null) {
            result.add(new TheoPriceDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new TheoPriceDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new TheoPriceDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        } else if (record.getMapping(UnderlyingMapping.class) != null) {
            result.add(new UnderlyingDelegate(record, QDContract.TICKER, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
            result.add(new UnderlyingDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new UnderlyingDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.TIME_SERIES)));
        } else if (record.getMapping(SeriesMapping.class) != null) {
            result.add(new SeriesDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
            result.add(new SeriesDelegate(record, QDContract.HISTORY, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB)));
        }
        return result;
    }

    @Override
    public Collection<EventDelegate<?>> createStreamOnlyDelegates(DataRecord record) {
        ArrayList result = new ArrayList();
        if (record.getMapping(GreeksMapping.class) != null) {
            result.add(new GreeksDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(TheoPriceMapping.class) != null) {
            result.add(new TheoPriceDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(UnderlyingMapping.class) != null) {
            result.add(new UnderlyingDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        } else if (record.getMapping(SeriesMapping.class) != null) {
            result.add(new SeriesDelegate(record, QDContract.STREAM, EnumSet.of(EventDelegateFlags.SUB, EventDelegateFlags.PUB, EventDelegateFlags.WILDCARD)));
        }
        return result;
    }

    @Override
    public RecordMapping createMapping(DataRecord record) {
        String baseRecordName = this.getBaseRecordName(record.getName());
        if (baseRecordName.equals("Greeks")) {
            return new GreeksMapping(record);
        }
        if (baseRecordName.equals("TheoPrice")) {
            return new TheoPriceMapping(record);
        }
        if (baseRecordName.equals("Underlying")) {
            return new UnderlyingMapping(record);
        }
        if (baseRecordName.equals("Series")) {
            return new SeriesMapping(record);
        }
        return null;
    }
}

