/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.option;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegate;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.option.Greeks;
import com.dxfeed.event.option.impl.GreeksMapping;
import java.util.EnumSet;

public final class GreeksDelegate
extends EventDelegate<Greeks> {
    private final GreeksMapping m;

    public GreeksDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(GreeksMapping.class);
    }

    @Override
    public GreeksMapping getMapping() {
        return this.m;
    }

    @Override
    public Greeks createEvent() {
        return new Greeks();
    }

    @Override
    public Greeks getEvent(Greeks event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setPrice(this.m.getPrice(cursor));
        event.setVolatility(this.m.getVolatility(cursor));
        event.setDelta(this.m.getDelta(cursor));
        event.setGamma(this.m.getGamma(cursor));
        event.setTheta(this.m.getTheta(cursor));
        event.setRho(this.m.getRho(cursor));
        event.setVega(this.m.getVega(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Greeks event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        this.m.setTimeSeconds(cursor, (int)(event.getIndex() >>> 32));
        this.m.setSequence(cursor, (int)event.getIndex());
        this.m.setPrice(cursor, event.getPrice());
        this.m.setVolatility(cursor, event.getVolatility());
        this.m.setDelta(cursor, event.getDelta());
        this.m.setGamma(cursor, event.getGamma());
        this.m.setTheta(cursor, event.getTheta());
        this.m.setRho(cursor, event.getRho());
        this.m.setVega(cursor, event.getVega());
        return cursor;
    }
}

