/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public class TradeMapping
extends MarketEventMapping {
    private final int iTime;
    private final int iSequence;
    private final int iTimeNanoPart;
    private final int iExchangeCode;
    private final int iPrice;
    private final int iSize;
    private final int iTick;
    private final int iChange;
    private final int iDayVolume;
    private final int iDayTurnover;
    private final int iFlags;

    public TradeMapping(DataRecord record) {
        super(record);
        this.iTime = MappingUtil.findIntField(record, "Last.Time", false);
        this.iSequence = MappingUtil.findIntField(record, "Last.Sequence", false);
        this.iTimeNanoPart = MappingUtil.findIntField(record, "Last.TimeNanoPart", false);
        this.iExchangeCode = MappingUtil.findIntField(record, "Last.Exchange", false);
        this.iPrice = this.findIntField("Last.Price", true);
        this.iSize = this.findIntField("Last.Size", true);
        this.iTick = MappingUtil.findIntField(record, "Last.Tick", false);
        this.iChange = this.findIntField("Last.Change", false);
        this.iDayVolume = this.findIntField("Volume", false);
        this.iDayTurnover = this.findIntField("DayTurnover", false);
        this.iFlags = MappingUtil.findIntField(record, "Last.Flags", false);
        this.putNonDefaultPropertyName("Last.Time", "Time");
        this.putNonDefaultPropertyName("Last.Sequence", "Sequence");
        this.putNonDefaultPropertyName("Last.TimeNanoPart", "TimeNanoPart");
        this.putNonDefaultPropertyName("Last.Exchange", "ExchangeCode");
        this.putNonDefaultPropertyName("Last.Price", "Price");
        this.putNonDefaultPropertyName("Last.Size", "Size");
        this.putNonDefaultPropertyName("Last.Tick", "Tick");
        this.putNonDefaultPropertyName("Last.Change", "Change");
        this.putNonDefaultPropertyName("Volume", "DayVolume");
        this.putNonDefaultPropertyName("Last.Flags", "Flags");
    }

    @Deprecated
    public long getLastTimeMillis(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    @Deprecated
    public void setLastTimeMillis(RecordCursor cursor, long lastTime) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(lastTime));
    }

    @Deprecated
    public int getLastTimeSeconds(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTime);
    }

    @Deprecated
    public void setLastTimeSeconds(RecordCursor cursor, int lastTime) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, lastTime);
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, time);
    }

    @Deprecated
    public int getLastSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    @Deprecated
    public void setLastSequence(RecordCursor cursor, int lastSequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, lastSequence);
    }

    public int getSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, sequence);
    }

    @Deprecated
    public int getLastTimeNanoPart(RecordCursor cursor) {
        if (this.iTimeNanoPart < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTimeNanoPart);
    }

    @Deprecated
    public void setLastTimeNanoPart(RecordCursor cursor, int lastTimeNanoPart) {
        if (this.iTimeNanoPart < 0) {
            return;
        }
        this.setInt(cursor, this.iTimeNanoPart, lastTimeNanoPart);
    }

    public int getTimeNanoPart(RecordCursor cursor) {
        if (this.iTimeNanoPart < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTimeNanoPart);
    }

    public void setTimeNanoPart(RecordCursor cursor, int timeNanoPart) {
        if (this.iTimeNanoPart < 0) {
            return;
        }
        this.setInt(cursor, this.iTimeNanoPart, timeNanoPart);
    }

    @Deprecated
    public char getLastExchange(RecordCursor cursor) {
        if (this.iExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    @Deprecated
    public void setLastExchange(RecordCursor cursor, char lastExchange) {
        if (this.iExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iExchangeCode, lastExchange);
    }

    public char getExchangeCode(RecordCursor cursor) {
        if (this.iExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    public void setExchangeCode(RecordCursor cursor, char exchangeCode) {
        if (this.iExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iExchangeCode, exchangeCode);
    }

    @Deprecated
    public double getLastPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    @Deprecated
    public void setLastPrice(RecordCursor cursor, double lastPrice) {
        this.setAsDouble(cursor, this.iPrice, lastPrice);
    }

    @Deprecated
    public int getLastPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    @Deprecated
    public void setLastPriceDecimal(RecordCursor cursor, int lastPrice) {
        this.setAsTinyDecimal(cursor, this.iPrice, lastPrice);
    }

    @Deprecated
    public long getLastPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    @Deprecated
    public void setLastPriceWideDecimal(RecordCursor cursor, long lastPrice) {
        this.setAsWideDecimal(cursor, this.iPrice, lastPrice);
    }

    public double getPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        this.setAsDouble(cursor, this.iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        this.setAsTinyDecimal(cursor, this.iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        this.setAsWideDecimal(cursor, this.iPrice, price);
    }

    @Deprecated
    public int getLastSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iSize);
    }

    @Deprecated
    public void setLastSize(RecordCursor cursor, int lastSize) {
        this.setAsInt(cursor, this.iSize, lastSize);
    }

    @Deprecated
    public long getLastSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iSize);
    }

    @Deprecated
    public void setLastSizeLong(RecordCursor cursor, long lastSize) {
        this.setAsLong(cursor, this.iSize, lastSize);
    }

    @Deprecated
    public double getLastSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iSize);
    }

    @Deprecated
    public void setLastSizeDouble(RecordCursor cursor, double lastSize) {
        this.setAsDouble(cursor, this.iSize, lastSize);
    }

    @Deprecated
    public int getLastSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iSize);
    }

    @Deprecated
    public void setLastSizeDecimal(RecordCursor cursor, int lastSize) {
        this.setAsTinyDecimal(cursor, this.iSize, lastSize);
    }

    @Deprecated
    public long getLastSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iSize);
    }

    @Deprecated
    public void setLastSizeWideDecimal(RecordCursor cursor, long lastSize) {
        this.setAsWideDecimal(cursor, this.iSize, lastSize);
    }

    public int getSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iSize);
    }

    public void setSize(RecordCursor cursor, int size) {
        this.setAsInt(cursor, this.iSize, size);
    }

    public long getSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iSize);
    }

    public void setSizeLong(RecordCursor cursor, long size) {
        this.setAsLong(cursor, this.iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        this.setAsDouble(cursor, this.iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        this.setAsTinyDecimal(cursor, this.iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        this.setAsWideDecimal(cursor, this.iSize, size);
    }

    @Deprecated
    public int getLastTick(RecordCursor cursor) {
        if (this.iTick < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTick);
    }

    @Deprecated
    public void setLastTick(RecordCursor cursor, int lastTick) {
        if (this.iTick < 0) {
            return;
        }
        this.setInt(cursor, this.iTick, lastTick);
    }

    public int getTick(RecordCursor cursor) {
        if (this.iTick < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTick);
    }

    public void setTick(RecordCursor cursor, int tick) {
        if (this.iTick < 0) {
            return;
        }
        this.setInt(cursor, this.iTick, tick);
    }

    @Deprecated
    public double getLastChange(RecordCursor cursor) {
        if (this.iChange < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iChange);
    }

    @Deprecated
    public void setLastChange(RecordCursor cursor, double lastChange) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iChange, lastChange);
    }

    @Deprecated
    public int getLastChangeDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iChange);
    }

    @Deprecated
    public void setLastChangeDecimal(RecordCursor cursor, int lastChange) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iChange, lastChange);
    }

    @Deprecated
    public long getLastChangeWideDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iChange);
    }

    @Deprecated
    public void setLastChangeWideDecimal(RecordCursor cursor, long lastChange) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iChange, lastChange);
    }

    public double getChange(RecordCursor cursor) {
        if (this.iChange < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iChange);
    }

    public void setChange(RecordCursor cursor, double change) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iChange, change);
    }

    public int getChangeDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iChange);
    }

    public void setChangeDecimal(RecordCursor cursor, int change) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iChange, change);
    }

    public long getChangeWideDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iChange);
    }

    public void setChangeWideDecimal(RecordCursor cursor, long change) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iChange, change);
    }

    @Deprecated
    public long getVolume(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setVolume(RecordCursor cursor, long volume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iDayVolume, volume);
    }

    @Deprecated
    public double getVolumeDouble(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setVolumeDouble(RecordCursor cursor, double volume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayVolume, volume);
    }

    @Deprecated
    public int getVolumeDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setVolumeDecimal(RecordCursor cursor, int volume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayVolume, volume);
    }

    @Deprecated
    public long getVolumeWideDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setVolumeWideDecimal(RecordCursor cursor, long volume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayVolume, volume);
    }

    public long getDayVolume(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iDayVolume);
    }

    public void setDayVolume(RecordCursor cursor, long dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iDayVolume, dayVolume);
    }

    public double getDayVolumeDouble(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayVolume);
    }

    public void setDayVolumeDouble(RecordCursor cursor, double dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayVolume, dayVolume);
    }

    public int getDayVolumeDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayVolume);
    }

    public void setDayVolumeDecimal(RecordCursor cursor, int dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayVolume, dayVolume);
    }

    public long getDayVolumeWideDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayVolume);
    }

    public void setDayVolumeWideDecimal(RecordCursor cursor, long dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayVolume, dayVolume);
    }

    public double getDayTurnover(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayTurnover);
    }

    public void setDayTurnover(RecordCursor cursor, double dayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayTurnover, dayTurnover);
    }

    public int getDayTurnoverDecimal(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayTurnover);
    }

    public void setDayTurnoverDecimal(RecordCursor cursor, int dayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayTurnover, dayTurnover);
    }

    public long getDayTurnoverWideDecimal(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayTurnover);
    }

    public void setDayTurnoverWideDecimal(RecordCursor cursor, long dayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayTurnover, dayTurnover);
    }

    @Deprecated
    public int getLastFlags(RecordCursor cursor) {
        if (this.iFlags < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iFlags);
    }

    @Deprecated
    public void setLastFlags(RecordCursor cursor, int lastFlags) {
        if (this.iFlags < 0) {
            return;
        }
        this.setInt(cursor, this.iFlags, lastFlags);
    }

    public int getFlags(RecordCursor cursor) {
        if (this.iFlags < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        if (this.iFlags < 0) {
            return;
        }
        this.setInt(cursor, this.iFlags, flags);
    }
}

