/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public class TradeETHMapping
extends MarketEventMapping {
    private final int iTime;
    private final int iSequence;
    private final int iTimeNanoPart;
    private final int iExchangeCode;
    private final int iPrice;
    private final int iSize;
    private final int iChange;
    private final int iDayVolume;
    private final int iDayTurnover;
    private final int iFlags;

    public TradeETHMapping(DataRecord record) {
        super(record);
        this.iTime = MappingUtil.findIntField(record, "ETHLast.Time", false);
        this.iSequence = MappingUtil.findIntField(record, "ETHLast.Sequence", false);
        this.iTimeNanoPart = MappingUtil.findIntField(record, "Last.TimeNanoPart", false);
        this.iExchangeCode = MappingUtil.findIntField(record, "ETHLast.Exchange", false);
        this.iPrice = this.findIntField("ETHLast.Price", true);
        this.iSize = this.findIntField("ETHLast.Size", true);
        this.iChange = this.findIntField("ETHLast.Change", false);
        this.iDayVolume = this.findIntField("ETHVolume", false);
        this.iDayTurnover = this.findIntField("ETHDayTurnover", false);
        this.iFlags = MappingUtil.findIntField(record, "ETHLast.Flags", true);
        this.putNonDefaultPropertyName("ETHLast.Time", "Time");
        this.putNonDefaultPropertyName("ETHLast.Sequence", "Sequence");
        this.putNonDefaultPropertyName("Last.TimeNanoPart", "TimeNanoPart");
        this.putNonDefaultPropertyName("ETHLast.Exchange", "ExchangeCode");
        this.putNonDefaultPropertyName("ETHLast.Price", "Price");
        this.putNonDefaultPropertyName("ETHLast.Size", "Size");
        this.putNonDefaultPropertyName("ETHLast.Change", "Change");
        this.putNonDefaultPropertyName("ETHVolume", "DayVolume");
        this.putNonDefaultPropertyName("ETHDayTurnover", "DayTurnover");
        this.putNonDefaultPropertyName("ETHLast.Flags", "Flags");
    }

    @Deprecated
    public long getETHLastTimeMillis(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    @Deprecated
    public void setETHLastTimeMillis(RecordCursor cursor, long _ETHLastTime) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(_ETHLastTime));
    }

    @Deprecated
    public int getETHLastTimeSeconds(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTime);
    }

    @Deprecated
    public void setETHLastTimeSeconds(RecordCursor cursor, int _ETHLastTime) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, _ETHLastTime);
    }

    public long getTimeMillis(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        if (this.iTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        if (this.iTime < 0) {
            return;
        }
        this.setInt(cursor, this.iTime, time);
    }

    @Deprecated
    public int getETHLastSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    @Deprecated
    public void setETHLastSequence(RecordCursor cursor, int _ETHLastSequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, _ETHLastSequence);
    }

    public int getSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, sequence);
    }

    @Deprecated
    public int getLastTimeNanoPart(RecordCursor cursor) {
        if (this.iTimeNanoPart < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTimeNanoPart);
    }

    @Deprecated
    public void setLastTimeNanoPart(RecordCursor cursor, int lastTimeNanoPart) {
        if (this.iTimeNanoPart < 0) {
            return;
        }
        this.setInt(cursor, this.iTimeNanoPart, lastTimeNanoPart);
    }

    public int getTimeNanoPart(RecordCursor cursor) {
        if (this.iTimeNanoPart < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTimeNanoPart);
    }

    public void setTimeNanoPart(RecordCursor cursor, int timeNanoPart) {
        if (this.iTimeNanoPart < 0) {
            return;
        }
        this.setInt(cursor, this.iTimeNanoPart, timeNanoPart);
    }

    @Deprecated
    public char getETHLastExchange(RecordCursor cursor) {
        if (this.iExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    @Deprecated
    public void setETHLastExchange(RecordCursor cursor, char _ETHLastExchange) {
        if (this.iExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iExchangeCode, _ETHLastExchange);
    }

    public char getExchangeCode(RecordCursor cursor) {
        if (this.iExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    public void setExchangeCode(RecordCursor cursor, char exchangeCode) {
        if (this.iExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iExchangeCode, exchangeCode);
    }

    @Deprecated
    public double getETHLastPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    @Deprecated
    public void setETHLastPrice(RecordCursor cursor, double _ETHLastPrice) {
        this.setAsDouble(cursor, this.iPrice, _ETHLastPrice);
    }

    @Deprecated
    public int getETHLastPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    @Deprecated
    public void setETHLastPriceDecimal(RecordCursor cursor, int _ETHLastPrice) {
        this.setAsTinyDecimal(cursor, this.iPrice, _ETHLastPrice);
    }

    @Deprecated
    public long getETHLastPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    @Deprecated
    public void setETHLastPriceWideDecimal(RecordCursor cursor, long _ETHLastPrice) {
        this.setAsWideDecimal(cursor, this.iPrice, _ETHLastPrice);
    }

    public double getPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        this.setAsDouble(cursor, this.iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        this.setAsTinyDecimal(cursor, this.iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        this.setAsWideDecimal(cursor, this.iPrice, price);
    }

    @Deprecated
    public int getETHLastSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iSize);
    }

    @Deprecated
    public void setETHLastSize(RecordCursor cursor, int _ETHLastSize) {
        this.setAsInt(cursor, this.iSize, _ETHLastSize);
    }

    @Deprecated
    public long getETHLastSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iSize);
    }

    @Deprecated
    public void setETHLastSizeLong(RecordCursor cursor, long _ETHLastSize) {
        this.setAsLong(cursor, this.iSize, _ETHLastSize);
    }

    @Deprecated
    public double getETHLastSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iSize);
    }

    @Deprecated
    public void setETHLastSizeDouble(RecordCursor cursor, double _ETHLastSize) {
        this.setAsDouble(cursor, this.iSize, _ETHLastSize);
    }

    @Deprecated
    public int getETHLastSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iSize);
    }

    @Deprecated
    public void setETHLastSizeDecimal(RecordCursor cursor, int _ETHLastSize) {
        this.setAsTinyDecimal(cursor, this.iSize, _ETHLastSize);
    }

    @Deprecated
    public long getETHLastSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iSize);
    }

    @Deprecated
    public void setETHLastSizeWideDecimal(RecordCursor cursor, long _ETHLastSize) {
        this.setAsWideDecimal(cursor, this.iSize, _ETHLastSize);
    }

    public int getSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iSize);
    }

    public void setSize(RecordCursor cursor, int size) {
        this.setAsInt(cursor, this.iSize, size);
    }

    public long getSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iSize);
    }

    public void setSizeLong(RecordCursor cursor, long size) {
        this.setAsLong(cursor, this.iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        this.setAsDouble(cursor, this.iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        this.setAsTinyDecimal(cursor, this.iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        this.setAsWideDecimal(cursor, this.iSize, size);
    }

    @Deprecated
    public double getETHLastChange(RecordCursor cursor) {
        if (this.iChange < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iChange);
    }

    @Deprecated
    public void setETHLastChange(RecordCursor cursor, double _ETHLastChange) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iChange, _ETHLastChange);
    }

    @Deprecated
    public int getETHLastChangeDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iChange);
    }

    @Deprecated
    public void setETHLastChangeDecimal(RecordCursor cursor, int _ETHLastChange) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iChange, _ETHLastChange);
    }

    @Deprecated
    public long getETHLastChangeWideDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iChange);
    }

    @Deprecated
    public void setETHLastChangeWideDecimal(RecordCursor cursor, long _ETHLastChange) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iChange, _ETHLastChange);
    }

    public double getChange(RecordCursor cursor) {
        if (this.iChange < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iChange);
    }

    public void setChange(RecordCursor cursor, double change) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iChange, change);
    }

    public int getChangeDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iChange);
    }

    public void setChangeDecimal(RecordCursor cursor, int change) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iChange, change);
    }

    public long getChangeWideDecimal(RecordCursor cursor) {
        if (this.iChange < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iChange);
    }

    public void setChangeWideDecimal(RecordCursor cursor, long change) {
        if (this.iChange < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iChange, change);
    }

    @Deprecated
    public long getETHVolume(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setETHVolume(RecordCursor cursor, long _ETHVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iDayVolume, _ETHVolume);
    }

    @Deprecated
    public double getETHVolumeDouble(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setETHVolumeDouble(RecordCursor cursor, double _ETHVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayVolume, _ETHVolume);
    }

    @Deprecated
    public int getETHVolumeDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setETHVolumeDecimal(RecordCursor cursor, int _ETHVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayVolume, _ETHVolume);
    }

    @Deprecated
    public long getETHVolumeWideDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayVolume);
    }

    @Deprecated
    public void setETHVolumeWideDecimal(RecordCursor cursor, long _ETHVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayVolume, _ETHVolume);
    }

    public long getDayVolume(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iDayVolume);
    }

    public void setDayVolume(RecordCursor cursor, long dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iDayVolume, dayVolume);
    }

    public double getDayVolumeDouble(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayVolume);
    }

    public void setDayVolumeDouble(RecordCursor cursor, double dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayVolume, dayVolume);
    }

    public int getDayVolumeDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayVolume);
    }

    public void setDayVolumeDecimal(RecordCursor cursor, int dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayVolume, dayVolume);
    }

    public long getDayVolumeWideDecimal(RecordCursor cursor) {
        if (this.iDayVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayVolume);
    }

    public void setDayVolumeWideDecimal(RecordCursor cursor, long dayVolume) {
        if (this.iDayVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayVolume, dayVolume);
    }

    @Deprecated
    public double getETHDayTurnover(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayTurnover);
    }

    @Deprecated
    public void setETHDayTurnover(RecordCursor cursor, double _ETHDayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayTurnover, _ETHDayTurnover);
    }

    @Deprecated
    public int getETHDayTurnoverDecimal(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayTurnover);
    }

    @Deprecated
    public void setETHDayTurnoverDecimal(RecordCursor cursor, int _ETHDayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayTurnover, _ETHDayTurnover);
    }

    @Deprecated
    public long getETHDayTurnoverWideDecimal(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayTurnover);
    }

    @Deprecated
    public void setETHDayTurnoverWideDecimal(RecordCursor cursor, long _ETHDayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayTurnover, _ETHDayTurnover);
    }

    public double getDayTurnover(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayTurnover);
    }

    public void setDayTurnover(RecordCursor cursor, double dayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayTurnover, dayTurnover);
    }

    public int getDayTurnoverDecimal(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayTurnover);
    }

    public void setDayTurnoverDecimal(RecordCursor cursor, int dayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayTurnover, dayTurnover);
    }

    public long getDayTurnoverWideDecimal(RecordCursor cursor) {
        if (this.iDayTurnover < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayTurnover);
    }

    public void setDayTurnoverWideDecimal(RecordCursor cursor, long dayTurnover) {
        if (this.iDayTurnover < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayTurnover, dayTurnover);
    }

    @Deprecated
    public int getETHLastFlags(RecordCursor cursor) {
        return this.getInt(cursor, this.iFlags);
    }

    @Deprecated
    public void setETHLastFlags(RecordCursor cursor, int _ETHLastFlags) {
        this.setInt(cursor, this.iFlags, _ETHLastFlags);
    }

    public int getFlags(RecordCursor cursor) {
        return this.getInt(cursor, this.iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        this.setInt(cursor, this.iFlags, flags);
    }
}

