/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.qd.util.ShortString;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public class TimeAndSaleMapping
extends MarketEventMapping {
    private final int iTime;
    private final int iSequence;
    private final int iTimeNanoPart;
    private final int iExchangeCode;
    private final int iPrice;
    private final int iSize;
    private final int iBidPrice;
    private final int iAskPrice;
    private final int iSaleConditions;
    private final int iFlags;
    private final int oBuyer;
    private final int oSeller;

    public TimeAndSaleMapping(DataRecord record) {
        super(record);
        this.iTime = MappingUtil.findIntField(record, "Time", true);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", true);
        this.iTimeNanoPart = MappingUtil.findIntField(record, "TimeNanoPart", false);
        this.iExchangeCode = MappingUtil.findIntField(record, "Exchange", true);
        this.iPrice = this.findIntField("Price", true);
        this.iSize = this.findIntField("Size", true);
        this.iBidPrice = this.findIntField("Bid.Price", true);
        this.iAskPrice = this.findIntField("Ask.Price", true);
        this.iSaleConditions = MappingUtil.findIntField(record, "ExchangeSaleConditions", true);
        this.iFlags = MappingUtil.findIntField(record, "Flags", true);
        this.oBuyer = MappingUtil.findObjField(record, "Buyer", false);
        this.oSeller = MappingUtil.findObjField(record, "Seller", false);
        this.putNonDefaultPropertyName("Exchange", "ExchangeCode");
        this.putNonDefaultPropertyName("ExchangeSaleConditions", "SaleConditions");
    }

    public long getTimeMillis(RecordCursor cursor) {
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        this.setInt(cursor, this.iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        this.setInt(cursor, this.iSequence, sequence);
    }

    public int getTimeNanoPart(RecordCursor cursor) {
        if (this.iTimeNanoPart < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTimeNanoPart);
    }

    public void setTimeNanoPart(RecordCursor cursor, int timeNanoPart) {
        if (this.iTimeNanoPart < 0) {
            return;
        }
        this.setInt(cursor, this.iTimeNanoPart, timeNanoPart);
    }

    @Deprecated
    public char getExchange(RecordCursor cursor) {
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    @Deprecated
    public void setExchange(RecordCursor cursor, char exchange) {
        this.setInt(cursor, this.iExchangeCode, exchange);
    }

    public char getExchangeCode(RecordCursor cursor) {
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    public void setExchangeCode(RecordCursor cursor, char exchangeCode) {
        this.setInt(cursor, this.iExchangeCode, exchangeCode);
    }

    public double getPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        this.setAsDouble(cursor, this.iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        this.setAsTinyDecimal(cursor, this.iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        this.setAsWideDecimal(cursor, this.iPrice, price);
    }

    public int getSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iSize);
    }

    public void setSize(RecordCursor cursor, int size) {
        this.setAsInt(cursor, this.iSize, size);
    }

    public long getSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iSize);
    }

    public void setSizeLong(RecordCursor cursor, long size) {
        this.setAsLong(cursor, this.iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        this.setAsDouble(cursor, this.iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        this.setAsTinyDecimal(cursor, this.iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        this.setAsWideDecimal(cursor, this.iSize, size);
    }

    public double getBidPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iBidPrice);
    }

    public void setBidPrice(RecordCursor cursor, double bidPrice) {
        this.setAsDouble(cursor, this.iBidPrice, bidPrice);
    }

    public int getBidPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceDecimal(RecordCursor cursor, int bidPrice) {
        this.setAsTinyDecimal(cursor, this.iBidPrice, bidPrice);
    }

    public long getBidPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceWideDecimal(RecordCursor cursor, long bidPrice) {
        this.setAsWideDecimal(cursor, this.iBidPrice, bidPrice);
    }

    public double getAskPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iAskPrice);
    }

    public void setAskPrice(RecordCursor cursor, double askPrice) {
        this.setAsDouble(cursor, this.iAskPrice, askPrice);
    }

    public int getAskPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceDecimal(RecordCursor cursor, int askPrice) {
        this.setAsTinyDecimal(cursor, this.iAskPrice, askPrice);
    }

    public long getAskPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceWideDecimal(RecordCursor cursor, long askPrice) {
        this.setAsWideDecimal(cursor, this.iAskPrice, askPrice);
    }

    @Deprecated
    public String getExchangeSaleConditionsString(RecordCursor cursor) {
        return ShortString.decode(this.getInt(cursor, this.iSaleConditions));
    }

    @Deprecated
    public void setExchangeSaleConditionsString(RecordCursor cursor, String exchangeSaleConditions) {
        this.setInt(cursor, this.iSaleConditions, (int)ShortString.encode(exchangeSaleConditions));
    }

    @Deprecated
    public int getExchangeSaleConditions(RecordCursor cursor) {
        return this.getInt(cursor, this.iSaleConditions);
    }

    @Deprecated
    public void setExchangeSaleConditions(RecordCursor cursor, int exchangeSaleConditions) {
        this.setInt(cursor, this.iSaleConditions, exchangeSaleConditions);
    }

    public String getSaleConditionsString(RecordCursor cursor) {
        return ShortString.decode(this.getInt(cursor, this.iSaleConditions));
    }

    public void setSaleConditionsString(RecordCursor cursor, String saleConditions) {
        this.setInt(cursor, this.iSaleConditions, (int)ShortString.encode(saleConditions));
    }

    public int getSaleConditions(RecordCursor cursor) {
        return this.getInt(cursor, this.iSaleConditions);
    }

    public void setSaleConditions(RecordCursor cursor, int saleConditions) {
        this.setInt(cursor, this.iSaleConditions, saleConditions);
    }

    public int getFlags(RecordCursor cursor) {
        return this.getInt(cursor, this.iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        this.setInt(cursor, this.iFlags, flags);
    }

    public String getBuyer(RecordCursor cursor) {
        if (this.oBuyer < 0) {
            return null;
        }
        return (String)this.getObj(cursor, this.oBuyer);
    }

    public void setBuyer(RecordCursor cursor, String buyer) {
        if (this.oBuyer < 0) {
            return;
        }
        this.setObj(cursor, this.oBuyer, buyer);
    }

    public String getSeller(RecordCursor cursor) {
        if (this.oSeller < 0) {
            return null;
        }
        return (String)this.getObj(cursor, this.oSeller);
    }

    public void setSeller(RecordCursor cursor, String seller) {
        if (this.oSeller < 0) {
            return;
        }
        this.setObj(cursor, this.oSeller, seller);
    }
}

