/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public class SummaryMapping
extends MarketEventMapping {
    private final int iDayId;
    private final int iDayOpenPrice;
    private final int iDayHighPrice;
    private final int iDayLowPrice;
    private final int iDayClosePrice;
    private final int iPrevDayId;
    private final int iPrevDayClosePrice;
    private final int iPrevDayVolume;
    private final int iOpenInterest;
    private final int iFlags;

    public SummaryMapping(DataRecord record) {
        super(record);
        this.iDayId = MappingUtil.findIntField(record, "DayId", true);
        this.iDayOpenPrice = this.findIntField("DayOpen.Price", true);
        this.iDayHighPrice = this.findIntField("DayHigh.Price", true);
        this.iDayLowPrice = this.findIntField("DayLow.Price", true);
        this.iDayClosePrice = this.findIntField("DayClose.Price", false);
        this.iPrevDayId = MappingUtil.findIntField(record, "PrevDayId", true);
        this.iPrevDayClosePrice = this.findIntField("PrevDayClose.Price", true);
        this.iPrevDayVolume = this.findIntField("PrevDayVolume", false);
        this.iOpenInterest = this.findIntField("OpenInterest", false);
        this.iFlags = MappingUtil.findIntField(record, "Flags", false);
    }

    public int getDayId(RecordCursor cursor) {
        return this.getInt(cursor, this.iDayId);
    }

    public void setDayId(RecordCursor cursor, int dayId) {
        this.setInt(cursor, this.iDayId, dayId);
    }

    public double getDayOpenPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iDayOpenPrice);
    }

    public void setDayOpenPrice(RecordCursor cursor, double dayOpenPrice) {
        this.setAsDouble(cursor, this.iDayOpenPrice, dayOpenPrice);
    }

    public int getDayOpenPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iDayOpenPrice);
    }

    public void setDayOpenPriceDecimal(RecordCursor cursor, int dayOpenPrice) {
        this.setAsTinyDecimal(cursor, this.iDayOpenPrice, dayOpenPrice);
    }

    public long getDayOpenPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iDayOpenPrice);
    }

    public void setDayOpenPriceWideDecimal(RecordCursor cursor, long dayOpenPrice) {
        this.setAsWideDecimal(cursor, this.iDayOpenPrice, dayOpenPrice);
    }

    public double getDayHighPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iDayHighPrice);
    }

    public void setDayHighPrice(RecordCursor cursor, double dayHighPrice) {
        this.setAsDouble(cursor, this.iDayHighPrice, dayHighPrice);
    }

    public int getDayHighPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iDayHighPrice);
    }

    public void setDayHighPriceDecimal(RecordCursor cursor, int dayHighPrice) {
        this.setAsTinyDecimal(cursor, this.iDayHighPrice, dayHighPrice);
    }

    public long getDayHighPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iDayHighPrice);
    }

    public void setDayHighPriceWideDecimal(RecordCursor cursor, long dayHighPrice) {
        this.setAsWideDecimal(cursor, this.iDayHighPrice, dayHighPrice);
    }

    public double getDayLowPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iDayLowPrice);
    }

    public void setDayLowPrice(RecordCursor cursor, double dayLowPrice) {
        this.setAsDouble(cursor, this.iDayLowPrice, dayLowPrice);
    }

    public int getDayLowPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iDayLowPrice);
    }

    public void setDayLowPriceDecimal(RecordCursor cursor, int dayLowPrice) {
        this.setAsTinyDecimal(cursor, this.iDayLowPrice, dayLowPrice);
    }

    public long getDayLowPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iDayLowPrice);
    }

    public void setDayLowPriceWideDecimal(RecordCursor cursor, long dayLowPrice) {
        this.setAsWideDecimal(cursor, this.iDayLowPrice, dayLowPrice);
    }

    public double getDayClosePrice(RecordCursor cursor) {
        if (this.iDayClosePrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDayClosePrice);
    }

    public void setDayClosePrice(RecordCursor cursor, double dayClosePrice) {
        if (this.iDayClosePrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDayClosePrice, dayClosePrice);
    }

    public int getDayClosePriceDecimal(RecordCursor cursor) {
        if (this.iDayClosePrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDayClosePrice);
    }

    public void setDayClosePriceDecimal(RecordCursor cursor, int dayClosePrice) {
        if (this.iDayClosePrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDayClosePrice, dayClosePrice);
    }

    public long getDayClosePriceWideDecimal(RecordCursor cursor) {
        if (this.iDayClosePrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDayClosePrice);
    }

    public void setDayClosePriceWideDecimal(RecordCursor cursor, long dayClosePrice) {
        if (this.iDayClosePrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDayClosePrice, dayClosePrice);
    }

    public int getPrevDayId(RecordCursor cursor) {
        return this.getInt(cursor, this.iPrevDayId);
    }

    public void setPrevDayId(RecordCursor cursor, int prevDayId) {
        this.setInt(cursor, this.iPrevDayId, prevDayId);
    }

    public double getPrevDayClosePrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrevDayClosePrice);
    }

    public void setPrevDayClosePrice(RecordCursor cursor, double prevDayClosePrice) {
        this.setAsDouble(cursor, this.iPrevDayClosePrice, prevDayClosePrice);
    }

    public int getPrevDayClosePriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrevDayClosePrice);
    }

    public void setPrevDayClosePriceDecimal(RecordCursor cursor, int prevDayClosePrice) {
        this.setAsTinyDecimal(cursor, this.iPrevDayClosePrice, prevDayClosePrice);
    }

    public long getPrevDayClosePriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrevDayClosePrice);
    }

    public void setPrevDayClosePriceWideDecimal(RecordCursor cursor, long prevDayClosePrice) {
        this.setAsWideDecimal(cursor, this.iPrevDayClosePrice, prevDayClosePrice);
    }

    public long getPrevDayVolume(RecordCursor cursor) {
        if (this.iPrevDayVolume < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iPrevDayVolume);
    }

    public void setPrevDayVolume(RecordCursor cursor, long prevDayVolume) {
        if (this.iPrevDayVolume < 0) {
            return;
        }
        this.setAsLong(cursor, this.iPrevDayVolume, prevDayVolume);
    }

    public double getPrevDayVolumeDouble(RecordCursor cursor) {
        if (this.iPrevDayVolume < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iPrevDayVolume);
    }

    public void setPrevDayVolumeDouble(RecordCursor cursor, double prevDayVolume) {
        if (this.iPrevDayVolume < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iPrevDayVolume, prevDayVolume);
    }

    public int getPrevDayVolumeDecimal(RecordCursor cursor) {
        if (this.iPrevDayVolume < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iPrevDayVolume);
    }

    public void setPrevDayVolumeDecimal(RecordCursor cursor, int prevDayVolume) {
        if (this.iPrevDayVolume < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iPrevDayVolume, prevDayVolume);
    }

    public long getPrevDayVolumeWideDecimal(RecordCursor cursor) {
        if (this.iPrevDayVolume < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iPrevDayVolume);
    }

    public void setPrevDayVolumeWideDecimal(RecordCursor cursor, long prevDayVolume) {
        if (this.iPrevDayVolume < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iPrevDayVolume, prevDayVolume);
    }

    public int getOpenInterest(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return 0;
        }
        return this.getAsInt(cursor, this.iOpenInterest);
    }

    public void setOpenInterest(RecordCursor cursor, int openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsInt(cursor, this.iOpenInterest, openInterest);
    }

    public long getOpenInterestLong(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iOpenInterest);
    }

    public void setOpenInterestLong(RecordCursor cursor, long openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsLong(cursor, this.iOpenInterest, openInterest);
    }

    public double getOpenInterestDouble(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iOpenInterest);
    }

    public void setOpenInterestDouble(RecordCursor cursor, double openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iOpenInterest, openInterest);
    }

    public int getOpenInterestDecimal(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iOpenInterest);
    }

    public void setOpenInterestDecimal(RecordCursor cursor, int openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iOpenInterest, openInterest);
    }

    public long getOpenInterestWideDecimal(RecordCursor cursor) {
        if (this.iOpenInterest < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iOpenInterest);
    }

    public void setOpenInterestWideDecimal(RecordCursor cursor, long openInterest) {
        if (this.iOpenInterest < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iOpenInterest, openInterest);
    }

    public int getFlags(RecordCursor cursor) {
        if (this.iFlags < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        if (this.iFlags < 0) {
            return;
        }
        this.setInt(cursor, this.iFlags, flags);
    }
}

