/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public class QuoteMapping
extends MarketEventMapping {
    private final int iSequence;
    private final int iTimeNanoPart;
    private final int iBidTime;
    private final int iBidExchangeCode;
    private final int iBidPrice;
    private final int iBidSize;
    private final int iAskTime;
    private final int iAskExchangeCode;
    private final int iAskPrice;
    private final int iAskSize;

    public QuoteMapping(DataRecord record) {
        super(record);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", false);
        this.iTimeNanoPart = MappingUtil.findIntField(record, "TimeNanoPart", false);
        this.iBidTime = MappingUtil.findIntField(record, "Bid.Time", false);
        this.iBidExchangeCode = MappingUtil.findIntField(record, "Bid.Exchange", false);
        this.iBidPrice = this.findIntField("Bid.Price", true);
        this.iBidSize = this.findIntField("Bid.Size", true);
        this.iAskTime = MappingUtil.findIntField(record, "Ask.Time", false);
        this.iAskExchangeCode = MappingUtil.findIntField(record, "Ask.Exchange", false);
        this.iAskPrice = this.findIntField("Ask.Price", true);
        this.iAskSize = this.findIntField("Ask.Size", true);
        this.putNonDefaultPropertyName("Bid.Exchange", "BidExchangeCode");
        this.putNonDefaultPropertyName("Ask.Exchange", "AskExchangeCode");
    }

    public int getSequence(RecordCursor cursor) {
        if (this.iSequence < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        if (this.iSequence < 0) {
            return;
        }
        this.setInt(cursor, this.iSequence, sequence);
    }

    public int getTimeNanoPart(RecordCursor cursor) {
        if (this.iTimeNanoPart < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTimeNanoPart);
    }

    public void setTimeNanoPart(RecordCursor cursor, int timeNanoPart) {
        if (this.iTimeNanoPart < 0) {
            return;
        }
        this.setInt(cursor, this.iTimeNanoPart, timeNanoPart);
    }

    public long getBidTimeMillis(RecordCursor cursor) {
        if (this.iBidTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iBidTime) * 1000L;
    }

    public void setBidTimeMillis(RecordCursor cursor, long bidTime) {
        if (this.iBidTime < 0) {
            return;
        }
        this.setInt(cursor, this.iBidTime, TimeUtil.getSecondsFromTime(bidTime));
    }

    public int getBidTimeSeconds(RecordCursor cursor) {
        if (this.iBidTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iBidTime);
    }

    public void setBidTimeSeconds(RecordCursor cursor, int bidTime) {
        if (this.iBidTime < 0) {
            return;
        }
        this.setInt(cursor, this.iBidTime, bidTime);
    }

    @Deprecated
    public char getBidExchange(RecordCursor cursor) {
        if (this.iBidExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iBidExchangeCode);
    }

    @Deprecated
    public void setBidExchange(RecordCursor cursor, char bidExchange) {
        if (this.iBidExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iBidExchangeCode, bidExchange);
    }

    public char getBidExchangeCode(RecordCursor cursor) {
        if (this.iBidExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iBidExchangeCode);
    }

    public void setBidExchangeCode(RecordCursor cursor, char bidExchangeCode) {
        if (this.iBidExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iBidExchangeCode, bidExchangeCode);
    }

    public double getBidPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iBidPrice);
    }

    public void setBidPrice(RecordCursor cursor, double bidPrice) {
        this.setAsDouble(cursor, this.iBidPrice, bidPrice);
    }

    public int getBidPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceDecimal(RecordCursor cursor, int bidPrice) {
        this.setAsTinyDecimal(cursor, this.iBidPrice, bidPrice);
    }

    public long getBidPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceWideDecimal(RecordCursor cursor, long bidPrice) {
        this.setAsWideDecimal(cursor, this.iBidPrice, bidPrice);
    }

    public int getBidSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iBidSize);
    }

    public void setBidSize(RecordCursor cursor, int bidSize) {
        this.setAsInt(cursor, this.iBidSize, bidSize);
    }

    public long getBidSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iBidSize);
    }

    public void setBidSizeLong(RecordCursor cursor, long bidSize) {
        this.setAsLong(cursor, this.iBidSize, bidSize);
    }

    public double getBidSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iBidSize);
    }

    public void setBidSizeDouble(RecordCursor cursor, double bidSize) {
        this.setAsDouble(cursor, this.iBidSize, bidSize);
    }

    public int getBidSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iBidSize);
    }

    public void setBidSizeDecimal(RecordCursor cursor, int bidSize) {
        this.setAsTinyDecimal(cursor, this.iBidSize, bidSize);
    }

    public long getBidSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iBidSize);
    }

    public void setBidSizeWideDecimal(RecordCursor cursor, long bidSize) {
        this.setAsWideDecimal(cursor, this.iBidSize, bidSize);
    }

    public long getAskTimeMillis(RecordCursor cursor) {
        if (this.iAskTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iAskTime) * 1000L;
    }

    public void setAskTimeMillis(RecordCursor cursor, long askTime) {
        if (this.iAskTime < 0) {
            return;
        }
        this.setInt(cursor, this.iAskTime, TimeUtil.getSecondsFromTime(askTime));
    }

    public int getAskTimeSeconds(RecordCursor cursor) {
        if (this.iAskTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iAskTime);
    }

    public void setAskTimeSeconds(RecordCursor cursor, int askTime) {
        if (this.iAskTime < 0) {
            return;
        }
        this.setInt(cursor, this.iAskTime, askTime);
    }

    @Deprecated
    public char getAskExchange(RecordCursor cursor) {
        if (this.iAskExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iAskExchangeCode);
    }

    @Deprecated
    public void setAskExchange(RecordCursor cursor, char askExchange) {
        if (this.iAskExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iAskExchangeCode, askExchange);
    }

    public char getAskExchangeCode(RecordCursor cursor) {
        if (this.iAskExchangeCode < 0) {
            return this.recordExchange;
        }
        return (char)this.getInt(cursor, this.iAskExchangeCode);
    }

    public void setAskExchangeCode(RecordCursor cursor, char askExchangeCode) {
        if (this.iAskExchangeCode < 0) {
            return;
        }
        this.setInt(cursor, this.iAskExchangeCode, askExchangeCode);
    }

    public double getAskPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iAskPrice);
    }

    public void setAskPrice(RecordCursor cursor, double askPrice) {
        this.setAsDouble(cursor, this.iAskPrice, askPrice);
    }

    public int getAskPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceDecimal(RecordCursor cursor, int askPrice) {
        this.setAsTinyDecimal(cursor, this.iAskPrice, askPrice);
    }

    public long getAskPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceWideDecimal(RecordCursor cursor, long askPrice) {
        this.setAsWideDecimal(cursor, this.iAskPrice, askPrice);
    }

    public int getAskSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iAskSize);
    }

    public void setAskSize(RecordCursor cursor, int askSize) {
        this.setAsInt(cursor, this.iAskSize, askSize);
    }

    public long getAskSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iAskSize);
    }

    public void setAskSizeLong(RecordCursor cursor, long askSize) {
        this.setAsLong(cursor, this.iAskSize, askSize);
    }

    public double getAskSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iAskSize);
    }

    public void setAskSizeDouble(RecordCursor cursor, double askSize) {
        this.setAsDouble(cursor, this.iAskSize, askSize);
    }

    public int getAskSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iAskSize);
    }

    public void setAskSizeDecimal(RecordCursor cursor, int askSize) {
        this.setAsTinyDecimal(cursor, this.iAskSize, askSize);
    }

    public long getAskSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iAskSize);
    }

    public void setAskSizeWideDecimal(RecordCursor cursor, long askSize) {
        this.setAsWideDecimal(cursor, this.iAskSize, askSize);
    }
}

