/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public class ProfileMapping
extends MarketEventMapping {
    private final int iBeta = this.findIntField("Beta", false);
    private final int iEps = this.findIntField("Eps", false);
    private final int iDivFreq = this.findIntField("DivFreq", false);
    private final int iExdDivAmount = this.findIntField("ExdDiv.Amount", false);
    private final int iExdDivDate;
    private final int iHighPrice52;
    private final int iLowPrice52;
    private final int iShares;
    private final int iFreeFloat;
    private final int iHighLimitPrice;
    private final int iLowLimitPrice;
    private final int iHaltStartTime;
    private final int iHaltEndTime;
    private final int iFlags;
    private final int oDescription;
    private final int oStatusReason;

    public ProfileMapping(DataRecord record) {
        super(record);
        this.iExdDivDate = MappingUtil.findIntField(record, "ExdDiv.Date", false);
        this.iHighPrice52 = this.findIntField("52High.Price", false);
        this.iLowPrice52 = this.findIntField("52Low.Price", false);
        this.iShares = this.findIntField("Shares", false);
        this.iFreeFloat = this.findIntField("FreeFloat", false);
        this.iHighLimitPrice = this.findIntField("HighLimitPrice", false);
        this.iLowLimitPrice = this.findIntField("LowLimitPrice", false);
        this.iHaltStartTime = MappingUtil.findIntField(record, "Halt.StartTime", false);
        this.iHaltEndTime = MappingUtil.findIntField(record, "Halt.EndTime", false);
        this.iFlags = MappingUtil.findIntField(record, "Flags", false);
        this.oDescription = MappingUtil.findObjField(record, "Description", true);
        this.oStatusReason = MappingUtil.findObjField(record, "StatusReason", false);
        this.putNonDefaultPropertyName("52High.Price", "HighPrice52");
        this.putNonDefaultPropertyName("52Low.Price", "LowPrice52");
    }

    public double getBeta(RecordCursor cursor) {
        if (this.iBeta < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iBeta);
    }

    public void setBeta(RecordCursor cursor, double beta) {
        if (this.iBeta < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iBeta, beta);
    }

    public int getBetaDecimal(RecordCursor cursor) {
        if (this.iBeta < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iBeta);
    }

    public void setBetaDecimal(RecordCursor cursor, int beta) {
        if (this.iBeta < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iBeta, beta);
    }

    public long getBetaWideDecimal(RecordCursor cursor) {
        if (this.iBeta < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iBeta);
    }

    public void setBetaWideDecimal(RecordCursor cursor, long beta) {
        if (this.iBeta < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iBeta, beta);
    }

    public double getEps(RecordCursor cursor) {
        if (this.iEps < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iEps);
    }

    public void setEps(RecordCursor cursor, double eps) {
        if (this.iEps < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iEps, eps);
    }

    public int getEpsDecimal(RecordCursor cursor) {
        if (this.iEps < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iEps);
    }

    public void setEpsDecimal(RecordCursor cursor, int eps) {
        if (this.iEps < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iEps, eps);
    }

    public long getEpsWideDecimal(RecordCursor cursor) {
        if (this.iEps < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iEps);
    }

    public void setEpsWideDecimal(RecordCursor cursor, long eps) {
        if (this.iEps < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iEps, eps);
    }

    public int getDivFreq(RecordCursor cursor) {
        if (this.iDivFreq < 0) {
            return 0;
        }
        return this.getAsInt(cursor, this.iDivFreq);
    }

    public void setDivFreq(RecordCursor cursor, int divFreq) {
        if (this.iDivFreq < 0) {
            return;
        }
        this.setAsInt(cursor, this.iDivFreq, divFreq);
    }

    public long getDivFreqLong(RecordCursor cursor) {
        if (this.iDivFreq < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iDivFreq);
    }

    public void setDivFreqLong(RecordCursor cursor, long divFreq) {
        if (this.iDivFreq < 0) {
            return;
        }
        this.setAsLong(cursor, this.iDivFreq, divFreq);
    }

    public double getDivFreqDouble(RecordCursor cursor) {
        if (this.iDivFreq < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iDivFreq);
    }

    public void setDivFreqDouble(RecordCursor cursor, double divFreq) {
        if (this.iDivFreq < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iDivFreq, divFreq);
    }

    public int getDivFreqDecimal(RecordCursor cursor) {
        if (this.iDivFreq < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iDivFreq);
    }

    public void setDivFreqDecimal(RecordCursor cursor, int divFreq) {
        if (this.iDivFreq < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iDivFreq, divFreq);
    }

    public long getDivFreqWideDecimal(RecordCursor cursor) {
        if (this.iDivFreq < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iDivFreq);
    }

    public void setDivFreqWideDecimal(RecordCursor cursor, long divFreq) {
        if (this.iDivFreq < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iDivFreq, divFreq);
    }

    public double getExdDivAmount(RecordCursor cursor) {
        if (this.iExdDivAmount < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iExdDivAmount);
    }

    public void setExdDivAmount(RecordCursor cursor, double exdDivAmount) {
        if (this.iExdDivAmount < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iExdDivAmount, exdDivAmount);
    }

    public int getExdDivAmountDecimal(RecordCursor cursor) {
        if (this.iExdDivAmount < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iExdDivAmount);
    }

    public void setExdDivAmountDecimal(RecordCursor cursor, int exdDivAmount) {
        if (this.iExdDivAmount < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iExdDivAmount, exdDivAmount);
    }

    public long getExdDivAmountWideDecimal(RecordCursor cursor) {
        if (this.iExdDivAmount < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iExdDivAmount);
    }

    public void setExdDivAmountWideDecimal(RecordCursor cursor, long exdDivAmount) {
        if (this.iExdDivAmount < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iExdDivAmount, exdDivAmount);
    }

    public int getExdDivDate(RecordCursor cursor) {
        if (this.iExdDivDate < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iExdDivDate);
    }

    public void setExdDivDate(RecordCursor cursor, int exdDivDate) {
        if (this.iExdDivDate < 0) {
            return;
        }
        this.setInt(cursor, this.iExdDivDate, exdDivDate);
    }

    @Deprecated
    public double get52HighPrice(RecordCursor cursor) {
        if (this.iHighPrice52 < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iHighPrice52);
    }

    @Deprecated
    public void set52HighPrice(RecordCursor cursor, double _52HighPrice) {
        if (this.iHighPrice52 < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iHighPrice52, _52HighPrice);
    }

    @Deprecated
    public int get52HighPriceDecimal(RecordCursor cursor) {
        if (this.iHighPrice52 < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iHighPrice52);
    }

    @Deprecated
    public void set52HighPriceDecimal(RecordCursor cursor, int _52HighPrice) {
        if (this.iHighPrice52 < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iHighPrice52, _52HighPrice);
    }

    @Deprecated
    public long get52HighPriceWideDecimal(RecordCursor cursor) {
        if (this.iHighPrice52 < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iHighPrice52);
    }

    @Deprecated
    public void set52HighPriceWideDecimal(RecordCursor cursor, long _52HighPrice) {
        if (this.iHighPrice52 < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iHighPrice52, _52HighPrice);
    }

    public double getHighPrice52(RecordCursor cursor) {
        if (this.iHighPrice52 < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iHighPrice52);
    }

    public void setHighPrice52(RecordCursor cursor, double highPrice52) {
        if (this.iHighPrice52 < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iHighPrice52, highPrice52);
    }

    public int getHighPrice52Decimal(RecordCursor cursor) {
        if (this.iHighPrice52 < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iHighPrice52);
    }

    public void setHighPrice52Decimal(RecordCursor cursor, int highPrice52) {
        if (this.iHighPrice52 < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iHighPrice52, highPrice52);
    }

    public long getHighPrice52WideDecimal(RecordCursor cursor) {
        if (this.iHighPrice52 < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iHighPrice52);
    }

    public void setHighPrice52WideDecimal(RecordCursor cursor, long highPrice52) {
        if (this.iHighPrice52 < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iHighPrice52, highPrice52);
    }

    @Deprecated
    public double get52LowPrice(RecordCursor cursor) {
        if (this.iLowPrice52 < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iLowPrice52);
    }

    @Deprecated
    public void set52LowPrice(RecordCursor cursor, double _52LowPrice) {
        if (this.iLowPrice52 < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iLowPrice52, _52LowPrice);
    }

    @Deprecated
    public int get52LowPriceDecimal(RecordCursor cursor) {
        if (this.iLowPrice52 < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iLowPrice52);
    }

    @Deprecated
    public void set52LowPriceDecimal(RecordCursor cursor, int _52LowPrice) {
        if (this.iLowPrice52 < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iLowPrice52, _52LowPrice);
    }

    @Deprecated
    public long get52LowPriceWideDecimal(RecordCursor cursor) {
        if (this.iLowPrice52 < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iLowPrice52);
    }

    @Deprecated
    public void set52LowPriceWideDecimal(RecordCursor cursor, long _52LowPrice) {
        if (this.iLowPrice52 < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iLowPrice52, _52LowPrice);
    }

    public double getLowPrice52(RecordCursor cursor) {
        if (this.iLowPrice52 < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iLowPrice52);
    }

    public void setLowPrice52(RecordCursor cursor, double lowPrice52) {
        if (this.iLowPrice52 < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iLowPrice52, lowPrice52);
    }

    public int getLowPrice52Decimal(RecordCursor cursor) {
        if (this.iLowPrice52 < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iLowPrice52);
    }

    public void setLowPrice52Decimal(RecordCursor cursor, int lowPrice52) {
        if (this.iLowPrice52 < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iLowPrice52, lowPrice52);
    }

    public long getLowPrice52WideDecimal(RecordCursor cursor) {
        if (this.iLowPrice52 < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iLowPrice52);
    }

    public void setLowPrice52WideDecimal(RecordCursor cursor, long lowPrice52) {
        if (this.iLowPrice52 < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iLowPrice52, lowPrice52);
    }

    public long getShares(RecordCursor cursor) {
        if (this.iShares < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iShares);
    }

    public void setShares(RecordCursor cursor, long shares) {
        if (this.iShares < 0) {
            return;
        }
        this.setAsLong(cursor, this.iShares, shares);
    }

    public double getSharesDouble(RecordCursor cursor) {
        if (this.iShares < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iShares);
    }

    public void setSharesDouble(RecordCursor cursor, double shares) {
        if (this.iShares < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iShares, shares);
    }

    public int getSharesDecimal(RecordCursor cursor) {
        if (this.iShares < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iShares);
    }

    public void setSharesDecimal(RecordCursor cursor, int shares) {
        if (this.iShares < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iShares, shares);
    }

    public long getSharesWideDecimal(RecordCursor cursor) {
        if (this.iShares < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iShares);
    }

    public void setSharesWideDecimal(RecordCursor cursor, long shares) {
        if (this.iShares < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iShares, shares);
    }

    public long getFreeFloat(RecordCursor cursor) {
        if (this.iFreeFloat < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iFreeFloat);
    }

    public void setFreeFloat(RecordCursor cursor, long freeFloat) {
        if (this.iFreeFloat < 0) {
            return;
        }
        this.setAsLong(cursor, this.iFreeFloat, freeFloat);
    }

    public double getFreeFloatDouble(RecordCursor cursor) {
        if (this.iFreeFloat < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iFreeFloat);
    }

    public void setFreeFloatDouble(RecordCursor cursor, double freeFloat) {
        if (this.iFreeFloat < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iFreeFloat, freeFloat);
    }

    public int getFreeFloatDecimal(RecordCursor cursor) {
        if (this.iFreeFloat < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iFreeFloat);
    }

    public void setFreeFloatDecimal(RecordCursor cursor, int freeFloat) {
        if (this.iFreeFloat < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iFreeFloat, freeFloat);
    }

    public long getFreeFloatWideDecimal(RecordCursor cursor) {
        if (this.iFreeFloat < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iFreeFloat);
    }

    public void setFreeFloatWideDecimal(RecordCursor cursor, long freeFloat) {
        if (this.iFreeFloat < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iFreeFloat, freeFloat);
    }

    public double getHighLimitPrice(RecordCursor cursor) {
        if (this.iHighLimitPrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iHighLimitPrice);
    }

    public void setHighLimitPrice(RecordCursor cursor, double highLimitPrice) {
        if (this.iHighLimitPrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iHighLimitPrice, highLimitPrice);
    }

    public int getHighLimitPriceDecimal(RecordCursor cursor) {
        if (this.iHighLimitPrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iHighLimitPrice);
    }

    public void setHighLimitPriceDecimal(RecordCursor cursor, int highLimitPrice) {
        if (this.iHighLimitPrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iHighLimitPrice, highLimitPrice);
    }

    public long getHighLimitPriceWideDecimal(RecordCursor cursor) {
        if (this.iHighLimitPrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iHighLimitPrice);
    }

    public void setHighLimitPriceWideDecimal(RecordCursor cursor, long highLimitPrice) {
        if (this.iHighLimitPrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iHighLimitPrice, highLimitPrice);
    }

    public double getLowLimitPrice(RecordCursor cursor) {
        if (this.iLowLimitPrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iLowLimitPrice);
    }

    public void setLowLimitPrice(RecordCursor cursor, double lowLimitPrice) {
        if (this.iLowLimitPrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iLowLimitPrice, lowLimitPrice);
    }

    public int getLowLimitPriceDecimal(RecordCursor cursor) {
        if (this.iLowLimitPrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iLowLimitPrice);
    }

    public void setLowLimitPriceDecimal(RecordCursor cursor, int lowLimitPrice) {
        if (this.iLowLimitPrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iLowLimitPrice, lowLimitPrice);
    }

    public long getLowLimitPriceWideDecimal(RecordCursor cursor) {
        if (this.iLowLimitPrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iLowLimitPrice);
    }

    public void setLowLimitPriceWideDecimal(RecordCursor cursor, long lowLimitPrice) {
        if (this.iLowLimitPrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iLowLimitPrice, lowLimitPrice);
    }

    public long getHaltStartTimeMillis(RecordCursor cursor) {
        if (this.iHaltStartTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iHaltStartTime) * 1000L;
    }

    public void setHaltStartTimeMillis(RecordCursor cursor, long haltStartTime) {
        if (this.iHaltStartTime < 0) {
            return;
        }
        this.setInt(cursor, this.iHaltStartTime, TimeUtil.getSecondsFromTime(haltStartTime));
    }

    public int getHaltStartTimeSeconds(RecordCursor cursor) {
        if (this.iHaltStartTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iHaltStartTime);
    }

    public void setHaltStartTimeSeconds(RecordCursor cursor, int haltStartTime) {
        if (this.iHaltStartTime < 0) {
            return;
        }
        this.setInt(cursor, this.iHaltStartTime, haltStartTime);
    }

    public long getHaltEndTimeMillis(RecordCursor cursor) {
        if (this.iHaltEndTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iHaltEndTime) * 1000L;
    }

    public void setHaltEndTimeMillis(RecordCursor cursor, long haltEndTime) {
        if (this.iHaltEndTime < 0) {
            return;
        }
        this.setInt(cursor, this.iHaltEndTime, TimeUtil.getSecondsFromTime(haltEndTime));
    }

    public int getHaltEndTimeSeconds(RecordCursor cursor) {
        if (this.iHaltEndTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iHaltEndTime);
    }

    public void setHaltEndTimeSeconds(RecordCursor cursor, int haltEndTime) {
        if (this.iHaltEndTime < 0) {
            return;
        }
        this.setInt(cursor, this.iHaltEndTime, haltEndTime);
    }

    public int getFlags(RecordCursor cursor) {
        if (this.iFlags < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        if (this.iFlags < 0) {
            return;
        }
        this.setInt(cursor, this.iFlags, flags);
    }

    public String getDescription(RecordCursor cursor) {
        return (String)this.getObj(cursor, this.oDescription);
    }

    public void setDescription(RecordCursor cursor, String description) {
        this.setObj(cursor, this.oDescription, description);
    }

    public String getStatusReason(RecordCursor cursor) {
        if (this.oStatusReason < 0) {
            return null;
        }
        return (String)this.getObj(cursor, this.oStatusReason);
    }

    public void setStatusReason(RecordCursor cursor, String statusReason) {
        if (this.oStatusReason < 0) {
            return;
        }
        this.setObj(cursor, this.oStatusReason, statusReason);
    }
}

