/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.qd.util.ShortString;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public class MarketMakerMapping
extends MarketEventMapping {
    private final int iExchangeCode;
    private final int iMarketMaker;
    private final int iBidTime;
    private final int iBidPrice;
    private final int iBidSize;
    private final int iBidCount;
    private final int iAskTime;
    private final int iAskPrice;
    private final int iAskSize;
    private final int iAskCount;

    public MarketMakerMapping(DataRecord record) {
        super(record);
        this.iExchangeCode = MappingUtil.findIntField(record, "MMExchange", true);
        this.iMarketMaker = MappingUtil.findIntField(record, "MMID", true);
        this.iBidTime = MappingUtil.findIntField(record, "MMBid.Time", false);
        this.iBidPrice = this.findIntField("MMBid.Price", true);
        this.iBidSize = this.findIntField("MMBid.Size", true);
        this.iBidCount = this.findIntField("MMBid.Count", false);
        this.iAskTime = MappingUtil.findIntField(record, "MMAsk.Time", false);
        this.iAskPrice = this.findIntField("MMAsk.Price", true);
        this.iAskSize = this.findIntField("MMAsk.Size", true);
        this.iAskCount = this.findIntField("MMAsk.Count", false);
        this.putNonDefaultPropertyName("MMExchange", "ExchangeCode");
        this.putNonDefaultPropertyName("MMID", "MarketMaker");
        this.putNonDefaultPropertyName("MMBid.Time", "BidTime");
        this.putNonDefaultPropertyName("MMBid.Price", "BidPrice");
        this.putNonDefaultPropertyName("MMBid.Size", "BidSize");
        this.putNonDefaultPropertyName("MMBid.Count", "BidCount");
        this.putNonDefaultPropertyName("MMAsk.Time", "AskTime");
        this.putNonDefaultPropertyName("MMAsk.Price", "AskPrice");
        this.putNonDefaultPropertyName("MMAsk.Size", "AskSize");
        this.putNonDefaultPropertyName("MMAsk.Count", "AskCount");
    }

    @Deprecated
    public char getMMExchange(RecordCursor cursor) {
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    @Deprecated
    public void setMMExchange(RecordCursor cursor, char _MMExchange) {
        this.setInt(cursor, this.iExchangeCode, _MMExchange);
    }

    public char getExchangeCode(RecordCursor cursor) {
        return (char)this.getInt(cursor, this.iExchangeCode);
    }

    public void setExchangeCode(RecordCursor cursor, char exchangeCode) {
        this.setInt(cursor, this.iExchangeCode, exchangeCode);
    }

    @Deprecated
    public String getMMIDString(RecordCursor cursor) {
        return ShortString.decode(this.getInt(cursor, this.iMarketMaker));
    }

    @Deprecated
    public void setMMIDString(RecordCursor cursor, String _MMID) {
        this.setInt(cursor, this.iMarketMaker, (int)ShortString.encode(_MMID));
    }

    @Deprecated
    public int getMMID(RecordCursor cursor) {
        return this.getInt(cursor, this.iMarketMaker);
    }

    @Deprecated
    public void setMMID(RecordCursor cursor, int _MMID) {
        this.setInt(cursor, this.iMarketMaker, _MMID);
    }

    public String getMarketMakerString(RecordCursor cursor) {
        return ShortString.decode(this.getInt(cursor, this.iMarketMaker));
    }

    public void setMarketMakerString(RecordCursor cursor, String marketMaker) {
        this.setInt(cursor, this.iMarketMaker, (int)ShortString.encode(marketMaker));
    }

    public int getMarketMaker(RecordCursor cursor) {
        return this.getInt(cursor, this.iMarketMaker);
    }

    public void setMarketMaker(RecordCursor cursor, int marketMaker) {
        this.setInt(cursor, this.iMarketMaker, marketMaker);
    }

    @Deprecated
    public long getMMBidTimeMillis(RecordCursor cursor) {
        if (this.iBidTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iBidTime) * 1000L;
    }

    @Deprecated
    public void setMMBidTimeMillis(RecordCursor cursor, long _MMBidTime) {
        if (this.iBidTime < 0) {
            return;
        }
        this.setInt(cursor, this.iBidTime, TimeUtil.getSecondsFromTime(_MMBidTime));
    }

    @Deprecated
    public int getMMBidTimeSeconds(RecordCursor cursor) {
        if (this.iBidTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iBidTime);
    }

    @Deprecated
    public void setMMBidTimeSeconds(RecordCursor cursor, int _MMBidTime) {
        if (this.iBidTime < 0) {
            return;
        }
        this.setInt(cursor, this.iBidTime, _MMBidTime);
    }

    public long getBidTimeMillis(RecordCursor cursor) {
        if (this.iBidTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iBidTime) * 1000L;
    }

    public void setBidTimeMillis(RecordCursor cursor, long bidTime) {
        if (this.iBidTime < 0) {
            return;
        }
        this.setInt(cursor, this.iBidTime, TimeUtil.getSecondsFromTime(bidTime));
    }

    public int getBidTimeSeconds(RecordCursor cursor) {
        if (this.iBidTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iBidTime);
    }

    public void setBidTimeSeconds(RecordCursor cursor, int bidTime) {
        if (this.iBidTime < 0) {
            return;
        }
        this.setInt(cursor, this.iBidTime, bidTime);
    }

    @Deprecated
    public double getMMBidPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iBidPrice);
    }

    @Deprecated
    public void setMMBidPrice(RecordCursor cursor, double _MMBidPrice) {
        this.setAsDouble(cursor, this.iBidPrice, _MMBidPrice);
    }

    @Deprecated
    public int getMMBidPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iBidPrice);
    }

    @Deprecated
    public void setMMBidPriceDecimal(RecordCursor cursor, int _MMBidPrice) {
        this.setAsTinyDecimal(cursor, this.iBidPrice, _MMBidPrice);
    }

    @Deprecated
    public long getMMBidPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iBidPrice);
    }

    @Deprecated
    public void setMMBidPriceWideDecimal(RecordCursor cursor, long _MMBidPrice) {
        this.setAsWideDecimal(cursor, this.iBidPrice, _MMBidPrice);
    }

    public double getBidPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iBidPrice);
    }

    public void setBidPrice(RecordCursor cursor, double bidPrice) {
        this.setAsDouble(cursor, this.iBidPrice, bidPrice);
    }

    public int getBidPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceDecimal(RecordCursor cursor, int bidPrice) {
        this.setAsTinyDecimal(cursor, this.iBidPrice, bidPrice);
    }

    public long getBidPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iBidPrice);
    }

    public void setBidPriceWideDecimal(RecordCursor cursor, long bidPrice) {
        this.setAsWideDecimal(cursor, this.iBidPrice, bidPrice);
    }

    @Deprecated
    public int getMMBidSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iBidSize);
    }

    @Deprecated
    public void setMMBidSize(RecordCursor cursor, int _MMBidSize) {
        this.setAsInt(cursor, this.iBidSize, _MMBidSize);
    }

    @Deprecated
    public long getMMBidSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iBidSize);
    }

    @Deprecated
    public void setMMBidSizeLong(RecordCursor cursor, long _MMBidSize) {
        this.setAsLong(cursor, this.iBidSize, _MMBidSize);
    }

    @Deprecated
    public double getMMBidSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iBidSize);
    }

    @Deprecated
    public void setMMBidSizeDouble(RecordCursor cursor, double _MMBidSize) {
        this.setAsDouble(cursor, this.iBidSize, _MMBidSize);
    }

    @Deprecated
    public int getMMBidSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iBidSize);
    }

    @Deprecated
    public void setMMBidSizeDecimal(RecordCursor cursor, int _MMBidSize) {
        this.setAsTinyDecimal(cursor, this.iBidSize, _MMBidSize);
    }

    @Deprecated
    public long getMMBidSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iBidSize);
    }

    @Deprecated
    public void setMMBidSizeWideDecimal(RecordCursor cursor, long _MMBidSize) {
        this.setAsWideDecimal(cursor, this.iBidSize, _MMBidSize);
    }

    public int getBidSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iBidSize);
    }

    public void setBidSize(RecordCursor cursor, int bidSize) {
        this.setAsInt(cursor, this.iBidSize, bidSize);
    }

    public long getBidSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iBidSize);
    }

    public void setBidSizeLong(RecordCursor cursor, long bidSize) {
        this.setAsLong(cursor, this.iBidSize, bidSize);
    }

    public double getBidSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iBidSize);
    }

    public void setBidSizeDouble(RecordCursor cursor, double bidSize) {
        this.setAsDouble(cursor, this.iBidSize, bidSize);
    }

    public int getBidSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iBidSize);
    }

    public void setBidSizeDecimal(RecordCursor cursor, int bidSize) {
        this.setAsTinyDecimal(cursor, this.iBidSize, bidSize);
    }

    public long getBidSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iBidSize);
    }

    public void setBidSizeWideDecimal(RecordCursor cursor, long bidSize) {
        this.setAsWideDecimal(cursor, this.iBidSize, bidSize);
    }

    @Deprecated
    public int getMMBidCount(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0;
        }
        return this.getAsInt(cursor, this.iBidCount);
    }

    @Deprecated
    public void setMMBidCount(RecordCursor cursor, int _MMBidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsInt(cursor, this.iBidCount, _MMBidCount);
    }

    @Deprecated
    public long getMMBidCountLong(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iBidCount);
    }

    @Deprecated
    public void setMMBidCountLong(RecordCursor cursor, long _MMBidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsLong(cursor, this.iBidCount, _MMBidCount);
    }

    @Deprecated
    public double getMMBidCountDouble(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iBidCount);
    }

    @Deprecated
    public void setMMBidCountDouble(RecordCursor cursor, double _MMBidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iBidCount, _MMBidCount);
    }

    @Deprecated
    public int getMMBidCountDecimal(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iBidCount);
    }

    @Deprecated
    public void setMMBidCountDecimal(RecordCursor cursor, int _MMBidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iBidCount, _MMBidCount);
    }

    @Deprecated
    public long getMMBidCountWideDecimal(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iBidCount);
    }

    @Deprecated
    public void setMMBidCountWideDecimal(RecordCursor cursor, long _MMBidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iBidCount, _MMBidCount);
    }

    public int getBidCount(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0;
        }
        return this.getAsInt(cursor, this.iBidCount);
    }

    public void setBidCount(RecordCursor cursor, int bidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsInt(cursor, this.iBidCount, bidCount);
    }

    public long getBidCountLong(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iBidCount);
    }

    public void setBidCountLong(RecordCursor cursor, long bidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsLong(cursor, this.iBidCount, bidCount);
    }

    public double getBidCountDouble(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iBidCount);
    }

    public void setBidCountDouble(RecordCursor cursor, double bidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iBidCount, bidCount);
    }

    public int getBidCountDecimal(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iBidCount);
    }

    public void setBidCountDecimal(RecordCursor cursor, int bidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iBidCount, bidCount);
    }

    public long getBidCountWideDecimal(RecordCursor cursor) {
        if (this.iBidCount < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iBidCount);
    }

    public void setBidCountWideDecimal(RecordCursor cursor, long bidCount) {
        if (this.iBidCount < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iBidCount, bidCount);
    }

    @Deprecated
    public long getMMAskTimeMillis(RecordCursor cursor) {
        if (this.iAskTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iAskTime) * 1000L;
    }

    @Deprecated
    public void setMMAskTimeMillis(RecordCursor cursor, long _MMAskTime) {
        if (this.iAskTime < 0) {
            return;
        }
        this.setInt(cursor, this.iAskTime, TimeUtil.getSecondsFromTime(_MMAskTime));
    }

    @Deprecated
    public int getMMAskTimeSeconds(RecordCursor cursor) {
        if (this.iAskTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iAskTime);
    }

    @Deprecated
    public void setMMAskTimeSeconds(RecordCursor cursor, int _MMAskTime) {
        if (this.iAskTime < 0) {
            return;
        }
        this.setInt(cursor, this.iAskTime, _MMAskTime);
    }

    public long getAskTimeMillis(RecordCursor cursor) {
        if (this.iAskTime < 0) {
            return 0L;
        }
        return (long)this.getInt(cursor, this.iAskTime) * 1000L;
    }

    public void setAskTimeMillis(RecordCursor cursor, long askTime) {
        if (this.iAskTime < 0) {
            return;
        }
        this.setInt(cursor, this.iAskTime, TimeUtil.getSecondsFromTime(askTime));
    }

    public int getAskTimeSeconds(RecordCursor cursor) {
        if (this.iAskTime < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iAskTime);
    }

    public void setAskTimeSeconds(RecordCursor cursor, int askTime) {
        if (this.iAskTime < 0) {
            return;
        }
        this.setInt(cursor, this.iAskTime, askTime);
    }

    @Deprecated
    public double getMMAskPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iAskPrice);
    }

    @Deprecated
    public void setMMAskPrice(RecordCursor cursor, double _MMAskPrice) {
        this.setAsDouble(cursor, this.iAskPrice, _MMAskPrice);
    }

    @Deprecated
    public int getMMAskPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iAskPrice);
    }

    @Deprecated
    public void setMMAskPriceDecimal(RecordCursor cursor, int _MMAskPrice) {
        this.setAsTinyDecimal(cursor, this.iAskPrice, _MMAskPrice);
    }

    @Deprecated
    public long getMMAskPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iAskPrice);
    }

    @Deprecated
    public void setMMAskPriceWideDecimal(RecordCursor cursor, long _MMAskPrice) {
        this.setAsWideDecimal(cursor, this.iAskPrice, _MMAskPrice);
    }

    public double getAskPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iAskPrice);
    }

    public void setAskPrice(RecordCursor cursor, double askPrice) {
        this.setAsDouble(cursor, this.iAskPrice, askPrice);
    }

    public int getAskPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceDecimal(RecordCursor cursor, int askPrice) {
        this.setAsTinyDecimal(cursor, this.iAskPrice, askPrice);
    }

    public long getAskPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iAskPrice);
    }

    public void setAskPriceWideDecimal(RecordCursor cursor, long askPrice) {
        this.setAsWideDecimal(cursor, this.iAskPrice, askPrice);
    }

    @Deprecated
    public int getMMAskSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iAskSize);
    }

    @Deprecated
    public void setMMAskSize(RecordCursor cursor, int _MMAskSize) {
        this.setAsInt(cursor, this.iAskSize, _MMAskSize);
    }

    @Deprecated
    public long getMMAskSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iAskSize);
    }

    @Deprecated
    public void setMMAskSizeLong(RecordCursor cursor, long _MMAskSize) {
        this.setAsLong(cursor, this.iAskSize, _MMAskSize);
    }

    @Deprecated
    public double getMMAskSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iAskSize);
    }

    @Deprecated
    public void setMMAskSizeDouble(RecordCursor cursor, double _MMAskSize) {
        this.setAsDouble(cursor, this.iAskSize, _MMAskSize);
    }

    @Deprecated
    public int getMMAskSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iAskSize);
    }

    @Deprecated
    public void setMMAskSizeDecimal(RecordCursor cursor, int _MMAskSize) {
        this.setAsTinyDecimal(cursor, this.iAskSize, _MMAskSize);
    }

    @Deprecated
    public long getMMAskSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iAskSize);
    }

    @Deprecated
    public void setMMAskSizeWideDecimal(RecordCursor cursor, long _MMAskSize) {
        this.setAsWideDecimal(cursor, this.iAskSize, _MMAskSize);
    }

    public int getAskSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iAskSize);
    }

    public void setAskSize(RecordCursor cursor, int askSize) {
        this.setAsInt(cursor, this.iAskSize, askSize);
    }

    public long getAskSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iAskSize);
    }

    public void setAskSizeLong(RecordCursor cursor, long askSize) {
        this.setAsLong(cursor, this.iAskSize, askSize);
    }

    public double getAskSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iAskSize);
    }

    public void setAskSizeDouble(RecordCursor cursor, double askSize) {
        this.setAsDouble(cursor, this.iAskSize, askSize);
    }

    public int getAskSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iAskSize);
    }

    public void setAskSizeDecimal(RecordCursor cursor, int askSize) {
        this.setAsTinyDecimal(cursor, this.iAskSize, askSize);
    }

    public long getAskSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iAskSize);
    }

    public void setAskSizeWideDecimal(RecordCursor cursor, long askSize) {
        this.setAsWideDecimal(cursor, this.iAskSize, askSize);
    }

    @Deprecated
    public int getMMAskCount(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0;
        }
        return this.getAsInt(cursor, this.iAskCount);
    }

    @Deprecated
    public void setMMAskCount(RecordCursor cursor, int _MMAskCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsInt(cursor, this.iAskCount, _MMAskCount);
    }

    @Deprecated
    public long getMMAskCountLong(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iAskCount);
    }

    @Deprecated
    public void setMMAskCountLong(RecordCursor cursor, long _MMAskCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsLong(cursor, this.iAskCount, _MMAskCount);
    }

    @Deprecated
    public double getMMAskCountDouble(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iAskCount);
    }

    @Deprecated
    public void setMMAskCountDouble(RecordCursor cursor, double _MMAskCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iAskCount, _MMAskCount);
    }

    @Deprecated
    public int getMMAskCountDecimal(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iAskCount);
    }

    @Deprecated
    public void setMMAskCountDecimal(RecordCursor cursor, int _MMAskCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iAskCount, _MMAskCount);
    }

    @Deprecated
    public long getMMAskCountWideDecimal(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iAskCount);
    }

    @Deprecated
    public void setMMAskCountWideDecimal(RecordCursor cursor, long _MMAskCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iAskCount, _MMAskCount);
    }

    public int getAskCount(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0;
        }
        return this.getAsInt(cursor, this.iAskCount);
    }

    public void setAskCount(RecordCursor cursor, int askCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsInt(cursor, this.iAskCount, askCount);
    }

    public long getAskCountLong(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iAskCount);
    }

    public void setAskCountLong(RecordCursor cursor, long askCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsLong(cursor, this.iAskCount, askCount);
    }

    public double getAskCountDouble(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iAskCount);
    }

    public void setAskCountDouble(RecordCursor cursor, double askCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iAskCount, askCount);
    }

    public int getAskCountDecimal(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iAskCount);
    }

    public void setAskCountDecimal(RecordCursor cursor, int askCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iAskCount, askCount);
    }

    public long getAskCountWideDecimal(RecordCursor cursor) {
        if (this.iAskCount < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iAskCount);
    }

    public void setAskCountWideDecimal(RecordCursor cursor, long askCount) {
        if (this.iAskCount < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iAskCount, askCount);
    }
}

