/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.MarketEventMapping;

public final class BookMapping
extends MarketEventMapping {
    private final int iId;
    private final int iTime;
    private final int iType;
    private final int iPrice;
    private final int iSize;
    private final int iTimeInForce;
    private final int oSymbol;

    public BookMapping(DataRecord record) {
        super(record);
        this.iId = MappingUtil.findIntField(record, "ID", true);
        this.iTime = MappingUtil.findIntField(record, "Time", true);
        this.iType = MappingUtil.findIntField(record, "Type", true);
        this.iPrice = this.findIntField("Price", true);
        this.iSize = this.findIntField("Size", true);
        this.iTimeInForce = MappingUtil.findIntField(record, "TimeInForce", true);
        this.oSymbol = MappingUtil.findObjField(record, "Symbol", true);
        this.putNonDefaultPropertyName("ID", "Id");
    }

    @Deprecated
    public int getID(RecordCursor cursor) {
        return this.getInt(cursor, this.iId);
    }

    @Deprecated
    public void setID(RecordCursor cursor, int _ID) {
        this.setInt(cursor, this.iId, _ID);
    }

    public int getId(RecordCursor cursor) {
        return this.getInt(cursor, this.iId);
    }

    public void setId(RecordCursor cursor, int id) {
        this.setInt(cursor, this.iId, id);
    }

    public long getTimeMillis(RecordCursor cursor) {
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        this.setInt(cursor, this.iTime, time);
    }

    public char getType(RecordCursor cursor) {
        return (char)this.getInt(cursor, this.iType);
    }

    public void setType(RecordCursor cursor, char type) {
        this.setInt(cursor, this.iType, type);
    }

    public double getPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        this.setAsDouble(cursor, this.iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        this.setAsTinyDecimal(cursor, this.iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        this.setAsWideDecimal(cursor, this.iPrice, price);
    }

    public int getSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iSize);
    }

    public void setSize(RecordCursor cursor, int size) {
        this.setAsInt(cursor, this.iSize, size);
    }

    public long getSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iSize);
    }

    public void setSizeLong(RecordCursor cursor, long size) {
        this.setAsLong(cursor, this.iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        this.setAsDouble(cursor, this.iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        this.setAsTinyDecimal(cursor, this.iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        this.setAsWideDecimal(cursor, this.iSize, size);
    }

    public char getTimeInForce(RecordCursor cursor) {
        return (char)this.getInt(cursor, this.iTimeInForce);
    }

    public void setTimeInForce(RecordCursor cursor, char timeInForce) {
        this.setInt(cursor, this.iTimeInForce, timeInForce);
    }

    public String getSymbol(RecordCursor cursor) {
        return (String)this.getObj(cursor, this.oSymbol);
    }

    public void setSymbol(RecordCursor cursor, String symbol) {
        this.setObj(cursor, this.oSymbol, symbol);
    }
}

