/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market.impl;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.ng.RecordCursor;
import com.devexperts.qd.util.MappingUtil;
import com.devexperts.qd.util.ShortString;
import com.devexperts.util.TimeUtil;
import com.dxfeed.event.market.impl.OrderBaseMapping;

public class AnalyticOrderMapping
extends OrderBaseMapping {
    private final int iIndex;
    private final int iTime;
    private final int iSequence;
    private final int iTimeNanoPart;
    private final int iActionTime;
    private final int iOrderId;
    private final int iAuxOrderId;
    private final int iPrice;
    private final int iSize;
    private final int iExecutedSize;
    private final int iCount;
    private final int iFlags;
    private final int iTradeId;
    private final int iTradePrice;
    private final int iTradeSize;
    private final int iMarketMaker;
    private final int iIcebergPeakSize;
    private final int iIcebergHiddenSize;
    private final int iIcebergExecutedSize;
    private final int iIcebergFlags;

    public AnalyticOrderMapping(DataRecord record) {
        super(record);
        this.iIndex = MappingUtil.findIntField(record, "Index", true);
        this.iTime = MappingUtil.findIntField(record, "Time", true);
        this.iSequence = MappingUtil.findIntField(record, "Sequence", true);
        this.iTimeNanoPart = MappingUtil.findIntField(record, "TimeNanoPart", false);
        this.iActionTime = MappingUtil.findIntField(record, "ActionTime", false);
        this.iOrderId = MappingUtil.findIntField(record, "OrderId", false);
        this.iAuxOrderId = MappingUtil.findIntField(record, "AuxOrderId", false);
        this.iPrice = this.findIntField("Price", true);
        this.iSize = this.findIntField("Size", true);
        this.iExecutedSize = this.findIntField("ExecutedSize", false);
        this.iCount = this.findIntField("Count", false);
        this.iFlags = MappingUtil.findIntField(record, "Flags", true);
        this.iTradeId = MappingUtil.findIntField(record, "TradeId", false);
        this.iTradePrice = this.findIntField("TradePrice", false);
        this.iTradeSize = this.findIntField("TradeSize", false);
        this.iMarketMaker = MappingUtil.findIntField(record, "MMID", false);
        this.iIcebergPeakSize = this.findIntField("IcebergPeakSize", false);
        this.iIcebergHiddenSize = this.findIntField("IcebergHiddenSize", false);
        this.iIcebergExecutedSize = this.findIntField("IcebergExecutedSize", false);
        this.iIcebergFlags = MappingUtil.findIntField(record, "IcebergFlags", false);
        this.putNonDefaultPropertyName("MMID", "MarketMaker");
    }

    public int getIndex(RecordCursor cursor) {
        return this.getInt(cursor, this.iIndex);
    }

    public void setIndex(RecordCursor cursor, int index) {
        this.setInt(cursor, this.iIndex, index);
    }

    public long getTimeMillis(RecordCursor cursor) {
        return (long)this.getInt(cursor, this.iTime) * 1000L;
    }

    public void setTimeMillis(RecordCursor cursor, long time) {
        this.setInt(cursor, this.iTime, TimeUtil.getSecondsFromTime(time));
    }

    public int getTimeSeconds(RecordCursor cursor) {
        return this.getInt(cursor, this.iTime);
    }

    public void setTimeSeconds(RecordCursor cursor, int time) {
        this.setInt(cursor, this.iTime, time);
    }

    public int getSequence(RecordCursor cursor) {
        return this.getInt(cursor, this.iSequence);
    }

    public void setSequence(RecordCursor cursor, int sequence) {
        this.setInt(cursor, this.iSequence, sequence);
    }

    public int getTimeNanoPart(RecordCursor cursor) {
        if (this.iTimeNanoPart < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iTimeNanoPart);
    }

    public void setTimeNanoPart(RecordCursor cursor, int timeNanoPart) {
        if (this.iTimeNanoPart < 0) {
            return;
        }
        this.setInt(cursor, this.iTimeNanoPart, timeNanoPart);
    }

    public long getActionTimeMillis(RecordCursor cursor) {
        if (this.iActionTime < 0) {
            return 0L;
        }
        return this.getLong(cursor, this.iActionTime);
    }

    public void setActionTimeMillis(RecordCursor cursor, long actionTime) {
        if (this.iActionTime < 0) {
            return;
        }
        this.setLong(cursor, this.iActionTime, actionTime);
    }

    public int getActionTimeSeconds(RecordCursor cursor) {
        if (this.iActionTime < 0) {
            return 0;
        }
        return TimeUtil.getSecondsFromTime(this.getLong(cursor, this.iActionTime));
    }

    public void setActionTimeSeconds(RecordCursor cursor, int actionTime) {
        if (this.iActionTime < 0) {
            return;
        }
        this.setLong(cursor, this.iActionTime, (long)actionTime * 1000L);
    }

    public long getOrderId(RecordCursor cursor) {
        if (this.iOrderId < 0) {
            return 0L;
        }
        return this.getLong(cursor, this.iOrderId);
    }

    public void setOrderId(RecordCursor cursor, long orderId) {
        if (this.iOrderId < 0) {
            return;
        }
        this.setLong(cursor, this.iOrderId, orderId);
    }

    public long getAuxOrderId(RecordCursor cursor) {
        if (this.iAuxOrderId < 0) {
            return 0L;
        }
        return this.getLong(cursor, this.iAuxOrderId);
    }

    public void setAuxOrderId(RecordCursor cursor, long auxOrderId) {
        if (this.iAuxOrderId < 0) {
            return;
        }
        this.setLong(cursor, this.iAuxOrderId, auxOrderId);
    }

    public double getPrice(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iPrice);
    }

    public void setPrice(RecordCursor cursor, double price) {
        this.setAsDouble(cursor, this.iPrice, price);
    }

    public int getPriceDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iPrice);
    }

    public void setPriceDecimal(RecordCursor cursor, int price) {
        this.setAsTinyDecimal(cursor, this.iPrice, price);
    }

    public long getPriceWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iPrice);
    }

    public void setPriceWideDecimal(RecordCursor cursor, long price) {
        this.setAsWideDecimal(cursor, this.iPrice, price);
    }

    public int getSize(RecordCursor cursor) {
        return this.getAsInt(cursor, this.iSize);
    }

    public void setSize(RecordCursor cursor, int size) {
        this.setAsInt(cursor, this.iSize, size);
    }

    public long getSizeLong(RecordCursor cursor) {
        return this.getAsLong(cursor, this.iSize);
    }

    public void setSizeLong(RecordCursor cursor, long size) {
        this.setAsLong(cursor, this.iSize, size);
    }

    public double getSizeDouble(RecordCursor cursor) {
        return this.getAsDouble(cursor, this.iSize);
    }

    public void setSizeDouble(RecordCursor cursor, double size) {
        this.setAsDouble(cursor, this.iSize, size);
    }

    public int getSizeDecimal(RecordCursor cursor) {
        return this.getAsTinyDecimal(cursor, this.iSize);
    }

    public void setSizeDecimal(RecordCursor cursor, int size) {
        this.setAsTinyDecimal(cursor, this.iSize, size);
    }

    public long getSizeWideDecimal(RecordCursor cursor) {
        return this.getAsWideDecimal(cursor, this.iSize);
    }

    public void setSizeWideDecimal(RecordCursor cursor, long size) {
        this.setAsWideDecimal(cursor, this.iSize, size);
    }

    public double getExecutedSize(RecordCursor cursor) {
        if (this.iExecutedSize < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iExecutedSize);
    }

    public void setExecutedSize(RecordCursor cursor, double executedSize) {
        if (this.iExecutedSize < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iExecutedSize, executedSize);
    }

    public int getExecutedSizeDecimal(RecordCursor cursor) {
        if (this.iExecutedSize < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iExecutedSize);
    }

    public void setExecutedSizeDecimal(RecordCursor cursor, int executedSize) {
        if (this.iExecutedSize < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iExecutedSize, executedSize);
    }

    public long getExecutedSizeWideDecimal(RecordCursor cursor) {
        if (this.iExecutedSize < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iExecutedSize);
    }

    public void setExecutedSizeWideDecimal(RecordCursor cursor, long executedSize) {
        if (this.iExecutedSize < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iExecutedSize, executedSize);
    }

    public int getCount(RecordCursor cursor) {
        if (this.iCount < 0) {
            return 0;
        }
        return this.getAsInt(cursor, this.iCount);
    }

    public void setCount(RecordCursor cursor, int count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsInt(cursor, this.iCount, count);
    }

    public long getCountLong(RecordCursor cursor) {
        if (this.iCount < 0) {
            return 0L;
        }
        return this.getAsLong(cursor, this.iCount);
    }

    public void setCountLong(RecordCursor cursor, long count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsLong(cursor, this.iCount, count);
    }

    public double getCountDouble(RecordCursor cursor) {
        if (this.iCount < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iCount);
    }

    public void setCountDouble(RecordCursor cursor, double count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iCount, count);
    }

    public int getCountDecimal(RecordCursor cursor) {
        if (this.iCount < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iCount);
    }

    public void setCountDecimal(RecordCursor cursor, int count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iCount, count);
    }

    public long getCountWideDecimal(RecordCursor cursor) {
        if (this.iCount < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iCount);
    }

    public void setCountWideDecimal(RecordCursor cursor, long count) {
        if (this.iCount < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iCount, count);
    }

    public int getFlags(RecordCursor cursor) {
        return this.getInt(cursor, this.iFlags);
    }

    public void setFlags(RecordCursor cursor, int flags) {
        this.setInt(cursor, this.iFlags, flags);
    }

    public long getTradeId(RecordCursor cursor) {
        if (this.iTradeId < 0) {
            return 0L;
        }
        return this.getLong(cursor, this.iTradeId);
    }

    public void setTradeId(RecordCursor cursor, long tradeId) {
        if (this.iTradeId < 0) {
            return;
        }
        this.setLong(cursor, this.iTradeId, tradeId);
    }

    public double getTradePrice(RecordCursor cursor) {
        if (this.iTradePrice < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iTradePrice);
    }

    public void setTradePrice(RecordCursor cursor, double tradePrice) {
        if (this.iTradePrice < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iTradePrice, tradePrice);
    }

    public int getTradePriceDecimal(RecordCursor cursor) {
        if (this.iTradePrice < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iTradePrice);
    }

    public void setTradePriceDecimal(RecordCursor cursor, int tradePrice) {
        if (this.iTradePrice < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iTradePrice, tradePrice);
    }

    public long getTradePriceWideDecimal(RecordCursor cursor) {
        if (this.iTradePrice < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iTradePrice);
    }

    public void setTradePriceWideDecimal(RecordCursor cursor, long tradePrice) {
        if (this.iTradePrice < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iTradePrice, tradePrice);
    }

    public double getTradeSize(RecordCursor cursor) {
        if (this.iTradeSize < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iTradeSize);
    }

    public void setTradeSize(RecordCursor cursor, double tradeSize) {
        if (this.iTradeSize < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iTradeSize, tradeSize);
    }

    public int getTradeSizeDecimal(RecordCursor cursor) {
        if (this.iTradeSize < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iTradeSize);
    }

    public void setTradeSizeDecimal(RecordCursor cursor, int tradeSize) {
        if (this.iTradeSize < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iTradeSize, tradeSize);
    }

    public long getTradeSizeWideDecimal(RecordCursor cursor) {
        if (this.iTradeSize < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iTradeSize);
    }

    public void setTradeSizeWideDecimal(RecordCursor cursor, long tradeSize) {
        if (this.iTradeSize < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iTradeSize, tradeSize);
    }

    @Deprecated
    public String getMMIDString(RecordCursor cursor) {
        if (this.iMarketMaker < 0) {
            return null;
        }
        return ShortString.decode(this.getInt(cursor, this.iMarketMaker));
    }

    @Deprecated
    public void setMMIDString(RecordCursor cursor, String _MMID) {
        if (this.iMarketMaker < 0) {
            return;
        }
        this.setInt(cursor, this.iMarketMaker, (int)ShortString.encode(_MMID));
    }

    @Deprecated
    public int getMMID(RecordCursor cursor) {
        if (this.iMarketMaker < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iMarketMaker);
    }

    @Deprecated
    public void setMMID(RecordCursor cursor, int _MMID) {
        if (this.iMarketMaker < 0) {
            return;
        }
        this.setInt(cursor, this.iMarketMaker, _MMID);
    }

    public String getMarketMakerString(RecordCursor cursor) {
        if (this.iMarketMaker < 0) {
            return null;
        }
        return ShortString.decode(this.getInt(cursor, this.iMarketMaker));
    }

    public void setMarketMakerString(RecordCursor cursor, String marketMaker) {
        if (this.iMarketMaker < 0) {
            return;
        }
        this.setInt(cursor, this.iMarketMaker, (int)ShortString.encode(marketMaker));
    }

    public int getMarketMaker(RecordCursor cursor) {
        if (this.iMarketMaker < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iMarketMaker);
    }

    public void setMarketMaker(RecordCursor cursor, int marketMaker) {
        if (this.iMarketMaker < 0) {
            return;
        }
        this.setInt(cursor, this.iMarketMaker, marketMaker);
    }

    public double getIcebergPeakSize(RecordCursor cursor) {
        if (this.iIcebergPeakSize < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iIcebergPeakSize);
    }

    public void setIcebergPeakSize(RecordCursor cursor, double icebergPeakSize) {
        if (this.iIcebergPeakSize < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iIcebergPeakSize, icebergPeakSize);
    }

    public int getIcebergPeakSizeDecimal(RecordCursor cursor) {
        if (this.iIcebergPeakSize < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iIcebergPeakSize);
    }

    public void setIcebergPeakSizeDecimal(RecordCursor cursor, int icebergPeakSize) {
        if (this.iIcebergPeakSize < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iIcebergPeakSize, icebergPeakSize);
    }

    public long getIcebergPeakSizeWideDecimal(RecordCursor cursor) {
        if (this.iIcebergPeakSize < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iIcebergPeakSize);
    }

    public void setIcebergPeakSizeWideDecimal(RecordCursor cursor, long icebergPeakSize) {
        if (this.iIcebergPeakSize < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iIcebergPeakSize, icebergPeakSize);
    }

    public double getIcebergHiddenSize(RecordCursor cursor) {
        if (this.iIcebergHiddenSize < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iIcebergHiddenSize);
    }

    public void setIcebergHiddenSize(RecordCursor cursor, double icebergHiddenSize) {
        if (this.iIcebergHiddenSize < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iIcebergHiddenSize, icebergHiddenSize);
    }

    public int getIcebergHiddenSizeDecimal(RecordCursor cursor) {
        if (this.iIcebergHiddenSize < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iIcebergHiddenSize);
    }

    public void setIcebergHiddenSizeDecimal(RecordCursor cursor, int icebergHiddenSize) {
        if (this.iIcebergHiddenSize < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iIcebergHiddenSize, icebergHiddenSize);
    }

    public long getIcebergHiddenSizeWideDecimal(RecordCursor cursor) {
        if (this.iIcebergHiddenSize < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iIcebergHiddenSize);
    }

    public void setIcebergHiddenSizeWideDecimal(RecordCursor cursor, long icebergHiddenSize) {
        if (this.iIcebergHiddenSize < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iIcebergHiddenSize, icebergHiddenSize);
    }

    public double getIcebergExecutedSize(RecordCursor cursor) {
        if (this.iIcebergExecutedSize < 0) {
            return Double.NaN;
        }
        return this.getAsDouble(cursor, this.iIcebergExecutedSize);
    }

    public void setIcebergExecutedSize(RecordCursor cursor, double icebergExecutedSize) {
        if (this.iIcebergExecutedSize < 0) {
            return;
        }
        this.setAsDouble(cursor, this.iIcebergExecutedSize, icebergExecutedSize);
    }

    public int getIcebergExecutedSizeDecimal(RecordCursor cursor) {
        if (this.iIcebergExecutedSize < 0) {
            return 0;
        }
        return this.getAsTinyDecimal(cursor, this.iIcebergExecutedSize);
    }

    public void setIcebergExecutedSizeDecimal(RecordCursor cursor, int icebergExecutedSize) {
        if (this.iIcebergExecutedSize < 0) {
            return;
        }
        this.setAsTinyDecimal(cursor, this.iIcebergExecutedSize, icebergExecutedSize);
    }

    public long getIcebergExecutedSizeWideDecimal(RecordCursor cursor) {
        if (this.iIcebergExecutedSize < 0) {
            return 0L;
        }
        return this.getAsWideDecimal(cursor, this.iIcebergExecutedSize);
    }

    public void setIcebergExecutedSizeWideDecimal(RecordCursor cursor, long icebergExecutedSize) {
        if (this.iIcebergExecutedSize < 0) {
            return;
        }
        this.setAsWideDecimal(cursor, this.iIcebergExecutedSize, icebergExecutedSize);
    }

    public int getIcebergFlags(RecordCursor cursor) {
        if (this.iIcebergFlags < 0) {
            return 0;
        }
        return this.getInt(cursor, this.iIcebergFlags);
    }

    public void setIcebergFlags(RecordCursor cursor, int icebergFlags) {
        if (this.iIcebergFlags < 0) {
            return;
        }
        this.setInt(cursor, this.iIcebergFlags, icebergFlags);
    }
}

