/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.MarketEventDelegateImpl;
import com.dxfeed.event.market.TradeETH;
import com.dxfeed.event.market.impl.TradeETHMapping;
import java.util.EnumSet;

public final class TradeETHDelegate
extends MarketEventDelegateImpl<TradeETH> {
    private final TradeETHMapping m;

    public TradeETHDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(TradeETHMapping.class);
    }

    @Override
    public TradeETHMapping getMapping() {
        return this.m;
    }

    @Override
    public TradeETH createEvent() {
        return new TradeETH();
    }

    @Override
    public TradeETH getEvent(TradeETH event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setTimeSequence((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setTimeNanoPart(this.m.getTimeNanoPart(cursor));
        event.setExchangeCode(this.m.getExchangeCode(cursor));
        event.setPrice(this.m.getPrice(cursor));
        event.setSizeAsDouble(this.m.getSizeDouble(cursor));
        event.setChange(this.m.getChange(cursor));
        event.setDayVolumeAsDouble(this.m.getDayVolumeDouble(cursor));
        event.setDayTurnover(this.m.getDayTurnover(cursor));
        event.setFlags(this.m.getFlags(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(TradeETH event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        this.m.setTimeSeconds(cursor, (int)(event.getTimeSequence() >>> 32));
        this.m.setSequence(cursor, (int)event.getTimeSequence());
        this.m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        this.m.setExchangeCode(cursor, event.getExchangeCode());
        this.m.setPrice(cursor, event.getPrice());
        this.m.setSizeDouble(cursor, event.getSizeAsDouble());
        this.m.setChange(cursor, event.getChange());
        this.m.setDayVolumeDouble(cursor, event.getDayVolumeAsDouble());
        this.m.setDayTurnover(cursor, event.getDayTurnover());
        this.m.setFlags(cursor, event.getFlags());
        return cursor;
    }
}

