/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.Direction;
import com.dxfeed.event.market.MarketEventDelegateImpl;
import com.dxfeed.event.market.Trade;
import com.dxfeed.event.market.impl.TradeMapping;
import java.util.EnumSet;

public final class TradeDelegate
extends MarketEventDelegateImpl<Trade> {
    private final TradeMapping m;

    public TradeDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(TradeMapping.class);
    }

    @Override
    public TradeMapping getMapping() {
        return this.m;
    }

    @Override
    public Trade createEvent() {
        return new Trade();
    }

    @Override
    public Trade getEvent(Trade event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setTimeSequence((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setTimeNanoPart(this.m.getTimeNanoPart(cursor));
        event.setExchangeCode(this.m.getExchangeCode(cursor));
        event.setPrice(this.m.getPrice(cursor));
        event.setSizeAsDouble(this.m.getSizeDouble(cursor));
        event.setChange(this.m.getChange(cursor));
        event.setDayVolumeAsDouble(this.m.getDayVolumeDouble(cursor));
        event.setDayTurnover(this.m.getDayTurnover(cursor));
        event.setFlags(this.m.getFlags(cursor));
        if (event.getTickDirection() == Direction.UNDEFINED) {
            int tick = this.m.getTick(cursor);
            if (tick == 1) {
                event.setTickDirection(Direction.ZERO_UP);
            } else if (tick == 2) {
                event.setTickDirection(Direction.ZERO_DOWN);
            }
        }
        return event;
    }

    @Override
    public RecordCursor putEvent(Trade event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        this.m.setTimeSeconds(cursor, (int)(event.getTimeSequence() >>> 32));
        this.m.setSequence(cursor, (int)event.getTimeSequence());
        this.m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        this.m.setExchangeCode(cursor, event.getExchangeCode());
        this.m.setPrice(cursor, event.getPrice());
        this.m.setSizeDouble(cursor, event.getSizeAsDouble());
        this.m.setChange(cursor, event.getChange());
        this.m.setDayVolumeDouble(cursor, event.getDayVolumeAsDouble());
        this.m.setDayTurnover(cursor, event.getDayTurnover());
        this.m.setFlags(cursor, event.getFlags());
        Direction d = event.getTickDirection();
        this.m.setTick(cursor, d == Direction.UP || d == Direction.ZERO_UP ? 1 : (d == Direction.DOWN || d == Direction.ZERO_DOWN ? 2 : 0));
        return cursor;
    }
}

