/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.MarketEventDelegateImpl;
import com.dxfeed.event.market.TimeAndSale;
import com.dxfeed.event.market.impl.TimeAndSaleMapping;
import java.util.EnumSet;

public final class TimeAndSaleDelegate
extends MarketEventDelegateImpl<TimeAndSale> {
    private final TimeAndSaleMapping m;

    public TimeAndSaleDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(TimeAndSaleMapping.class);
    }

    @Override
    public TimeAndSaleMapping getMapping() {
        return this.m;
    }

    @Override
    public TimeAndSale createEvent() {
        return new TimeAndSale();
    }

    @Override
    public TimeAndSale getEvent(TimeAndSale event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setTimeNanoPart(this.m.getTimeNanoPart(cursor));
        event.setExchangeCode(this.m.getExchangeCode(cursor));
        event.setPrice(this.m.getPrice(cursor));
        event.setSizeAsDouble(this.m.getSizeDouble(cursor));
        event.setBidPrice(this.m.getBidPrice(cursor));
        event.setAskPrice(this.m.getAskPrice(cursor));
        event.setExchangeSaleConditions(this.m.getSaleConditionsString(cursor));
        event.setFlags(this.m.getFlags(cursor));
        event.setBuyer(this.m.getBuyer(cursor));
        event.setSeller(this.m.getSeller(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(TimeAndSale event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        this.m.setTimeSeconds(cursor, (int)(event.getIndex() >>> 32));
        this.m.setSequence(cursor, (int)event.getIndex());
        this.m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        this.m.setExchangeCode(cursor, event.getExchangeCode());
        this.m.setPrice(cursor, event.getPrice());
        this.m.setSizeDouble(cursor, event.getSizeAsDouble());
        this.m.setBidPrice(cursor, event.getBidPrice());
        this.m.setAskPrice(cursor, event.getAskPrice());
        this.m.setSaleConditionsString(cursor, event.getExchangeSaleConditions());
        this.m.setFlags(cursor, event.getFlags());
        this.m.setBuyer(cursor, event.getBuyer());
        this.m.setSeller(cursor, event.getSeller());
        return cursor;
    }
}

