/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.MarketEventDelegateImpl;
import com.dxfeed.event.market.Summary;
import com.dxfeed.event.market.impl.SummaryMapping;
import java.util.EnumSet;

public final class SummaryDelegate
extends MarketEventDelegateImpl<Summary> {
    private final SummaryMapping m;

    public SummaryDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(SummaryMapping.class);
    }

    @Override
    public SummaryMapping getMapping() {
        return this.m;
    }

    @Override
    public Summary createEvent() {
        return new Summary();
    }

    @Override
    public Summary getEvent(Summary event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setDayId(this.m.getDayId(cursor));
        event.setDayOpenPrice(this.m.getDayOpenPrice(cursor));
        event.setDayHighPrice(this.m.getDayHighPrice(cursor));
        event.setDayLowPrice(this.m.getDayLowPrice(cursor));
        event.setDayClosePrice(this.m.getDayClosePrice(cursor));
        event.setPrevDayId(this.m.getPrevDayId(cursor));
        event.setPrevDayClosePrice(this.m.getPrevDayClosePrice(cursor));
        event.setPrevDayVolume(this.m.getPrevDayVolumeDouble(cursor));
        event.setOpenInterest(this.m.getOpenInterest(cursor));
        event.setFlags(this.m.getFlags(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Summary event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        this.m.setDayId(cursor, event.getDayId());
        this.m.setDayOpenPrice(cursor, event.getDayOpenPrice());
        this.m.setDayHighPrice(cursor, event.getDayHighPrice());
        this.m.setDayLowPrice(cursor, event.getDayLowPrice());
        this.m.setDayClosePrice(cursor, event.getDayClosePrice());
        this.m.setPrevDayId(cursor, event.getPrevDayId());
        this.m.setPrevDayClosePrice(cursor, event.getPrevDayClosePrice());
        this.m.setPrevDayVolumeDouble(cursor, event.getPrevDayVolume());
        this.m.setOpenInterest(cursor, (int)event.getOpenInterest());
        this.m.setFlags(cursor, event.getFlags());
        return cursor;
    }
}

