/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.MarketEventDelegateImpl;
import com.dxfeed.event.market.Quote;
import com.dxfeed.event.market.impl.QuoteMapping;
import java.util.EnumSet;

public class QuoteDelegate
extends MarketEventDelegateImpl<Quote> {
    private final QuoteMapping m;

    public QuoteDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(QuoteMapping.class);
    }

    @Override
    public QuoteMapping getMapping() {
        return this.m;
    }

    @Override
    public Quote createEvent() {
        return new Quote();
    }

    @Override
    public Quote getEvent(Quote event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setTimeNanoPart(this.m.getTimeNanoPart(cursor));
        event.setBidTime(this.m.getBidTimeMillis(cursor));
        event.setBidExchangeCode(this.m.getBidExchangeCode(cursor));
        event.setBidPrice(this.m.getBidPrice(cursor));
        event.setBidSizeAsDouble(this.m.getBidSizeDouble(cursor));
        event.setAskTime(this.m.getAskTimeMillis(cursor));
        event.setAskExchangeCode(this.m.getAskExchangeCode(cursor));
        event.setAskPrice(this.m.getAskPrice(cursor));
        event.setAskSizeAsDouble(this.m.getAskSizeDouble(cursor));
        event.setTimeMillisSequence(this.m.getSequence(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Quote event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        this.m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        this.m.setBidTimeMillis(cursor, event.getBidTime());
        this.m.setBidExchangeCode(cursor, event.getBidExchangeCode());
        this.m.setBidPrice(cursor, event.getBidPrice());
        this.m.setBidSizeDouble(cursor, event.getBidSizeAsDouble());
        this.m.setAskTimeMillis(cursor, event.getAskTime());
        this.m.setAskExchangeCode(cursor, event.getAskExchangeCode());
        this.m.setAskPrice(cursor, event.getAskPrice());
        this.m.setAskSizeDouble(cursor, event.getAskSizeAsDouble());
        this.m.setSequence(cursor, event.getTimeMillisSequence());
        return cursor;
    }
}

