/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.market.MarketEventDelegateImpl;
import com.dxfeed.event.market.Profile;
import com.dxfeed.event.market.impl.ProfileMapping;
import java.util.EnumSet;

public final class ProfileDelegate
extends MarketEventDelegateImpl<Profile> {
    private final ProfileMapping m;

    public ProfileDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(ProfileMapping.class);
    }

    @Override
    public ProfileMapping getMapping() {
        return this.m;
    }

    @Override
    public Profile createEvent() {
        return new Profile();
    }

    @Override
    public Profile getEvent(Profile event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setHigh52WeekPrice(this.m.getHighPrice52(cursor));
        event.setLow52WeekPrice(this.m.getLowPrice52(cursor));
        event.setHighLimitPrice(this.m.getHighLimitPrice(cursor));
        event.setLowLimitPrice(this.m.getLowLimitPrice(cursor));
        event.setHaltStartTime(this.m.getHaltStartTimeMillis(cursor));
        event.setHaltEndTime(this.m.getHaltEndTimeMillis(cursor));
        event.setFlags(this.m.getFlags(cursor));
        event.setDescription(this.m.getDescription(cursor));
        event.setStatusReason(this.m.getStatusReason(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Profile event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        this.m.setHighPrice52(cursor, event.getHigh52WeekPrice());
        this.m.setLowPrice52(cursor, event.getLow52WeekPrice());
        this.m.setHighLimitPrice(cursor, event.getHighLimitPrice());
        this.m.setLowLimitPrice(cursor, event.getLowLimitPrice());
        this.m.setHaltStartTimeMillis(cursor, event.getHaltStartTime());
        this.m.setHaltEndTimeMillis(cursor, event.getHaltEndTime());
        this.m.setFlags(cursor, event.getFlags());
        this.m.setDescription(cursor, event.getDescription());
        this.m.setStatusReason(cursor, event.getStatusReason());
        return cursor;
    }
}

