/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordBuffer;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBaseDelegateImpl;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.impl.OrderMapping;
import java.util.EnumSet;

public final class OrderDelegate
extends OrderBaseDelegateImpl<Order> {
    private final OrderMapping m;

    public OrderDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(OrderMapping.class);
    }

    @Override
    public OrderMapping getMapping() {
        return this.m;
    }

    @Override
    public Order createEvent() {
        return new Order();
    }

    @Override
    public Order getEvent(Order event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setEventFlags(cursor.getEventFlags());
        event.setIndex((long)this.getSource().id() << 32 | (long)this.m.getIndex(cursor) & 0xFFFFFFFFL);
        event.setTimeSequence((long)this.m.getTimeSeconds(cursor) << 32 | (long)this.m.getSequence(cursor) & 0xFFFFFFFFL);
        event.setTimeNanoPart(this.m.getTimeNanoPart(cursor));
        event.setActionTime(this.m.getActionTimeMillis(cursor));
        event.setOrderId(this.m.getOrderId(cursor));
        event.setAuxOrderId(this.m.getAuxOrderId(cursor));
        event.setPrice(this.m.getPrice(cursor));
        event.setSizeAsDouble(this.m.getSizeDouble(cursor));
        event.setExecutedSize(this.m.getExecutedSize(cursor));
        event.setCount(this.m.getCount(cursor));
        event.setFlags(this.m.getFlags(cursor));
        event.setTradeId(this.m.getTradeId(cursor));
        event.setTradePrice(this.m.getTradePrice(cursor));
        event.setTradeSize(this.m.getTradeSize(cursor));
        event.setMarketMaker(this.m.getMarketMakerString(cursor));
        return event;
    }

    @Override
    public RecordCursor putEvent(Order event, RecordBuffer buf) {
        RecordCursor cursor = super.putEvent(event, buf);
        cursor.setEventFlags(event.getEventFlags());
        int index = (int)event.getIndex();
        this.m.setIndex(cursor, index);
        this.m.setTimeSeconds(cursor, (int)(event.getTimeSequence() >>> 32));
        this.m.setSequence(cursor, (int)event.getTimeSequence());
        this.m.setTimeNanoPart(cursor, event.getTimeNanoPart());
        this.m.setActionTimeMillis(cursor, event.getActionTime());
        this.m.setOrderId(cursor, event.getOrderId());
        this.m.setAuxOrderId(cursor, event.getAuxOrderId());
        this.m.setPrice(cursor, event.getPrice());
        this.m.setSizeDouble(cursor, event.getSizeAsDouble());
        this.m.setExecutedSize(cursor, event.getExecutedSize());
        this.m.setCount(cursor, (int)event.getCount());
        this.m.setFlags(cursor, event.getFlags());
        this.m.setTradeId(cursor, event.getTradeId());
        this.m.setTradePrice(cursor, event.getTradePrice());
        this.m.setTradeSize(cursor, event.getTradeSize());
        this.m.setMarketMakerString(cursor, event.getMarketMaker());
        if (index < 0) {
            throw new IllegalArgumentException("Invalid index to publish");
        }
        if ((event.getEventFlags() & 0x18) != 0 && index != 0) {
            throw new IllegalArgumentException("SNAPSHOT_END and SNAPSHOT_SNIP orders must have index == 0");
        }
        if (event.getOrderSide() == Side.UNDEFINED && event.hasSize()) {
            throw new IllegalArgumentException("only empty orders can have side == UNDEFINED");
        }
        return cursor;
    }

    @Override
    public IndexedEventSource getSource() {
        return this.m.getRecordSource();
    }
}

