/*
 * Decompiled with CFR 0.152.
 */
package com.dxfeed.event.market;

import com.devexperts.qd.DataRecord;
import com.devexperts.qd.QDContract;
import com.devexperts.qd.ng.RecordCursor;
import com.dxfeed.api.impl.EventDelegateFlags;
import com.dxfeed.event.IndexedEventSource;
import com.dxfeed.event.market.Order;
import com.dxfeed.event.market.OrderBaseDelegateImpl;
import com.dxfeed.event.market.OrderSource;
import com.dxfeed.event.market.Scope;
import com.dxfeed.event.market.Side;
import com.dxfeed.event.market.impl.QuoteMapping;
import java.util.EnumSet;

public final class OrderByQuoteAskDelegate
extends OrderBaseDelegateImpl<Order> {
    private final QuoteMapping m;

    public OrderByQuoteAskDelegate(DataRecord record, QDContract contract, EnumSet<EventDelegateFlags> flags) {
        super(record, contract, flags);
        this.m = record.getMapping(QuoteMapping.class);
    }

    @Override
    public QuoteMapping getMapping() {
        return this.m;
    }

    @Override
    public Order createEvent() {
        return new Order();
    }

    @Override
    public Order getEvent(Order event, RecordCursor cursor) {
        super.getEvent(event, cursor);
        event.setIndex((long)this.getSource().id() << 48 | (long)this.m.getRecordExchange() << 32);
        event.setTime(this.m.getAskTimeMillis(cursor));
        event.setSequence(0);
        event.setPrice(this.m.getAskPrice(cursor));
        event.setSizeAsDouble(this.m.getAskSizeDouble(cursor));
        event.setExchangeCode(this.m.getRecordExchange() == '\u0000' ? this.m.getAskExchangeCode(cursor) : this.m.getRecordExchange());
        event.setOrderSide(Side.SELL);
        event.setScope(this.m.getRecordExchange() == '\u0000' ? Scope.COMPOSITE : Scope.REGIONAL);
        event.setMarketMaker(null);
        return event;
    }

    @Override
    public IndexedEventSource getSource() {
        return this.m.getRecordExchange() == '\u0000' ? OrderSource.COMPOSITE_ASK : OrderSource.REGIONAL_ASK;
    }

    @Override
    public char getExchangeCode() {
        return '\u0000';
    }
}

